/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.CoderuleFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.billtype.entity.BillTypeFile;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.metadata.MetaDataDeployHandler;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.io.FilenameUtils;

public class MetaDataExportHandler {
    private static final Log logger = LogFactory.getLog(MetaDataExportHandler.class);
    private static final String PAGE = "_page";
    private static final String SCRIPT = "_script";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String BIZCLOUD = "bizcloud";
    private static final String KEY_SPLIT = "'-'";
    private static final String DETAILERRORINFO = "detailerrorinfo";
    private static final String DATAMODEL = "datamodel";
    private static final String ZIP_PATH = "zippath";
    private static final String SQLENTRYENTITY = "sqlentryentity";
    private static final String SELECT_APP_PATH = "selectapppath";
    private static final String URL_NAME = "urlname";
    private static final String URL = "url";
    private static final String PREINSDATA = "preinsdata";
    private static final String SELECTAPPIDS = "selectappids";
    private static final String APPIDSVALUE = "appidsvalue";
    private static final String LEFTROOT = "leftroot";
    private static final StringBuilder SELECTED_META_INFO = new StringBuilder();
    private IFormView view;
    private AddPacketProgress addPacketProgress;
    private int complete = 0;
    private int total = 0;
    private List<String> pageIds = new ArrayList<String>();
    private List<String> scriptIds = new ArrayList<String>();
    private boolean appFlag = false;
    private boolean cloudFlag = false;
    private List<String> btIdList = new ArrayList<String>();
    private List<String> crIdList = new ArrayList<String>();
    private List<Long> wkBenchList = new ArrayList<Long>();
    private List<String> treeNodeList = new ArrayList<String>();
    private String gitLocalPath = "";
    private File gitLocalRepo = null;
    private String gitDataModelPath = "";
    private String userName = "";
    private String passgit = "";
    private String gitConfigUrl = "";
    private String jsonFileName = "kdpkgs.json";
    private String metaJsonPath = "";
    private File metaJsonFile = null;
    private LinkedHashMap<String, Object> paramMap = new LinkedHashMap(16);
    private List<Map<String, Object>> dataModelMaps = new ArrayList<Map<String, Object>>(16);
    private List<String> appFileNameList = new ArrayList<String>(16);

    public MetaDataExportHandler(IFormView view, AddPacketProgress addPacketProgress) {
        this.view = view;
        this.addPacketProgress = addPacketProgress;
    }

    public String exportMetadataByCloud(ListSelectedRow selectedPacket, List<String> selectAppList) {
        QFilter filter;
        String string;
        Object pullResult;
        QFilter idFilter = new QFilter("id", "in", selectAppList);
        DynamicObject[] appInfos = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,number,isv,name,version,bizcloud.id as cloudid,bizcloud", (QFilter[])new QFilter[]{idFilter});
        if (appInfos.length <= 0) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", (String)"MetaDataExportHandler_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        this.total = selectAppList.size();
        ScheduleUtil.addPacketFeedbackProgress(this.addPacketProgress, this.total, 0);
        String defaultCloudNum = ((DynamicObject)appInfos[0].get(BIZCLOUD)).getString("number");
        String defaultAppNum = appInfos[0].getString("number");
        String defaultAppVersion = "1.5";
        ArrayList<String> appNums = new ArrayList<String>(16);
        Map<String, List<String>> cloudAppListMap = this.appListGroupByCloud(appInfos, appNums);
        DynamicObject guide = ConfigItemHelper.queryGuideByNumber("ricc_metadata_export", "id,name,number");
        Set<Map.Entry<String, List<String>>> entrySet = cloudAppListMap.entrySet();
        ArrayList<DynamicObject> subdataPackets = new ArrayList<DynamicObject>(entrySet.size());
        DynamicObject dataEntity = this.view.getModel().getDataEntity();
        boolean isPush = dataEntity.getBoolean("ispush");
        if (isPush && !((String)(pullResult = this.pullGitFile(appNums))).contains("success")) {
            return pullResult;
        }
        try {
            this.complete = 0;
            for (Map.Entry entry : entrySet) {
                DynamicObject subdataPacket = this.exportMetadata(selectedPacket, (String)entry.getKey(), defaultCloudNum, defaultAppNum, defaultAppVersion, guide, (List)entry.getValue(), isPush);
                if (subdataPacket == null) {
                    throw new RiccBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01", (String)"MetaDataExportHandler_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                subdataPackets.add(subdataPacket);
            }
            SubDataPacketDispatch.saveBatchSubDataPacket(selectedPacket.getPrimaryKeyValue(), subdataPackets);
        }
        catch (RiccBizException e) {
            logger.error("\u5bfc\u51fa\u5143\u6570\u636e\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01%s", (String)"MetaDataExportHandler_2", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        if (isPush && StringUtils.isNotEmpty((String)this.userName) && StringUtils.isNotEmpty((String)this.passgit) && !(string = this.pushGitFile(filter = new QFilter("id", "=", selectedPacket.getPrimaryKeyValue()))).contains("success")) {
            return string;
        }
        return "success";
    }

    private String pullGitFile(List<String> appNums) {
        long currUserId = RequestContext.get().getCurrUserId();
        String key = "ricc_gitmsg_" + currUserId;
        String encryptUserName = this.view.getPageCache().get(key);
        String distributeKey = Instance.getClusterName() + "." + RequestContext.get().getAccountId() + ".git." + encryptUserName;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ricc_git_userInfo", new DistributeCacheHAPolicy());
        if (cache.contains(distributeKey)) {
            this.userName = Encrypters.decode((String)encryptUserName);
            String encryptPassGit = (String)cache.get(distributeKey, "passgit");
            this.passgit = Encrypters.decode((String)encryptPassGit);
            String gitUrl = (String)cache.get(distributeKey, "giturl");
            String gitBranch = (String)cache.get(distributeKey, "gitbranch");
            this.gitLocalPath = FileUtils.generateLocalPath();
            this.gitLocalRepo = FileUtils.createFile((String)this.gitLocalPath);
            if (!this.gitLocalRepo.exists()) {
                this.gitLocalRepo.mkdirs();
            }
            this.gitDataModelPath = this.gitLocalPath + File.separator + DATAMODEL;
            File gitDataModelFile = FileUtils.createFile((String)this.gitDataModelPath);
            if (!gitDataModelFile.exists()) {
                gitDataModelFile.mkdirs();
            }
            this.metaJsonPath = this.gitLocalPath + File.separator + this.jsonFileName;
            this.metaJsonFile = new File(FileUtils.cleanString((String)this.metaJsonPath));
            this.gitConfigUrl = this.gitLocalPath + File.separator + ".git";
            File gitFile = new File(FileUtils.cleanString((String)this.gitConfigUrl));
            FileInputStream inputStream = null;
            if (!gitFile.exists()) {
                try {
                    String result;
                    if (StringUtils.isNotEmpty((String)gitUrl) && StringUtils.isNotEmpty((String)gitBranch) && StringUtils.isNotEmpty((String)this.userName) && StringUtils.isNotEmpty((String)this.passgit) && !(result = GITCodeHostingServiceImpl.cloneRepository((String)gitUrl, (String)this.gitLocalPath, (String)gitBranch, null, (String)this.userName, (String)this.passgit)).contains("success")) {
                        result = ResManager.loadKDString((String)"\u62c9\u53d6\u8fdc\u7a0b\u5206\u652f\u5230\u672c\u5730\u4ed3\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5317\u6597\u7cfb\u7edf\u767b\u5f55\u9875\u4fe1\u606f\u662f\u5426\u6b63\u786e:%s", (String)"MetaDataExportHandler_16", (String)"sys-ricc-platform", (Object[])new Object[]{result});
                        this.addPacketProgress.fail(result);
                        String string = result;
                        if (inputStream != null) {
                            this.safeClose(inputStream);
                        }
                        return string;
                    }
                    if (this.metaJsonFile.isFile()) {
                        List remoteDataModelMaps;
                        inputStream = new FileInputStream(this.metaJsonFile);
                        String resStr = FileUtils.inputStreamToString((InputStream)inputStream);
                        this.paramMap = (LinkedHashMap)JSON.parseObject((String)resStr, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                        if (!this.paramMap.isEmpty() && this.paramMap.containsKey(DATAMODEL) && this.paramMap.get(DATAMODEL) != null && !(remoteDataModelMaps = (List)this.paramMap.get(DATAMODEL)).isEmpty()) {
                            for (Map dataModelMap : remoteDataModelMaps) {
                                String appNumber = (String)dataModelMap.get("appnumber");
                                if (appNums.contains(appNumber)) continue;
                                this.dataModelMaps.add(dataModelMap);
                            }
                            this.paramMap.remove(DATAMODEL);
                        }
                    }
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u62c9\u53d6\u8fdc\u7a0b\u5206\u652f\u5230\u672c\u5730\u4ed3\u5e93\u5931\u8d25:%s", (String)"MetaDataExportHandler_17", (String)"sys-ricc-platform", (Object[])new Object[]{e.getMessage()}));
                }
                finally {
                    if (inputStream != null) {
                        this.safeClose(inputStream);
                    }
                }
            }
        }
        return "success";
    }

    private String pushGitFile(QFilter filter) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.paramMap.put("createdate", simpleDateFormat.format(new Date()));
            this.paramMap.put("domainurl", UrlService.getDomainContextUrl());
            this.paramMap.put("tenantcode", RequestContext.get().getTenantId());
            this.paramMap.put("accountid", Long.valueOf(RequestContext.get().getAccountId()));
            this.paramMap.put(DATAMODEL, this.dataModelMaps);
            FileUtils.writeMap2File((String)FileUtils.cleanString((String)this.metaJsonPath), this.paramMap);
            List<String> gitConfigFiles = this.getFileNameList(FileUtils.cleanString((String)this.gitConfigUrl));
            gitConfigFiles.addAll(this.appFileNameList);
            gitConfigFiles.add(this.jsonFileName);
            String annotation = UUID.randomUUID().toString().substring(0, 23);
            String gitResult = GITCodeHostingServiceImpl.commitAndPush((String)this.gitLocalPath, (String)this.userName, (String)this.passgit, (String)annotation, gitConfigFiles);
            DynamicObject dataPacket = BusinessDataServiceHelper.loadSingle((String)"ricc_datapacket", (String)"commitstatus,commitid,commitdetail,commitdetail_tag", (QFilter[])filter.toArray());
            if (!gitResult.contains("success")) {
                gitResult = ResManager.loadKDString((String)"\u63d0\u4ea4\u4ee3\u7801\u4ed3\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5317\u6597\u7cfb\u7edf\u767b\u5f55\u9875\u4fe1\u606f\u662f\u5426\u6b63\u786e:%s", (String)"MetaDataExportHandler_18", (String)"sys-ricc-platform", (Object[])new Object[]{gitResult});
                this.addPacketProgress.fail(gitResult);
                String string = gitResult;
                return string;
            }
            dataPacket.set("commitstatus", (Object)"1");
            dataPacket.set("commitid", (Object)annotation);
            String fileListStr = ResManager.loadKDString((String)"\u6587\u4ef6\u6e05\u5355", (String)"MetaDataExportHandler_20", (String)"sys-ricc-platform", (Object[])new Object[0]);
            ArrayList<String> transferDetail = new ArrayList<String>(16);
            transferDetail.add(fileListStr);
            transferDetail.addAll(this.appFileNameList);
            String joinStr = String.join((CharSequence)",", transferDetail);
            String allFileNameStr = joinStr.replace(",", "\r\n");
            if (joinStr.length() > 20) {
                joinStr = joinStr.substring(0, 20) + "...";
            }
            dataPacket.set("commitdetail", (Object)joinStr);
            dataPacket.set("commitdetail_tag", (Object)allFileNameStr);
            SaveServiceHelper.saveOperate((String)"ricc_datapacket", (DynamicObject[])new DynamicObject[]{dataPacket}, (OperateOption)OperateOption.create());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u4ee3\u7801\u4ed3\u5931\u8d25:%s", (String)"MetaDataExportHandler_19", (String)"sys-ricc-platform", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            if (this.gitLocalRepo != null) {
                FileUtils.deleteLocalFile((File)this.gitLocalRepo);
            }
        }
        return "success";
    }

    private List<String> getFileNameList(String gitLocalPath) {
        ArrayList appFileList = new ArrayList(16);
        DevportalUtil.recursiveFiles((String)gitLocalPath, appFileList);
        ArrayList<String> fileNameList = new ArrayList<String>(16);
        for (String addfileName : appFileList) {
            String[] splitFileNames = addfileName.replaceAll("\\\\", "/").split("/");
            String fileName = splitFileNames[splitFileNames.length - 1];
            fileNameList.add(fileName);
        }
        return fileNameList;
    }

    private Map<String, List<String>> appListGroupByCloud(DynamicObject[] appInfos, List<String> appNums) {
        HashMap<String, List<String>> cloudAppListMap = new HashMap<String, List<String>>(appInfos.length);
        for (DynamicObject oneApp : appInfos) {
            String cloudId = ((DynamicObject)oneApp.get(BIZCLOUD)).getString("id");
            String cloudNumber = ((DynamicObject)oneApp.get(BIZCLOUD)).getString("number");
            String key = cloudId + KEY_SPLIT + cloudNumber;
            String appId = oneApp.getString("id");
            appNums.add(oneApp.getString("number"));
            List<String> appIdList = new ArrayList<String>();
            List keyVal = (List)cloudAppListMap.get(key);
            if (keyVal != null) {
                appIdList = keyVal;
            }
            appIdList.add(appId);
            cloudAppListMap.put(key, appIdList);
        }
        return cloudAppListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject exportMetadata(ListSelectedRow selectedPacket, String cloudInfo, String defaultCloudNum, String defaultAppNum, String defaultAppVersion, DynamicObject guide, List<String> selectAppList, boolean isPush) {
        DynamicObject subDataPacket;
        String selectAppNum;
        if (selectAppList == null || selectAppList.isEmpty()) {
            return null;
        }
        String localPath = FileUtils.generateLocalPath();
        String defaultAppPackageName = defaultCloudNum + "-" + defaultAppNum + "-dm";
        String gitCloudPath = "";
        if (isPush && StringUtils.isNotEmpty((String)this.gitDataModelPath)) {
            String cloudName = cloudInfo.split(KEY_SPLIT)[1].toLowerCase();
            gitCloudPath = this.gitDataModelPath + File.separator + cloudName;
            File gitCloudFile = FileUtils.createFile((String)gitCloudPath);
            if (!gitCloudFile.exists()) {
                gitCloudFile.mkdirs();
            }
        }
        String defaultDmPath = localPath + File.separator + defaultAppPackageName;
        String traceIdHash = RequestContext.get().getTraceId();
        String defaultZipPath = defaultDmPath + File.separator + traceIdHash;
        this.view.getPageCache().put(ZIP_PATH, defaultZipPath);
        String defaultAppPath = defaultZipPath + File.separator + DATAMODEL + File.separator + defaultAppVersion + File.separator + "main";
        try {
            File defaultAppFile = FileUtils.createFile((String)defaultAppPath).getCanonicalFile();
            defaultAppFile.mkdirs();
        }
        catch (Exception e) {
            logger.error("\u5b89\u88c5\u5305\u521b\u5efa\u5931\u8d25", (Throwable)e);
            return null;
        }
        ArrayList<String> appZipNames = new ArrayList<String>();
        int sqlRowCount = this.view.getModel().getEntryRowCount(SQLENTRYENTITY);
        String detailErrorInfoStr = this.view.getPageCache().get(DETAILERRORINFO);
        StringBuilder detailErrorInfo = new StringBuilder();
        detailErrorInfo.append(detailErrorInfoStr == null ? "" : detailErrorInfoStr);
        List<String> appNumberList = new ArrayList(selectAppList.size());
        SELECTED_META_INFO.delete(0, SELECTED_META_INFO.length());
        AtomicInteger count = new AtomicInteger();
        for (String selectAppId : selectAppList) {
            AppMetadata selectAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)selectAppId, (boolean)false);
            if (selectAppMeta == null) continue;
            JSONArray dbschemaMsg = new JSONArray();
            JSONArray preinsdataMsg = new JSONArray();
            AppPackageUtil.putSqlIntoApp((int)sqlRowCount, (String)selectAppId, (JSONArray)dbschemaMsg, (JSONArray)preinsdataMsg, (IDataModel)this.view.getModel());
            this.getLoadResourceIdList(selectAppId, detailErrorInfo);
            selectAppNum = selectAppMeta.getNumber().toLowerCase();
            String gitAppPath = "";
            if (isPush && StringUtils.isNotEmpty((String)gitCloudPath)) {
                gitAppPath = gitCloudPath + File.separator + defaultAppVersion + File.separator + "main" + File.separator + selectAppNum;
                File gitAppFile = FileUtils.createFile((String)gitAppPath);
                if (!gitAppFile.exists()) {
                    gitAppFile.mkdirs();
                } else {
                    FileUtils.deleteLocalFile((File)gitAppFile);
                }
            }
            appNumberList.add(selectAppNum);
            String selectCloudId = selectAppMeta.getBizCloudID();
            DynamicObject selectCloudObject = BusinessDataServiceHelper.loadSingleFromCache((Object)selectCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"number");
            String selectCloudNum = selectCloudObject.getString("number").toLowerCase();
            String selectAppPath = defaultAppPath + File.separator + selectAppNum;
            this.view.getPageCache().put(SELECT_APP_PATH, selectAppPath);
            String appPackageName = selectCloudNum + "-" + selectAppNum + "-dm";
            InputStream appMd5Input = null;
            try {
                List billtypeExportFileList;
                List coderuleFileList;
                String url;
                Iterator urlName;
                JSONObject urlObj;
                Map<String, Object> metaDataMap;
                String modifierName;
                DynamicObject modifier;
                File selectAppFile = FileUtils.createFile((String)selectAppPath).getCanonicalFile();
                if (!selectAppFile.exists()) {
                    selectAppFile.mkdirs();
                }
                if (this.cloudFlag) {
                    DevportalUtil.expCloudMetadata((String)selectCloudId, (String)selectAppPath, (String)"EXPORT_CLOUD");
                    if (isPush && StringUtils.isNotEmpty((String)gitAppPath)) {
                        DevportalUtil.expCloudMetadata((String)selectCloudId, (String)gitAppPath, (String)"EXPORT_CLOUD");
                        DynamicObject cloud = BusinessDataServiceHelper.loadSingle((Object)selectCloudId, (String)BOS_DEVPORTAL_BIZCLOUD);
                        modifier = cloud.getDynamicObject("modifier");
                        modifierName = "";
                        if (modifier != null) {
                            modifierName = modifier.getLocaleString("name").getLocaleValue();
                        }
                        metaDataMap = this.createMetaDataMap(cloud, selectCloudNum, selectAppNum, modifierName);
                        this.addMetaDataFile("EXPORT_CLOUD", selectCloudNum, defaultAppVersion, selectAppNum, selectCloudId, metaDataMap);
                        this.dataModelMaps.add(metaDataMap);
                    }
                }
                if (this.appFlag) {
                    DevportalUtil.expAppMetadata((String)selectAppId, (String)selectAppPath, (String)"EXPORT_APP");
                    if (isPush && StringUtils.isNotEmpty((String)gitAppPath)) {
                        DevportalUtil.expAppMetadata((String)selectAppId, (String)gitAppPath, (String)"EXPORT_APP");
                        DynamicObject bizApp = BusinessDataServiceHelper.loadSingle((Object)selectAppId, (String)BOS_DEVPORTAL_BIZAPP);
                        modifier = bizApp.getDynamicObject("modifier");
                        modifierName = "";
                        if (modifier != null) {
                            modifierName = modifier.getLocaleString("name").getLocaleValue();
                        }
                        metaDataMap = this.createMetaDataMap(bizApp, selectCloudNum, selectAppNum, modifierName);
                        this.addMetaDataFile("EXPORT_APP", selectCloudNum, defaultAppVersion, selectAppNum, selectAppId, metaDataMap);
                        this.dataModelMaps.add(metaDataMap);
                    }
                }
                if (!this.pageIds.isEmpty()) {
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_formmeta");
                    DynamicObject[] pageDyms = BusinessDataServiceHelper.load((Object[])this.pageIds.toArray(), (DynamicObjectType)dataEntityType);
                    Map<String, DynamicObject> pageDymMap = Arrays.stream(pageDyms).collect(Collectors.toMap(pageDym -> pageDym.getString("id"), pageDym -> pageDym, (k1, k2) -> k2));
                    List modifierIdList = Arrays.stream(pageDyms).filter(pageDym -> StringUtils.isNotEmpty((String)pageDym.getString("modifierid"))).map(pageDym -> Long.valueOf(pageDym.getString("modifierid"))).collect(Collectors.toList());
                    MainEntityType userEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
                    DynamicObject[] userDyms = BusinessDataServiceHelper.load((Object[])modifierIdList.toArray(), (DynamicObjectType)userEntityType);
                    Map<String, DynamicObject> userDymMap = Arrays.stream(userDyms).collect(Collectors.toMap(userDym -> userDym.getString("id"), userDym -> userDym, (k1, k2) -> k2));
                    for (String pageId : this.pageIds) {
                        if (!QueryServiceHelper.exists((String)"bos_formmeta", (Object)pageId)) continue;
                        DevportalUtil.expFormMetadata((String)pageId, (String)selectAppPath, (String)"EXPORT_PAGE");
                        if (!isPush || !StringUtils.isNotEmpty((String)gitAppPath)) continue;
                        DevportalUtil.expFormMetadata((String)pageId, (String)gitAppPath, (String)"EXPORT_PAGE");
                        DynamicObject page = pageDymMap.get(pageId);
                        if (page == null) continue;
                        String modifierId = page.getString("modifierid");
                        DynamicObject modifier2 = userDymMap.get(modifierId);
                        String modifierName2 = "";
                        if (modifier2 != null) {
                            modifierName2 = modifier2.getLocaleString("name").getLocaleValue();
                        }
                        Map<String, Object> metaDataMap2 = this.createMetaDataMap(page, selectCloudNum, selectAppNum, modifierName2);
                        this.addMetaDataFile("EXPORT_PAGE", selectCloudNum, defaultAppVersion, selectAppNum, pageId, metaDataMap2);
                        this.dataModelMaps.add(metaDataMap2);
                    }
                }
                if (!this.scriptIds.isEmpty()) {
                    for (String scriptId : this.scriptIds) {
                        DevportalUtil.expScriptMeta((String)scriptId, (String)selectAppPath);
                        if (!isPush || !StringUtils.isNotEmpty((String)gitAppPath)) continue;
                        DevportalUtil.expScriptMeta((String)scriptId, (String)gitAppPath);
                    }
                }
                if (dbschemaMsg != null && !dbschemaMsg.isEmpty()) {
                    for (int i = 0; i < dbschemaMsg.size(); ++i) {
                        urlObj = (JSONObject)dbschemaMsg.get(i);
                        urlName = urlObj.getString(URL_NAME);
                        url = urlObj.getString(URL);
                        AppPackageUtil.exportSchOrPreSource((String)selectAppPath, urlName, (String)url, (String)"dbschema");
                        if (!isPush || !StringUtils.isNotEmpty((String)gitAppPath)) continue;
                        AppPackageUtil.exportSchOrPreSource((String)gitAppPath, urlName, (String)url, (String)"dbschema");
                    }
                }
                if (preinsdataMsg != null && !preinsdataMsg.isEmpty()) {
                    for (int i = 0; i < preinsdataMsg.size(); ++i) {
                        urlObj = (JSONObject)preinsdataMsg.get(i);
                        urlName = urlObj.getString(URL_NAME);
                        url = urlObj.getString(URL);
                        AppPackageUtil.exportSchOrPreSource((String)selectAppPath, urlName, (String)url, (String)PREINSDATA);
                        if (!isPush || !StringUtils.isNotEmpty((String)gitAppPath)) continue;
                        AppPackageUtil.exportSchOrPreSource((String)gitAppPath, urlName, (String)url, (String)PREINSDATA);
                    }
                }
                ArrayList<String> sqlNameList = new ArrayList<String>();
                if (!this.crIdList.isEmpty() && !(coderuleFileList = CodeRuleServiceHelper.exportCodeRuleByCoderuleID(this.crIdList)).isEmpty()) {
                    for (CoderuleFile coderuleFile : coderuleFileList) {
                        sqlNameList.add(coderuleFile.getFileName() + ".sql");
                        this.exportSource(coderuleFile, selectAppPath);
                        if (!isPush || !StringUtils.isNotEmpty((String)gitAppPath)) continue;
                        this.exportSource(coderuleFile, gitAppPath);
                    }
                }
                if (!this.btIdList.isEmpty() && !(billtypeExportFileList = BillTypeServiceHelper.exportBillTypeByIds(this.btIdList)).isEmpty()) {
                    for (BillTypeFile billtypeFile : billtypeExportFileList) {
                        sqlNameList.add(billtypeFile.getFileName() + ".sql");
                        this.exportSource(billtypeFile, selectAppPath);
                        if (!isPush || !StringUtils.isNotEmpty((String)gitAppPath)) continue;
                        this.exportSource(billtypeFile, gitAppPath);
                    }
                }
                boolean hasXmlFlag = false;
                boolean hasGitXmlFlag = false;
                if (!this.wkBenchList.isEmpty()) {
                    hasXmlFlag = AppPackageUtil.exportPageScheme(this.wkBenchList, (String)selectAppPath, sqlNameList);
                    if (isPush && StringUtils.isNotEmpty((String)gitAppPath)) {
                        hasGitXmlFlag = AppPackageUtil.exportPageScheme(this.wkBenchList, (String)gitAppPath, new ArrayList(1));
                    }
                }
                AppPackageUtil.createDataModelXML((String)selectAppId, (String)selectAppNum, (String)selectCloudNum, (String)defaultAppVersion, (String)defaultZipPath);
                AppPackageUtil.createAppXML((String)selectAppId, (String)selectAppNum, (String)selectAppPath, (JSONArray)dbschemaMsg, (JSONArray)preinsdataMsg, sqlNameList, (boolean)hasXmlFlag);
                if (isPush && StringUtils.isNotEmpty((String)gitAppPath)) {
                    AppPackageUtil.createAppXML((String)selectAppId, (String)selectAppNum, (String)gitAppPath, (JSONArray)dbschemaMsg, (JSONArray)preinsdataMsg, sqlNameList, (boolean)hasGitXmlFlag);
                }
                if (isPush) {
                    this.appFileNameList.addAll(this.getFileNameList(gitAppPath));
                }
                this.view.getPageCache().remove(SELECT_APP_PATH);
                ArrayList fileList = new ArrayList();
                String datamodelPath = defaultZipPath + File.separator + DATAMODEL;
                List appSourceList = DevportalUtil.recursiveFiles((String)datamodelPath, fileList);
                count.getAndAdd(appSourceList.size());
                StringBuilder appRelPathBuilder = new StringBuilder();
                appSourceList.forEach(appSource -> {
                    int datamodelIndex = appSource.indexOf(DATAMODEL);
                    String appRelPath = appSource.substring(datamodelIndex + DATAMODEL.length());
                    if (!appRelPath.endsWith("filelist.txt")) {
                        appRelPathBuilder.append(appRelPath);
                        appRelPathBuilder.append(System.lineSeparator());
                    }
                });
                String appInfoPath = datamodelPath + File.separator + "filelist.txt";
                this.createLogInfo(appRelPathBuilder.toString(), appInfoPath);
                this.zipDmFile(appPackageName);
                appZipNames.add(appPackageName);
                String dmPath = defaultZipPath + File.separator + "dm" + File.separator + appPackageName + ".zip";
                Path zipPath = Paths.get(DevportalUtil.checkFilePath((String)dmPath), new String[0]);
                appMd5Input = Files.newInputStream(zipPath, new OpenOption[0]);
                if (selectAppFile.exists()) {
                    AppUtils.deleteKd((File)selectAppFile);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            finally {
                if (appMd5Input != null) {
                    try {
                        appMd5Input.close();
                    }
                    catch (Exception exception) {
                        logger.error((Throwable)exception);
                        AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"io", (String)exception.getMessage());
                    }
                }
            }
            ScheduleUtil.addPacketFeedbackProgress(this.addPacketProgress, this.total, ++this.complete);
        }
        try {
            String packagePath;
            String appSequenceInfo = this.view.getPageCache().get("appsequenceinfo");
            if (StringUtils.isNotBlank((CharSequence)appSequenceInfo)) {
                appNumberList = (List)SerializationUtils.fromJsonString((String)appSequenceInfo, List.class);
            }
            if (appNumberList != null && !appNumberList.isEmpty()) {
                packagePath = defaultZipPath + File.separator + "appInfo.xml";
                AppPackageUtil.createAppInfo((String)defaultZipPath, appNumberList, (String)packagePath);
                count.getAndIncrement();
            }
            if (detailErrorInfo.length() > 0) {
                packagePath = defaultZipPath + File.separator + "errorInfo.txt";
                this.createLogInfo(detailErrorInfo.toString(), packagePath);
            }
            DevportalUtil.zipFiles(appZipNames, (String)defaultZipPath, (String)defaultAppPackageName);
            String downloadPath = defaultZipPath + File.separator + defaultAppPackageName + ".zip";
            String fileName = guide.getString("number") + "_" + System.currentTimeMillis() + ".zip";
            String uploadPath = SysParaUtil.getSavePath() + selectedPacket.getNumber();
            List list = CommonUtil.uploadDataPacket((Object)selectedPacket.getPrimaryKeyValue(), (String)localPath, (String)downloadPath, (String)uploadPath, (String)fileName);
            if (list.isEmpty()) {
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
                selectAppNum = null;
                return selectAppNum;
            }
            HashMap<String, Object> custParam = new HashMap<String, Object>();
            String[] cloudInfoArr = cloudInfo.split(KEY_SPLIT);
            custParam.put("cloudId", cloudInfoArr[0]);
            custParam.put("cloudNumber", cloudInfoArr[1]);
            subDataPacket = SubDataPacketDispatch.createEntryRow(DataPacketTypeEnum.CONFIG.getVal(), guide.getLong("id"), -1, ((DynamicObject)list.get(0)).getLong("id"), fileName, custParam, SELECTED_META_INFO.toString(), count.get());
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5143\u6570\u636e\u5f02\u5e38\u3002", (Throwable)e);
            DynamicObject dynamicObject = null;
            return dynamicObject;
        }
        finally {
            try {
                File zipFile = FileUtils.createFile((String)defaultZipPath).getCanonicalFile();
                if (zipFile.exists()) {
                    boolean deleteFlag;
                    AppUtils.deleteKd((File)zipFile);
                    String appNumberStr = localPath + File.separator + defaultAppPackageName;
                    File appNumberPath = FileUtils.createFile((String)appNumberStr);
                    if (appNumberPath.listFiles().length == 0 && !(deleteFlag = appNumberPath.delete())) {
                        logger.warn("delete file" + appNumberPath.getAbsolutePath() + "fail.");
                    }
                }
            }
            catch (Exception ioExp) {
                logger.error((Throwable)ioExp);
                AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"io", (String)ioExp.getMessage());
            }
        }
        return subDataPacket;
    }

    private Map<String, Object> createMetaDataMap(DynamicObject dynamicObject, String selectCloudNum, String selectAppNum, String modifier) {
        LinkedHashMap<String, Object> metadataMap = new LinkedHashMap<String, Object>(16);
        metadataMap.put("name", dynamicObject.getLocaleString("name").getLocaleValue());
        metadataMap.put("number", dynamicObject.getString("number"));
        metadataMap.put("appnumber", selectAppNum);
        metadataMap.put("cloudnumber", selectCloudNum);
        metadataMap.put("modifier", modifier);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date modifydate = dynamicObject.getDate("modifydate");
        String modifydateStr = "";
        if (modifydate != null) {
            modifydateStr = simpleDateFormat.format(modifydate);
        }
        metadataMap.put("dcmodifydate", modifydateStr);
        return metadataMap;
    }

    private void addMetaDataFile(String sourceType, String selectCloudNum, String defaultAppVersion, String selectAppNum, String id, Map<String, Object> metadataMap) {
        String tempPath = FileUtils.generateLocalPath();
        String tempDataModelPath = tempPath + File.separator + DATAMODEL + File.separator + selectCloudNum + File.separator + defaultAppVersion + File.separator + "main" + File.separator + selectAppNum;
        File tempDataModelFile = FileUtils.createFile((String)tempDataModelPath);
        if (!tempDataModelFile.exists()) {
            tempDataModelFile.mkdirs();
        }
        if ("EXPORT_CLOUD".equals(sourceType)) {
            DevportalUtil.expCloudMetadata((String)id, (String)tempDataModelPath, (String)"EXPORT_CLOUD");
        } else if ("EXPORT_APP".equals(sourceType)) {
            DevportalUtil.expAppMetadata((String)id, (String)tempDataModelPath, (String)"EXPORT_APP");
        } else if ("EXPORT_PAGE".equals(sourceType)) {
            DevportalUtil.expFormMetadata((String)id, (String)tempDataModelPath, (String)"EXPORT_PAGE");
        }
        if (tempDataModelFile.isDirectory()) {
            ArrayList absoluteFilePaths = new ArrayList(16);
            DevportalUtil.recursiveFiles((String)tempDataModelPath, absoluteFilePaths);
            ArrayList<String> relativeFilePaths = new ArrayList<String>(absoluteFilePaths.size());
            for (String absoluteFilePath : absoluteFilePaths) {
                String relativeFilePath = absoluteFilePath.substring(tempPath.length()).replace("\\", "/");
                relativeFilePaths.add(relativeFilePath);
            }
            metadataMap.put("files", relativeFilePaths);
        }
        FileUtils.deleteLocalFile((File)tempDataModelFile);
    }

    private void getLoadResourceIdList(String selectAppId, StringBuilder detailErrorInfo) {
        this.pageIds.clear();
        this.scriptIds.clear();
        this.appFlag = false;
        this.cloudFlag = false;
        this.btIdList.clear();
        this.crIdList.clear();
        this.wkBenchList.clear();
        this.treeNodeList.clear();
        String selectAppNode = this.view.getPageCache().get(selectAppId);
        TreeNode selectAppTreeNode = null;
        if (StringUtils.isNotBlank((CharSequence)selectAppNode)) {
            selectAppTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)selectAppNode, TreeNode.class);
            AppPackageUtil.getTreeNodeChildren((TreeNode)selectAppTreeNode, this.treeNodeList);
        }
        if (this.treeNodeList.isEmpty()) {
            return;
        }
        if (this.treeNodeList.size() == 1) {
            this.getNoLoadResourceIdList(selectAppId, detailErrorInfo);
            return;
        }
        this.getSelectedAppInfo(selectAppTreeNode);
        for (String id : this.treeNodeList) {
            if (id.endsWith(PAGE)) {
                String pageSource = id.split("#")[1];
                String pageId = pageSource.substring(0, pageSource.indexOf(PAGE));
                this.pageIds.add(pageId);
                continue;
            }
            if (id.endsWith(SCRIPT)) {
                String scriptSource = id.split("#")[1];
                String scriptId = scriptSource.substring(0, scriptSource.indexOf(SCRIPT));
                this.scriptIds.add(scriptId);
                continue;
            }
            if (id.endsWith("#cld")) {
                this.cloudFlag = true;
                continue;
            }
            if (id.endsWith("#app")) {
                this.appFlag = true;
                continue;
            }
            if (id.endsWith("cr")) {
                this.crIdList.add(id.split("#cr")[0]);
                continue;
            }
            if (id.endsWith("bt")) {
                this.btIdList.add(id.split("#bt")[0]);
                continue;
            }
            if (!id.endsWith("bench")) continue;
            String wkBenchId = id.split("#")[0];
            this.wkBenchList.add(Long.valueOf(wkBenchId));
        }
    }

    private void getSelectedAppInfo(TreeNode selectAppTreeNode) {
        if (selectAppTreeNode == null) {
            return;
        }
        String appName = selectAppTreeNode.getText();
        SELECTED_META_INFO.append("\n------");
        SELECTED_META_INFO.append(appName);
        SELECTED_META_INFO.append("------\n");
        List childTreeNodeList = selectAppTreeNode.getChildren();
        if (childTreeNodeList != null) {
            this.getChildrenSelectedInfo(childTreeNodeList);
        }
    }

    private void getChildrenSelectedInfo(List<TreeNode> childTreeNodeList) {
        for (TreeNode childTreeNode : childTreeNodeList) {
            String id = childTreeNode.getId();
            if (id.contains("sec")) {
                SELECTED_META_INFO.append('\u3010');
            }
            if (id.contains("menu")) {
                SELECTED_META_INFO.append('\n');
            }
            SELECTED_META_INFO.append(childTreeNode.getText());
            if (id.contains("sec")) {
                SELECTED_META_INFO.append('\u3011');
            }
            if (id.contains("menu")) {
                SELECTED_META_INFO.append('\uff1a');
            }
            SELECTED_META_INFO.append('\n');
            List childTreeNodeChild = childTreeNode.getChildren();
            if (childTreeNodeChild == null) continue;
            this.getChildrenSelectedInfo(childTreeNode.getChildren());
        }
    }

    public void exportSource(Object objectFile, String appPath) {
        block32: {
            String fileName = "";
            List dataList = Collections.emptyList();
            if (objectFile instanceof CoderuleFile) {
                fileName = ((CoderuleFile)objectFile).getFileName();
                dataList = ((CoderuleFile)objectFile).getFileContent();
            } else if (objectFile instanceof BillTypeFile) {
                fileName = ((BillTypeFile)objectFile).getFileName();
                dataList = ((BillTypeFile)objectFile).getFileContent();
            }
            Path filePath = Paths.get(FileUtils.cleanString((String)appPath), PREINSDATA, FilenameUtils.getName((String)(fileName + ".sql")));
            File file = FileUtils.createFile((String)filePath.toString());
            File coderuleAboveFile = file.getParentFile();
            if (!coderuleAboveFile.exists()) {
                coderuleAboveFile.mkdirs();
            }
            if (!file.exists()) {
                try {
                    boolean fileCreate = file.createNewFile();
                    if (!fileCreate) break block32;
                    Path customZipPath = Paths.get(DevportalUtil.checkFilePath((String)filePath.toString()), new String[0]);
                    try (OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                         OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                        for (String data : dataList) {
                            writer.write(data + System.lineSeparator());
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLogInfo(String detailErrorInfo, String packagePath) {
        String checkPackagePath = DevportalUtil.checkFilePath((String)packagePath);
        File packageFile = FileUtils.createFile((String)packagePath);
        OutputStream fos = null;
        try {
            boolean packageCreate;
            boolean delete;
            if (packageFile.exists() && !(delete = packageFile.delete())) {
                logger.warn("delete file" + packageFile.getAbsolutePath() + "fail.");
            }
            if (packageCreate = packageFile.createNewFile()) {
                Path customZipPath = Paths.get(checkPackagePath, new String[0]);
                fos = Files.newOutputStream(customZipPath, new OpenOption[0]);
                fos.write(detailErrorInfo.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"createLogInfo", (String)e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception);
                    AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"createLogInfo", (String)exception.getMessage());
                }
            }
        }
    }

    public void zipDmFile(String appPackageName) {
        File dmFile;
        String zipPath = this.view.getPageCache().get(ZIP_PATH);
        JSONArray files = new JSONArray();
        File file = FileUtils.createFile((String)zipPath);
        if (file.exists()) {
            files.add((Object)zipPath);
        }
        if (!(dmFile = FileUtils.createFile((String)(zipPath + File.separator + "dm"))).exists()) {
            dmFile.mkdirs();
        }
        String zipFilePath = zipPath + File.separator + "dm" + File.separator + appPackageName + ".zip";
        Path customZipPath = Paths.get(DevportalUtil.checkFilePath((String)zipFilePath), new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevportalUtil.zipFile((JSONArray)files, (ZipOutputStream)out, (String)"");
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new RiccBizException((Throwable)e);
        }
    }

    public void getNoLoadResourceIdList(String bizAppId, StringBuilder detailErrorInfo) {
        AppMetadata appMeta;
        try {
            appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        }
        catch (Exception e) {
            detailErrorInfo.append(String.format(ResManager.loadKDString((String)"getNoLoadResourceIdList\uff1a\u52a0\u8f7d\u5e94\u7528\u5931\u8d25 \uff0cid=%s", (String)"MetaDataExportHandler_3", (String)"sys-ricc-platform", (Object[])new Object[0]), bizAppId));
            logger.error("getNoLoadResourceIdList\uff1a\u52a0\u8f7d\u5e94\u7528\u5931\u8d25\uff0cid=" + bizAppId, (Throwable)e);
            return;
        }
        String appType = appMeta.getDevType();
        String masterAppId = appMeta.getMasterId();
        String appName = appMeta.getName().getLocaleValue();
        String appNum = appMeta.getNumber();
        String inheritPath = appMeta.getInheritPath();
        JSONArray firNodesArr = AppPackageUtil.getFirNodes();
        SELECTED_META_INFO.append("\n------");
        SELECTED_META_INFO.append(MetaDataDeployHandler.getFirstNodeText(appName, appNum, ""));
        SELECTED_META_INFO.append("------");
        for (Object firNodeObj : firNodesArr) {
            QFilter qApp;
            QFilter[] filters;
            String selectFields;
            DynamicObject[] protalSchemaObjects;
            QFilter appFilter;
            List appIdList;
            JSONObject firNode = (JSONObject)firNodeObj;
            String firNumber = firNode.getString("number");
            if ("cloudnum".equals(firNumber)) {
                String bizCloudId = appMeta.getBizCloudID();
                DynamicObject cloudObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"baseapp,name");
                if (Objects.isNull(cloudObject)) {
                    detailErrorInfo.append(String.format(ResManager.loadKDString((String)"getNoLoadResourceIdList\uff1a%1$s\u6240\u5728\u7684\u4e1a\u52a1\u4e91\u3010%2$s\u3011\u4e0d\u5b58\u5728\u3002", (String)"MetaDataExportHandler_4", (String)"sys-ricc-platform", (Object[])new Object[0]), appName, bizCloudId));
                    continue;
                }
                String cloudBaseAppId = cloudObject.getString("baseapp_id");
                QFilter qFilter = new QFilter("id", "=", (Object)cloudBaseAppId);
                QFilter[] filters2 = new QFilter[]{qFilter};
                Boolean cloudBaseAppExist = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filters2);
                if (Boolean.TRUE.equals(cloudBaseAppExist) && bizAppId.equals(cloudBaseAppId)) {
                    SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91\uff1a", (String)"MetaDataExportHandler_5", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                    SELECTED_META_INFO.append(cloudObject.getString("name"));
                    SELECTED_META_INFO.append('-');
                    SELECTED_META_INFO.append(bizCloudId);
                    this.cloudFlag = true;
                }
            }
            if ("appnum".equals(firNumber)) {
                SELECTED_META_INFO.append("\n\n").append(ResManager.loadKDString((String)"\u5e94\u7528\u4fe1\u606f(\u5305\u62ec\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4)\uff1a", (String)"MetaDataExportHandler_6", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                SELECTED_META_INFO.append(appName);
                SELECTED_META_INFO.append('\n');
                this.appFlag = true;
            }
            if ("billtypenum".equals(firNumber)) {
                appIdList = DevportalUtil.getAllAppIds((String)inheritPath, (String)bizAppId);
                List billTypeList = Collections.emptyList();
                try {
                    billTypeList = BillTypeServiceHelper.getBillTypesByAppId((List)appIdList);
                }
                catch (Exception exception) {
                    logger.error("getNoLoadResourceIdList\uff1aBillTypeServiceHelper.getBillTypesByAppId\u51fa\u9519", (Throwable)exception);
                    detailErrorInfo.append(String.format(ResManager.loadKDString((String)"getNoLoadResourceIdList\uff1aBillTypeServiceHelper.getBillTypesByAppId\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"MetaDataExportHandler_7", (String)"sys-ricc-platform", (Object[])new Object[0]), exception.getMessage()));
                }
                if (billTypeList != null && !billTypeList.isEmpty()) {
                    SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a", (String)"MetaDataExportHandler_8", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                    for (Map billType : billTypeList) {
                        this.btIdList.add(String.valueOf(billType.get("id")));
                        SELECTED_META_INFO.append(billType.get("name"));
                        SELECTED_META_INFO.append('\n');
                    }
                }
            }
            if ("coderulenum".equals(firNumber)) {
                appIdList = DevportalUtil.getAllAppIds((String)inheritPath, (String)bizAppId);
                List codeRules = Collections.emptyList();
                try {
                    codeRules = CodeRuleServiceHelper.getAllCodeRuleByAppId((List)appIdList);
                }
                catch (Exception exception) {
                    logger.error("getNoLoadResourceIdList\uff1aCodeRuleServiceHelper.getAllCodeRuleByAppId\u51fa\u9519", (Throwable)exception);
                    detailErrorInfo.append(ResManager.loadKDString((String)"getNoLoadResourceIdList\uff1aCodeRuleServiceHelper.getAllCodeRuleByAppId\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"MetaDataExportHandler_9", (String)"sys-ricc-platform", (Object[])new Object[]{exception.getMessage()}));
                }
                if (codeRules != null && !codeRules.isEmpty()) {
                    SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\uff1a", (String)"MetaDataExportHandler_10", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                    for (CodeRuleInfo codeRule : codeRules) {
                        this.crIdList.add(codeRule.getId());
                        SELECTED_META_INFO.append(codeRule.getName());
                        SELECTED_META_INFO.append('\n');
                    }
                }
            }
            if ("pagenum".equals(firNumber)) {
                appFilter = new QFilter("bizapp", "=", (Object)bizAppId);
                QFilter[] pageFilters = new QFilter[]{appFilter};
                boolean pageExist = QueryServiceHelper.exists((String)"bos_devportal_unitrelform", (QFilter[])pageFilters);
                if (!pageExist) continue;
                ArrayList formIds = new ArrayList();
                ArrayList formAndUnitIds = new ArrayList();
                Map unitreForms = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_unitrelform", (String)"bizunit,form", (QFilter[])pageFilters);
                unitreForms.forEach((unitreKey, unitreVal) -> {
                    String formId = unitreVal.getString("form");
                    String bizUnitId = unitreVal.getString("bizunit");
                    formIds.add(formId);
                    String formAndUnitId = formId + "\u224c" + bizUnitId;
                    formAndUnitIds.add(formAndUnitId);
                });
                QFilter[] metaFilters = new QFilter[]{new QFilter("id", "in", formIds)};
                Map fromMetaResult = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,name,number", (QFilter[])metaFilters);
                ArrayList formInfos = new ArrayList();
                fromMetaResult.forEach((metaKey, metaValue) -> formAndUnitIds.forEach(form -> {
                    String formId;
                    String[] formAndUnitInfo = form.split("\u224c");
                    if (formAndUnitInfo.length == 2 && (formId = formAndUnitInfo[0]).equals(metaKey)) {
                        String unitId = formAndUnitInfo[1];
                        String formName = metaValue.getLocaleString("name").getLocaleValue();
                        String formNum = metaValue.getString("number");
                        String formInfo = unitId + "\u224c" + formId + "\u224c" + formName + "\u224c" + formNum;
                        formInfos.add(formInfo);
                    }
                }));
                List functionElements = appMeta.getAppFunctionPackets();
                SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u9875\u9762\uff1a", (String)"MetaDataExportHandler_11", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                for (AppFunctionPacketElement functionElement : functionElements) {
                    String nodeId = functionElement.getId();
                    boolean pageFlag = true;
                    for (String formInfo : formInfos) {
                        String[] formInfoArr = formInfo.split("\u224c");
                        String bizUnitId = formInfoArr[0];
                        String bizFormId = formInfoArr[1];
                        String bizFormName = formInfoArr[2];
                        String bizFormNumber = formInfoArr[3];
                        if (!bizUnitId.equals(nodeId)) continue;
                        this.pageIds.add(bizFormId);
                        if (pageFlag) {
                            SELECTED_META_INFO.append('\u3010');
                            SELECTED_META_INFO.append(functionElement.getName().getLocaleValue());
                            SELECTED_META_INFO.append("\u3011\n");
                            pageFlag = false;
                        }
                        SELECTED_META_INFO.append(bizFormName);
                        SELECTED_META_INFO.append('-');
                        SELECTED_META_INFO.append(bizFormNumber);
                        SELECTED_META_INFO.append('\n');
                    }
                }
            }
            if ("scriptnum".equals(firNumber)) {
                appFilter = new QFilter("bizappid", "=", (Object)bizAppId);
                QFilter[] scriptFiltersExist = new QFilter[]{appFilter};
                boolean scriptExist = QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])scriptFiltersExist);
                if (!scriptExist) continue;
                String scriptFields = "id, txt_scriptnumber, txt_scriptname,bizunitid";
                String scriptOrderBy = "txt_scriptnumber";
                Map scriptInfos = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)scriptFields, (QFilter[])scriptFiltersExist, (String)scriptOrderBy);
                List functionElements = appMeta.getAppFunctionPackets();
                SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u811a\u672c\uff1a", (String)"MetaDataExportHandler_12", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                for (AppFunctionPacketElement functionElement : functionElements) {
                    String nodeId = functionElement.getId();
                    String text = (String)functionElement.getName().getDefaultItem();
                    if (scriptInfos.isEmpty()) continue;
                    boolean scriptFlag = true;
                    for (Map.Entry entry : scriptInfos.entrySet()) {
                        DynamicObject scriptInfo = (DynamicObject)entry.getValue();
                        String bizScriptUnitId = scriptInfo.getString("bizunitid");
                        String bizScriptId = scriptInfo.getString("id");
                        if (!bizScriptUnitId.equals(nodeId)) continue;
                        if (scriptFlag) {
                            SELECTED_META_INFO.append('\u3010');
                            SELECTED_META_INFO.append(text);
                            SELECTED_META_INFO.append("\u3011\n");
                            scriptFlag = false;
                        }
                        this.scriptIds.add(bizScriptId);
                        SELECTED_META_INFO.append(scriptInfo.getString("txt_scriptname"));
                        SELECTED_META_INFO.append('-');
                        SELECTED_META_INFO.append(scriptInfo.getString("txt_scriptnumber"));
                        SELECTED_META_INFO.append('\n');
                    }
                }
            }
            if (!"workbenchnum".equals(firNumber) || (protalSchemaObjects = BusinessDataServiceHelper.load((String)"portal_scheme", (String)(selectFields = "id,number,name,schemetype"), (QFilter[])(filters = new QFilter[]{qApp = "2".equals(appType) ? new QFilter("bizapp", "=", (Object)masterAppId) : new QFilter("bizapp", "=", (Object)bizAppId)}), (String)"schemetype")) == null || protalSchemaObjects.length <= 0) continue;
            boolean sysWorkBench = true;
            boolean personalWorkBench = true;
            SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u5e94\u7528\u5de5\u4f5c\u53f0\uff1a", (String)"MetaDataExportHandler_13", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
            for (DynamicObject protalSchemaObject : protalSchemaObjects) {
                String pageSchemeKey = protalSchemaObject.getString("id");
                this.wkBenchList.add(Long.valueOf(pageSchemeKey));
                String pageSchemeType = protalSchemaObject.getString("schemetype");
                if ("1".equals(pageSchemeType)) {
                    if (sysWorkBench) {
                        SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848\uff1a", (String)"MetaDataExportHandler_14", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                        sysWorkBench = false;
                    }
                } else if (personalWorkBench && "3".equals(pageSchemeType)) {
                    SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848\uff1a", (String)"MetaDataExportHandler_15", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                }
                SELECTED_META_INFO.append(protalSchemaObject.getString("name"));
                SELECTED_META_INFO.append('\n');
            }
        }
    }

    private void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }
}

