/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.schedule;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;

public abstract class AbstractProgressTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo != null) {
            if (!taskInfo.isTaskEnd()) {
                this.showProgress();
            } else {
                this.complete(taskInfo);
            }
            IFormView view = this.getParentView();
            if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
                this.getMainView().sendFormAction(view);
            }
        }
    }

    public FormShowParameter getFormShowParameter(String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setAppId("ricc");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            showParameter.getCustomParams().putAll(this.getJobFormInfo().getParams());
            showParameter.getCustomParams().put("ricc_jobforminfo", SerializationUtils.toJsonString((Object)jobFormInfo));
        }
        showParameter.getCustomParams().put("ricc_taskid", this.getTaskId());
        return showParameter;
    }

    public IFormView getShowFormView() {
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        return view;
    }

    public abstract void showProgress();

    public abstract void complete(TaskInfo var1);
}

