/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.schedule;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.schedule.executor.ExecutorService;

public class ProgressBack {
    public String taskId;
    public int progress;
    public String desc;
    public Map<String, Object> custData = new HashMap<String, Object>();

    public ProgressBack(String taskId) {
        this.taskId = taskId;
    }

    public void feedbackProgress(int total, int complete) {
        this.calculateProgress(total, complete);
        this.custData.put("total", String.valueOf(total));
        this.custData.put("complete", String.valueOf(complete));
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    public void feedbackProgress(int progress, String desc, Map<String, Object> data) {
        this.progress = progress;
        this.desc = desc;
        if (data != null) {
            this.custData.putAll(data);
        }
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    public void feedbackProgress(String desc) {
        this.desc = desc;
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    public void feedbackProgress(int progress, String desc) {
        this.progress = progress;
        this.desc = desc;
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    public void feedbackCustData(Map<String, Object> data) {
        if (data != null) {
            this.custData.putAll(data);
            ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, this.custData);
        }
    }

    public void fail(String failMessage) {
        if (StringUtils.isBlank((CharSequence)failMessage)) {
            return;
        }
        if (this.custData == null) {
            this.custData = new HashMap<String, Object>(2);
        }
        this.custData.put("fail", Boolean.TRUE);
        this.custData.put("failmessage", failMessage);
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    public void complete() {
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, this.custData);
    }

    public void calculateProgress(int total, int complete) {
        this.progress = 0;
        if (total != 0) {
            this.progress = complete * 100 / total;
        }
        if (this.progress >= 100) {
            this.progress = 99;
        } else if (this.progress < 0) {
            this.progress = 0;
        }
    }
}

