/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.schedule;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.business.schedule.TaskIf;
import kd.sys.ricc.exception.RiccBizException;

public class TaskHandler {
    private static final Log logger = LogFactory.getLog(TaskHandler.class);
    private static final long DEFAULT_TIMEOUT = 300000L;
    private static final Integer INDEX_ONE = 1;
    private static final Integer INDEX_THREE = 3;
    private String taskName;
    private String taskId;
    private TaskInfo taskInfo;
    private TaskIf taskIf;

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public void setTaskInfo(TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public TaskHandler(String taskName, TaskInfo taskInfo, TaskIf taskIf) {
        this.taskName = taskName;
        this.taskId = taskInfo.getId();
        this.taskInfo = taskInfo;
        this.taskIf = taskIf;
    }

    public TaskHandler(String taskName, String taskId, TaskIf taskIf) {
        this(taskName, ScheduleServiceHelper.queryTask((String)taskId), taskIf);
        this.taskId = taskId;
    }

    public TaskHandler(String taskId, TaskIf taskIf) {
        this(TaskHandler.getDefaultName(taskId), taskId, taskIf);
    }

    private static String getDefaultName(String taskId) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length > 4) {
            StackTraceElement currentMethod = elements[INDEX_ONE];
            if (TaskHandler.class.getName().equals(currentMethod.getClassName())) {
                return elements[INDEX_THREE].getClassName() + "." + elements[INDEX_THREE].getMethodName() + "." + taskId;
            }
        }
        return "taskId:" + taskId;
    }

    public void wait2End() {
        this.wait2End(true, 300000L);
    }

    public void wait2End(boolean progressCtrl) {
        this.wait2End(progressCtrl, 300000L);
    }

    public TaskIf getTaskIf() {
        return this.taskIf != null ? this.taskIf : new TaskIf(){};
    }

    public void setTaskIf(TaskIf taskIf) {
        this.taskIf = taskIf;
    }

    public void wait2End(boolean progressCtrl, long timeout) {
        TaskInfo next;
        int sleepSecond = 500;
        long startTime = System.currentTimeMillis();
        int interruptedCount = 0;
        while (true) {
            block9: {
                if ((next = ScheduleServiceHelper.queryTask((String)this.getTaskId())).isTaskEnd()) {
                    if (next.isFailure()) {
                        logger.info(this.getTaskName() + "\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a" + next.getFailureReason());
                        throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%1$s]\u6267\u884c\u5931\u8d25\uff1a%2$s", (String)"TaskHandler_0", (String)"sys-ricc-platform", (Object[])new Object[0]), this.getTaskName(), next.getFailureReason()));
                    }
                    break;
                }
                if (next.getProgress() == this.getTaskInfo().getProgress()) {
                    if (progressCtrl && System.currentTimeMillis() - startTime > timeout) {
                        if ("SCHEDULED".equals(next.getStatus())) {
                            throw new RiccBizException(String.format(ResManager.loadKDString((String)"%s\u4efb\u52a1\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u8ba1\u5212\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u8f6c", (String)"TaskHandler_1", (String)"sys-ricc-platform", (Object[])new Object[0]), this.getTaskName()));
                        }
                        throw new RiccBizException(String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u8fdb\u5ea6\u5df2\u957f\u65f6\u95f4\u65e0\u8fdb\u5c55\uff0c\u76ee\u524d\u8fdb\u5ea6: %2$d, \u76ee\u524d\u72b6\u6001\uff1a%3$s", (String)"TaskHandler_2", (String)"sys-ricc-platform", (Object[])new Object[0]), this.getTaskName(), next.getProgress(), next.getStatus()));
                    }
                } else {
                    startTime = System.currentTimeMillis();
                    this.setTaskInfo(next);
                    this.getTaskIf().ifUpdate(this.getTaskInfo());
                }
                try {
                    Thread.sleep(sleepSecond);
                }
                catch (InterruptedException e) {
                    int n = interruptedCount;
                    interruptedCount = (byte)(interruptedCount + 1);
                    if (n <= INDEX_THREE) break block9;
                    String message = ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u7ecf\u88ab\u591a\u6b21\u4e2d\u65ad\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5 %2$s", (String)"TaskHandler_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    throw new RiccBizException(String.format(message, this.getTaskName(), e.getMessage()), (Throwable)e);
                }
            }
            sleepSecond = ScheduleUtil.getDynamicSleepSecond(sleepSecond, 5000);
        }
        this.setTaskInfo(next);
        this.getTaskIf().ifUpdate(this.getTaskInfo());
        logger.info(this.getTaskName() + "\u8c03\u5ea6\u4efb\u52a1\u7ed3\u675f");
    }
}

