/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.transfer;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.sys.ricc.business.datapacket.download.PacketDownLoadUtil;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.business.transfer.TransferPacketProgress;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.enums.TransferStatusEnum;
import kd.sys.ricc.common.log.AbstractLogRecord;
import kd.sys.ricc.common.log.LogRecorder;
import kd.sys.ricc.common.log.impl.ConfigLogImpl;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.Hex;
import kd.sys.ricc.common.util.Sha256Util;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

@Deprecated
public class TransferDataPacketTask
extends AbstractSerailTask {
    private static Log log = LogFactory.getLog(TransferDataPacketTask.class);
    private TransferPacketProgress transferProcess;
    private List<DynamicObject> logs;
    private final ConfigLogImpl configLog = new ConfigLogImpl();
    private int subTotal;
    private int selectedPacket = 0;
    private int totalSuccessCount = 0;
    private int totalSubSuccessCount = 0;
    private static final String DOTRANSFERER = "dotransferer";
    private static final String TRANSFERTIME = "transfertime";
    private static final String ISCOMPLETED = "iscompleted";
    private static final String COMPLETETIME = "completetime";

    public String getTransferFailedMsg() {
        return ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %s \u5728\u7ebf\u4f20\u8f93\u4efb\u52a1\u5931\u8d25\uff1a", (String)"TransferDataPacketTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> map) {
        String selectRowsStr = (String)map.get("selectRows");
        if (StringUtils.isEmpty((CharSequence)selectRowsStr)) {
            this.getProcess().fail(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4f20\u8f93\u7684\u4f20\u8f93\u5305!", (String)"TransferDataPacketTask_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection listSelectedRows = ListSelectedRowCollection.deSerialize((String)selectRowsStr);
        MainEntityType transferTaskType = EntityMetadataCache.getDataEntityType((String)"ricc_transfertask");
        Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
        this.selectedPacket = primaryKeyValues.length;
        DynamicObject[] fnumbers = BusinessDataServiceHelper.load((String)"ricc_destaccount", (String)"number", null);
        String targetIds = Arrays.stream(fnumbers).map(fnumber -> fnumber.getString("number")).collect(Collectors.joining(","));
        DynamicObject[] selectedTransferTasks = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)transferTaskType);
        ArrayList<Object> ids = new ArrayList<Object>();
        if (selectedTransferTasks.length > 0) {
            for (DynamicObject dynamicObject : selectedTransferTasks) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("datapackettrans");
                for (DynamicObject datapackettran : dynamicObjectCollection) {
                    DynamicObject datapacket = (DynamicObject)datapackettran.get("datapacket");
                    Object id = datapacket.getPkValue();
                    ids.add(id);
                }
                int size = dynamicObjectCollection.size();
                this.subTotal += size;
            }
        }
        MainEntityType datapacketType = EntityMetadataCache.getDataEntityType((String)"ricc_datapacket");
        if (!ids.isEmpty()) {
            DynamicObject[] datapackets = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)datapacketType);
            HashMap<Object, DynamicObject> datapacketInfo = new HashMap<Object, DynamicObject>(datapackets.length);
            for (DynamicObject datapacket : datapackets) {
                Object id = datapacket.get("id");
                datapacketInfo.put(id, datapacket);
            }
            this.getProcess().feedbackTitle(String.format(ResManager.loadKDString((String)"\u5171\u52fe\u9009 %1$s \u4e2a\u4f20\u8f93\u4efb\u52a1\uff0c\u5305\u542b %2$s \u4e2a\u4f20\u8f93\u5305\u3002%n", (String)"TransferDataPacketTask_2", (String)"sys-ricc-platform", (Object[])new Object[0]), this.selectedPacket, this.subTotal));
            String string = (String)map.get("transfertype");
            this.handleTransferTasks(targetIds, selectedTransferTasks, datapacketInfo, string);
            this.getProcess().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
            OperateOption option = OperateOption.create();
            SaveServiceHelper.saveOperate((String)"ricc_transfertask", (DynamicObject[])selectedTransferTasks, (OperateOption)option);
            this.getProcess().complete();
            CommonUtil.saveLog(this.logs);
        } else {
            this.getProcess().fail(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fdb\u884c\u4f20\u8f93\u7684\u4f20\u8f93\u5305\uff01", (String)"TransferDataPacketTask_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }

    private void handleTransferTasks(String targetIds, DynamicObject[] selectedTransferTasks, Map<Object, DynamicObject> datapacketInfo, String transferType) {
        for (DynamicObject selectedTransferTask : selectedTransferTasks) {
            String taskNo = selectedTransferTask.getString("billno");
            DynamicObjectCollection datapackettrans = selectedTransferTask.getDynamicObjectCollection("datapackettrans");
            int total = datapackettrans.size();
            DynamicObject targetdatacenter = selectedTransferTask.getDynamicObject("targetdatacenter");
            HashMap<String, Object> loginParam = new HashMap<String, Object>(5);
            loginParam.put("evnurl", targetdatacenter.getString("evnurl"));
            loginParam.put("appsecuret", targetdatacenter.getString("appsecuret"));
            loginParam.put("targetdatacenteruser", selectedTransferTask.getString("targetdatacenteruser"));
            loginParam.put("accountId", targetdatacenter.getString("number"));
            loginParam.put("evntype", targetdatacenter.getString("evntype"));
            loginParam.put("tarDataCenterPk", targetdatacenter.getPkValue());
            if (total == 0) continue;
            int packetSucCount = this.handleDataPackets(targetIds, datapackettrans, loginParam, datapacketInfo, taskNo, transferType);
            selectedTransferTask.set(DOTRANSFERER, (Object)UserServiceHelper.getCurrentUserId());
            selectedTransferTask.set("datapackettrans", (Object)datapackettrans);
            this.getProcess().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
            if (packetSucCount == 0) {
                selectedTransferTask.set("billstatus", (Object)"A");
                selectedTransferTask.set(ISCOMPLETED, (Object)"3");
                continue;
            }
            if (packetSucCount > 0 && packetSucCount != total) {
                selectedTransferTask.set(ISCOMPLETED, (Object)"2");
                selectedTransferTask.set("billstatus", (Object)"C");
                continue;
            }
            selectedTransferTask.set(ISCOMPLETED, (Object)"1");
            selectedTransferTask.set(COMPLETETIME, (Object)System.currentTimeMillis());
            selectedTransferTask.set("billstatus", (Object)"C");
            ++this.totalSuccessCount;
            this.getProcess().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int handleDataPackets(String targetIds, DynamicObjectCollection datapackettrans, Map<String, Object> loginParam, Map<Object, DynamicObject> datapacketInfo, String taskNo, String transferType) {
        int packetSucCount = 0;
        Iterator iterator = datapackettrans.iterator();
        while (true) {
            String transType;
            String datapacketNum;
            Object id;
            LogRecorder errMsg;
            DynamicObject datapackettran;
            block16: {
                DynamicObject datapacket;
                if (!iterator.hasNext()) {
                    return packetSucCount;
                }
                datapackettran = (DynamicObject)iterator.next();
                errMsg = new LogRecorder();
                if (errMsg.length() > 0) {
                    errMsg.append("\n");
                }
                if (Objects.isNull(datapacket = (DynamicObject)datapackettran.get("datapacket"))) continue;
                id = datapacket.get("id");
                String transferstatus = datapackettran.getString("transferstatus");
                datapacketNum = datapacket.getString("number");
                String billName = datapacket.getString("name");
                String datapacketNameAndNo = datapacketNum + " | " + billName;
                String tarLoginUser = loginParam.get("targetdatacenteruser").toString();
                long tarDataCenterPk = (Long)loginParam.get("tarDataCenterPk");
                if ("transferandsyn".equals(transferType)) {
                    this.configLog.preWriteLog("5", this.taskId, ((Long)id).longValue(), tarDataCenterPk, tarLoginUser, null);
                } else {
                    this.configLog.preWriteLog("1", this.taskId, ((Long)id).longValue(), tarDataCenterPk, tarLoginUser, null);
                }
                log.info(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u53c2\u6570:: \u5305\uff1a%1$s, \u64cd\u4f5c\u7c7b\u578b\uff1a%2$s, \u4f20\u8f93\u72b6\u6001\uff1a%3$s", (String)"TransferDataPacketTask_4", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNameAndNo, transferType, transferstatus));
                Date lastTransferTime = datapackettran.getDate(TRANSFERTIME);
                Date lastUpdateTime = datapacket.getDate("modifytime");
                if (lastUpdateTime == null) {
                    errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %s \u7684\u4fee\u6539\u65f6\u95f4\u4e3a\u7a7a\uff0c\u662f\u5f02\u5e38\u6570\u636e\uff0c\u7cfb\u7edf\u903b\u8f91\u65e0\u6cd5\u6b63\u786e\u6267\u884c\uff0c\u8bf7\u4fdd\u5b58\u8be5\u4f20\u8f93\u5305\u7ef4\u62a4\u4e0b\u4fee\u6539\u65f6\u95f4\u5b57\u6bb5", (String)"TransferDataPacketTask_5", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum));
                    this.configLog.afterWriteLog(1, 0, (AbstractLogRecord)errMsg);
                    continue;
                }
                transType = "";
                log.info("\u4f20\u8f93\u5305\u6700\u540e\u4fee\u6539\u65f6\u95f4\uff1a" + lastUpdateTime);
                log.info("\u4f20\u8f93\u5305\u6700\u540e\u4f20\u8f93\u65f6\u95f4\uff1a" + lastTransferTime);
                if (lastTransferTime == null || lastUpdateTime.after(lastTransferTime)) {
                    transType = transferType;
                } else {
                    if (StringUtils.equals((CharSequence)transferType, (CharSequence)"transfer")) {
                        if (StringUtils.equals((CharSequence)transferstatus, (CharSequence)TransferStatusEnum.FAILED.getVal()) || StringUtils.equals((CharSequence)transferstatus, (CharSequence)TransferStatusEnum.NOTSTART.getVal())) {
                            transType = "transfer";
                            break block16;
                        } else {
                            errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %s \u7684\u73b0\u6709\u5185\u5bb9\u5df2\u6210\u529f\u4f20\u8f93\u81f3\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\uff0c\u65e0\u9700\u518d\u6b21\u4f20\u8f93", (String)"TransferDataPacketTask_6", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum));
                            this.configLog.afterWriteLog(1, 0, (AbstractLogRecord)errMsg);
                            continue;
                        }
                    }
                    if (StringUtils.equals((CharSequence)transferstatus, (CharSequence)TransferStatusEnum.SYN_SUCCESS.getVal())) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %s \u7684\u73b0\u6709\u5185\u5bb9\u5df2\u6210\u529f\u540c\u6b65\u81f3\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\uff0c\u65e0\u9700\u518d\u6b21\u540c\u6b65", (String)"TransferDataPacketTask_7", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum));
                        this.configLog.afterWriteLog(1, 0, (AbstractLogRecord)errMsg);
                        continue;
                    }
                    transType = StringUtils.equals((CharSequence)transferstatus, (CharSequence)TransferStatusEnum.FAILED.getVal()) || StringUtils.equals((CharSequence)transferstatus, (CharSequence)TransferStatusEnum.NOTSTART.getVal()) ? "transferandsyn" : "onlysyn";
                }
            }
            DynamicObject iccDatapacket = datapacketInfo.get(id);
            if (Objects.isNull(iccDatapacket)) continue;
            iccDatapacket.set("destdatacenter", (Object)targetIds);
            DynamicObjectCollection dCollection = iccDatapacket.getDynamicObjectCollection("subdatapacket");
            if (Objects.isNull(dCollection) || dCollection.isEmpty()) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %s \u4e0d\u5b58\u5728\u5b50\u4f20\u8f93\u5305\uff0c\u4f20\u8f93\u5931\u8d25\uff01", (String)"TransferDataPacketTask_8", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum));
                datapackettran.set("transferstatus", (Object)TransferStatusEnum.FAILED.getVal());
                this.configLog.afterWriteLog(1, 0, (AbstractLogRecord)errMsg);
                continue;
            }
            String filePath = FileUtils.generateLocalPath();
            File fileTemp = FileUtils.checkAndCreateDir((String)filePath);
            HashMap<String, String> mD5 = new HashMap<String, String>(dCollection.size());
            this.handleSubPackets(errMsg, datapacketNum, filePath, dCollection, mD5);
            if (this.writeToJson(errMsg, iccDatapacket, datapacketNum, filePath, mD5)) {
                datapackettran.set("transferstatus", (Object)TransferStatusEnum.FAILED.getVal());
                FileUtils.deleteLocalFile((File)fileTemp);
                this.configLog.afterWriteLog(1, 0, (AbstractLogRecord)errMsg);
                continue;
            }
            if (this.compressAndTransfer(errMsg, loginParam, datapackettran, datapacketNum, filePath, transType, id)) {
                boolean needWriteEntryLog;
                FileUtils.deleteLocalFile((File)fileTemp);
                boolean bl = needWriteEntryLog = transType.equals("transferandsyn") || transType.equals("onlysyn");
                if (needWriteEntryLog) {
                    this.configLog.afterWriteEntryLog(dCollection.size(), 0, (AbstractLogRecord)errMsg);
                    continue;
                }
                this.configLog.afterWriteLog(1, 0, (AbstractLogRecord)errMsg);
                continue;
            }
            FileUtils.deleteLocalFile((File)fileTemp);
            ++this.totalSubSuccessCount;
            ++packetSucCount;
            this.configLog.afterWriteLog(1, 1, (AbstractLogRecord)errMsg);
            this.getProcess().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
        }
    }

    private boolean compressAndTransfer(LogRecorder errMsg, Map<String, Object> loginParam, DynamicObject datapackettran, String datapacketNum, String filePath, String transferType, Object id) {
        ArrayList<Object> addDownloadCountList;
        LogRecorder syncMessage;
        HashMap<String, String> data = new HashMap<String, String>(4);
        String dataStream = this.compress(errMsg, datapackettran, datapacketNum, filePath);
        if (dataStream == null) {
            return true;
        }
        data.put("data", dataStream);
        data.put("billno", datapacketNum);
        data.put("methodName", transferType);
        log.info("\u4f20\u8f93\u6216\u540c\u6b65\u540c\u6b65\u4f20\u8f93\u5305\u7f16\u7801\uff1a" + datapacketNum);
        log.info("\u4f20\u8f93\u6216\u540c\u6b65\u540c\u6b65\u7c7b\u578b\u53c2\u6570\uff1a" + transferType);
        String response = null;
        try {
            response = ApiUtil.transfer(data, loginParam);
        }
        catch (RiccBizException e) {
            log.error("\u5728\u7ebf\u4f20\u8f93\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\u3002", (Throwable)e);
            datapackettran.set("transferstatus", (Object)TransferStatusEnum.FAILED.getVal());
            datapackettran.set(TRANSFERTIME, (Object)System.currentTimeMillis());
            errMsg.append(String.format(this.getTransferFailedMsg(), datapacketNum), (Throwable)e);
            return true;
        }
        catch (Exception e) {
            log.error("\u5728\u7ebf\u4f20\u8f93\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\u3002", (Throwable)e);
            datapackettran.set("transferstatus", (Object)TransferStatusEnum.FAILED.getVal());
            datapackettran.set(TRANSFERTIME, (Object)System.currentTimeMillis());
            errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %s \u5728\u7ebf\u4f20\u8f93\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff1a", (String)"TransferDataPacketTask_9", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum), (Throwable)e);
            return true;
        }
        log.info("\u5728\u7ebf\u4f20\u8f93\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4fe1\u606f\uff1a" + response);
        Map resp = (Map)JSON.parseObject((String)response, Map.class);
        String transferstatus = datapackettran.getString("transferstatus");
        String transferResult = (String)resp.get("data");
        try {
            syncMessage = (LogRecorder)SerializationUtils.fromJsonString((String)((String)resp.get("message")), LogRecorder.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6210LogRecorder\u5bf9\u8c61\u5931\u8d25\u3002", (Throwable)e);
            syncMessage = new LogRecorder();
            syncMessage.append(resp.get("message"));
        }
        if (transferResult == null) {
            errMsg.append(String.format(this.getTransferFailedMsg(), datapacketNum) + syncMessage.getMessageStr(), syncMessage.getDevMessageStr());
            return true;
        }
        String entryLogsStr = syncMessage.getEntryLogs();
        if (!StringUtils.isEmpty((CharSequence)entryLogsStr)) {
            Object[] entryLogs;
            for (Object entryLogObj : entryLogs = DynamicObjectSerializeUtil.deserialize((String)entryLogsStr, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ricc_log").getDynamicObjectCollection("synlogentry").getDynamicObjectType())) {
                DynamicObject entryLog = (DynamicObject)entryLogObj;
                String entrySynStatus = entryLog.getString("entrysynstatus");
                String entryLogTag = entryLog.getString("synlog_tag");
                int entrySuccessCount = entryLog.getInt("entrysuccesscount");
                int entryFailedCount = entryLog.getInt("entryfailedcount");
                int seq = entryLog.getInt("seq");
                this.configLog.buildEntrySyncLogWithMsg(entrySynStatus, entryLogTag, seq, entrySuccessCount, entryFailedCount);
            }
        }
        datapackettran.set("transferstatus", (Object)transferResult);
        datapackettran.set(TRANSFERTIME, (Object)System.currentTimeMillis());
        log.info("\u4f20\u8f93\u6216\u540c\u6b65\u8bbe\u7f6e\u6700\u540e\u72b6\u6001\uff1a" + transferResult);
        if (!transferResult.equals(TransferStatusEnum.SUCCESS.getVal()) && !transferResult.equals(TransferStatusEnum.SYN_SUCCESS.getVal())) {
            errMsg.append(String.format(this.getTransferFailedMsg(), datapacketNum) + syncMessage.getMessageStr(), syncMessage.getDevMessageStr());
            if (transferResult.equals(TransferStatusEnum.SYN_FAILED.getVal()) && (transferstatus.equals(TransferStatusEnum.NOTSTART.getVal()) || transferstatus.equals(TransferStatusEnum.FAILED.getVal()))) {
                addDownloadCountList = new ArrayList(1);
                addDownloadCountList.add(id);
                CommonUtil.afterDownload(addDownloadCountList);
            }
            return true;
        }
        if (transferstatus.equals(TransferStatusEnum.NOTSTART.getVal()) || transferstatus.equals(TransferStatusEnum.FAILED.getVal())) {
            addDownloadCountList = new ArrayList<Object>(1);
            addDownloadCountList.add(id);
            CommonUtil.afterDownload(addDownloadCountList);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String compress(LogRecorder errMsg, DynamicObject datapackettran, String datapacketNum, String filePath) {
        String data;
        String zipPath = FileUtils.generateLocalPath();
        File zipfile = FileUtils.createFile((String)(zipPath + File.separator + datapacketNum + ".zip"));
        File file = FileUtils.checkAndCreateDir((String)zipPath);
        try (FileOutputStream fos = new FileOutputStream(zipfile);
             FileInputStream fileInputStream = new FileInputStream(zipfile);
             ByteArrayOutputStream buffer = new ByteArrayOutputStream(0x400000);){
            FileUtils.toZip((String)filePath, (OutputStream)fos, (boolean)false);
            FileUtils.inputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)buffer);
            byte[] datapacketBytes = buffer.toByteArray();
            data = Hex.encode((byte[])datapacketBytes);
        }
        catch (Exception e) {
            log.error("\u6253\u5305\u538b\u7f29\u5931\u8d25\u3002", (Throwable)e);
            errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %s \u4f20\u8f93\u5931\u8d25\uff1a", (String)"TransferDataPacketTask_10", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum), (Throwable)e);
            datapackettran.set("transferstatus", (Object)"1");
            datapackettran.set(TRANSFERTIME, (Object)System.currentTimeMillis());
            String string = null;
            return string;
        }
        finally {
            FileUtils.deleteLocalFile((File)file);
        }
        return data;
    }

    private boolean writeToJson(LogRecorder errMsg, DynamicObject iccDatapacket, String datapacketNum, String filePath, Map<String, String> mD5) {
        String fileName = "ricc_datapacket.json";
        Map objectMap = DynamicObjectUtil.object2Map((DynamicObject)iccDatapacket);
        PacketDownLoadUtil.writeConfig2Map((DynamicObjectCollection)iccDatapacket.get("subdatapacket"), (ArrayList)objectMap.get("subdatapacket"));
        objectMap.putAll(mD5);
        DynamicObject versionObject = iccDatapacket.getDynamicObject("packetversion");
        String versionNumber = null;
        if (versionObject != null) {
            versionNumber = versionObject.getString("number");
        }
        objectMap.put("packetversion_number", versionNumber);
        EnvRoleEnum role = EnvRoleEnum.fromVal((String)SysParaUtil.getenvRole());
        String srcdatacenter = (String)objectMap.get("srcdatacenter");
        if (StringUtils.isEmpty((CharSequence)srcdatacenter)) {
            if (role != null) {
                objectMap.put("srcdatacenter", role.getName() + "(" + RequestContext.get().getAccountId() + ") -> ");
            }
        } else if (role != null) {
            objectMap.put("srcdatacenter", srcdatacenter + "->" + role.getName() + "(" + RequestContext.get().getAccountId() + ") -> ");
        }
        String fullFilePath = filePath + File.separator + fileName;
        try {
            FileUtils.writeMap2File((String)fullFilePath, (Map)objectMap);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\uff1a%s \u4fe1\u606f\u5199\u5165json\u6587\u4ef6\u5931\u8d25\u3002", (String)"TransferDataPacketTask_11", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum), (Throwable)e);
            return true;
        }
        return false;
    }

    private void handleSubPackets(LogRecorder errMsg, String datapacketNum, String filePath, DynamicObjectCollection dCollection, Map<String, String> signMap) {
        ArrayList<DynamicObject> invalidList = new ArrayList<DynamicObject>();
        for (int i = 0; i < dCollection.size(); ++i) {
            DynamicObject row = (DynamicObject)dCollection.get(i);
            String subFileName = (String)row.get("filename");
            int status = row.getInt("entrystatus");
            if (status == 1) {
                log.info("\u5b50\u4f20\u8f93\u5305\u3010" + subFileName + "\u3011\u5df2\u4f5c\u5e9f\uff0c\u65e0\u9700\u8fdb\u884c\u4f20\u8f93\u3002");
                invalidList.add(row);
                continue;
            }
            DynamicObjectCollection fileDy = (DynamicObjectCollection)row.get("subdatapacketfile");
            if (Objects.isNull(fileDy) || fileDy.isEmpty()) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %1$s \u5b50\u4f20\u8f93\u5305\u7b2c%2$s\u884c\uff0c\u6587\u4ef6\u627e\u4e0d\u5230\uff01", (String)"TransferDataPacketTask_12", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum, i + 1));
                continue;
            }
            DynamicObject dataPackage = (DynamicObject)fileDy.get(0);
            DynamicObject fileBaseDataId = dataPackage.getDynamicObject("fbasedataid");
            String fileUrl = (String)fileBaseDataId.get("url");
            String realFileUrl = CommonUtil.checkUrl((String)fileUrl);
            File subZipFile = FileUtils.createFile((String)(filePath + File.separator + subFileName));
            try (ByteArrayOutputStream by = FileUtils.getFileOutputStream((String)realFileUrl);
                 FileOutputStream downloadFile = new FileOutputStream(subZipFile);){
                downloadFile.write(by.toByteArray());
            }
            catch (IOException e) {
                log.error((Throwable)e);
                errMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305 %1$s \u5b50\u4f20\u8f93\u5305\u7b2c%2$s\u884c\uff0c\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25\u3002", (String)"TransferDataPacketTask_13", (String)"sys-ricc-platform", (Object[])new Object[0]), datapacketNum, i + 1), (Throwable)e);
                continue;
            }
            String signStr = Sha256Util.fileToSha256((File)subZipFile);
            signMap.put(subFileName, signStr);
        }
        dCollection.removeAll(invalidList);
    }

    public TransferPacketProgress getProcess() {
        if (this.transferProcess == null) {
            this.transferProcess = new TransferPacketProgress(this.taskId, CommonConstant.getMsgTransferTaskName());
        }
        return this.transferProcess;
    }
}

