/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.business.hosting.GITCodeHostingServiceImpl;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.instance.Instance;
import kd.sys.ricc.common.util.StringUtils;

public class GitLoginFormPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"giturl", "gitbranch", BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String encryptUserName = (String)formShowParameter.getCustomParam("username");
        if (StringUtils.isNotEmpty((String)encryptUserName)) {
            String distributeKey = Instance.getClusterName() + "." + RequestContext.get().getAccountId() + ".git." + encryptUserName;
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ricc_git_userInfo", new DistributeCacheHAPolicy());
            this.getView().setVisible(Boolean.valueOf(cache.contains(distributeKey)), new String[]{"account", "branch"});
            if (cache.contains(distributeKey)) {
                String userName = Encrypters.decode((String)encryptUserName);
                String encryptPassGit = (String)cache.get(distributeKey, "passgit");
                String passGit = Encrypters.decode((String)encryptPassGit);
                String gitUrl = (String)cache.get(distributeKey, "giturl");
                String gitBranch = (String)cache.get(distributeKey, "gitbranch");
                this.getModel().setValue("username", (Object)userName);
                this.getModel().setValue("passgit", (Object)passGit);
                this.getModel().setValue("giturl", (Object)gitUrl);
                List<String> branches = this.setBranchItems(userName, passGit, gitUrl);
                if (branches != null && branches.contains(gitBranch)) {
                    this.getModel().setValue("gitbranch", (Object)gitBranch);
                } else {
                    this.getModel().setValue("gitbranch", null);
                }
            }
        }
    }

    public void click(EventObject evt) {
        String gitUrl;
        String passGit;
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        String gitUsername = (String)this.getModel().getValue("username");
        if (StringUtils.isNotBlank((CharSequence)gitUsername)) {
            gitUsername = gitUsername.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(passGit = (String)this.getModel().getValue("passgit")))) {
            passGit = passGit.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(gitUrl = (String)this.getModel().getValue("giturl")))) {
            gitUrl = gitUrl.trim();
        }
        String gitBranch = (String)this.getModel().getValue("gitbranch");
        if (StringUtils.equals((String)"giturl", (String)key)) {
            if (this.checkUrlParameter(gitUsername, passGit, gitUrl)) {
                return;
            }
            if (this.validateGitUrl(gitUsername, passGit, gitUrl)) {
                return;
            }
            List<String> branches = this.setBranchItems(gitUsername, passGit, gitUrl);
            if (branches == null) {
                this.getModel().setValue("gitbranch", null);
            } else if (branches.contains("main") && (StringUtils.isEmpty((String)gitBranch) || !branches.contains(gitBranch))) {
                this.getModel().setValue("gitbranch", (Object)"main");
            } else if (!branches.contains(gitBranch)) {
                this.getModel().setValue("gitbranch", null);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"Git\u767b\u5f55\u4fe1\u606f\u9a8c\u8bc1\u6210\u529f\u3002", (String)"GitLoginFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
        } else if (StringUtils.equals((String)BTN_OK, (String)key)) {
            if (this.checkUrlParameter(gitUsername, passGit, gitUrl)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)gitBranch)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GitLoginFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            if (this.validateGitUrl(gitUsername, passGit, gitUrl)) {
                return;
            }
            List<String> branches = this.setBranchItems(gitUsername, passGit, gitUrl);
            if (branches == null || !branches.contains(gitBranch)) {
                this.getModel().setValue("gitbranch", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5206\u652f%s\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u5207\u6362Git\u8fdc\u7a0b\u5206\u652f\u3002", (String)"GitLoginFormPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[]{gitBranch}));
                return;
            }
            Map<String, String> dataMap = this.saveParameter(gitUsername, passGit, gitUrl, gitBranch);
            this.getView().returnDataToParent(dataMap);
            this.getView().close();
        }
    }

    private Map<String, String> saveParameter(String gitUsername, String passGit, String gitUrl, String gitBranch) {
        String encryptUserName = Encrypters.encode((String)gitUsername);
        String encryptPassGit = Encrypters.encode((String)passGit);
        long currUserId = RequestContext.get().getCurrUserId();
        String key = "ricc_gitmsg_" + currUserId;
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).setClientLocalStorage(key, encryptUserName);
        String distributeKey = Instance.getClusterName() + "." + RequestContext.get().getAccountId() + ".git." + encryptUserName;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ricc_git_userInfo", new DistributeCacheHAPolicy());
        cache.put(distributeKey, "giturl", (Object)gitUrl);
        cache.put(distributeKey, "gitbranch", (Object)gitBranch);
        cache.put(distributeKey, "passgit", (Object)encryptPassGit);
        HashMap<String, String> dataMap = new HashMap<String, String>(2);
        dataMap.put("username", gitUsername);
        dataMap.put("gitbranch", gitBranch);
        return dataMap;
    }

    private boolean checkUrlParameter(String gitUsername, String passGit, String gitUrl) {
        if (StringUtils.isBlank((CharSequence)gitUsername)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"KingCode\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GitLoginFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)passGit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"KingCode\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GitLoginFormPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)gitUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GitLoginFormPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)gitUrl) && !gitUrl.endsWith(".git")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Git\u8fdc\u7a0b\u5730\u5740\u4e0d\u6b63\u786e\u3002", (String)"GitLoginFormPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateGitUrl(String gitUsername, String passGit, String gitUrl) {
        try {
            GITCodeHostingServiceImpl.checkRemoteAccount((String)gitUrl, (String)gitUsername, (String)passGit);
        }
        catch (Exception e) {
            if (e.getMessage().contains("not authorized")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u8d26\u53f7\uff1a%s\u662f\u5426\u6b63\u786e\uff0c\u6216\u8005\u68c0\u67e5\u8d26\u53f7\u662f\u5426\u5177\u6709\u76f8\u5e94\u7684\u6743\u9650\u3002", (String)"GitLoginFormPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[]{gitUsername}));
            } else if (e.getMessage().contains("timed out")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u8d26\u53f7\u662f\u5426\u6b63\u786e\u6216\u8005\u7f51\u7edc\u662f\u5426\u6b63\u5e38\u540e\u91cd\u8bd5\u3002", (String)"GitLoginFormPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6Git\u8fdc\u7a0b\u5206\u652f\u5931\u8d25: %s", (String)"GitLoginFormPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()));
            }
            return true;
        }
        return false;
    }

    private List<String> setBranchItems(String gitUsername, String passGit, String gitUrl) {
        List<String> branches = new ArrayList(16);
        try {
            branches = GitOperationUtil.getBranchs((String)gitUrl, (String)gitUsername, (String)passGit);
            if (!branches.isEmpty()) {
                ArrayList<ComboItem> branchItems = new ArrayList<ComboItem>(16);
                for (String branch : branches) {
                    branchItems.add(new ComboItem(new LocaleString(branch), branch));
                }
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl("gitbranch");
                comboEdit.setComboItems(branchItems);
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6Git\u8fdc\u7a0b\u5206\u652f\u5931\u8d25: %s", (String)"GitLoginFormPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()));
        }
        return branches;
    }
}

