/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter.batchpack;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BatchPackLogEditPlugin
extends AbstractFormPlugin {
    private static final String PART_FAILED = "part_failed";
    private static final String ALL_FAILED = "all_failed";
    private static final String SAVE = "save";
    private static final String DISCARD = "discard";
    private static final String CLOSE = "close";
    private static final String DETAIL = "detail";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE, DISCARD, CLOSE, DETAIL});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String failKey = (String)showParameter.getCustomParam("failKey");
        String msg = (String)showParameter.getCustomParam("msg");
        Label label = (Label)this.getView().getControl("msglabel");
        label.setText(msg);
        if (PART_FAILED.equals(failKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CLOSE});
        } else if (ALL_FAILED.equals(failKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE, DISCARD});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String clickKey = button.getKey();
        String packetNumber = (String)this.getView().getFormShowParameter().getCustomParam("packetNumber");
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        switch (clickKey) {
            case "discard": {
                this.getView().returnDataToParent((Object)("discard@" + packetNumber + "@" + rootPageId));
                this.getView().close();
                break;
            }
            case "save": {
                this.getView().returnDataToParent((Object)("save@" + packetNumber + "@" + rootPageId));
                this.getView().close();
                break;
            }
            case "detail": {
                this.showDetailLogForm();
                break;
            }
        }
    }

    private void showDetailLogForm() {
        Long logId = (Long)this.getView().getFormShowParameter().getCustomParam("logId");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("ricc_log");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId((Object)logId);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

