/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter.batchpack;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sys.ricc.business.datapacket.schedule.BatchPacketTask;
import kd.sys.ricc.business.datapacket.schedule.BatchPacketTaskClick;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.formplugin.AbstractProgressFormPlugin;

public class BatchPackProgressFormPlugin
extends AbstractProgressFormPlugin {
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETE = "complete";
    private static final String LABEL_SUCCESSALL = "successall";
    private static final String PANEL_SUCCESSS = "successpanel";
    private static final String PANEL_SYNC = "addpanel";
    private static final String PANEL_FAIL = "failedpanel";
    private static final String KEY_CURRENTROW = "currentrow";
    private static final String SAVE = "save";
    private static final String DISCARD = "discard";
    private static final String FAIL_MSG = "failmsg";
    private static final String PACKET_NUMBER = "packetNumber";
    private static final String SUCCESS_COUNT = "successCount";
    private static final String ALL_FAILED = "all_failed";
    private static final String PART_FAILED = "part_failed";
    private static final String MSG_CONFIRM_ACTION = "showConfirmMsg";

    @Override
    public JobFormInfo buildJobFormInfo() {
        Map allParam = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(allParam);
        params.put("requestcontext", RequestContext.get());
        return ScheduleUtil.buildJobFormInfo(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305", (String)"BatchPackProgressFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), BatchPacketTask.class.getName(), BatchPacketTaskClick.class.getName(), this.getView(), params);
    }

    @Override
    public void showDetails(TaskInfo taskInfo) {
        Map<String, Object> data = ScheduleUtil.getTaskCustData(taskInfo);
        if (data.size() <= 0) {
            return;
        }
        Object totalVal = data.get(KEY_TOTAL);
        int totalCount = totalVal != null ? Integer.parseInt(totalVal.toString()) : 0;
        String completeVal = (String)data.get(KEY_COMPLETE);
        int completeCount = completeVal != null ? Integer.parseInt(completeVal) : 0;
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(String.valueOf(totalCount));
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText(String.valueOf(completeCount));
        Label currentrowLabel = (Label)this.getControl(KEY_CURRENTROW);
        int currentrowCount = completeCount + 1;
        if (currentrowCount > totalCount) {
            currentrowCount = totalCount;
        }
        currentrowLabel.setText(String.valueOf(currentrowCount));
        if (totalCount == completeCount) {
            Label titleLabel = (Label)this.getControl("title");
            titleLabel.setText(taskInfo.getDesc());
        }
    }

    @Override
    public void showComplete(TaskInfo taskInfo, ProgressEvent e) {
        Map<String, Object> taskData = ScheduleUtil.getTaskCustData(taskInfo);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (StringUtils.isNotBlank((CharSequence)taskInfo.getFailureReason())) {
                this.getView().showMessage(taskInfo.getFailureReason());
            }
            this.stopBar();
        } else {
            String failMessage = (String)taskData.get(FAIL_MSG);
            if (failMessage != null && StringUtils.isNotBlank((CharSequence)failMessage)) {
                int total = (Integer)taskData.get(KEY_TOTAL);
                int successCount = (Integer)taskData.get(SUCCESS_COUNT);
                String packetNumber = String.valueOf(taskData.get(PACKET_NUMBER));
                Object logId = taskData.get("logId");
                this.getPageCache().put(PACKET_NUMBER, packetNumber);
                if (successCount <= 0) {
                    String msg = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305\u4efb\u52a1\u6267\u884c\u5168\u90e8\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a", (String)"BatchPackProgressFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    this.showExportConfirmForm(this.getView(), logId, ALL_FAILED, msg);
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305%1$s\u90e8\u5206\u914d\u7f6e\u9879\u6253\u5305\u5931\u8d25\uff08\u6210\u529f%2$d\u9879\uff0c\u5931\u8d25%3$d\u9879\uff09\uff0c\u662f\u5426\u4fdd\u7559\u5f53\u524d\u4f20\u8f93\u5305\uff1f\u70b9\u51fb\u8be6\u60c5\u67e5\u770b\u5931\u8d25\u539f\u56e0", (String)"BatchPackProgressFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNumber, successCount, total - successCount);
                    this.showExportConfirmForm(this.getView(), logId, PART_FAILED, msg);
                }
                e.setProgress(100);
                this.stopBar();
                return;
            }
        }
        Label success = (Label)this.getControl(LABEL_SUCCESSALL);
        success.setText("" + taskData.get(KEY_COMPLETE));
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_SUCCESSS});
        this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_SYNC, PANEL_FAIL});
        HashMap<String, Integer> notHidden = new HashMap<String, Integer>(1);
        notHidden.put("gr", 1);
        this.getView().updateControlMetadata(PANEL_SUCCESSS, notHidden);
        String newName = ResManager.loadKDString((String)"\u5173\u95ed", (String)"BatchPackProgressFormPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        this.modifyControlName("btncancel", newName);
        e.setProgress(100);
        this.stopBar();
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
        this.getPageCache().put(PACKET_NUMBER, String.valueOf(taskData.get(PACKET_NUMBER)));
        this.getView().returnDataToParent((Object)String.valueOf(taskData.get(PACKET_NUMBER)));
    }

    public void closedCallBack(ClosedCallBackEvent callBack) {
        super.closedCallBack(callBack);
        String callBackId = callBack.getActionId();
        String packetNumber = this.getPageCache().get(PACKET_NUMBER);
        if (MSG_CONFIRM_ACTION.equals(callBackId)) {
            if (StringUtils.isEmpty((CharSequence)packetNumber)) {
                return;
            }
            String result = (String)callBack.getReturnData();
            if (result != null && result.contains(DISCARD)) {
                DeleteServiceHelper.delete((String)"ricc_datapacket", (QFilter[])new QFilter("number", "=", (Object)packetNumber).toArray());
                this.getView().returnDataToParent((Object)DISCARD);
            } else if (result != null && result.contains(SAVE)) {
                this.getView().returnDataToParent((Object)packetNumber);
            }
            this.getView().close();
        }
    }

    private void showExportConfirmForm(IFormView view, Object logId, String failKey, String msg) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_onekeypackconfirm");
        showParameter.setCustomParam("failKey", (Object)failKey);
        showParameter.setCustomParam("msg", (Object)msg);
        showParameter.setCustomParam("logId", logId);
        showParameter.setAppId("ricc");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MSG_CONFIRM_ACTION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }
}

