/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter.guide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class SelectConfigItemPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String PARENT_ID = "parentId";
    private static final String MENU_ID = "menuId";
    private static final String FORM_ID = "formId";
    private static final String PX = "600px";
    private static final String CENTER = "center";
    private static final Log logger = LogFactory.getLog(SelectConfigItemPlugin.class);
    private static final String MENU_PREFIX = "menu#";
    private static final String ICON_PREFIX = "iconap";
    private static final String PANEL_PREFIX = "panelap";
    private static final String LABEL_PREFIX = "labelap";
    private static final String VECTOR_PREFIX = "vectorap";
    private static final String PANEL_CONTAINER = "flexpanel_menucards";
    private static final String DEFAULT_ICONURL = "/icons/pc/entrance/default_48_48.png";
    private static final String UNSELECT_FONT = "kdfont kdfont-danxuankuang-weixuan";
    private static final String SELECTED_FONT = "kdfont kdfont-liebiaodanxuankuangxuanzhong";
    private static final String CLOUD_APP_TREE = "tree_cloudappmenu";
    private static final String SELECTED_NODE = "cache_selectedNode";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView treeCloudAppMenu = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        treeCloudAppMenu.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCloudAppTree();
    }

    private void initCloudAppTree() {
        String langName = RequestContext.get().getLang().name();
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(logger, this.getView());
        JSONArray resultApps = portalUtil.getUserHasPerApp();
        if (resultApps == null || resultApps.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528", (String)"SelectConfigItemPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<String, TreeNode> cloudNodeMap = new LinkedHashMap<String, TreeNode>(10);
        block0: for (int i = 0; i < resultApps.size(); ++i) {
            JSONArray cloudAppItem = (JSONArray)resultApps.get(i);
            for (Object item : cloudAppItem) {
                String name;
                Map itemMap = null;
                if (item instanceof Map) {
                    itemMap = (Map)item;
                }
                if (itemMap == null) continue;
                Boolean isCloud = (Boolean)itemMap.get("iscloud");
                if (isCloud == null || !isCloud.booleanValue()) {
                    String parentId = itemMap.get("cloudid") == null ? null : itemMap.get("cloudid").toString().toLowerCase();
                    String tempAppNum = itemMap.get("number") == null ? null : itemMap.get("number").toString();
                    String tempAppid = itemMap.get("id") == null ? null : itemMap.get("id").toString();
                    Map nameMap = (Map)itemMap.get("name");
                    String name2 = null;
                    if (nameMap != null) {
                        String string = name2 = nameMap.get(langName) == null ? null : nameMap.get(langName).toString();
                    }
                    if (StringUtils.isEmpty((String)parentId) || StringUtils.isEmpty((String)tempAppNum) || StringUtils.isEmpty((String)name2)) continue;
                    TreeNode appNode = new TreeNode();
                    appNode.setId(tempAppid);
                    appNode.setText(name2);
                    appNode.setParentid(parentId);
                    appNode.setIsOpened(false);
                    appNode.setChildren(null);
                    appNode.setData((Object)tempAppNum);
                    TreeNode currCloudNode = (TreeNode)cloudNodeMap.get(parentId);
                    currCloudNode.addChild(appNode);
                    cloudNodeMap.put(parentId, currCloudNode);
                    continue;
                }
                String id = itemMap.get("id") == null ? null : itemMap.get("id").toString().toLowerCase();
                Map nameMap = (Map)itemMap.get("name");
                String string = name = nameMap.get(langName) == null ? null : nameMap.get(langName).toString();
                if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)name)) continue block0;
                TreeNode cloudNode = new TreeNode();
                cloudNode.setId(id);
                cloudNode.setText(name);
                cloudNode.setParentid("");
                cloudNode.setIsOpened(i == 0);
                cloudNodeMap.put(id, cloudNode);
            }
        }
        ArrayList cloudNodeList = new ArrayList(cloudNodeMap.values());
        TreeView tree = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        tree.addNodes(cloudNodeList);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void click(EventObject evt) {
        super.click(evt);
        String key = null;
        Object source = evt.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (key == null) {
            return;
        }
        switch (key) {
            case "btnok": {
                Tab tab = (Tab)this.getControl("tabap");
                String curTabId = tab.getCurrentTab();
                ArrayList returnData = new ArrayList();
                if ("tabpage_appfunc".equals(curTabId)) {
                    String selStr = this.getPageCache().get(SELECTED_NODE);
                    if (!StringUtils.isNotEmpty((String)selStr)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u6570\u636e", (String)"SelectConfigItemPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                        return;
                    }
                    Map selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
                    if (selMap.size() <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u6570\u636e", (String)"SelectConfigItemPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                        return;
                    }
                    for (Map.Entry entry : selMap.entrySet()) {
                        HashMap<String, String> returnMap = new HashMap<String, String>();
                        String menuId = this.getPageCache().get((String)entry.getKey());
                        if (StringUtils.isEmpty((String)menuId)) {
                            menuId = (String)entry.getKey();
                        }
                        returnMap.put("cache_sel_menuId", menuId);
                        returnData.add(returnMap);
                    }
                }
                String formId = (String)((Map)returnData.get(0)).get("cache_sel_menuId");
                String pageNumber = formId.substring(formId.lastIndexOf(35) + 1);
                this.getView().returnDataToParent((Object)pageNumber);
                this.getView().close();
                break;
            }
        }
        if (key.startsWith(VECTOR_PREFIX)) {
            Map<String, String> selMap;
            Vector vectorIcon = (Vector)this.getView().getControl(key);
            String vectorUrl = this.getPageCache().get(key);
            String selStr = this.getPageCache().get(SELECTED_NODE);
            if (StringUtils.isNotEmpty((String)selStr) && (selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class)) != null) {
                for (String selectKey : selMap.keySet()) {
                    Vector vectorSelect = (Vector)this.getView().getControl(VECTOR_PREFIX + selectKey);
                    vectorSelect.setFontClass(UNSELECT_FONT);
                    this.getPageCache().put(VECTOR_PREFIX + selectKey, UNSELECT_FONT);
                }
                selMap.clear();
            }
            selMap = new HashMap();
            if (StringUtils.isEmpty((String)vectorUrl) || UNSELECT_FONT.equals(vectorUrl)) {
                vectorIcon.setFontClass(SELECTED_FONT);
                this.getPageCache().put(key, SELECTED_FONT);
                TreeView cloudAppTree = (TreeView)this.getControl(CLOUD_APP_TREE);
                Map focusNode = cloudAppTree.getTreeState().getFocusNode();
                String appNum = this.getView().getFormShowParameter().getAppId();
                String appId = StringUtils.isEmpty((String)appNum) ? focusNode.get("id").toString() : AppMetadataCache.getAppInfo((String)appNum).getId();
                selMap.put(key.substring(VECTOR_PREFIX.length()), appId);
            } else {
                vectorIcon.setFontClass(UNSELECT_FONT);
                this.getPageCache().put(key, UNSELECT_FONT);
            }
            this.getPageCache().put(SELECTED_NODE, SerializationUtils.toJsonString(selMap));
        }
    }

    private Map<String, Map<String, String>> getMenuInfoMap(String appID, Map<String, List<String>> menuRelationMap) {
        Map<String, String> menuInfo;
        String appNum = AppMetadataCache.getAppNumberById((String)appID);
        if (StringUtils.isBlank((String)appNum) || StringUtils.isEmpty((String)appNum)) {
            return new HashMap<String, Map<String, String>>(2);
        }
        List menus = AppMetadataCache.getAppMenusInfoByAppId((String)appNum);
        List qingMenus = this.getPageCache() != null && this.getPageCache().get("qingmenus_" + appID) != null ? JSONObject.parseArray((String)this.getPageCache().get("qingmenus_" + appID), AppMenuInfo.class) : this.getQingMenuArray(appID);
        if (qingMenus != null) {
            menus.addAll(qingMenus);
        }
        if (menus == null || menus.isEmpty()) {
            logger.info("appID -- " + appID + ", appNum -- " + appNum + " \u83dc\u5355\u7f13\u5b58\u4e3a\u7a7a");
            return new HashMap<String, Map<String, String>>();
        }
        if (menuRelationMap == null) {
            menuRelationMap = new HashMap<String, List<String>>();
        }
        HashMap<String, Map<String, String>> menuInfos = new HashMap<String, Map<String, String>>(menus.size());
        for (AppMenuInfo menu : menus) {
            String menuId = menu.getId();
            this.getPageCache().put(menuId.toLowerCase(), menuId);
            if (menuId.endsWith("#hpce")) continue;
            menuInfo = new HashMap(6);
            String parentId = menu.getParentId();
            menuInfo.put(MENU_ID, menuId);
            menuInfo.put(PARENT_ID, parentId);
            menuInfo.put("text", menu.getName().getLocaleValue());
            menuInfo.put(FORM_ID, menu.getFormId());
            menuInfo.put("seq", menu.getSeq().toString());
            menuInfo.put("icon", menu.getShortcutIcon());
            menuInfos.put(menuId, menuInfo);
            menuRelationMap.computeIfAbsent(parentId, k -> new ArrayList()).add(menuId);
        }
        HashSet<String> needDel = new HashSet<String>();
        for (Map.Entry entry : menuInfos.entrySet()) {
            String key = (String)entry.getKey();
            menuInfo = (Map)entry.getValue();
            String formId = (String)menuInfo.get(FORM_ID);
            List<String> children = menuRelationMap.get(entry.getKey());
            if (!StringUtils.isEmpty((String)formId) || children != null && !children.isEmpty()) continue;
            needDel.add(key);
        }
        if (needDel.isEmpty()) {
            return menuInfos;
        }
        for (String id : needDel) {
            menuInfos.remove(id);
        }
        return menuInfos;
    }

    public List<AppMenuInfo> getQingMenuArray(String appID) {
        ArrayList<AppMenuInfo> appMenuInfoList = new ArrayList<AppMenuInfo>(2);
        String appNum = AppMetadataCache.getAppNumberById((String)appID);
        if (appNum == null || "".equals(appNum.trim())) {
            return appMenuInfoList;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
        if (appInfo == null || appInfo.getId() == null || "".equals(appInfo.getId())) {
            return appMenuInfoList;
        }
        List qingMenus = null;
        try {
            logger.info("getQingMenuArray, appid = " + appID);
            Class<?> qingAppMenuUtil = Class.forName("kd.bos.qing.plugin.appmenu.PublishedAppMenuUtil");
            qingMenus = (List)MethodUtils.invokeStaticMethod(qingAppMenuUtil, (String)"getPublishedAppQingMenuList", (Object)appID);
            JSONArray qingPublishMenus = JSONArray.parseArray((String)JSONUtils.toString((Object)qingMenus));
            if (this.getPageCache() != null) {
                this.getPageCache().put("qingmenus_" + appID, qingPublishMenus.toJSONString());
            }
        }
        catch (Exception ex) {
            logger.error("getQingMenuArray error.", (Throwable)ex);
            return appMenuInfoList;
        }
        return qingMenus;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeView srcTreeView = (TreeView)e.getSource();
        Map focusNodeMap = srcTreeView.getTreeState().getFocusNode();
        String treeKey = srcTreeView.getKey();
        String nodeId = (String)focusNodeMap.get("id");
        if (CLOUD_APP_TREE.equals(treeKey)) {
            String parentId = (String)focusNodeMap.get("parentid");
            if (StringUtils.isEmpty((String)parentId)) {
                srcTreeView.expand(nodeId);
            } else if (nodeId.startsWith(MENU_PREFIX)) {
                this.refreshMenuCardPanel(nodeId);
            } else {
                this.refreshMenuCardPanel(nodeId);
            }
        }
    }

    private void refreshMenuCardPanel(String nodeId) {
        List<String> controlKey = new ArrayList();
        String controlKeyJsonStr = this.getPageCache().get("controlKey");
        Container c = (Container)this.getControl(PANEL_CONTAINER);
        if (!StringUtils.isEmpty((String)controlKeyJsonStr)) {
            controlKey = SerializationUtils.fromJsonStringToList((String)controlKeyJsonStr, String.class);
            for (String key : controlKey) {
                c.deleteControls(new String[]{key});
            }
            this.getView().updateView(PANEL_CONTAINER);
            controlKey.clear();
        }
        String selStr = this.getPageCache().get(SELECTED_NODE);
        Map selMap = new HashMap();
        if (StringUtils.isNotEmpty((String)selStr)) {
            selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
        }
        if (!nodeId.startsWith(MENU_PREFIX)) {
            String appNum = AppMetadataCache.getAppNumberById((String)nodeId);
            HashMap<String, List<String>> menuRelationMap = new HashMap<String, List<String>>();
            Map<String, Map<String, String>> menuInfoMap = this.getMenuInfoMap(nodeId, menuRelationMap);
            ArrayList<Map<String, String>> firstMenu = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : menuInfoMap.entrySet()) {
                Map<String, String> map = entry.getValue();
                String parentId = map.get(PARENT_ID);
                if (!nodeId.equals(parentId)) continue;
                firstMenu.add(map);
            }
            if (firstMenu.isEmpty()) {
                return;
            }
            firstMenu.sort((map1, map2) -> {
                short seq1 = Short.parseShort((String)map1.get("seq"));
                short seq2 = Short.parseShort((String)map2.get("seq"));
                return seq1 - seq2;
            });
            List menuBlackList = CardUtils.getProductBlackMenus((String)appNum);
            for (Map map : firstMenu) {
                String id = (String)map.get(MENU_ID);
                if (menuBlackList.contains(id)) continue;
                String text = (String)map.get("text");
                ArrayList<Map> list = new ArrayList<Map>();
                LabelAp labelTitle = new LabelAp();
                labelTitle.setKey(id.toLowerCase());
                controlKey.add(id.toLowerCase());
                labelTitle.setName(new LocaleString(text));
                labelTitle.setFontSize(18);
                labelTitle.setHeight(new LocaleString("30px"));
                labelTitle.setWidth(new LocaleString(PX));
                labelTitle.setShrink(0);
                Style style = labelTitle.getStyle();
                if (style == null) {
                    style = new Style();
                }
                Margin margin = new Margin();
                margin.setTop("20px");
                margin.setLeft("20px");
                style.setMargin(margin);
                labelTitle.setStyle(style);
                FlexPanelAp outerPanel = new FlexPanelAp();
                outerPanel.setKey(PANEL_PREFIX + id.toLowerCase());
                controlKey.add(PANEL_PREFIX + id.toLowerCase());
                outerPanel.setDirection("row");
                outerPanel.setGrow(0);
                outerPanel.setShrink(0);
                outerPanel.setWidth(new LocaleString(PX));
                outerPanel.setOverflow("auto");
                style = outerPanel.getStyle();
                if (style == null) {
                    style = new Style();
                }
                Padding padding = new Padding();
                padding.setTop("15px");
                style.setPadding(padding);
                outerPanel.setStyle(style);
                List<Map<String, String>> curAndSubMenus = this.getCurAndSubMenus(id, menuInfoMap, menuRelationMap);
                if (curAndSubMenus.isEmpty()) continue;
                for (Map<String, String> menuInfo : curAndSubMenus) {
                    String menuId = menuInfo.get(MENU_ID);
                    if (menuBlackList.contains(menuId)) continue;
                    String formId = menuInfo.get(FORM_ID);
                    FlexPanelAp itemPanel = new FlexPanelAp();
                    itemPanel.setKey("panelap_item_" + menuId.toLowerCase());
                    itemPanel.setDirection("row");
                    itemPanel.setAlignItems(CENTER);
                    itemPanel.setGrow(0);
                    itemPanel.setJustifyContent(CENTER);
                    itemPanel.setAlignItems(CENTER);
                    itemPanel.setShrink(0);
                    itemPanel.setOverflow("hidden");
                    itemPanel.setWidth(new LocaleString("100px"));
                    style = itemPanel.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    padding = new Padding();
                    padding.setLeft("5px");
                    padding.setTop("5px");
                    padding.setBottom("5px");
                    style.setPadding(padding);
                    itemPanel.setStyle(style);
                    String name = menuInfo.get("text");
                    String iconUrl = menuInfo.get("icon");
                    IconAp icon = new IconAp();
                    icon.setKey(ICON_PREFIX + menuId.toLowerCase());
                    icon.setName(new LocaleString(name));
                    if (StringUtils.isEmpty((String)iconUrl)) {
                        icon.setImageKey(DEFAULT_ICONURL);
                    } else {
                        icon.setImageKey(iconUrl);
                    }
                    icon.setHeight(new LocaleString("48px"));
                    icon.setWidth(new LocaleString("48px"));
                    icon.setRadius("6px");
                    style = new Style();
                    margin = new Margin();
                    margin.setBottom("3px");
                    style.setMargin(margin);
                    icon.setStyle(style);
                    VectorAp selector = new VectorAp();
                    selector.setKey(VECTOR_PREFIX + menuId + "#" + formId);
                    selector.setName(new LocaleString());
                    if (selMap.containsKey(formId)) {
                        selector.setfontClass(SELECTED_FONT);
                        this.getPageCache().put(selector.getKey(), SELECTED_FONT);
                    } else {
                        selector.setfontClass(UNSELECT_FONT);
                    }
                    selector.setFontSize(13);
                    selector.setForeColor("#007fff");
                    style = selector.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    Margin selectorMargin = new Margin();
                    selectorMargin.setTop("-45px");
                    selectorMargin.setLeft("2px");
                    style.setMargin(selectorMargin);
                    selector.setStyle(style);
                    selector.setAlignSelf(CENTER);
                    LabelAp labelMenu = new LabelAp();
                    labelMenu.setKey(LABEL_PREFIX + menuId.toLowerCase());
                    labelMenu.setName(new LocaleString(name));
                    labelMenu.setWidth(new LocaleString("90px"));
                    labelMenu.setHeight(new LocaleString("31px"));
                    labelMenu.setTextAlign(CENTER);
                    labelMenu.setAutoTextWrap(true);
                    labelMenu.setShrink(0);
                    labelMenu.setLineHeight("15px");
                    style = labelMenu.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    Margin labelMargin = new Margin();
                    labelMargin.setLeft("-15px");
                    style.setMargin(labelMargin);
                    labelMenu.setStyle(style);
                    itemPanel.getItems().add(icon);
                    itemPanel.getItems().add(selector);
                    itemPanel.getItems().add(labelMenu);
                    outerPanel.getItems().add(itemPanel);
                }
                list.add(labelTitle.createControl());
                list.add(outerPanel.createControl());
                c.addControls(list);
            }
        }
        this.getPageCache().put("controlKey", SerializationUtils.toJsonString(controlKey));
    }

    private List<Map<String, String>> getCurAndSubMenus(String id, Map<String, Map<String, String>> menuInfoMap, Map<String, List<String>> menuRelationMap) {
        List<String> subMenus;
        ArrayList<Map<String, String>> menuItems = new ArrayList<Map<String, String>>();
        Map<String, String> menuInfo = menuInfoMap.get(id);
        if (menuInfo == null || menuInfo.isEmpty()) {
            return menuItems;
        }
        String formId = menuInfo.get(FORM_ID);
        if (StringUtils.isNotEmpty((String)formId)) {
            menuItems.add(menuInfo);
        }
        if ((subMenus = menuRelationMap.get(id)) == null || subMenus.isEmpty()) {
            return menuItems;
        }
        for (String subMenuId : subMenus) {
            List<Map<String, String>> subMenuInfos = this.getCurAndSubMenus(subMenuId, menuInfoMap, menuRelationMap);
            menuItems.addAll(subMenuInfos);
        }
        return menuItems;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(VECTOR_PREFIX)) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        } else if (key.startsWith(ICON_PREFIX)) {
            TreeView srcTreeView = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
            Map focusNodeMap = srcTreeView.getTreeState().getFocusNode();
            String nodeId = (String)focusNodeMap.get("id");
            String appNumber = AppMetadataCache.getAppNumberById((String)nodeId);
            if (StringUtils.isBlank((String)appNumber) || StringUtils.isEmpty((String)appNumber)) {
                return;
            }
            String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            List menus = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
            if (menus != null) {
                for (AppMenuInfo menu : menus) {
                    String menuId = menu.getId();
                    String subKey = key.substring(ICON_PREFIX.length());
                    boolean isEqualsMenuId = subKey.equalsIgnoreCase(menuId);
                    if (!isEqualsMenuId) continue;
                    Vector vector = new Vector();
                    String formId = menu.getFormId();
                    vector.setKey(VECTOR_PREFIX + subKey + '#' + formId);
                    vector.setView(this.getView());
                    vector.addClickListener((ClickListener)this);
                    e.setControl((Control)vector);
                    return;
                }
            }
        }
    }
}

