/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter.log;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;

public class LogListPlugin
extends AbstractListPlugin {
    private static final String PACKET_NUMBER = "packet_number";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object showFilterContainer = this.getView().getFormShowParameter().getCustomParam("showFilterContainer");
        if (showFilterContainer != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.packetSpecialPermIsEnabled()) {
            boolean isFilterAll;
            QFilter filter = PermissionServiceHelper.getOperationRuleFilter((String)"ricc", (String)"ricc_datapacket", (String)"view", (StringBuilder)new StringBuilder());
            String spFilterProp = "1";
            boolean bl = isFilterAll = filter != null && spFilterProp.equals(filter.getProperty()) && "=".equals(filter.getCP());
            if (filter == null || isFilterAll) {
                return;
            }
            long userId = RequestContext.get().getCurrUserId();
            QFilter qFilter = new QFilter("packet.creator.id", "=", (Object)userId);
            QFilter qFilterUpload = new QFilter("packet", "=", (Object)0).and(new QFilter("optype", "=", (Object)"6")).and(new QFilter("opuser", "=", (Object)userId));
            e.addCustomQFilter(qFilter.or(qFilterUpload));
        }
    }

    private boolean packetSpecialPermIsEnabled() {
        DynamicObjectCollection permRuleObj = PermissionUtil.querySpecialDataPermData((String)"view", (boolean)true, (String[])new String[]{"ricc_datapacket"});
        for (DynamicObject permRule : permRuleObj) {
            boolean objenabled = (Boolean)permRule.get("objenabled");
            if (!objenabled) continue;
            return true;
        }
        return false;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String clickField = args.getFieldName();
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"ricc_log");
        if ("billno".equals(clickField)) {
            String taskid = log.getString("taskid");
            String state = log.getString("state");
            String opType = log.getString("optype");
            String formId = this.getFormId(opType);
            if (StringUtils.isNotEmpty((String)taskid) && "4".equals(state)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(formId);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.getCustomParams().put("ricc_taskid", taskid);
                this.getView().showForm(showParameter);
            } else {
                ShowParameterUtil.showLog((Object)selectedId, (IFormView)this.getView(), (ShowType)ShowType.MainNewTabPage, (String)opType);
            }
        } else if (PACKET_NUMBER.equals(clickField)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("ricc_datapacket");
            billShowParameter.setPkId(log.getDynamicObject("packet").getPkValue());
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String schemeNumber = (String)formShowParameter.getCustomParam("packschemenumber");
        if (schemeNumber != null) {
            boolean schemeIsSave = (Boolean)formShowParameter.getCustomParam("isleachschemebumber");
            if (schemeIsSave) {
                FilterColumn filter = args.getFilterColumn("batchpackscheme.number");
                filter.setDefaultValue(schemeNumber);
            } else {
                FilterColumn dataFilter = args.getFilterColumn("optype");
                dataFilter.setDefaultValue("2");
            }
        }
    }

    private String getFormId(String optype) {
        String formId;
        switch (optype) {
            case "0": {
                formId = "ricc_syncdataprogress";
                break;
            }
            case "1": {
                formId = "ricc_transferprogress";
                break;
            }
            case "2": {
                formId = "ricc_onekeypack";
                break;
            }
            case "3": {
                formId = "ricc_addpacketprogress";
                break;
            }
            case "4": {
                formId = "ricc_addtransferprogress";
                break;
            }
            default: {
                formId = "ricc_addpacketprogress";
            }
        }
        return formId;
    }
}

