/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.other;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sys.ricc.common.util.StringUtils;

public class PageEnterParamPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String PARAMS = "params";
    private static final String METHODNAME = "methodname";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String SETAPPID = "setAppId";
    private static final String SETCAPTION = "setCaption";
    private static final String SETCUSTOMPARAM = "setCustomParam";
    private static final String ADDCUSTPLUGIN = "addCustPlugin";
    private static final String UNIQUE = "1";
    private static final String PAGECACHEPARAMS = "cacheParams";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String operateKey = control.getKey();
        if (BTN_OK.equals(operateKey)) {
            JSONObject obj = new JSONObject();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PARAMS);
            Map<String, Map<String, Object>> entryEntityMap = this.getEntryData(entryEntity);
            if (entryEntityMap.isEmpty()) {
                this.getView().returnDataToParent((Object)"isEmpty");
            } else {
                obj.put(PARAMS, entryEntityMap);
                this.getView().returnDataToParent((Object)obj);
            }
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int index = changeData.getRowIndex();
        if (METHODNAME.equals(key)) {
            boolean methodUnique = this.checkUnique(METHODNAME, newValue, index);
            if (methodUnique) {
                this.setLineValue(newValue, index);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6cd5\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u6761\u5206\u5f55\u884c\u6570\u636e\uff0c\u5982\u9700\u7f16\u8f91\uff0c\u8bf7\u4fee\u6539\u5df2\u5b58\u5728\u7684\u6570\u636e\u3002", (String)"PageEnterParamPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), Integer.valueOf(3000));
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(PARAMS).get(index);
                this.getPageCache().put(PAGECACHEPARAMS, UNIQUE);
                this.getModel().setValue(METHODNAME, oldValue, index);
                this.getModel().setValue(NAME, dynamicObject.get(NAME), index);
                this.getModel().setValue(VALUE, dynamicObject.get(VALUE), index);
            }
        } else if (NAME.equals(key)) {
            boolean nameIsUnique;
            DynamicObject currentLineData = e.getChangeSet()[0].getDataEntity();
            String methodName = currentLineData.getString(METHODNAME);
            boolean bl = nameIsUnique = SETCUSTOMPARAM.equals(methodName) && !this.checkUnique(NAME, newValue, index);
            if (nameIsUnique) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"SetCustomParam\u65b9\u6cd5\u4e0d\u5141\u8bb8\u91cd\u590d\u7684\u53c2\u6570\u540d\u79f0\u3002", (String)"PageEnterParamPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue(NAME, oldValue, index);
            }
        }
    }

    private void setLineValue(String value, int index) {
        String unUnique = this.getPageCache().get(PAGECACHEPARAMS);
        if (StringUtils.isEmpty((String)unUnique)) {
            this.getModel().setValue(NAME, null, index);
            this.getModel().setValue(VALUE, null, index);
        }
        if (StringUtils.isNotEmpty((String)value)) {
            switch (value) {
                case "setAppId": {
                    this.getModel().setValue(NAME, (Object)"appId", index);
                    break;
                }
                case "setCaption": {
                    this.getModel().setValue(NAME, (Object)"caption", index);
                    break;
                }
                case "addCustPlugin": {
                    this.setCustPluginName(index);
                    break;
                }
            }
        }
        this.getPageCache().remove(PAGECACHEPARAMS);
    }

    private void setCustPluginName(int index) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PARAMS);
        int count = 0;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject lineData = (DynamicObject)entryEntity.get(i);
            String methodName = lineData.getString(METHODNAME);
            if (!ADDCUSTPLUGIN.equals(methodName)) continue;
            ++count;
        }
        StringBuilder name = new StringBuilder();
        name.append("custPlugin");
        name.append(count);
        this.getModel().setValue(NAME, (Object)name.toString(), index);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String params = (String)parameter.getCustomParam("enterParams");
        if (params != null && !params.isEmpty()) {
            JSONObject map = JSONObject.parseObject((String)params).getJSONObject(PARAMS);
            this.setEntryEntity((Map<String, Map<String, Object>>)map);
        }
    }

    private boolean checkUnique(String type, String value, int index) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(PARAMS);
        int size = dynamicObjects.size();
        if (size <= 1) {
            return true;
        }
        boolean flag = false;
        if (METHODNAME.equals(type)) {
            flag = SETAPPID.equals(value) || SETCAPTION.equals(value);
        } else if (NAME.equals(type)) {
            flag = StringUtils.isNotEmpty((String)value);
        }
        if (flag) {
            for (int i = 0; i < size; ++i) {
                if (i == index) continue;
                String lineMethodName = ((DynamicObject)dynamicObjects.get(i)).getString(METHODNAME);
                String currentLineName = ((DynamicObject)dynamicObjects.get(i)).getString(NAME);
                boolean bl = flag = value.equals(lineMethodName) || SETCUSTOMPARAM.equals(lineMethodName) && currentLineName.equals(value);
                if (!flag) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, Map<String, Object>> getEntryData(DynamicObjectCollection dynamicObjects) {
        ConcurrentHashMap<String, Map<String, Object>> result = new ConcurrentHashMap<String, Map<String, Object>>(dynamicObjects.size());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject lineData = (DynamicObject)dynamicObjects.get(i);
            String methodName = lineData.getString(METHODNAME);
            String name = lineData.getString(NAME);
            String value = lineData.getString(VALUE);
            Map map = result.get(methodName) == null ? new ConcurrentHashMap(1) : (Map)result.get(methodName);
            map.put(name, value);
            result.put(methodName, map);
        }
        return result;
    }

    private void setEntryEntity(Map<String, Map<String, Object>> map) {
        IDataModel model = this.getModel();
        int index = 0;
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> tempMap = entry.getValue();
            for (Map.Entry<String, Object> otherentry : tempMap.entrySet()) {
                model.createNewEntryRow(PARAMS);
                String name = otherentry.getKey();
                String value = (String)otherentry.getValue();
                model.setValue(METHODNAME, (Object)key, index);
                model.setValue(NAME, (Object)name, index);
                model.setValue(VALUE, (Object)value, index++);
            }
        }
    }
}

