/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.setting.account;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.exception.RiccBizException;
import kd.sys.ricc.formplugin.setting.account.DataCenterFormPlugin;

public class DestAccountManageEditPlugin
extends DataCenterFormPlugin {
    private static final String ISDEFAULT = "isdefault";
    private static final String REPLACE_CONFIRM = "replace_confirm";
    private static final String OP_TEST = "test";
    private static final String OP_GETDATACENTER = "getdatacenterlist";
    private static final String APP_SECURET = "appsecuret";
    private static final Log logger = LogFactory.getLog(DestAccountManageEditPlugin.class);
    public static final String ACCOUNT_ID = "number";
    public static final String EVN_URL = "evnurl";

    @Override
    public String getAccountIdField() {
        return ACCOUNT_ID;
    }

    @Override
    public String getAccountNameField() {
        return "name";
    }

    @Override
    public String getEnvUrlField() {
        return EVN_URL;
    }

    @Override
    public String getDataCenterField() {
        return "datacenter";
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPwdFormat();
    }

    private void setPwdFormat() {
        if (((BillModel)this.getModel()).getPKValue() != null) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get(APP_SECURET))) {
                proxy.setFieldProperty(APP_SECURET, "v", (Object)"******");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String opKey = operate.getOperateKey();
            if ("save".equals(opKey)) {
                boolean isdefault = this.getModel().getDataEntity().getBoolean(ISDEFAULT);
                if (isdefault) {
                    String entityName = this.getModel().getDataEntityType().getName();
                    Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
                    boolean exist = Long.parseLong(pkValue.toString()) == 0L ? QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter(ISDEFAULT, "=", (Object)"1")}) : QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)Long.parseLong(pkValue.toString())), new QFilter(ISDEFAULT, "=", (Object)"1")});
                    if (exist) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u9ed8\u8ba4\u7684\u8fde\u63a5\u6570\u636e\u4e2d\u5fc3\uff0c\u662f\u5426\u8fdb\u884c\u66ff\u6362\uff1f", (String)"DestAccountManageEditPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(REPLACE_CONFIRM, (IFormPlugin)this));
                        args.setCancel(true);
                        return;
                    }
                }
            } else if (OP_TEST.equals(opKey)) {
                IDataModel model = this.getModel();
                if (StringUtils.isBlank((Object)model.getValue(EVN_URL))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u73af\u5883\u7684\u8fde\u63a5\u5730\u5740", (String)"DestAccountManageEditPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.isBlank((Object)model.getValue(ACCOUNT_ID))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u73af\u5883\u7684\u6570\u636e\u4e2d\u5fc3id", (String)"DestAccountManageEditPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.isBlank((Object)model.getValue(APP_SECURET))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8fde\u63a5\u5bc6\u94a5", (String)"DestAccountManageEditPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)OP_GETDATACENTER, (CharSequence)opKey) && StringUtils.isBlank((Object)this.getModel().getValue(EVN_URL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u73af\u5883\u7684\u8fde\u63a5\u5730\u5740", (String)"DestAccountManageEditPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.contains(REPLACE_CONFIRM) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String entityName = dataEntity.getDataEntityType().getName();
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
            List successPkIds = result.getSuccessPkIds();
            if (successPkIds != null && !successPkIds.isEmpty()) {
                DynamicObject[] accounts;
                QFilter filter = new QFilter("id", "!=", (Object)Long.parseLong(successPkIds.get(0).toString()));
                filter.and(ISDEFAULT, "=", (Object)"1");
                for (DynamicObject account : accounts = BusinessDataServiceHelper.load((String)entityName, (String)"id, isdefault", (QFilter[])filter.toArray())) {
                    account.set(ISDEFAULT, (Object)"0");
                }
                SaveServiceHelper.update((DynamicObject[])accounts);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DestAccountManageEditPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.getView().close();
            } else {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c", (String)"DestAccountManageEditPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0])).append(result.getMessage());
                result.getAllErrorOrValidateInfo().forEach(errorMessage::append);
                this.getView().showErrorNotification(errorMessage.toString());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)OP_TEST, (CharSequence)operateKey)) {
            IDataModel model = this.getModel();
            String accountId = String.valueOf(model.getValue(ACCOUNT_ID));
            String appsecuret = (String)model.getValue(APP_SECURET);
            String evnurl = (String)model.getValue(EVN_URL);
            try {
                ApiUtil.getAppToken((String)accountId, (String)evnurl, (String)appsecuret);
            }
            catch (RiccBizException e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25,\u8bf7\u68c0\u67e5\u8fde\u63a5\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff1a ", (String)"DestAccountManageEditPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e), MessageTypes.Default);
                logger.error(CommonUtil.getExceptionDetailInfo((Throwable)e));
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6210\u529f\u3002", (String)"DestAccountManageEditPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)OP_GETDATACENTER, (CharSequence)operateKey)) {
            try {
                String dataCenterStr = ApiUtil.getDestDataCenterStr((String)((String)this.getModel().getValue(EVN_URL)));
                HashMap<String, String> retData = new HashMap<String, String>();
                retData.put("content", dataCenterStr);
                FormShowParameter formShowParameter = ShowParameterUtil.formShowParameter((String)"ricc_show_content_dialog", (ShowType)ShowType.Modal, retData, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u5217\u8868", (String)"DestAccountManageEditPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), (String)"");
                this.getView().showForm(formShowParameter);
            }
            catch (RiccBizException e) {
                logger.error((Throwable)e);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25,\u8bf7\u68c0\u67e5\u8fde\u63a5\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff1a ", (String)"DestAccountManageEditPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e), MessageTypes.Default);
            }
        }
    }
}

