/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.packet;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.datapacket.download.DataPacketDownLoader;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.schedule.TaskSerailHelper;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketEntryStatusEnum;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.formplugin.AbstractRiccListPlugin;

public class PacketManageListPlugin
extends AbstractRiccListPlugin {
    public static final String SRC_DATA_CENTER = "srcdatacenter";
    private static final Log log = LogFactory.getLog(PacketManageListPlugin.class);
    private static final String BT_NEW = "tblnew";
    private static final String BT_COPY = "tblcopy";
    private static final String BT_SYNC = "tblsync";
    private static final String BT_UPLOAD = "tblupload";
    private static final String BT_DOWNLOAD = "tbldownload";
    private static final String BT_VIEWLOGS = "tblviewlogs";
    private static final String OP_SYNC = "sync";
    private static final String OP_UPLOAD = "upload";
    private static final String OP_DOWNLOAD = "download";
    private static final String OP_VIEWLOGS = "viewlogs";
    private static final String OP_RETURNPACKET = "returnpacket";
    private static final String OP_CREATETRANSFER = "createtransfer";
    private static final String OP_QUERY_TRANSFER_TASK = "querytransfertask";
    private static final String ACTION_UPLOAD = "action_upload";
    private static final String ACTION_SYNC = "sync_packet";
    public static final String OPERATE_NEW = "kd.bos.form.operate.New";
    private static final String PACKET_COUNT = "packetCount";
    private static final String PACKET_ENTRY_STATUS = "entrystatus";
    private static final String OP_COPY = "copy";
    private static final String OP_PUBLICTRANSFER = "publictransfer";
    private static final String OP_COMPARE = "compare";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("dataPacketOpenFrom", this.getView().getFormShowParameter().getCustomParam("dataPacketOpenFrom"));
    }

    public void afterCreateNewData(EventObject e) {
        this.disableBtAndHideTipsByRole();
    }

    private void disableBtAndHideTipsByRole() {
        ArrayList<String> cleanTipsKeyList = new ArrayList<String>();
        boolean canUploadPacket = SysParaUtil.canUploadPacket();
        cleanTipsKeyList.add(BT_VIEWLOGS);
        this.getView().setEnable(Boolean.valueOf(canUploadPacket), new String[]{BT_SYNC, BT_UPLOAD, SRC_DATA_CENTER, "syncstate"});
        if (canUploadPacket) {
            cleanTipsKeyList.add(BT_UPLOAD);
            LocaleString tipsContent = new LocaleString(ResManager.loadKDString((String)"\u5c06\u89e3\u6790\u4f20\u8f93\u5305\u5185\u5b50\u4f20\u8f93\u5305\u6570\u636e\uff0c\u5e76\u5c06\u6570\u636e\u540c\u6b65\u5bfc\u5165\u7cfb\u7edf\u4e2d", (String)"PacketManageListPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            HashMap<String, LocaleString> itemsMap = new HashMap<String, LocaleString>(2);
            itemsMap.put("content", tipsContent);
            HashMap<String, HashMap<String, LocaleString>> ctlMap = new HashMap<String, HashMap<String, LocaleString>>(1);
            ctlMap.put("tips", itemsMap);
            this.getView().updateControlMetadata(BT_SYNC, ctlMap);
        }
        boolean canDownLoadPacket = SysParaUtil.canDownLoadPacket();
        this.getView().setEnable(Boolean.valueOf(canDownLoadPacket), new String[]{BT_DOWNLOAD});
        if (canDownLoadPacket) {
            cleanTipsKeyList.add(BT_DOWNLOAD);
        }
        boolean canCreatePacket = SysParaUtil.canCreatePacket();
        this.getView().setEnable(Boolean.valueOf(SysParaUtil.canCreatePacket()), new String[]{BT_NEW, BT_COPY});
        if (canCreatePacket) {
            cleanTipsKeyList.add(BT_NEW);
            cleanTipsKeyList.add(BT_COPY);
        }
        if (!cleanTipsKeyList.isEmpty()) {
            FormViewUtil.cleanButtonTips(cleanTipsKeyList, (IFormView)this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        DynamicObject[] selectedPackets = DataPacketHelper.getSelectedPackets(selectedRows.getPrimaryKeyValues());
        if (StringUtils.equals((String)OP_COPY, (String)operationKey)) {
            for (DynamicObject selectedPacket : selectedPackets) {
                String datasource = selectedPacket.getString("datasource");
                if (StringUtils.equals((String)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal(), (String)datasource)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ec5\u624b\u5de5\u65b0\u589e\u7684\u4f20\u8f93\u5305\u624d\u5141\u8bb8\u590d\u5236", (String)"PacketManageListPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((String)OP_SYNC, (String)operationKey)) {
            for (DynamicObject selectedPacket : selectedPackets) {
                String status = selectedPacket.getString("status");
                String datasource = selectedPacket.getString("datasource");
                boolean isManualNew = StringUtils.equals((String)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal(), (String)datasource);
                if (!StringUtils.equals((String)"C", (String)status) && isManualNew) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e\u7684\u4f20\u8f93\u5305\u4ec5\u5ba1\u6838\u72b6\u6001\u53ef\u540c\u6b65", (String)"PacketManageListPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection subDataPackets = selectedPacket.getDynamicObjectCollection("subdatapacket");
                int subPacketCount = subDataPackets.size();
                int failSubPacket = 0;
                if (subDataPackets.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305[%s]\u4e0d\u5b58\u5728\u5b50\u4f20\u8f93\u5305,\u65e0\u6cd5\u8fdb\u884c\u540c\u6b65,\u8bf7\u5148\u6dfb\u52a0\u5b50\u4f20\u8f93\u5305!", (String)"PacketManageListPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]), selectedPacket.getString("name")));
                    args.setCancel(true);
                    return;
                }
                for (DynamicObject subDataPacket : subDataPackets) {
                    String entryStatus = (String)subDataPacket.get(PACKET_ENTRY_STATUS);
                    if (!StringUtils.equals((String)PacketEntryStatusEnum.INVALID.getVal(), (String)entryStatus)) continue;
                    ++failSubPacket;
                }
                if (subPacketCount <= failSubPacket) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"[%s]\u4f20\u8f93\u5305\u5185\u5b50\u4f20\u8f93\u5305\u5df2\u5168\u90e8\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8fdb\u884c\u540c\u6b65", (String)"PacketManageListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), selectedPacket.get("name")));
                    args.setCancel(true);
                    return;
                }
                String billType = selectedPacket.getString("packettype");
                if (EnvTypeHelper.isProductEnv() && DataPacketTypeEnum.METADATA.getVal().equals(billType)) {
                    String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e", (String)"PacketManageListPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorMsg);
                    args.setCancel(true);
                    return;
                }
                if (!SysParaUtil.canSyncPacketStatus((String)status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u5bf9\u540c\u6b65\u4f20\u8f93\u5305\u7684\u72b6\u6001\u505a\u4e86\u9650\u5236\uff0c\u53ea\u80fd\u540c\u6b65\u5ba1\u6838\u72b6\u6001\u7684\u4f20\u8f93\u5305\uff0c\u5982\u9700\u540c\u6b65\uff0c\u8bf7\u5ba1\u6838\u4f20\u8f93\u5305\u6216\u8005\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4fee\u6539\u73af\u5883\u7ba1\u63a7\u914d\u7f6e\uff0c\u4fee\u6539\u4f20\u8f93\u5305\u72b6\u6001\u9650\u5236\u3002", (String)"PacketManageListPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String enable = selectedPacket.getString("enable");
                if (!"1".equalsIgnoreCase(enable)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305<%1$s | %2$s>\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u540c\u6b65\u64cd\u4f5c\u3002", (String)"PacketManageListPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]), selectedPacket.get("number"), selectedPacket.get("name")));
                    args.setCancel(true);
                    return;
                }
                String taskKey = "syn" + selectedPacket.get("number");
                if (!TaskSerailHelper.taskExist(taskKey)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305<%1$s | %2$s>\u5df2\u7ecf\u5728\u6267\u884c\u540c\u6b65\u4e86\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u4efb\u52a1\u67e5\u770b\u8be6\u60c5\u6216\u7b49\u5f85\u4efb\u52a1\u7ed3\u675f", (String)"PacketManageListPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), selectedPacket.get("number"), selectedPacket.get("name")));
                args.setCancel(true);
                return;
            }
            LinkedHashMap<String, String> transTipMap = this.getTransTips(selectedPackets);
            this.showSynConfirmView(selectedRows, transTipMap);
        } else if (StringUtils.equals((String)OP_CREATETRANSFER, (String)operationKey)) {
            for (DynamicObject packet : selectedPackets) {
                int subpacketNum = packet.getInt("subpacketcount");
                if (subpacketNum <= 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305<%1$s | %2$s>\u4e0d\u5b58\u5728\u5b50\u4f20\u8f93\u5305,\u65e0\u6cd5\u8fdb\u884c\u4f20\u8f93,\u8bf7\u5148\u6dfb\u52a0\u5b50\u4f20\u8f93\u5305!", (String)"PacketManageListPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]), packet.get("number"), packet.get("name")), Integer.valueOf(10000));
                    args.setCancel(true);
                    return;
                }
                String enable = packet.getString("enable");
                if (!"1".equalsIgnoreCase(enable)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305<%1$s | %2$s>\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f20\u8f93\uff01", (String)"PacketManageListPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]), packet.get("number"), packet.get("name")));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection subDataPackets = packet.getDynamicObjectCollection("subdatapacket");
                int subPacketCount = subDataPackets.size();
                int failSubPacket = 0;
                for (DynamicObject subDataPacket : subDataPackets) {
                    String entryStatus = (String)subDataPacket.get(PACKET_ENTRY_STATUS);
                    if (!StringUtils.equals((String)PacketEntryStatusEnum.INVALID.getVal(), (String)entryStatus)) continue;
                    ++failSubPacket;
                }
                if (subPacketCount > failSubPacket) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4f20\u8f93\u5305\u5185\u5b50\u4f20\u8f93\u5305\u5df2\u5168\u90e8\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8fdb\u884c\u5728\u7ebf\u4f20\u8f93", (String)"PacketManageListPlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]), packet.get("name")));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((String)OP_DOWNLOAD, (String)operationKey)) {
            ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
            boolean canDownLoad = this.validateEvnAndPacket(listSelectedRows);
            if (!canDownLoad) {
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((String)OP_PUBLICTRANSFER, (String)operationKey)) {
            if (selectedPackets.length == 1) {
                DynamicObject selectedPacket = selectedPackets[0];
                String packetType = selectedPacket.getString("packettype");
                String datasource = selectedPacket.getString("datasource");
                if (!DataPacketTypeEnum.METADATA.getVal().equals(packetType) || !PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal().equals(datasource)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u4f20\u8f93\u5305\u7c7b\u578b\u4e3a\u5143\u6570\u636e\u7c7b\u578b\u4e14\u624b\u5de5\u65b0\u589e\u7684\u4f20\u8f93\u5305\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"PacketManageListPlugin_20", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"PacketManageListPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)OP_COMPARE, (String)operationKey)) {
            if (selectedPackets.length == 1) {
                DynamicObject selectedPacket = selectedPackets[0];
                String packetType = selectedPacket.getString("packettype");
                String datasource = selectedPacket.getString("datasource");
                if (!DataPacketTypeEnum.METADATA.getVal().equals(packetType) || !PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal().equals(datasource)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u4f20\u8f93\u5305\u7c7b\u578b\u4e3a\u5143\u6570\u636e\u7c7b\u578b\u4e14\u624b\u5de5\u65b0\u589e\u7684\u4f20\u8f93\u5305\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"PacketManageListPlugin_20", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"PacketManageListPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private LinkedHashMap<String, String> getTransTips(DynamicObject[] selectedPackets) {
        LinkedHashMap<String, String> transTipMap = new LinkedHashMap<String, String>(16);
        HashSet<Object> configIds = new HashSet<Object>(16);
        for (DynamicObject packet : selectedPackets) {
            DynamicObjectCollection packetEntryRows = packet.getDynamicObjectCollection("subdatapacket");
            for (DynamicObject row : packetEntryRows) {
                DynamicObject bizObject = row.getDynamicObject("bizobject");
                if (bizObject == null) continue;
                Object bizObjectId = bizObject.getPkValue();
                configIds.add(bizObjectId);
            }
        }
        if (!configIds.isEmpty()) {
            DynamicObject[] configs;
            QFilter qFilter = new QFilter("id", "in", configIds);
            for (DynamicObject config : configs = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)"name,transtips", (QFilter[])qFilter.toArray(), null)) {
                String configName = config.getString("name");
                String transTips = config.getString("transtips");
                if (!StringUtils.isNotEmpty((String)transTips)) continue;
                transTipMap.put(configName, transTips);
            }
        }
        return transTipMap;
    }

    private void showSynConfirmView(ListSelectedRowCollection selectedRows, LinkedHashMap<String, String> transTipMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_synconfirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("listselectrow", (Object)selectedRows.serialize());
        showParameter.setCustomParam("transtips", (Object)SerializationUtils.toJsonString(transTipMap));
        if (!transTipMap.isEmpty()) {
            StyleCss style = new StyleCss();
            style.setWidth("500px");
            style.setHeight("570px");
            showParameter.getOpenStyle().setInlineStyleCss(style);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SYNC));
        showParameter.setShowTitle(false);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        DynamicObject[] packets = DataPacketHelper.getSelectedPackets(listSelectedRows.getPrimaryKeyValues());
        if (OP_UPLOAD.equals(operationKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("ricc_packageupload");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_UPLOAD));
            this.getView().showForm(formShowParameter);
        } else if (StringUtils.equals((String)OP_DOWNLOAD, (String)operationKey)) {
            for (DynamicObject packet : packets) {
                DataPacketDownLoader.download(packet, this.getView());
            }
        } else if (StringUtils.equals((String)OP_RETURNPACKET, (String)operationKey)) {
            this.checkAndDoPacket();
        } else if (StringUtils.equals((String)OP_VIEWLOGS, (String)operationKey)) {
            this.viewLogs();
        } else if (StringUtils.equals((String)OP_CREATETRANSFER, (String)operationKey) && args.getOperationResult().isSuccess()) {
            LinkedHashMap<String, String> transTipMap = this.getTransTips(packets);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("ricc_fasttransfer");
            formShowParameter.setCustomParam("selectRows", (Object)listSelectedRows.serialize());
            if (!transTipMap.isEmpty()) {
                StyleCss style = new StyleCss();
                style.setHeight("500px");
                formShowParameter.getOpenStyle().setInlineStyleCss(style);
            }
            formShowParameter.setCustomParam("transtips", (Object)SerializationUtils.toJsonString(transTipMap));
            formShowParameter.setCustomParam("transfertype", (Object)operationKey);
            this.getView().showForm(formShowParameter);
        } else if (StringUtils.equals((String)OP_QUERY_TRANSFER_TASK, (String)operationKey)) {
            boolean isOnePacket;
            boolean bl = isOnePacket = listSelectedRows.size() == 1;
            if (isOnePacket) {
                String number = listSelectedRows.get(0).getNumber();
                QFilter qFilter = new QFilter("datapackettrans.datapacket.number", "=", (Object)number);
                int count = ORM.create().count("transfertaskcount", "ricc_transfertask", qFilter.toArray());
                if (count == 0) {
                    String msgTpl = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u3010%s\u3011\u6682\u672a\u521b\u5efa\u4f20\u8f93\u4efb\u52a1\uff01", (String)"PacketManageListPlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    this.getView().showTipNotification(String.format(msgTpl, number));
                    return;
                }
                this.queryTransferTask(number, count);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"PacketManageListPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((String)OP_PUBLICTRANSFER, (String)operationKey)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            Object primaryKeyValue = listSelectedRows.get(0).getPrimaryKeyValue();
            paramMap.put("packetId", primaryKeyValue);
            FormShowParameter showParameter = ShowParameterUtil.formShowParameter((String)"ricc_metadata_cloudmanage", (ShowType)ShowType.Modal, paramMap, null, null);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((String)OP_COMPARE, (String)operationKey)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            Object primaryKeyValue = listSelectedRows.get(0).getPrimaryKeyValue();
            paramMap.put("packetId", primaryKeyValue);
            paramMap.put("datatype", "package");
            FormShowParameter showParameter = ShowParameterUtil.formShowParameter((String)"ricc_metadatacompare", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
            this.getView().showForm(showParameter);
        }
    }

    private void queryTransferTask(String dataPacketNumber, int count) {
        ListShowParameter showParam = ShowParameterUtil.listShowParameter((String)"ricc_transfertask", (String)"bos_list", (ShowType)ShowType.MainNewTabPage, null, null, null, null);
        showParam.setCustomParam("dataPacketNumber", (Object)dataPacketNumber);
        showParam.setCustomParam("count", (Object)count);
        String pageId = this.getView().getFormShowParameter().getRootPageId();
        showParam.setPageId(dataPacketNumber + pageId);
        String parentPageId = ShowParameterUtil.getParentPageId((IFormView)this.getView());
        showParam.setParentPageId(parentPageId);
        this.getView().showForm((FormShowParameter)showParam);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection packetListData = e.getPageData();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object packetCountObject = formShowParameter.getCustomParam(PACKET_COUNT);
        int packetCount = packetCountObject == null ? 0 : (Integer)packetCountObject;
        String tipIsShow = this.getPageCache().get(PACKET_COUNT);
        if (packetListData.size() < packetCount && StringUtils.isEmpty((String)tipIsShow)) {
            this.getPageCache().put(PACKET_COUNT, "1");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6309\u7167\u5f53\u524d\u7528\u6237\u6743\u9650\u8fc7\u6ee4\u51fa\u6240\u6709\u4f20\u8f93\u5305\u3002", (String)"PacketManageListPlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }

    private boolean validateEvnAndPacket(ListSelectedRowCollection listSelectedRows) {
        if (Objects.isNull(listSelectedRows) || listSelectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u4f20\u8f93\u5305\u3002", (String)"PacketManageListPlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        boolean canDownload = SysParaUtil.canDownLoadPacket();
        if (!canDownload) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301\u4e0b\u8f7d\u4f20\u8f93\u5305\u5982\u9700\u652f\u6301\u8bf7\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4fee\u6539\u73af\u5883\u7ba1\u63a7\u914d\u7f6e\uff0c\u6253\u5f00\u4e0b\u8f7d\u4f20\u8f93\u5305\u5f00\u5173\u3002", (String)"PacketManageListPlugin_16", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object versionId = formShowParameter.getCustomParam("ricc_version_id");
        if (versionId != null) {
            FilterColumn filter = args.getFilterColumn("packetversion.name");
            filter.setDefaultValue(versionId.toString());
        }
    }

    public void checkAndDoPacket() {
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        if (listSelectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4f20\u8f93\u5305\u3002", (String)"PacketManageListPlugin_17", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        if (listSelectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"PacketManageListPlugin_18", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        this.doPacket(listSelectedRows);
    }

    public void doPacket(ListSelectedRowCollection listSelectedRows) {
        String dataOpenFrom = (String)this.getView().getFormShowParameter().getCustomParam("dataPacketOpenFrom");
        ListSelectedRow selectedPacket = listSelectedRows.get(0);
        if ("openFromMetadata".equalsIgnoreCase(dataOpenFrom)) {
            HashMap<String, ListSelectedRow> returnParams = new HashMap<String, ListSelectedRow>(2);
            returnParams.put("selectedPacket", selectedPacket);
            this.getView().returnDataToParent(returnParams);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && actionId.equals(ACTION_UPLOAD)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"PacketManageListPlugin_19", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        } else if (actionId != null && actionId.equals(ACTION_SYNC)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void viewLogs() {
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        if (listSelectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"PacketManageListPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("packet.id", "=", listSelectedRows.get(0).getPrimaryKeyValue());
        ShowParameterUtil.showLogs((IFormView)this.getView(), (QFilter)filter, (ShowType)ShowType.MainNewTabPage);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (StringUtils.equals((String)"bos_listf7", (String)this.getView().getFormShowParameter().getFormId())) {
            List columns = args.getListColumns();
            Iterator iterators = columns.iterator();
            while (iterators.hasNext()) {
                IListColumn column = (IListColumn)iterators.next();
                String listFieldKey = column.getListFieldKey();
                if (!StringUtils.equals((String)SRC_DATA_CENTER, (String)listFieldKey) && !StringUtils.equals((String)"destdatacenter", (String)listFieldKey) && !StringUtils.equals((String)"syncstate", (String)listFieldKey)) continue;
                iterators.remove();
            }
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        Long key;
        CloseCallBack callBack = e.getCloseCallBack();
        if (OPERATE_NEW.equals(callBack.getClassName()) && (key = (Long)e.getPkId()) > 0L) {
            ListView listView = (ListView)this.getView();
            listView.getSelectedRows().add((Object)new ListSelectedRow((Object)key));
        }
    }
}

