/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.packet;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.TransferUtil;

public class SynConfirmPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SynConfirmPlugin.class);

    public void afterCreateNewData(EventObject e) {
        String transTipMapStr = (String)this.getView().getFormShowParameter().getCustomParam("transtips");
        LinkedHashMap transTipMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)transTipMapStr, LinkedHashMap.class);
        TransferUtil.fillTransTipEntry((IFormView)this.getView(), (LinkedHashMap)transTipMap);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncanel", "btnpreview", "btnsyn"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String listSelectRow = (String)this.getView().getFormShowParameter().getCustomParam("listselectrow");
        ListSelectedRowCollection selectedRows = ListSelectedRowCollection.deSerialize((String)listSelectRow);
        if (StringUtils.equals((String)source.getKey(), (String)"btnsyn")) {
            this.showSyncProgress(selectedRows);
        } else if (StringUtils.equals((String)source.getKey(), (String)"btnpreview")) {
            this.preView(selectedRows.getPrimaryKeyValues());
        }
    }

    private void preView(Object[] selectedRows) {
        HashMap<String, String> showParam = new HashMap<String, String>(2);
        showParam.put("previewType", "packetToCur");
        List selectIdList = Arrays.stream(selectedRows).collect(Collectors.toList());
        showParam.put("selectIds", JSON.toJSONString(selectIdList));
        FormShowParameter formShowParameter = ShowParameterUtil.simpleFormShowParameter((String)"ricc_dapacket_preview", showParam);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "previewdata"));
        this.getView().showForm(formShowParameter);
    }

    private void showSyncProgress(ListSelectedRowCollection listSelectedRows) {
        DynamicObject[] packets = DataPacketHelper.getSelectedPackets(listSelectedRows.getPrimaryKeyValues());
        HashSet<String> taskKeySet = new HashSet<String>(packets.length);
        for (DynamicObject onePacket : packets) {
            String taskKey = "syn" + onePacket.get("number");
            taskKeySet.add(taskKey);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("ricc_syncdataprogress");
        formShowParameter.setCustomParam("selectRows", (Object)listSelectedRows.serialize());
        formShowParameter.setCustomParam("pageId", (Object)this.getView().getPageId());
        formShowParameter.setCustomParam("ricconcekey", taskKeySet);
        this.getView().showForm(formShowParameter);
    }
}

