/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.version;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;

public class VersionControlListPlugin
extends AbstractListPlugin {
    private static final String TRANSFER_PACKET = "ricc_datapacket";
    private static final String TRANSFER_PACKET_VERSION = "packetversion";
    private static final String TRANSFER_PACKET_COUNT = "transferpacketcount";
    private static final String HAS_OPEN_FORM = "hasOpenForm";
    private static final String VERSION_PACKETCOUNT = "versionnumber_packetcount";

    public void beforePackageData(BeforePackageDataEvent e) {
        DataEntityPropertyCollection propertiesCollection;
        super.beforePackageData(e);
        DynamicObjectCollection versionControlListData = e.getPageData();
        if (versionControlListData.size() > 0 && (propertiesCollection = ((DynamicObject)versionControlListData.get(0)).getDataEntityType().getProperties()).containsKey((Object)TRANSFER_PACKET_COUNT)) {
            this.queryPacketCountByVersion(this.getVersionPkValue(versionControlListData));
            this.setListPacketcountValue(versionControlListData);
        }
    }

    private long[] getVersionPkValue(DynamicObjectCollection listData) {
        int len = listData.size();
        long[] versionPkValue = new long[len];
        for (int i = 0; i < len; ++i) {
            versionPkValue[i] = (Long)((DynamicObject)listData.get(i)).getPkValue();
        }
        return versionPkValue;
    }

    private void queryPacketCountByVersion(long[] versionId) {
        QFilter filter = new QFilter(TRANSFER_PACKET_VERSION, "in", (Object)versionId);
        try (DataSet transferPacketdata = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)TRANSFER_PACKET, (String)TRANSFER_PACKET_VERSION, (QFilter[])new QFilter[]{filter}, null);){
            GroupbyDataSet groupByPacketVersion = transferPacketdata.groupBy(new String[]{TRANSFER_PACKET_VERSION});
            groupByPacketVersion = groupByPacketVersion.count(TRANSFER_PACKET_COUNT);
            try (DataSet result = groupByPacketVersion.finish();){
                HashMap<String, Integer> versionNumberAndPacketCount = new HashMap<String, Integer>(16);
                for (Row row : result) {
                    String versionPkValue = row.get(TRANSFER_PACKET_VERSION).toString();
                    int packetCount = (Integer)row.get(TRANSFER_PACKET_COUNT);
                    versionNumberAndPacketCount.put(versionPkValue, packetCount);
                }
                this.getPageCache().put(VERSION_PACKETCOUNT, SerializationUtils.toJsonString(versionNumberAndPacketCount));
            }
        }
    }

    private void setListPacketcountValue(DynamicObjectCollection listData) {
        for (DynamicObject versionObject : listData) {
            String versionPkValue = versionObject.getPkValue().toString();
            versionObject.set(TRANSFER_PACKET_COUNT, (Object)this.getPacketCountByVersionId(versionPkValue));
        }
    }

    private int getPacketCountByVersionId(Object versionId) {
        Object versionIdVal;
        int packetCount = 0;
        String pageCacheVersionPacket = this.getPageCache().get(VERSION_PACKETCOUNT);
        Map versionPacketCount = pageCacheVersionPacket == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)pageCacheVersionPacket, Map.class);
        if (versionId != null && (versionIdVal = versionPacketCount.get(versionId.toString())) != null) {
            packetCount = (Integer)versionIdVal;
        }
        return packetCount;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        ListSelectedRow currentRow = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        String currentVersionPkValue = currentRow.getPrimaryKeyValue().toString();
        String clickField = args.getFieldName();
        if (TRANSFER_PACKET_COUNT.equals(clickField)) {
            args.setCancel(true);
            this.openDatapacketListForm(currentVersionPkValue, currentRow.getNumber());
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParam = e.getParameter();
        int packetCount = this.getPacketCountByVersionId(e.getParameter().getPkId());
        billShowParam.setCustomParam(TRANSFER_PACKET_COUNT, (Object)packetCount);
    }

    private void openDatapacketListForm(Object versionId, String number) {
        ShowType currentViewSHowType;
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("ricc_version_id", versionId);
        int packetCount = this.getPacketCountByVersionId(versionId);
        customParams.put("packetCount", packetCount);
        ListShowParameter formShowParameter = ShowParameterUtil.listShowParameter((String)TRANSFER_PACKET, (String)"bos_list", (ShowType)ShowType.MainNewTabPage, customParams, null, null, null);
        String hasOpenListForm = this.getPageCache().get(HAS_OPEN_FORM);
        Map<String, String> hasOpenFormMap = hasOpenListForm != null ? (Map)SerializationUtils.fromJsonString((String)hasOpenListForm, Map.class) : new HashMap(16);
        String pageId = (String)hasOpenFormMap.get(number);
        ListView openedView = (ListView)this.getView().getViewNoPlugin(pageId);
        if (StringUtils.isNotEmpty((String)pageId) && openedView != null) {
            openedView.activate();
            this.getView().sendFormAction((IFormView)openedView);
            return;
        }
        String parentPgId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPgId);
        String parentPageId = null;
        parentPageId = parentView != null ? (ShowType.Modal.equals((Object)(currentViewSHowType = this.getView().getFormShowParameter().getOpenStyle().getShowType())) ? this.getView().getPageId() : parentPgId) : this.getView().getFormShowParameter().getRootPageId();
        formShowParameter.setParentPageId(parentPageId);
        this.getView().showForm((FormShowParameter)formShowParameter);
        pageId = formShowParameter.getPageId();
        hasOpenFormMap.put(number, pageId);
        this.getPageCache().put(HAS_OPEN_FORM, SerializationUtils.toJsonString(hasOpenFormMap));
    }
}

