/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.mservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.util.StringUtils;

public class PackSchemeServiceImpl {
    private static final Log logger = LogFactory.getLog(PackSchemeServiceImpl.class);
    private static final String SUCCESS = "success";

    public static JSONObject success() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SUCCESS, (Object)Boolean.TRUE);
        return jsonObject;
    }

    public static JSONObject fail(String msg) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SUCCESS, (Object)Boolean.FALSE);
        jsonObject.put("msg", (Object)msg);
        return jsonObject;
    }

    public Object savePackScheme(List<Map<String, Object>> paramMapList) {
        logger.info("\u6279\u91cf\u6253\u5305\u65b9\u6848\u65b0\u589e\u4fee\u6539\u64cd\u4f5c\u5f00\u59cb\uff0c\u64cd\u4f5c\u7528\u6237\uff1a" + UserServiceHelper.getCurrentUserId());
        StringBuilder errorInfo = new StringBuilder();
        if (paramMapList == null || paramMapList.isEmpty()) {
            errorInfo.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u5f55\u5165\u6279\u91cf\u6253\u5305\u65b9\u6848\u6240\u9700\u7684\u53c2\u6570", (String)"PackSchemeServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return PackSchemeServiceImpl.fail(errorInfo.toString());
        }
        logger.info("\u5fae\u670d\u52a1\u4fdd\u5b58\u6279\u91cf\u6253\u5305\u65b9\u6848\u6570\u636e: {}", paramMapList);
        Object[] ids = paramMapList.stream().filter(l -> l.get("id") != null).map(p -> p.get("id")).distinct().toArray();
        Object[] numbers = paramMapList.stream().filter(l -> l.get("number") != null).map(p -> p.get("number")).distinct().toArray();
        long countOfNullIds = paramMapList.stream().filter(l -> l.get("id") == null).count();
        if ((long)ids.length + countOfNullIds != (long)paramMapList.size()) {
            errorInfo.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u51fa\u73b0\u91cd\u590d\u7684\u65b9\u6848id\uff0c\u8bf7\u68c0\u67e5", (String)"PackSchemeServiceImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return PackSchemeServiceImpl.fail(errorInfo.toString());
        }
        QFilter filter = new QFilter("id", "in", (Object)ids).or(new QFilter("number", "in", (Object)numbers));
        DynamicObject[] existArr = BusinessDataServiceHelper.load((String)"ricc_packscheme", (String)"id,name,number,enable,ispreset,remarks,packschemeentry.item,packschemeentry.itemispreset,packschemeentry.dataselection,packschemeentry.pid,packschemeentry.filterterm_l,packschemeentry.exportfilters,packschemeentry.exportfilters_tag,packschemeentry.manualsel,packschemeentry.manualselectdata,packschemeentry.manualselectdata_tag,packschemeentry.entryremark", (QFilter[])filter.toArray());
        Map existMap = Arrays.stream(existArr).collect(Collectors.toMap(y -> y.getString("number"), Function.identity()));
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(paramMapList.size());
        ArrayList<DynamicObject> editList = new ArrayList<DynamicObject>(paramMapList.size());
        for (Map<String, Object> paramMap : paramMapList) {
            StringBuilder msgInfo = new StringBuilder();
            String number = (String)paramMap.getOrDefault("number", "");
            boolean isNew = false;
            DynamicObject packScheme = (DynamicObject)existMap.get(number);
            if (packScheme == null) {
                packScheme = BusinessDataServiceHelper.newDynamicObject((String)"ricc_packscheme");
                packScheme.set("creator", (Object)UserServiceHelper.getCurrentUserId());
                packScheme.set("createtime", (Object)new Date());
                packScheme.set("id", paramMap.getOrDefault("id", 0L));
                packScheme.set("status", (Object)"C");
                isNew = true;
            }
            this.setBaseDataInfo(packScheme, paramMap);
            this.setEntryInfo(packScheme, paramMap, msgInfo);
            if (msgInfo.length() > 0) {
                String name = (String)paramMap.getOrDefault("name", "");
                try {
                    JSONObject nameObject = JSONObject.parseObject((String)name);
                    name = nameObject.getString(RequestContext.getOrCreate().getLang().getLocale().toString());
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    name = (String)paramMap.getOrDefault("name", "");
                }
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u6253\u5305\u65b9\u6848\u7f16\u7801\uff1a%1$s, \u6253\u5305\u65b9\u6848\u540d\u79f0\uff1a%2$s,\u6253\u5305\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\u5982\u4e0b\uff1a%3$s", (String)"PackSchemeServiceImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]), number, name, msgInfo)).append('\n');
                continue;
            }
            if (isNew) {
                newList.add(packScheme);
                continue;
            }
            editList.add(packScheme);
        }
        if (!newList.isEmpty()) {
            this.saveData(newList, errorInfo);
        }
        if (!editList.isEmpty()) {
            this.saveData(editList, errorInfo);
        }
        if (errorInfo.length() > 0) {
            return PackSchemeServiceImpl.fail(errorInfo.toString());
        }
        return PackSchemeServiceImpl.success();
    }

    private void setBaseDataInfo(DynamicObject packScheme, Map<String, Object> paramMap) {
        String number = (String)paramMap.getOrDefault("number", "");
        this.setValue(packScheme, "number", number);
        String name = (String)paramMap.getOrDefault("name", "");
        try {
            JSONObject nameObject = JSONObject.parseObject((String)name);
            this.setValue(packScheme, "name", nameObject);
        }
        catch (Exception e) {
            this.setValue(packScheme, "name", name);
        }
        String enable = (String)paramMap.getOrDefault("enable", "1");
        if (!"1".equals(enable) && !"0".equals(enable)) {
            enable = "1";
        }
        this.setValue(packScheme, "enable", enable);
        boolean isPreset = (Boolean)paramMap.getOrDefault("ispreset", packScheme.getBoolean("ispreset"));
        packScheme.set("ispreset", (Object)isPreset);
        String explain = (String)paramMap.getOrDefault("remarks", "");
        this.setValue(packScheme, "remarks", explain);
    }

    private void setEntryInfo(DynamicObject packScheme, Map<String, Object> paramMap, StringBuilder msgInfo) {
        long countOfNullIds;
        List schemeEntryParam = paramMap.getOrDefault("packschemeentry", Collections.emptyList());
        Object[] ids = schemeEntryParam.stream().filter(l -> l.get("id") != null).map(p -> p.get("id")).distinct().toArray();
        if ((long)ids.length + (countOfNullIds = schemeEntryParam.stream().filter(l -> l.get("id") == null).count()) != (long)schemeEntryParam.size()) {
            msgInfo.append(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u9519\u8bef\uff0c\u5206\u5f55id\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"PackSchemeServiceImpl_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        if (!schemeEntryParam.isEmpty()) {
            Object[] itemsIds = schemeEntryParam.stream().filter(l -> l.get("itemid") != null).map(p -> p.get("itemid")).toArray();
            Map<Object, DynamicObject> entryItems = this.getEntryConfigItems(itemsIds);
            DynamicObjectCollection schemeEntry = packScheme.getDynamicObjectCollection("packschemeentry");
            schemeEntry.clear();
            for (Map oneItemRow : schemeEntryParam) {
                this.setSchemeEntryValue(msgInfo, entryItems, schemeEntry, oneItemRow);
            }
        }
    }

    private void setSchemeEntryValue(StringBuilder msgInfo, Map<Object, DynamicObject> entryItems, DynamicObjectCollection schemeEntry, Map<String, Object> oneItemRow) {
        long itemId = (Long)oneItemRow.getOrDefault("itemid", 0L);
        DynamicObject configItem = entryItems.get(itemId);
        if (configItem == null) {
            msgInfo.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8f93\u5165\u7684\u914d\u7f6e\u9879id: %s\u3002\u5728\u5f53\u524d\u73af\u5883\u672a\u627e\u5230\u5bf9\u5e94\u914d\u7f6e\u9879%n", (String)"PackSchemeServiceImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]), itemId));
        } else {
            DynamicObject entryRow = new DynamicObject(schemeEntry.getDynamicObjectType());
            long entryId = (Long)oneItemRow.getOrDefault("entryid", 0L);
            entryRow.set("id", (Object)entryId);
            long parentEntryId = (Long)oneItemRow.getOrDefault("parententryid", 0L);
            entryRow.set("pid", (Object)parentEntryId);
            entryRow.set("item_id", (Object)itemId);
            String dataSelect = (String)oneItemRow.getOrDefault("dataselection", "A");
            entryRow.set("dataselection", (Object)dataSelect);
            if (StringUtils.equals((String)dataSelect, (String)"A")) {
                String crConditionJson = (String)oneItemRow.getOrDefault("exportfilters", "");
                this.setFilterDataStore(entryRow, crConditionJson);
            } else {
                Map<Object, Object> selectDatas = oneItemRow.getOrDefault("manualselectdata", Collections.emptyMap());
                this.setManualDataStore(msgInfo, selectDatas, entryRow, configItem);
            }
            String entryMark = (String)oneItemRow.getOrDefault("entryremark", "");
            this.setValue(entryRow, "entryremark", entryMark);
            schemeEntry.add((Object)entryRow);
        }
    }

    private void setFilterDataStore(DynamicObject entryRow, String crConditionJson) {
        CRCondition crCondition = null;
        if (StringUtils.isNotBlank((CharSequence)crConditionJson)) {
            crCondition = (CRCondition)SerializationUtils.fromJsonString((String)crConditionJson, CRCondition.class);
        }
        boolean isEmpty = crCondition == null || StringUtils.isBlank((CharSequence)crCondition.getExprDesc());
        String exportDesc = isEmpty ? "" : crCondition.getExprDesc();
        this.setValue(entryRow, "filterterm_l", exportDesc);
        String exportFilter = isEmpty ? "" : SerializationUtils.toJsonString((Object)crCondition);
        this.setValue(entryRow, "exportfilters_tag", exportFilter);
    }

    private void setManualDataStore(StringBuilder msgInfo, Map<Object, Object> selectDatas, DynamicObject entryRow, DynamicObject configItem) {
        if (selectDatas.isEmpty()) {
            msgInfo.append(ResManager.loadKDString((String)"\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u624b\u5de5\u9009\u62e9\u65f6\uff0c\u5fc5\u987b\u9009\u62e9\u6570\u636e", (String)"PackSchemeServiceImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
        } else {
            QFilter filter = new QFilter("id", "in", selectDatas.keySet());
            String entityName = configItem.getString("page.basedatafield.number");
            List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filter.toArray(), null, (int)1000);
            List<Object> notExist = selectDatas.keySet().stream().filter(o -> !queryPrimaryKeys.contains(o)).collect(Collectors.toList());
            if (notExist.isEmpty()) {
                this.setValue(entryRow, "manualsel", String.format(ResManager.loadKDString((String)"\u5df2\u9009%s\u6761", (String)"PackSchemeServiceImpl_6", (String)"sys-ricc-platform", (Object[])new Object[0]), selectDatas.size()));
                this.setValue(entryRow, "manualselectdata_tag", JSON.toJSONString(selectDatas));
            } else {
                msgInfo.append(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u6570\u636eid\u4e3a%s\u7684\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PackSchemeServiceImpl_7", (String)"sys-ricc-platform", (Object[])new Object[0]), Arrays.toString(notExist.toArray(new Object[0]))));
            }
        }
    }

    private Map<Object, DynamicObject> getEntryConfigItems(Object[] itemsIds) {
        DynamicObject[] loadDataArr = BusinessDataServiceHelper.load((Object[])itemsIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ricc_configitems"));
        return Arrays.stream(loadDataArr).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
    }

    private void setValue(DynamicObject dynamicObject, String key, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        dynamicObject.set(key, (Object)value);
    }

    private void setValue(DynamicObject dynamicObject, String key, Object value) {
        if (value == null) {
            return;
        }
        dynamicObject.set(key, value);
    }

    public Object deletePackScheme(List<Long> idList) {
        JSONObject returnInfo;
        StringBuilder errorInfo = new StringBuilder();
        if (idList == null || idList.isEmpty()) {
            errorInfo.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u5220\u9664\u6253\u5305\u65b9\u6848\u6240\u9700\u7684\u53c2\u6570", (String)"PackSchemeServiceImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return PackSchemeServiceImpl.fail(errorInfo.toString());
        }
        logger.info("\u5fae\u670d\u52a1\u5220\u9664\u6253\u5305\u65b9\u6848\u6570\u636e{}", idList);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ricc_packscheme", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
        boolean isSuccess = operationResult.isSuccess();
        List successPkIds = operationResult.getSuccessPkIds();
        if (!isSuccess) {
            Map<Object, Object> failPkIdMap = PackSchemeServiceImpl.buildDelFailInfoMap(operationResult, idList, errorInfo);
            returnInfo = PackSchemeServiceImpl.fail(errorInfo.toString());
            returnInfo.put("failPkIdsInfo", failPkIdMap);
        } else {
            returnInfo = PackSchemeServiceImpl.success();
        }
        returnInfo.put("successPkIds", (Object)successPkIds);
        return returnInfo;
    }

    private static Map<Object, Object> buildDelFailInfoMap(OperationResult operationResult, List<Long> idList, StringBuilder errorInfo) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        HashMap<Object, Object> failPkIdMap = new HashMap<Object, Object>(idList.size());
        if (!operationResult.isSuccess() && allErrorOrValidateInfo.isEmpty()) {
            for (Long id : idList) {
                HashMap<String, String> msgMap = new HashMap<String, String>(2);
                msgMap.put("errorCode", "notExistRecords");
                msgMap.put("errorMsg", operationResult.getMessage());
                failPkIdMap.put(id, msgMap);
            }
        }
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            OperateErrorInfo operateErrorInfo = (OperateErrorInfo)iOperateInfo;
            String errorCode = operateErrorInfo.getErrorCode();
            Object pkValue = operateErrorInfo.getPkValue();
            String message = operateErrorInfo.getMessage();
            errorInfo.append(message).append('\n');
            HashMap<String, String> msgMap = new HashMap<String, String>(2);
            msgMap.put("errorCode", errorCode);
            msgMap.put("errorMsg", message);
            failPkIdMap.put(pkValue, msgMap);
        }
        return failPkIdMap;
    }

    private void saveData(List<DynamicObject> saveList, StringBuilder errorInfo) {
        OperationResult operationResult;
        boolean success;
        long currentUserId = UserServiceHelper.getCurrentUserId();
        OperateOption option = OperateOption.create();
        if (PermissionServiceHelper.isAdminUser((long)currentUserId, (AdminType)AdminType.Administrator)) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        if (!(success = (operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ricc_packscheme", (DynamicObject[])saveList.toArray(new DynamicObject[0]), (OperateOption)option)).isSuccess())) {
            operationResult.getAllErrorOrValidateInfo().forEach(p -> errorInfo.append(p.getMessage()).append('\n'));
        }
    }

    public Map<String, Object> getSchemesByNumber(List<String> schemeNumberList) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        StringBuilder msg = new StringBuilder();
        if (schemeNumberList == null || schemeNumberList.isEmpty()) {
            msg.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6253\u5305\u65b9\u6848\u7f16\u7801", (String)"PackSchemeServiceImpl_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        logger.info("\u901a\u8fc7\u7f16\u7801\u67e5\u8be2\u6279\u91cf\u6253\u5305\u65b9\u6848\u5f00\u59cb{}", schemeNumberList);
        result.put(SUCCESS, msg.length() == 0);
        result.put("msg", msg.toString());
        if (msg.length() == 0) {
            DynamicObject[] data = BusinessDataServiceHelper.load((Object[])this.getSchemeIdsByNumber(schemeNumberList).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ricc_packscheme"));
            result.put("data", Arrays.stream(data).collect(Collectors.toList()));
        }
        return result;
    }

    private List<Object> getSchemeIdsByNumber(List<String> schemeNumberList) {
        QFilter qFilter = new QFilter("number", "in", schemeNumberList);
        return QueryServiceHelper.queryPrimaryKeys((String)"ricc_packscheme", (QFilter[])qFilter.toArray(), null, (int)-1);
    }
}

