/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.opplugin.initconfig;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sys.ricc.common.enums.ConfigControlItems;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class InitconfigSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(InitconfigSaveOp.class);
    private static final String ENV_ROLE = "envrole";
    public static final String ENVTYPEINFO = "envtypeinfo";
    public static final String ENV_ENTRY = "enventry";
    public static final String USER_ENTRY = "user_entry";
    public static final String IMPORT_TEMPLATE_HASID = "importtemplatehasid";
    private static final String DATAPACKET_SPECIAL_PERM_PK = "1VXYQ5RM6T+1";
    private static final String TRANSFERTASK_SPECIAL_PERM_PK = "1VXYT+ANYT00";
    private static final String PACKET_SECRET = "packetsecret";
    private static final String SYSTOKEN = "syspwd";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(ENV_ROLE);
        e.getFieldKeys().add(ENV_ENTRY);
        e.getFieldKeys().add(USER_ENTRY);
        e.getFieldKeys().add(IMPORT_TEMPLATE_HASID);
        e.getFieldKeys().add(PACKET_SECRET);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        if (dataEntities == null || dataEntities.length != 1) {
            return;
        }
        this.doExtraSave(dataEntities[0], beginOperationTransactionArgs);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        try {
            logger.info("SaveOp.afterExecuteOperationTransaction\u6267\u884c\u6e05\u7a7a\u914d\u7f6e\u9879\u7f13\u5b58\u6570\u636e");
            SysParaUtil.cleanControlConfigCache();
        }
        catch (Exception ex) {
            logger.error("\u6e05\u9664\u53c2\u6570\u914d\u7f6e\u5206\u5e03\u5f0f\u7f13\u5b58\u5931\u8d25\u3002", (Throwable)ex);
        }
    }

    private void doExtraSave(DynamicObject initConfigDy, BeginOperationTransactionArgs beginOperationTransactionArgs) {
        try (TXHandle txHandle = TX.required();){
            try {
                this.permInitOrUpdate(initConfigDy);
                SysParaUtil.savePublicParameter((String)"importtrmplatehasid", (Object)initConfigDy.get(IMPORT_TEMPLATE_HASID));
                this.saveSpecialDataPerm(initConfigDy);
                this.updateThirdApp(initConfigDy);
            }
            catch (Exception e) {
                logger.error("\u53c2\u6570\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25\u3002", (Throwable)e);
                txHandle.markRollback();
                String errorTitle = ResManager.loadKDString((String)"ricc\u64cd\u4f5c\u9519\u8bef\u63d0\u793a", (String)"InitconfigSaveOp_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002%s", (String)"InitconfigSaveOp_1", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage());
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", initConfigDy.getPkValue(), 0, 0, "initConfig_saveOp", errorTitle, errorMsg, ErrorLevel.Error));
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("ricc_initconfig", ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e", (String)"InitconfigSaveOp_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.operationResult.setBillNos(map);
                beginOperationTransactionArgs.setCancelOperation(true);
                beginOperationTransactionArgs.setDataEntities(new DynamicObject[0]);
            }
        }
    }

    private void permInitOrUpdate(DynamicObject initConfigDy) {
        String basicSetChange = this.getBasicSetChange(initConfigDy);
        DynamicObjectCollection exceptionUser = initConfigDy.getDynamicObjectCollection(USER_ENTRY);
        DynamicObject oldInitConfig = SysParaUtil.getInitConfig();
        String oldBasicSetChange = basicSetChange;
        List<Object> kickOutUserList = new ArrayList();
        if (oldInitConfig != null) {
            oldBasicSetChange = this.getBasicSetChange(oldInitConfig);
            DynamicObjectCollection oldExceptionUser = oldInitConfig.getDynamicObjectCollection(USER_ENTRY);
            kickOutUserList = this.getKickOutUser(oldExceptionUser, exceptionUser);
        }
        PermissionUtil.initOrUpdateRiccPerm((String)oldBasicSetChange, (String)basicSetChange, (DynamicObjectCollection)exceptionUser, kickOutUserList);
    }

    private String getBasicSetChange(DynamicObject initConfigDy) {
        String envRole = initConfigDy.getString(ENV_ROLE);
        DynamicObjectCollection envEntryDataDc = initConfigDy.getDynamicObjectCollection(ENV_ENTRY);
        for (DynamicObject envEntryData : envEntryDataDc) {
            String envTypeInfo = envEntryData.getString(ENVTYPEINFO);
            if (!envTypeInfo.equals(envRole)) continue;
            return envEntryData.getString(ConfigControlItems.CHANGE_PERM_TYPE.getValue());
        }
        return null;
    }

    private List<Object> getKickOutUser(DynamicObjectCollection originExceptionUser, DynamicObjectCollection newExceptionUser) {
        List<Object> kickOutList = new ArrayList<Object>();
        if (originExceptionUser.isEmpty()) {
            return kickOutList;
        }
        ArrayList<Object> originUserList = new ArrayList<Object>();
        for (DynamicObject originUser : originExceptionUser) {
            originUserList.add(originUser.getLong("user_id"));
        }
        if (newExceptionUser.isEmpty()) {
            return originUserList;
        }
        ArrayList<Object> newUserList = new ArrayList<Object>();
        for (DynamicObject excUser : newExceptionUser) {
            newUserList.add(excUser.get("user_id"));
        }
        kickOutList = originUserList.stream().filter(o -> !newUserList.contains(o)).collect(Collectors.toList());
        return kickOutList;
    }

    private void saveSpecialDataPerm(DynamicObject initConfigDy) {
        DynamicObjectCollection permRuleCollection = PermissionUtil.querySpecialDataPermData((String)"view", (boolean)false, (String[])new String[]{"ricc_transfertask", "ricc_datapacket"});
        HashMap<String, Boolean> pKandEnabled = new HashMap<String, Boolean>(2);
        for (DynamicObject permRule : permRuleCollection) {
            boolean newEnabled = false;
            boolean oldEnabled = (Boolean)permRule.get("objenabled");
            String entityNumber = permRule.get("entityType").toString();
            String rulePkValue = permRule.get("id").toString();
            if (StringUtils.equals((String)entityNumber, (String)"ricc_datapacket")) {
                newEnabled = (Boolean)initConfigDy.get("isolatepacketage");
            } else if (StringUtils.equals((String)entityNumber, (String)"ricc_transfertask")) {
                newEnabled = (Boolean)initConfigDy.get("isolatetransfer");
            }
            if (oldEnabled == newEnabled) continue;
            boolean isRiccPreset = StringUtils.equals((String)rulePkValue, (String)DATAPACKET_SPECIAL_PERM_PK) || StringUtils.equals((String)rulePkValue, (String)TRANSFERTASK_SPECIAL_PERM_PK);
            boolean needUpdateData = !newEnabled || newEnabled && isRiccPreset;
            if (!needUpdateData) continue;
            pKandEnabled.put(rulePkValue, newEnabled);
        }
        if (pKandEnabled.size() > 0) {
            PermissionUtil.updateSpecialPermEnabled(pKandEnabled);
        }
    }

    private void updateThirdApp(DynamicObject initConfigDy) {
        String sysPwd = initConfigDy.getString(SYSTOKEN);
        if (StringUtils.isEmpty((String)sysPwd)) {
            return;
        }
        QFilter filter = new QFilter("number", "=", (Object)"ricc");
        DynamicObject thirdApp = BusinessDataServiceHelper.loadSingle((String)"third_app", (String)"enable,syspwd,modifier,modifytime", (QFilter[])filter.toArray());
        thirdApp.set("enable", (Object)"1");
        thirdApp.set(SYSTOKEN, (Object)sysPwd);
        thirdApp.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
        thirdApp.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"third_app", (DynamicObject[])new DynamicObject[]{thirdApp}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u7b2c\u4e09\u65b9\u5e94\u7528token\u5bc6\u94a5\u5931\u8d25\uff1a%1$s%2$s", (String)"InitconfigSaveOp_5", (String)"sys-ricc-platform", (Object[])new Object[0]), operationResult.getAllErrorOrValidateInfo(), operationResult.getValidateResult()));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities;
                for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
                    String sysPwd;
                    String packetSecret = (String)entity.getValue(InitconfigSaveOp.PACKET_SECRET);
                    if (StringUtils.isNotBlank((CharSequence)packetSecret) && !packetSecret.matches("^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{8,50}$")) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u52a0\u5bc6\u5bc6\u94a5\u5b57\u6bb5\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff088~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09", (String)"InitconfigSaveOp_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(sysPwd = (String)entity.getValue(InitconfigSaveOp.SYSTOKEN))) || sysPwd.matches("^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$")) continue;
                    this.addMessage(entity, ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u5bc6\u94a5\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff0816~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09\u3002", (String)"InitconfigSaveOp_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
            }
        });
    }
}

