/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.report;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.sys.ricc.common.util.StringUtils;

public class DataReferenceReportPlugin
extends AbstractReportFormPlugin {
    private static final String ENTITY_DEPENDENCY = "2";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"referenceddata"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("basedatatype".equals(propertyName)) {
            this.getModel().setValue("referenceddata", null);
            this.getModel().setValue("referenceddataid", null);
        } else if ("querytype".equals(propertyName)) {
            String queryType = (String)e.getChangeSet()[0].getNewValue();
            TextEdit textEdit = (TextEdit)this.getControl("referenceddata");
            if (StringUtils.equals((String)ENTITY_DEPENDENCY, (String)queryType)) {
                textEdit.setMustInput(false);
            } else {
                textEdit.setMustInput(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("referenceddata".equalsIgnoreCase(key)) {
            DynamicObject baseDataType = this.getModel().getDataEntity().getDynamicObject("basedatatype");
            if (baseDataType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"DataReferenceReportPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            String baseDataNumber = this.getModel().getDataEntity().getDynamicObject("basedatatype").getString("number");
            ListShowParameter listParameter = ShowFormHelper.createShowListForm((String)baseDataNumber, (boolean)true);
            listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataCallBack"));
            this.getView().showForm((FormShowParameter)listParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String callBackID = closedCallBackEvent.getActionId();
            IDataModel model = this.getModel();
            if ("dataCallBack".equalsIgnoreCase(callBackID)) {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                StringBuilder name = new StringBuilder();
                StringBuilder id = new StringBuilder();
                for (ListSelectedRow row : returnData) {
                    name.append(row.getName()).append(";");
                    id.append(row.getPrimaryKeyValue()).append(";");
                }
                model.setValue("referenceddata", (Object)name.toString());
                model.setValue("referenceddataid", (Object)id.toString());
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        return this.verifyQueryParams(filter);
    }

    private boolean verifyQueryParams(FilterInfo filterInfo) {
        String value;
        if (StringUtils.isBlank((CharSequence)filterInfo.getString("querytype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u7c7b\u578b", (String)"DataReferenceReportPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)filterInfo.getString("basedatatype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"DataReferenceReportPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        if (!StringUtils.equals((String)ENTITY_DEPENDENCY, (String)filterInfo.getString("querytype")) && StringUtils.isBlank((Object)filterInfo.getValue("referenceddata"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u88ab\u5f15\u7528\u6570\u636e", (String)"DataReferenceReportPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isNotBlank((Object)filterInfo.getValue("referenceddata")) && (value = (String)filterInfo.getValue("referenceddata")).split(";").length > 100000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u5f15\u7528\u6570\u636e\u9009\u62e9\u4e0d\u5f97\u8d85\u8fc7100000\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"DataReferenceReportPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

