/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.accrual;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.business.accrual.AccrualListQueryService;
import kd.taxc.bdtaxr.business.accrual.DefaultAccrualListQueryServiceImpl;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AccrualListingService {
    private static final Log LOGGER = LogFactory.getLog(AccrualListingService.class);
    private static final String BDTAXR_ACCRUAL_LISTING = "bdtaxr_accrual_listing";
    AccrualListQueryService accrualListQueryService = new DefaultAccrualListQueryServiceImpl();

    public List<Map<String, Object>> query(List<Long> orgList, List<String> categoryList, Date accrualDate) {
        List<Map<String, Object>> defaultResult = this.accrualListQueryService.queryAccrualList(orgList, categoryList, accrualDate);
        ArrayList categoryListEnums = new ArrayList();
        categoryList.forEach(c -> {
            AccrualListEnum accrualListEnum = AccrualListEnum.valueOfCateGory((String)c);
            if (accrualListEnum != null) {
                categoryListEnums.add(accrualListEnum);
            }
        });
        Map<String, List<AccrualListEnum>> categoryListEnumsMap = categoryListEnums.stream().collect(Collectors.groupingBy(AccrualListEnum::getAppId));
        List needInvokeEnums = AccrualListEnum.needInvokeTax();
        Map<String, List<AccrualListEnum>> needInvokeEnumsGroup = needInvokeEnums.stream().collect(Collectors.groupingBy(AccrualListEnum::getAppId));
        needInvokeEnumsGroup.forEach((k, v) -> {
            try {
                List temp = (List)categoryListEnumsMap.get(k);
                if (temp != null && v.containsAll(temp)) {
                    List categories = temp.stream().map(AccrualListEnum::getCategory).distinct().collect(Collectors.toList());
                    List result = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)k, (String)"AccrualListQueryService", (String)"queryAccrualList", (Object[])new Object[]{orgList, categories, accrualDate});
                    defaultResult.addAll(result);
                }
            }
            catch (Exception e) {
                LOGGER.error("invoke appid:{1} falied", k);
            }
        });
        return defaultResult;
    }

    public List<Map<String, Object>> queryTaxableList(List<Map<String, Object>> categoryOrgList, Date accrualDate) {
        return this.accrualListQueryService.queryAccrualList(categoryOrgList, accrualDate);
    }

    public void updateAccrualListToDB(Date declareDate, List<Long> orgList, List<String> categoryList) {
        if (declareDate == null) {
            declareDate = new Date();
        }
        Date month = DateUtils.getFirstDateOfMonth((Date)declareDate);
        if (CollectionUtils.isEmpty(orgList)) {
            orgList = OrgUtils.getOrgIdlists();
        }
        if (CollectionUtils.isEmpty(categoryList)) {
            AccrualListEnum[] accrualListEnums = AccrualListEnum.values();
            categoryList = Arrays.stream(accrualListEnums).map(AccrualListEnum::getCategory).collect(Collectors.toList());
        }
        LOGGER.info("start accrualListService.queryTimely");
        long startTimeMillis = System.currentTimeMillis();
        List<Map<String, Object>> maps = this.query(orgList, categoryList, declareDate);
        LOGGER.info("end accrualListService.queryTimely cost time:{}", (Object)(System.currentTimeMillis() - startTimeMillis));
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(maps.size());
        for (Map<String, Object> objectMap : maps) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BDTAXR_ACCRUAL_LISTING));
            dynamicObject.set("org", objectMap.get("org"));
            dynamicObject.set("taxsystem", objectMap.get("taxsystem"));
            dynamicObject.set("taxareagroup", objectMap.get("taxareagroup"));
            dynamicObject.set("taxtype", objectMap.get("taxcatetory"));
            dynamicObject.set("accountsettype", objectMap.get("accountsettype"));
            dynamicObject.set("skssqq", (Object)DateUtils.trunc((Date)((Date)objectMap.get("skssqq"))));
            dynamicObject.set("skssqz", (Object)DateUtils.trunc((Date)((Date)objectMap.get("skssqz"))));
            dynamicObject.set("billno", objectMap.get("billno"));
            dynamicObject.set("billstatus", objectMap.get("billstatus"));
            dynamicObject.set("category", objectMap.get("category"));
            dynamicObject.set("month", objectMap.get("accrualDate"));
            dynamicObject.set("modifytime", (Object)declareDate);
            dynamicObjectList.add(dynamicObject);
        }
        try (TXHandle h = TX.required((String)"updateAccrualList");){
            try {
                Date end = DateUtils.getLastDateOfMonth((Date)month);
                QFilter q1 = new QFilter("month", ">=", (Object)month);
                QFilter q2 = new QFilter("month", "<=", (Object)end);
                if (EmptyCheckUtils.isNotEmpty((Object)orgList)) {
                    q2.and("org", "in", (Object)orgList);
                }
                DeleteServiceHelper.delete((String)BDTAXR_ACCRUAL_LISTING, (QFilter[])new QFilter[]{q1, q2});
                if (EmptyCheckUtils.isNotEmpty(dynamicObjectList)) {
                    List partitions = Lists.partition(dynamicObjectList, (int)200);
                    for (List partition : partitions) {
                        SaveServiceHelper.save((DynamicObject[])partition.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error("updateAccrualListToDB Error!", t);
            }
        }
    }

    public void updateAccrualListToDB() {
        this.updateAccrualListToDB(null, null, null);
    }
}

