/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.accrual;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.business.accrual.AccrualListQueryService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AccrualListDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class DefaultAccrualListQueryServiceImpl
implements AccrualListQueryService {
    private static final ArrayList<String> CHECK_ZERO_DECLARE_LIST = Lists.newArrayList((Object[])new String[]{"tcvat", "tccit"});
    private static final ArrayList<String> CHECK_FZJG_LIST = Lists.newArrayList((Object[])new String[]{"tcvat", "tccit", "itp"});
    private static final String BDTAXR_ACCRUAL_LISTING = "bdtaxr_accrual_listing";
    private String KEYFORMAT = "%s-%s-%s-%s-%s-%s-%s";

    @Override
    public List<Map<String, Object>> queryAccrualList(List<Long> orgList, List<String> categoryList, Date accrualDate) {
        ArrayList accrualListEnums = new ArrayList();
        categoryList.forEach(c -> {
            AccrualListEnum accrualListEnum = AccrualListEnum.valueOfCateGory((String)c);
            if (accrualListEnum != null) {
                accrualListEnums.add(accrualListEnum);
            }
        });
        orgList = (List)TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgId(orgList).getData();
        Map<String, Set<Long>> planMap = this.querySharePlanByOrgIds(orgList);
        ArrayList<Map<String, Object>> taxableListDtos = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Set<Long>> entry : planMap.entrySet()) {
            String planKey = entry.getKey();
            String[] planKeys = planKey.split("-");
            String taxtype = planKeys[2];
            String cycle = planKeys[3];
            String accountsettype = "";
            if (planKeys.length == 5) {
                accountsettype = planKeys[4];
            }
            ArrayList<Long> planOrgList = new ArrayList<Long>((Collection)entry.getValue());
            AccrualListEnum accrualListEnum = AccrualListEnum.valueOfBaseTaxIdAndAccountsettype((Long)Long.parseLong(taxtype), (String)accountsettype);
            if (accrualListEnum == null || !accrualListEnums.contains(accrualListEnum)) continue;
            Map<Boolean, List<Long>> orgGroup = this.groupOrgsByInTaxPeriod(planOrgList, accrualListEnum);
            for (Map.Entry<Boolean, List<Long>> listEntry : orgGroup.entrySet()) {
                Boolean intaxperiodjt = listEntry.getKey();
                Map skssqzMap = DateUtils.getSkssqzMap((Date)accrualDate, (String)cycle, (Boolean)intaxperiodjt);
                if (EmptyCheckUtils.isEmpty((Object)skssqzMap)) continue;
                List<Long> orglist = listEntry.getValue();
                this.createAccrualListDto(taxableListDtos, accrualListEnum, planKey, accrualDate, skssqzMap, orglist);
            }
        }
        return taxableListDtos;
    }

    @Override
    public List<Map<String, Object>> queryAccrualList(List<Map<String, Object>> categoryOrgList, Date accrualDate) {
        ArrayList<Long> orgList = new ArrayList<Long>(categoryOrgList.size());
        for (Map<String, Object> map : categoryOrgList) {
            String category = String.valueOf(map.get("category"));
            if (AccrualListEnum.needInvokeTax().contains(AccrualListEnum.valueOfCateGory((String)category))) continue;
            orgList.add(Long.parseLong(String.valueOf(map.get("org"))));
        }
        Map<String, Set<Long>> planMap = this.querySharePlanByOrgIds(orgList);
        ArrayList<Map<String, Object>> taxableListDtos = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Set<Long>> entry : planMap.entrySet()) {
            AccrualListEnum accrualListEnum;
            String planKey = entry.getKey();
            String[] planKeys = planKey.split("-");
            String taxtype = planKeys[2];
            String cycle = planKeys[3];
            String accountsettype = "";
            if (planKeys.length == 5) {
                accountsettype = planKeys[4];
            }
            ArrayList planOrgListOld = new ArrayList(entry.getValue());
            ArrayList<Long> planOrgList = new ArrayList<Long>();
            for (Map<String, Object> map : categoryOrgList) {
                String taxtypeFromTaskCenter = String.valueOf(map.get("taxtype"));
                Long org = Long.parseLong(String.valueOf(map.get("org")));
                if (!taxtype.equals(taxtypeFromTaskCenter) || !planOrgListOld.contains(org)) continue;
                planOrgList.add(org);
            }
            if (CollectionUtils.isEmpty(planOrgList) || (accrualListEnum = AccrualListEnum.valueOfBaseTaxIdAndAccountsettype((Long)Long.parseLong(taxtype), (String)accountsettype)) == null) continue;
            Map<Boolean, List<Long>> orgGroup = this.groupOrgsByInTaxPeriod(planOrgList, accrualListEnum);
            for (Map.Entry<Boolean, List<Long>> listEntry : orgGroup.entrySet()) {
                Boolean intaxperiodjt = listEntry.getKey();
                Map skssqzMap = DateUtils.getSkssqzMap((Date)accrualDate, (String)cycle, (Boolean)intaxperiodjt);
                if (EmptyCheckUtils.isEmpty((Object)skssqzMap)) continue;
                List<Long> orglist = listEntry.getValue();
                this.createAccrualListDto(taxableListDtos, accrualListEnum, planKey, accrualDate, skssqzMap, orglist);
            }
        }
        return taxableListDtos;
    }

    private Map<String, Set<Long>> querySharePlanByOrgIds(List<Long> orgList) {
        HashMap<String, Set<Long>> planMap = new HashMap<String, Set<Long>>();
        List sharePlans = (List)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIds(orgList).getData();
        for (DynamicObject sharePlan : sharePlans) {
            DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
            ArrayList<Long> orgs = new ArrayList<Long>();
            for (DynamicObject org : orgentity) {
                if (!orgList.contains(org.getDynamicObject("org").getLong("id"))) continue;
                orgs.add(org.getDynamicObject("org").getLong("id"));
            }
            DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
            for (DynamicObject rule : ruleentity) {
                DynamicObject plan = rule.getDynamicObject("rule");
                if (!plan.getBoolean("enable")) continue;
                String booktype = plan.getString("booktype");
                ArrayList<String> accountsettypes = new ArrayList<String>();
                if (EmptyCheckUtils.isNotEmpty((Object)booktype)) {
                    String[] split = booktype.substring(1, booktype.length() - 1).split(",");
                    Arrays.stream(split).forEach(type -> {
                        if (EmptyCheckUtils.isNotEmpty((Object)type)) {
                            accountsettypes.add((String)type);
                        }
                    });
                } else {
                    accountsettypes.add("");
                }
                for (String accountsettype : accountsettypes) {
                    String taxsystem = plan.getString("taxsystem.id");
                    String taxarea = plan.getString("taxarea.id");
                    String taxtype = plan.getString("taxtype.id");
                    String cycle = plan.getString("cycle");
                    String planMapKey = String.format("%s-%s-%s-%s-%s", taxsystem, taxarea, taxtype, cycle, accountsettype);
                    Set planOrgs = planMap.computeIfAbsent(planMapKey, d -> new HashSet());
                    planOrgs.addAll(orgs);
                }
            }
        }
        return planMap;
    }

    private void createAccrualListDto(List<Map<String, Object>> taxableListDtos, AccrualListEnum accrualListEnum, String planKey, Date accrualDate, Map<String, Date> skssqzMap, List<Long> orgs) {
        List<Long> appOrgList;
        String[] planKeys = planKey.split("-");
        String taxsystem = planKeys[0];
        String taxarea = planKeys[1];
        String taxtype = planKeys[2];
        String cycle = planKeys[3];
        String accountsettype = "";
        if (planKeys.length == 5) {
            accountsettype = planKeys[4];
        }
        if (EmptyCheckUtils.isEmpty(appOrgList = this.doBatchFilter(accrualListEnum, orgs, skssqzMap))) {
            return;
        }
        QFilter q1 = new QFilter("taxtype", "=", (Object)accrualListEnum.getBaseTaxId()).and("skssqq", "=", (Object)skssqzMap.get("skssqq")).and("skssqz", "=", (Object)skssqzMap.get("skssqz"));
        QFilter q2 = new QFilter("org", "in", appOrgList);
        QFilter q3 = new QFilter("taxsystem", "=", (Object)Long.parseLong(taxsystem));
        QFilter q4 = new QFilter("taxareagroup", "=", (Object)Long.parseLong(taxarea));
        QFilter q5 = new QFilter("templatetype", "not in", Arrays.asList("sdsjt_bd", "jtysbbd_bd", "yhs_bd", "fcs_bd", "cztdsys_bd"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"billno,billstatus,org,taxsystem,taxareagroup,accountsettype,taxtype,skssqq,skssqz", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        Map<String, DynamicObject> generatedDeclareData = dynamicObjects.stream().collect(Collectors.toMap(this.keyGroupFunction(), d -> d, (k1, k2) -> k2));
        for (Long orgid : appOrgList) {
            AccrualListDto accrualListDto = new AccrualListDto();
            accrualListDto.setOrg(orgid);
            accrualListDto.setTaxsystem(Long.valueOf(Long.parseLong(taxsystem)));
            accrualListDto.setTaxareagroup(Long.valueOf(Long.parseLong(taxarea)));
            accrualListDto.setTaxcatetory(Long.valueOf(Long.parseLong(taxtype)));
            accrualListDto.setAccountsettype(accountsettype);
            Date skssqq = skssqzMap.get("skssqq");
            accrualListDto.setSkssqq(skssqq);
            Date skssqz = skssqzMap.get("skssqz");
            accrualListDto.setSkssqz(skssqz);
            accrualListDto.setCategory(accrualListEnum.getCategory());
            accrualListDto.setAccrualDate(accrualDate);
            String key = String.format(this.KEYFORMAT, orgid, taxsystem, taxarea, accountsettype, taxtype, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
            DynamicObject object = generatedDeclareData.get(key);
            if (EmptyCheckUtils.isNotEmpty((Object)object)) {
                accrualListDto.setBillno(object.getString("billno"));
                accrualListDto.setBillstatus(object.getString("billstatus"));
            } else {
                accrualListDto.setBillstatus("nodata");
            }
            taxableListDtos.add(accrualListDto.transformToMap());
        }
    }

    private Map<Boolean, List<Long>> groupOrgsByInTaxPeriod(List<Long> planOrgList, AccrualListEnum accrualListEnum) {
        HashMap<Boolean, List<Long>> orgGroup = new HashMap<Boolean, List<Long>>();
        String appId = accrualListEnum.getAppId();
        if ("tcret".equals(appId)) {
            Map intaxperiodjtMap = SystemParamUtil.getAppParameterBatch((String)appId, (String)"intaxperiodjt", planOrgList);
            for (Map.Entry objectEntry : intaxperiodjtMap.entrySet()) {
                Boolean value = (Boolean)objectEntry.getValue();
                if (Boolean.TRUE.equals(value)) {
                    List trueOrgs = orgGroup.computeIfAbsent(Boolean.TRUE, d -> new ArrayList());
                    trueOrgs.add(objectEntry.getKey());
                    continue;
                }
                List falseOrgs = orgGroup.computeIfAbsent(Boolean.FALSE, d -> new ArrayList());
                falseOrgs.add(objectEntry.getKey());
            }
        } else {
            orgGroup.put(Boolean.FALSE, planOrgList);
        }
        return orgGroup;
    }

    private Function<DynamicObject, String> keyGroupFunction() {
        return d -> {
            Date skssqq = d.getDate("skssqq");
            Date skssqz = d.getDate("skssqz");
            return String.format(this.KEYFORMAT, d.getString("org"), d.getString("taxsystem"), d.getString("taxareagroup"), d.getString("accountsettype"), d.getString("taxtype"), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        };
    }

    private List<Long> doBatchFilter(AccrualListEnum accrualListEnum, List<Long> orgList, Map<String, Date> skssqzMap) {
        String appId = accrualListEnum.getAppId();
        if (EmptyCheckUtils.isNotEmpty(orgList) && CHECK_FZJG_LIST.contains(appId)) {
            Date skssqq = skssqzMap.get("skssqq");
            Date skssqz = skssqzMap.get("skssqz");
            QFilter q1 = new QFilter("billstatus", "=", (Object)"C");
            QFilter q2 = new QFilter("status", "=", (Object)"2");
            QFilter q3 = new QFilter("taxtype", "=", (Object)accrualListEnum.getTaxtype());
            QFilter q4 = new QFilter("effectdate", "<=", (Object)skssqq).and(new QFilter("invaliddate", ">=", (Object)skssqz).or("invaliddate", "is null", null));
            QFilter q5 = new QFilter("orgrow.declaration", "=", (Object)"3");
            DynamicObjectCollection orgCollection = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid as orgid", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
            List noNeedOrgIds = orgCollection.stream().map(d -> d.getLong("orgid")).collect(Collectors.toList());
            orgList.removeIf(noNeedOrgIds::contains);
        }
        if (EmptyCheckUtils.isNotEmpty(orgList) && CHECK_ZERO_DECLARE_LIST.contains(appId)) {
            Map zeroDeclareMap = SystemParamUtil.getAppParameterBatch((String)appId, (String)"zerodeclare", orgList);
            orgList.removeIf(d -> Objects.equals(zeroDeclareMap.get(d), true));
        }
        if (EmptyCheckUtils.isNotEmpty(orgList) && "tccit".equals(appId)) {
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgList);
            orgList = ((List)result.getData()).stream().filter(d -> {
                DynamicObject registertype = d.getDynamicObject("registertype");
                return registertype == null || !registertype.getString("longnumber").startsWith("400");
            }).map(d -> d.getLong("taxorg.id")).collect(Collectors.toList());
        }
        if (EmptyCheckUtils.isNotEmpty(orgList) && EmptyCheckUtils.isNotEmpty((Object)accrualListEnum.getTaxtype())) {
            orgList = TaxBaseDataUtils.filterEnableOrgsByTaxType(orgList, (String)accrualListEnum.getTaxtype());
        }
        return orgList;
    }
}

