/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.archive.impl;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.archive.ArchiveService;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ArchiveServiceImpl
implements ArchiveService {
    private static final String ARCHIVESTATUS = "archivestatus";
    private static Log LOGGER = LogFactory.getLog(ArchiveServiceImpl.class);
    private static final String ARCHIVE_STATUS_WGD = "unfiled";
    private static final String ARCHIVE_STATUS_YGD = "filed";

    @Override
    public String createDeclareTempFile(Long orgid, String startdate, String enddate, String templateType, String nsrxxfilter) {
        LOGGER.info("ArchiveServiceImpl createDeclareTempFile start");
        Date skssqq = DateUtils.stringToDate((String)startdate);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        if (orgid == null) {
            LOGGER.error("orgid is null");
            throw new KDBizException("Required parameters are missing\uff01orgid");
        }
        try {
            QFilter convertQfilter = this.convertQfilter(nsrxxfilter);
            String response = this.doCreateFile(orgid, skssqq, skssqz, templateType, convertQfilter);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ArchiveServiceImpl createDeclareTempFile result:", (Object)response);
            }
            LOGGER.info("ArchiveServiceImpl createDeclareTempFile end");
            return response;
        }
        catch (Throwable e) {
            LOGGER.error("ArchiveServiceImplError", e);
            throw e;
        }
    }

    private String doCreateFile(Long orgid, Date startdate, Date enddate, String templateType, QFilter nsrxxfilter) {
        QFilter defaultQfilter;
        ArrayList result = new ArrayList();
        QFilter tansferQFilter = new QFilter("org", "=", (Object)orgid).and("skssqq", ">=", (Object)startdate).and("skssqz", "<=", (Object)enddate).and("type", "=", (Object)templateType);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,skssqq,skssqz,type,org,templateid,org.name,org.number,sbrq,billno", (QFilter[])new QFilter[]{tansferQFilter, defaultQfilter = new QFilter("declarestatus", "=", (Object)"declared").and(ARCHIVESTATUS, "in", Arrays.asList(ARCHIVE_STATUS_WGD, "")), nsrxxfilter});
        if (EmptyCheckUtils.isNotEmpty((Object)collection)) {
            DynamicObject bdTaxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode,taxpayer", (QFilter[])new QFilter("org", "=", (Object)orgid).toArray());
            String unifiedsocialcode = bdTaxOrg != null ? bdTaxOrg.getString("unifiedsocialcode") : "";
            String taxpayer = bdTaxOrg != null ? bdTaxOrg.getString("taxpayer") : "";
            HashMap<String, Boolean> isNewTemplateMap = new HashMap<String, Boolean>();
            for (DynamicObject nsrxx : collection) {
                String type = nsrxx.getString("type");
                QFilter qFilter = new QFilter("type", "=", (Object)type);
                Boolean isNewTemplate = isNewTemplateMap.containsKey(type) ? (Boolean)isNewTemplateMap.get(type) : Boolean.valueOf(QueryServiceHelper.exists((String)"bdtaxr_template_main", (QFilter[])new QFilter[]{qFilter}));
                isNewTemplateMap.put(type, isNewTemplate);
                String templateid = nsrxx.getString("templateid");
                String org = nsrxx.getString("org");
                Date skssqq = nsrxx.getDate("skssqq");
                Date skssqz = nsrxx.getDate("skssqz");
                String pk = nsrxx.getString("id");
                String orgName = nsrxx.getString("org.name");
                Date declaredate = nsrxx.getDate("sbrq");
                String billno = nsrxx.getString("billno");
                DynamicObject template = null;
                if (StringUtils.isNotEmpty((CharSequence)templateid)) {
                    DynamicObject dynamicObject = template = isNewTemplate != false ? TemplateUtils.getTemplateObjectById((String)type, (String)templateid) : TemplateUtilsOld.getTemplateObjectById((String)type, (String)templateid);
                }
                if (template == null && org != null) {
                    DynamicObject dynamicObject = template = isNewTemplate != false ? TemplateUtils.getTemplateObjectByConfig((String)type, (String)org, (Date)skssqq, (Date)skssqq) : TemplateUtilsOld.getTemplateObjectByConfig((String)type, (String)org, (Date)skssqq, (Date)skssqq);
                }
                if (template == null) {
                    LOGGER.error(String.format("can't find template object,sbbid:%s", pk));
                    continue;
                }
                Map valMap = isNewTemplate != false ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.queryData((Long)template.getLong("id"), (String)pk, (String)"_") : TemplateShowUtils.queryData((String)type, (String)pk, (String)"_");
                try {
                    InputStream in = isNewTemplate != false ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, (Map)valMap) : TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, (Map)valMap);
                    Throwable throwable = null;
                    try {
                        String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(type, type) + "_" + orgName + "_" + DateUtils.format((Date)skssqq) + "_" + DateUtils.format((Date)skssqz) + ".xlsx";
                        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 7200);
                        PermissionUtils.putTempFilePermissionCache((String)urls, (String)"bdtaxr", (String)"tcvat_nsrxx", (String)"4730fc9f000004ae");
                        HashMap<String, Object> map = new HashMap<String, Object>(8);
                        map.put("id", Long.parseLong(pk));
                        map.put("billno", billno);
                        map.put("url", urls);
                        map.put("filename", fileName);
                        map.put("startdate", DateUtils.format((Date)skssqq));
                        map.put("enddate", DateUtils.format((Date)skssqz));
                        map.put("templatetype", type);
                        map.put("orgid", Long.parseLong(org));
                        map.put("period", declaredate == null ? "" : DateUtils.format((Date)declaredate, (String)"yyyy-MM"));
                        map.put("templatetypename", TemplateTypeConstant.getNsrtypemap().getOrDefault(type, type));
                        map.put("taxpayername", taxpayer);
                        map.put("taxnumber", unifiedsocialcode);
                        map.put("taxpayercode", nsrxx.getString("org.number"));
                        String taxcode = this.getTaxCode(type);
                        map.put("taxcode", taxcode);
                        String taxname = this.getTaxName(taxcode);
                        map.put("taxname", taxname);
                        result.add(map);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format("sbbid:%s", pk), (Throwable)e);
                }
            }
        }
        return SerializationUtils.toJsonString(result);
    }

    private String getTaxName(String taxcode) {
        MultiLangEnumBridge multiLangEnumBridge;
        if (taxcode != null && (multiLangEnumBridge = DeclareTaxType.nssbMatchBaseName((String)taxcode)) != null) {
            return multiLangEnumBridge.getDescription();
        }
        return "";
    }

    private String getTaxCode(String type) {
        Map typeMap = TemplateTypeConstant.getTypeMap();
        for (Map.Entry entry : typeMap.entrySet()) {
            Object[] value = (String[])entry.getValue();
            ArrayList strings = Lists.newArrayList((Object[])value);
            if (!strings.contains(type)) continue;
            return (String)entry.getKey();
        }
        return "";
    }

    private QFilter convertQfilter(String nsrxxfilter) {
        if (StringUtil.isNotEmpty((CharSequence)nsrxxfilter)) {
            return FilterBuilderUtils.getCustomQFilter((String)"tcvat_nsrxx", (String)nsrxxfilter);
        }
        return new QFilter("id", "!=", (Object)0L);
    }
}

