/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.datadetails;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class DataSourceDetailsService {
    public void validate(Map<String, Object> params) {
        boolean exists;
        Object viewdetails = params.get("view_details");
        if (!Boolean.TRUE.equals(viewdetails)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u53d6\u6570\u91d1\u989d\u6682\u4e0d\u652f\u6301\u6570\u636e\u4e0b\u94bb\u3002", (String)"DataSourceDetailsService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String datasourceid = (String)params.get("tableid");
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entityname,subname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(datasourceid))});
        if (object != null) {
            String entityname = object.getString("entityname");
            if (!this.validateIfSupport(entityname)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u7684\u6570\u636e\u6e90\u5173\u8054\u591a\u4e2a\u8868\u7ed3\u6784\uff0c\u4e0d\u652f\u6301\u6570\u636e\u4e0b\u94bb\u3002", (String)"DataSourceDetailsService_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            if ("tpo_declare_main_tsd".equals(entityname)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u6e90\u6682\u4e0d\u652f\u6301\u4e0b\u94bb\u3002", (String)"DataSourceDetailsService_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            String subname = object.getString("subname");
            if (EmptyCheckUtils.isNotEmpty((Object)subname)) {
                boolean subnameIsEntity = QueryServiceHelper.exists((String)"bos_entitymeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)subname)});
                if (!Objects.equals(entityname, subname) && subnameIsEntity) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u7684\u6570\u636e\u6e90\u5173\u8054\u591a\u4e2a\u8868\u7ed3\u6784\uff0c\u4e0d\u652f\u6301\u6570\u636e\u4e0b\u94bb\u3002", (String)"DataSourceDetailsService_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            }
        }
        if (!(exists = QueryServiceHelper.exists((String)"tctb_custom_datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(datasourceid)), new QFilter("entryentity.drilldown", "=", (Object)Boolean.TRUE)}))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u7684\u6570\u636e\u6e90\u672a\u914d\u7f6e\u4e0b\u94bb\u5c55\u793a\u5b57\u6bb5\uff0c\u5982\u9700\u4e0b\u94bb\u5c55\u793a\u660e\u7ec6\u8bf7\u5728\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u4e2d\u8fdb\u884c\u914d\u7f6e\u3002", (String)"DataSourceDetailsService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    public DynamicObjectCollection queryCustomSourceById(Long datasourceid) {
        return QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,entityname,subname,ischild,entryentity.fieldsubname as fieldsubname,entryentity.id as entryid,entryentity.fieldname as fieldname,entryentity.bizsubname as bizsubname,entryentity.drilldown as drilldown", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)datasourceid), new QFilter("entryentity.drilldown", "=", (Object)Boolean.TRUE)}, (String)"entryentity.seq");
    }

    public QFilter parseCondition(String conditionjson, String entryName, long orgId) {
        QFilter conditionFilters = null;
        if (StringUtils.isNotBlank((CharSequence)conditionjson)) {
            if ((entryName.equals("gl_voucher") || entryName.equals("gl_balance")) && conditionjson.contains("assgrp")) {
                conditionjson = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setAssgrpConditionJson", (Object[])new Object[]{conditionjson});
            }
            if ((conditionFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName)) != null) {
                if (entryName.equals("sim_vatinvoice") && conditionjson.contains("taxrate")) {
                    conditionFilters = DataSourceDetailsService.dealRate(conditionFilters);
                } else if ("gl_balance".equals(entryName) || "gl_voucher".equals(entryName)) {
                    Map fiBdAccounts = GetGLBalanceCommonUtil.create((Long)orgId);
                    conditionFilters = GetGLBalanceCommonUtil.parseQFilter((Long)orgId, (String)entryName, (QFilter)conditionFilters, (Map)fiBdAccounts);
                }
            }
        }
        return conditionFilters;
    }

    private static QFilter dealRate(QFilter conditionFilters) {
        String property = conditionFilters.getProperty();
        Object value = conditionFilters.getValue();
        String cp = conditionFilters.getCP();
        if ("items.taxrate".equals(property) || "taxrate".equals(property)) {
            String[] newValue;
            if (value instanceof String) {
                if (((String)value).matches("^-?\\d+(\\.\\d+)?$")) {
                    List<String> rateScaleList = DataSourceDetailsService.getRateScaleList(Collections.singletonList((String)value));
                    conditionFilters.__setValue(rateScaleList);
                    if (Objects.equals(cp, "=")) {
                        conditionFilters.__setCP("in");
                    } else if (Objects.equals(cp, "!=") || Objects.equals(cp, "<>")) {
                        conditionFilters.__setCP("not in");
                    }
                }
            } else if (value instanceof List) {
                List list = (List)value;
                conditionFilters.__setValue(DataSourceDetailsService.getRateScaleList(list));
            } else if (value instanceof String[] && (newValue = (String[])value) != null && newValue.length > 0) {
                ArrayList<String> list = new ArrayList<String>(8);
                for (int i = 0; i < newValue.length; ++i) {
                    list.add(newValue[i]);
                }
                conditionFilters.__setValue(DataSourceDetailsService.getRateScaleList(list));
            }
        }
        List nests = conditionFilters.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            DataSourceDetailsService.dealRate(nest.getFilter());
        }
        return conditionFilters;
    }

    private static List<String> getRateScaleList(List<String> rates) {
        ArrayList<String> result = new ArrayList<String>(10);
        for (String rateStr : rates) {
            if (null == rateStr || !rateStr.matches("^-?\\d+(\\.\\d+)?$")) continue;
            BigDecimal rate = BigDecimalUtil.toBigDecimal((Object)rateStr);
            rate = rate.stripTrailingZeros();
            for (int i = rate.scale(); i <= 3; ++i) {
                result.add(rate.setScale(i).toString());
            }
        }
        return result;
    }

    public List<String> getDataSourceFileds(Long datasourceid) {
        DynamicObjectCollection dataSource = this.queryCustomSourceById(datasourceid);
        ArrayList<String> list = new ArrayList<String>(10);
        for (DynamicObject object : dataSource) {
            DynamicProperty property;
            String fieldName = object.getString("fieldname");
            String entityname = object.getString("entityname");
            MainEntityType det = MetadataServiceHelper.getDataEntityType((String)entityname);
            if ("gl_balance".equals(entityname) && "period.begindate".equals(fieldName)) {
                fieldName = "period";
            }
            if ((property = (DynamicProperty)det.getAllFields().get(fieldName)) != null && EmptyCheckUtils.isEmpty((Object)property.getAlias())) continue;
            if (property instanceof BasedataProp) {
                fieldName = fieldName + "." + ((BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((BasedataProp)property).getBaseEntityId())).getNameProperty();
            }
            list.add(fieldName);
        }
        return list;
    }

    private boolean validateIfSupport(String entityName) {
        HashSet<String> notSupportSet = new HashSet<String>(8);
        notSupportSet.add("tdm_finance_hblrbfilter");
        notSupportSet.add("tdm_finance_hbzcfzbfilter");
        notSupportSet.add("tdm_finance_lrbfilter");
        notSupportSet.add("tdm_finance_syzqybdfilter");
        notSupportSet.add("tdm_finance_xjllbfilter");
        notSupportSet.add("tdm_finance_zcfzbfilter");
        return !notSupportSet.contains(entityName);
    }
}

