/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taxdeclare.update.DeclareMainTableSyncBusiness;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DeclareMainChangeEventService
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(DeclareMainChangeEventService.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("DeclareMainChangeEventService,event id:{},number:{}", (Object)evt.getEventNumber(), (Object)evt.getEventId());
        try {
            List paramList = (List)SerializationUtils.fromJsonString((String)evt.getSource(), List.class);
            if (CollectionUtils.isEmpty((Collection)paramList)) {
                logger.error("DeclareMainChangeEventService paramList isEmpty.");
                return evt.getEventId();
            }
            if (paramList != null && paramList.size() > 0) {
                Map params = (Map)paramList.get(0);
                if (ObjectUtils.isEmpty((Object)params)) {
                    logger.error("DeclareMainChangeEventService params isEmpty.");
                    return evt.getEventId();
                }
                List ids = (List)params.get("ids");
                if (CollectionUtils.isEmpty((Collection)ids)) {
                    logger.error("DeclareMainChangeEventService ids isEmpty.");
                    return evt.getEventId();
                }
                DeclareOperationEnum operate = DeclareOperationEnum.getEnumByKey((String)((String)params.get("operate")));
                ModelVersionEnum version = ModelVersionEnum.getEnumByKey((String)((String)params.get("version")));
                this.doBusiness(ids, operate, version);
            }
        }
        catch (Exception e) {
            logger.error("DeclareMainChangeEventService error." + e.getMessage(), (Throwable)e);
        }
        return evt.getEventId();
    }

    protected void doBusiness(List ids, DeclareOperationEnum operate, ModelVersionEnum version) {
        logger.info("DeclareMainChangeEventService.doBusiness  ids:{},operate:{},version:{}", new Object[]{ids, operate, version});
        ArrayList model2Ids = Lists.newArrayList((Iterable)ids);
        if (version != null && ModelVersionEnum.MODEL2.getVersion().equals(version.getVersion())) {
            if (operate != null && DeclareOperationEnum.DELETE.getOperation().equals(operate.getOperation())) {
                DeclareMainTableSyncBusiness.deleteModel3Data(model2Ids);
            } else {
                DeclareMainTableSyncBusiness.saveModel3Data(model2Ids);
            }
        }
    }
}

