/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.enums.RuleConfigEnum;
import kd.taxc.bdtaxr.common.enums.RuleFilterEnum;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class FilterService {
    private static final Log logger = LogFactory.getLog(FilterService.class);
    private static String YEAR_FIELD_DATE = "tccit_getreduce_acc";

    public void setQueryDateByAdvanceConf(RuleTimeFilterDto ruleTimeFilterDto) {
        String advancedconf = ruleTimeFilterDto.getAdvancedconf();
        Date startdate = ruleTimeFilterDto.getStartdate();
        Date enddate = ruleTimeFilterDto.getEnddate();
        if (advancedconf.equals(RuleConfigEnum.CUMULATIVE.getRuleConfigCode())) {
            startdate = DateUtils.getFirstDateOfYear((Date)startdate);
        }
        if (advancedconf.equals(RuleConfigEnum.TOBEGIN.getRuleConfigCode())) {
            startdate = DateUtils.getFirstDateOfMonth((Date)startdate);
            enddate = DateUtils.getLastDateOfMonth((Date)startdate);
        }
        if (advancedconf.equals(RuleConfigEnum.TOEND.getRuleConfigCode())) {
            startdate = DateUtils.getFirstDateOfMonth((Date)enddate);
            enddate = DateUtils.getLastDateOfMonth((Date)enddate);
        }
        if (advancedconf.equals(RuleConfigEnum.SQQMS.getRuleConfigCode())) {
            startdate = DateUtils.addMonth((Date)startdate, (int)-1);
            enddate = DateUtils.getLastDateOfMonth((Date)startdate);
        }
        ruleTimeFilterDto.setStartdate(startdate);
        ruleTimeFilterDto.setEnddate(enddate);
    }

    public void setTimeRule(RuleTimeFilterDto ruleTimeFilterDto) {
        Date startdate = ruleTimeFilterDto.getStartdate();
        Date enddate = ruleTimeFilterDto.getEnddate();
        Map fieldMap = ruleTimeFilterDto.getFieldMap();
        String entryName = ruleTimeFilterDto.getEntryName();
        String dataField = (String)fieldMap.get("datastate");
        List filterList = ruleTimeFilterDto.getFilterList();
        logger.info("\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}#", (Object)DateUtils.format((Date)startdate), (Object)DateUtils.format((Date)enddate));
        if (StringUtil.isNotEmpty((CharSequence)dataField)) {
            QFilter startFilter = new QFilter(dataField, ">=", (Object)DateUtils.getDayFirst((Date)startdate));
            QFilter endFilter = new QFilter(dataField, "<=", (Object)DateUtils.getDayLast((Date)enddate));
            filterList.add(startFilter);
            filterList.add(endFilter);
            return;
        }
        this.setYearMonthRule(startdate, enddate, fieldMap, entryName, filterList);
    }

    private void setYearMonthRule(Date startdate, Date enddate, Map<String, String> fieldMap, String entryName, List<QFilter> filterList) {
        String yearField = fieldMap.get("yearstate");
        String monthField = fieldMap.get("monthstate");
        int startYear = DateUtils.getYearOfDate((Date)startdate);
        int endYear = DateUtils.getYearOfDate((Date)enddate);
        int startMonth = DateUtils.getMonthOfDate((Date)startdate);
        int endMonth = DateUtils.getMonthOfDate((Date)enddate);
        boolean hasYear = StringUtil.isNotEmpty((CharSequence)yearField);
        boolean hasMonth = StringUtil.isNotEmpty((CharSequence)monthField);
        if (hasYear && hasMonth) {
            QFilter finalFilter = null;
            for (int year = startYear; year <= endYear; ++year) {
                QFilter qFilter = null;
                if (YEAR_FIELD_DATE.equals(entryName)) {
                    QFilter q1 = new QFilter(yearField, ">=", (Object)DateUtils.getFirstDateOfYear((Date)startdate));
                    QFilter q2 = new QFilter(yearField, "<=", (Object)DateUtils.getLastDateOfYear1((Date)startdate));
                    qFilter = q1.and(q2);
                } else {
                    qFilter = new QFilter(yearField, "=", (Object)String.valueOf(year));
                }
                List<String> diffMonth = this.getDiffMonth(year == startYear ? startMonth : 1, year == endYear ? endMonth : 12);
                qFilter.and(new QFilter(monthField, "in", diffMonth));
                if (finalFilter == null) {
                    finalFilter = qFilter;
                    continue;
                }
                finalFilter.or(qFilter);
            }
            filterList.add(finalFilter);
        } else if (hasYear) {
            QFilter qFilter = null;
            if (YEAR_FIELD_DATE.equals(entryName)) {
                QFilter q1 = new QFilter(yearField, ">=", (Object)DateUtils.getFirstDateOfYear((Date)startdate));
                QFilter q2 = new QFilter(yearField, "<=", (Object)DateUtils.getLastDateOfYear1((Date)startdate));
                qFilter = q1.and(q2);
            } else {
                qFilter = new QFilter(yearField, "=", (Object)String.valueOf(startYear));
            }
            for (int year = startYear + 1; year <= endYear; ++year) {
                qFilter.or(new QFilter(yearField, "=", (Object)String.valueOf(year)));
            }
            filterList.add(qFilter);
        } else if (hasMonth) {
            List<String> diffMonth = this.getDiffMonth(startMonth, endMonth);
            QFilter qFilter = new QFilter(monthField, "in", diffMonth);
            filterList.add(qFilter);
        }
    }

    private List<String> getDiffMonth(int lessMonth, int largeMonth) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = lessMonth; i <= largeMonth; ++i) {
            if (i < 10) {
                strings.add("" + i);
                strings.add("0" + i);
            }
            strings.add(String.valueOf(i));
        }
        return strings;
    }

    public void setGLQFeilter(RuleTimeFilterDto ruleTimeFilterDto) {
        boolean isBeginOrEnd = GetGLBalanceCommonUtil.conditionCheck((String)ruleTimeFilterDto.getEntryName(), (String)ruleTimeFilterDto.getAmountField());
        if (isBeginOrEnd) {
            String advancedconf = ruleTimeFilterDto.getAdvancedconf();
            if (StringUtil.equals((CharSequence)RuleConfigEnum.TOBEGIN.getRuleConfigCode(), (CharSequence)advancedconf)) {
                this.getBeginAccountingByDate(ruleTimeFilterDto);
            }
            if (StringUtil.equals((CharSequence)RuleConfigEnum.TOEND.getRuleConfigCode(), (CharSequence)advancedconf)) {
                this.getEndAccountingByDate(ruleTimeFilterDto);
            }
        }
    }

    private void getBeginAccountingByDate(RuleTimeFilterDto ruleTimeFilterDto) {
        List filterList = ruleTimeFilterDto.getFilterList();
        Date queryDate = DateUtils.getLastDateOfMonth((Date)ruleTimeFilterDto.getStartdate());
        for (QFilter filter : filterList) {
            if ("period.begindate".equals(filter.getProperty()) && "<=".equals(filter.getCP())) {
                filter.__setProperty("endperiod");
                filter.__setCP("in");
                filter.__setValue(this.getBdPeriod(new QFilter("begindate", ">", (Object)queryDate)));
                filter.or("endperiod.begindate", "is null", null);
            }
            if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                filter.__setProperty("period");
                filter.__setCP("in");
                filter.__setValue(this.getBdPeriod(new QFilter("enddate", "=", (Object)queryDate)));
            }
            if (!"period".equals(filter.getProperty()) || !"in".equals(filter.getCP())) continue;
            filter.__setProperty("period");
            filter.__setCP("in");
            filter.__setValue(this.getBdPeriod(new QFilter("enddate", "<", (Object)queryDate)));
        }
    }

    private void getEndAccountingByDate(RuleTimeFilterDto ruleTimeFilterDto) {
        List filterList = ruleTimeFilterDto.getFilterList();
        Date queryDate = DateUtils.getLastDateOfMonth((Date)ruleTimeFilterDto.getEnddate());
        for (QFilter filter : filterList) {
            if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                filter.__setProperty("endperiod");
                filter.__setCP("in");
                filter.__setValue(this.getBdPeriod(new QFilter("begindate", ">", (Object)queryDate)));
                filter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(filter.getProperty()) || !"<=".equals(filter.getCP())) continue;
            filter.__setProperty("period");
            filter.__setCP("in");
            filter.__setValue(this.getBdPeriod(new QFilter("enddate", "<=", (Object)queryDate)));
        }
    }

    private List<Long> getBdPeriod(QFilter qFilter) {
        QFilter q1 = new QFilter("periodnumber", "!=", (Object)13);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{q1, qFilter});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new ArrayList<Long>();
        }
        return query.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    public void setQysdsRuleFilter(RuleTimeFilterDto ruleTimeFilterDto, List<QFilter> filterList, String itemnumber) {
        List<QFilter> qFilters;
        Map<String, Map<String, List<QFilter>>> ruleFilterMap = FilterService.getRuleFilterMap();
        if (ruleFilterMap.get(ruleTimeFilterDto.getEntryName()) != null && (qFilters = ruleFilterMap.get(ruleTimeFilterDto.getEntryName()).get(itemnumber)) != null) {
            filterList.addAll(qFilters);
        }
    }

    private static Map<String, Map<String, List<QFilter>>> getRuleFilterMap() {
        RuleFilterEnum[] values;
        HashMap<String, Map<String, List<QFilter>>> ruleFilterMap = new HashMap<String, Map<String, List<QFilter>>>();
        for (RuleFilterEnum rfe : values = RuleFilterEnum.values()) {
            Map filterMap = ruleFilterMap.computeIfAbsent(rfe.getEntryName(), k -> new HashMap());
            List fel = rfe.getFilterEnumList();
            for (RuleFilterEnum.FilterEnum fe : fel) {
                String[] ins;
                String itemNumber = fe.getItemNumber();
                for (String in : ins = itemNumber.split(",")) {
                    List qFilters = filterMap.computeIfAbsent(in, k -> new ArrayList());
                    qFilters.add(fe.getFilter());
                }
            }
        }
        return ruleFilterMap;
    }
}

