/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.formula.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.formula.FormulaService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.formula.context.CheckFormulaContent;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.context.CheckFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.CellFormatModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.FormulaCalVo;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;

public class FormulaServiceImpl
implements FormulaService {
    private static Log logger = LogFactory.getLog(FormulaService.class);
    private static final String CACHE_INIT_CAL = "cache_init_cal";
    private Map<String, String> errorInfo = new HashMap<String, String>(256);

    public Map<String, String> getErrorInfo() {
        return this.errorInfo;
    }

    @Override
    public Map<String, String> initCal(FormulaCalVo formulaCalVo) {
        logger.info("\u5f00\u59cb\u8fdb\u884cinitCal\u8ba1\u7b97.....jsonStr=" + JSONObject.toJSONString((Object)formulaCalVo));
        Map<String, String> resultMap = new HashMap<String, String>();
        long time = System.currentTimeMillis();
        if (null == formulaCalVo || StringUtils.isBlank((Object)formulaCalVo.getTemplateId())) {
            return resultMap;
        }
        resultMap = this.initCalExec(formulaCalVo, resultMap);
        logger.info("\u7ed3\u675finitCal\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return resultMap;
    }

    private Map<String, String> initCalExec(FormulaCalVo formulaCalVo, Map<String, String> map) {
        logger.info("\u5f00\u59cb\u8fdb\u884cinitCalExec\u8ba1\u7b97.....");
        Map<String, String> resultMap = new HashMap<String, String>();
        long time = System.currentTimeMillis();
        if (null == formulaCalVo || StringUtils.isBlank((Object)formulaCalVo.getTemplateId())) {
            return resultMap;
        }
        FormulaCollectionVo formulaVo = formulaCalVo.getFormulas();
        if (formulaVo == null) {
            formulaVo = CacheFormulaService.getAllFormulasVo((Long)formulaCalVo.getTemplateId(), (List)formulaCalVo.getDynRowList());
        }
        CalFormulaContext calFormulaContext = new CalFormulaContext();
        Map formulaVoMap = formulaVo.getFormulas();
        Map ruleFormulasMap = formulaVo.getRformulas();
        Map mFormulasMap = formulaVo.getMformulas();
        ConcurrentHashMap<String, String> dataMap = new ConcurrentHashMap<String, String>();
        if (map != null) {
            Map qformulasMap = formulaVo.getQformulas();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!qformulasMap.containsKey(entry.getKey())) continue;
                dataMap.put(entry.getKey(), entry.getValue());
            }
        }
        dataMap.putAll(formulaCalVo.getDataMap());
        resultMap = calFormulaContext.initCal(formulaCalVo, dataMap, formulaVoMap, ruleFormulasMap, mFormulasMap);
        this.errorInfo.putAll(calFormulaContext.getErrorInfo());
        logger.info("\u7ed3\u675finitCalExec\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return resultMap;
    }

    @Override
    public Map<String, String> cal(FormulaCalVo formulaCalVo) {
        logger.info("\u5f00\u59cb\u8fdb\u884ccal\u8ba1\u7b97(\u542b\u7ea7\u8054).....");
        long time = System.currentTimeMillis();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (null == formulaCalVo || StringUtils.isBlank((CharSequence)formulaCalVo.getCellKey()) && CollectionUtils.isEmpty((Collection)formulaCalVo.getCellKeyList()) || StringUtils.isBlank((Object)formulaCalVo.getTemplateId())) {
            return resultMap;
        }
        Map<String, String> map = this.calExec(formulaCalVo);
        resultMap.putAll(map);
        logger.info("\u7ed3\u675fcal\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return resultMap;
    }

    private Map<String, String> calExec(FormulaCalVo formulaCalVo) {
        logger.info("\u5f00\u59cb\u8fdb\u884ccalExec\u8ba1\u7b97(\u542b\u7ea7\u8054).....");
        long time = System.currentTimeMillis();
        HashMap<String, String> resultMap = new HashMap();
        HashedMap dataMap = new HashedMap();
        if (formulaCalVo.getDataMap() != null) {
            dataMap.putAll(formulaCalVo.getDataMap());
        }
        long time1 = System.currentTimeMillis();
        Map allFormulas = formulaCalVo.getFormulas() == null ? CacheFormulaService.getAllFormulas((Long)formulaCalVo.getTemplateId(), (List)formulaCalVo.getDynRowList()) : CacheFormulaService.getAllFormulas((Long)formulaCalVo.getTemplateId(), (List)formulaCalVo.getDynRowList(), (Map)formulaCalVo.getFormulas().getDbCalFormulas());
        logger.info("logflag \u83b7\u53d6\u5e76\u89e3\u6790\u6240\u6709\u516c\u5f0f\u65f6\u95f4:{}ms", (Object)(System.currentTimeMillis() - time1));
        Map formulaVoMap = (Map)allFormulas.get("all");
        Map qformulasMap = (Map)allFormulas.get("Q");
        Map cformulasMap = (Map)allFormulas.get("C");
        Map rformulaMap = (Map)allFormulas.get("R");
        ArrayList<String> cellKeyList = formulaCalVo.getCellKeyList();
        if (CollectionUtils.isEmpty((Collection)cellKeyList)) {
            cellKeyList = new ArrayList<String>();
            cellKeyList.add(formulaCalVo.getCellKey());
        }
        for (Map.Entry map : cformulasMap.entrySet()) {
            if (!map.getKey().toString().endsWith("rownumber") && !map.getKey().toString().endsWith("seqno")) continue;
            dataMap.put(map.getKey().toString(), map.getValue().toString());
        }
        long time2 = System.currentTimeMillis();
        resultMap = new CalFormulaContext().cal((Map)dataMap, formulaCalVo, formulaVoMap, qformulasMap, rformulaMap, cellKeyList.toArray(new String[cellKeyList.size()]));
        logger.info("logflag \u516c\u5f0f\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time2));
        logger.info("logflag \u7ed3\u675fcalExec\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return resultMap;
    }

    @Override
    public List<Map<String, String>> checkFormula(String formulaCalVoStr) {
        if (StringUtils.isBlank((CharSequence)formulaCalVoStr)) {
            return new ArrayList<Map<String, String>>();
        }
        FormulaCalVo formulaCalVo = (FormulaCalVo)JsonUtil.fromJson((String)formulaCalVoStr, FormulaCalVo.class);
        Map dataMap = CacheUtils.getDataResult((Long)formulaCalVo.getTemplateId());
        List formulaVoList = CacheFormulaService.queryCheckFormulas((Long)formulaCalVo.getTemplateId());
        return new CheckFormulaContext().cal(dataMap, formulaCalVo.getParamMap(), formulaVoList);
    }

    @Override
    public List<Map<String, String>> checkFormula(String requestModelStr, Map<String, String> data, Map<String, String> param) {
        return new CheckFormulaContent().cal(data, param, CacheFormulaService.queryCheckFormulas((DeclareRequestModel)((DeclareRequestModel)JsonUtil.fromJson((String)requestModelStr, DeclareRequestModel.class))));
    }

    @Override
    public List<Map<String, String>> checkFormulas(DeclareRequestModel requestModel, Map<String, String> data, Map<String, String> param) {
        long time = System.currentTimeMillis();
        List list = new CheckFormulaContext().cal(data, param, CacheFormulaService.queryCheckFormulas((DeclareRequestModel)requestModel));
        logger.info("\u98ce\u9669\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return list;
    }

    @Override
    public List<Map<String, String>> checkFormulasNew(DeclareRequestModel requestModel, Map<String, String> data, Map<String, String> param, List<DynamicRowModel> dynamicRowList) {
        long time = System.currentTimeMillis();
        Map<String, EntityField> typeMap = TaxDeclarePluginService.getAllFieldTypeToShow(requestModel.getMetaDataMap());
        HashMap<String, EntityField> addedMetaTypeMap = new HashMap<String, EntityField>();
        for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
            String key = entry.getKey().toString();
            DynamicRowModel dyn = DynamicRowService.matchDyn(dynamicRowList, (String)key);
            if (dyn == null || dyn.getRowList() == null || dyn.getRowList().size() <= 1) continue;
            for (int i = 1; i < dyn.getRowList().size(); ++i) {
                String newKey = DynamicRowService.getNewKey((String)key, (long)(i + 1));
                addedMetaTypeMap.put(newKey, entry.getValue());
            }
        }
        if (!addedMetaTypeMap.isEmpty()) {
            typeMap.putAll(addedMetaTypeMap);
        }
        List list = new CheckFormulaContext().cal(data, param, CacheFormulaService.queryCheckFormulas((DeclareRequestModel)requestModel, dynamicRowList), typeMap);
        logger.info("logflag \u6821\u9a8c\u516c\u5f0f\u8ba1\u7b97\u65f6\u95f4:{}ms", (Object)(System.currentTimeMillis() - time));
        return list;
    }

    @Override
    public List<Map<String, String>> multiCheckFormulas(DeclareRequestModel requestModel, Map<String, String> data, List<FormulaVo> formula) {
        long time = System.currentTimeMillis();
        List list = new CheckFormulaContext().cal(data, requestModel.getBusinessMap(), formula);
        logger.info("\u98ce\u9669\u8ba1\u7b97\u65f6\u95f4:{}ms", (Object)(System.currentTimeMillis() - time));
        return list;
    }

    @Override
    public String getCellFormulas(Long templateId) {
        Map result = CacheFormulaService.getCellFormulas((Long)templateId);
        return JsonUtil.toJson((Object)result);
    }

    @Override
    public boolean deleteFormulaByKeyAndType(String formulaType, String formulaKey, Long templateId) {
        if (StringUtil.isEmpty((CharSequence)formulaType) || StringUtil.isEmpty((CharSequence)formulaKey) || templateId == null) {
            return false;
        }
        return QueryFormulaService.deleteFormulaByKeyAndType((String)formulaType, (String)formulaKey, (Long)templateId);
    }

    private Map<String, CellFormatModel> getAllCellFormat(Map<String, String> metadataMap) {
        Map entityFieldMap = TemplateUtils.getAllEntity(metadataMap);
        HashMap<String, CellFormatModel> allCellFormat = new HashMap<String, CellFormatModel>(entityFieldMap.size());
        entityFieldMap.entrySet().stream().forEach(v -> {
            CellFormatModel formatModel = new CellFormatModel();
            if (EmptyCheckUtils.isNotEmpty(v.getValue())) {
                formatModel.setFieldType(((EntityField)v.getValue()).getFieldType());
                formatModel.setMaxLength(((EntityField)v.getValue()).getMaxLength());
                formatModel.setPrecision(((EntityField)v.getValue()).getPrecision());
                formatModel.setScale(((EntityField)v.getValue()).getScale());
                allCellFormat.put((String)v.getKey(), formatModel);
            }
        });
        return allCellFormat;
    }

    @Override
    public String queryDBFormulaByFormulaKey(String formulaType, String formulaKey, String templateId) {
        List formulaVoList = QueryFormulaService.queryDBFormulaByFormulaKey((String)"1", (String)formulaKey, (String)templateId);
        ArrayList<FormulaVo> result = new ArrayList<FormulaVo>(4);
        for (FormulaVo formulaVo1Src : formulaVoList) {
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setCellType(formulaVo1Src.getCellType());
            formulaVo.setFormula(formulaVo1Src.getFormula());
            formulaVo.setContent(formulaVo1Src.getContent());
            formulaVo.setDescribe(formulaVo1Src.getDescribe());
            formulaVo.setFormulaName(formulaVo1Src.getFormulaName());
            formulaVo.setFormulaKey(formulaVo1Src.getFormulaKey());
            formulaVo.setTitle(formulaVo1Src.getTitle());
            formulaVo.setName(formulaVo1Src.getName());
            formulaVo.setFormulaType(formulaVo1Src.getFormulaType());
            result.add(formulaVo);
        }
        return JSONObject.toJSONString(result);
    }

    @Override
    public String queryDBCellConfig(String type, String startData, String endData, String templateid) {
        List result = QueryFormulaService.queryDBCellConfig((String)type, (String)startData, (String)endData, (String)templateid);
        return JsonUtil.toJson((Object)result);
    }
}

