/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.mq.consumer;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.mq.consumer.DraftMQMessage;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.vo.DraftRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class DraftConsumer
implements MessageConsumer {
    public static final Log logger = LogFactory.getLog(DraftConsumer.class);
    public static final String SERVICE_NAME = "DraftService";
    public static final String METHOD_NAME = "generate";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            String str = (String)message;
            logger.info("DraftConsumer message:" + str);
            DraftMQMessage draftMQMessage = (DraftMQMessage)SerializationUtils.fromJsonString((String)str, DraftMQMessage.class);
            String category = draftMQMessage.getCategory();
            DraftCateGory cateGory = DraftCateGory.valueOfCode((String)category);
            if (cateGory != null) {
                DraftRequest draftRequest = new DraftRequest();
                draftRequest.setCategory(category);
                draftRequest.setDataType("schedule");
                draftRequest.setOrgId(draftMQMessage.getOrgId());
                draftRequest.setExecuteTime(draftMQMessage.getExecuteTime());
                String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)cateGory.getAppId(), (String)SERVICE_NAME, (String)METHOD_NAME, (Object[])new Object[]{SerializationUtils.toJsonString((Object)draftRequest)});
                EngineResponse response = (EngineResponse)SerializationUtils.fromJsonString((String)result, EngineResponse.class);
                if (response.getSuccess().booleanValue()) {
                    acker.ack(messageId);
                } else {
                    acker.discard(messageId);
                }
            } else {
                acker.discard(messageId);
            }
        }
        catch (Throwable throwable) {
            logger.error("DraftConsumer execute error", throwable);
            acker.discard(messageId);
        }
    }
}

