/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.multidideclare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizDao;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportop.DeclareReportOpFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportop.service.DeclareReportOpService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.DeclareReportOpenFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.service.DeclareReportOpenService;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeEnum;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.multidimension.MultiDiConstant;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;

public class MultiDeclareBizBusiness {
    private static final Log logger = LogFactory.getLog(MultiDeclareBizBusiness.class);

    public static void doInvalid(DynamicObject obj, String causedesc, String entityNumber) {
        String appid;
        Long pkValue = obj.getLong("id");
        DynamicObject declares = MultiDeclareBizDao.queryMultiDeclareById(pkValue);
        String result = MultiDeclareBizBusiness.checkBeforeInvalid(declares);
        if (result != null) {
            throw new KDBizException(result);
        }
        Long hisSbbId = MultiDeclareBizBusiness.saveHisSbbInfo(declares, causedesc);
        declares.set("versiontype", (Object)"zcsb");
        declares.set("datatype", (Object)"1");
        SaveServiceHelper.update((DynamicObject)declares);
        OperationResult cancelapplyResult = OperationServiceHelper.executeOperate((String)"cancelapply", (String)entityNumber, (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
        logger.info("DeclareListInvalidOp\u4e2dcancelapply\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)SerializationUtils.toJsonString((Object)cancelapplyResult));
        if (!cancelapplyResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u5e9f\u7533\u62a5\u64cd\u4f5c\u5931\u8d25\u3002", (String)"MultiDeclareBizBusiness_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityNumber, (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
        logger.info("DeclareListInvalidOp\u4e2dunaudit\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)SerializationUtils.toJsonString((Object)unauditResult));
        if (!unauditResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u5e9f\u7533\u62a5\u64cd\u4f5c\u5931\u8d25\uff0c\u64a4\u9500\u672a\u6210\u529f\u3002", (String)"MultiDeclareBizBusiness_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String nsrtype = declares.getString("templatetype.id");
        DeclareReportOpService declareReportOpService = DeclareReportOpFactory.createHandler(nsrtype);
        if (declareReportOpService != null) {
            declareReportOpService.afterOperation("invalid", declares, hisSbbId);
        }
        OperatorDialogUtils.operateDialogByAppid((String)((appid = TemplateTypeEnum.getAppidByTemplate((String)nsrtype)) == null ? "bdtaxr" : appid), (String)entityNumber, (String)ResManager.loadKDString((String)"\u4f5c\u5e9f\u7533\u62a5", (String)"MultiDeclareBizBusiness_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u4f5c\u5e9f\u7533\u62a5\u64cd\u4f5c\u6210\u529f\u3002", (String)"MultiDeclareBizBusiness_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), declares.getString("billno")));
    }

    public static boolean isExistsPayRecord(BeginOperationTransactionArgs args) {
        QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)"0");
        QFilter sbbidfilter = new QFilter("sbbid", "=", (Object)String.valueOf(args.getDataEntities()[0].getLong("id")));
        QFilter paystatusfilter = new QFilter("paystatus", "=", (Object)"2");
        return QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidfilter, voucherFilter, paystatusfilter});
    }

    public static void doRectify(DynamicObject obj, String causedesc, String entityNumber) {
        Long pkValue = obj.getLong("id");
        DynamicObject declares = MultiDeclareBizDao.queryMultiDeclareById(pkValue);
        String checkZfInfo = MultiDeclareBizBusiness.checkBeforeRectify(declares);
        if (checkZfInfo != null) {
            throw new KDBizException(checkZfInfo);
        }
        Long hisSbbId = MultiDeclareBizBusiness.saveHisSbbInfo(declares, causedesc);
        declares.set("versiontype", (Object)"gzsb");
        declares.set("datatype", (Object)"1");
        declares.set("declarestatus", (Object)"editing");
        declares.set("paystatus", (Object)"unpaid");
        declares.set("payer", (Object)0L);
        declares.set("paydate", null);
        declares.set("declarer", (Object)0L);
        declares.set("sbrq", null);
        declares.set("declaremethod", null);
        declares.set("paytype", null);
        SaveServiceHelper.update((DynamicObject)declares);
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityNumber, (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
        logger.info("DeclareListRectifyOp\u4e2dunaudit\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)SerializationUtils.toJsonString((Object)unauditResult));
        if (!unauditResult.isSuccess()) {
            throw new KDBizException(StringUtil.isBlank((CharSequence)unauditResult.getMessage()) ? ResManager.loadKDString((String)"\u66f4\u6b63\u7533\u62a5\u64cd\u4f5c\u5931\u8d25\uff0c\u64a4\u9500\u672a\u6210\u529f\u3002", (String)"MultiDeclareBizBusiness_4", (String)"taxc-bdtaxr", (Object[])new Object[0]) : unauditResult.getMessage());
        }
        String nsrtype = declares.getString("templatetype.id");
        DeclareReportOpService declareReportOpService = DeclareReportOpFactory.createHandler(nsrtype);
        if (declareReportOpService != null) {
            declareReportOpService.afterOperation("rectify", declares, hisSbbId);
        }
        QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)"0");
        QFilter sbbidfilter = new QFilter("sbbid", "=", (Object)String.valueOf(pkValue));
        QFilter paystatusfilter = new QFilter("paystatus", "=", (Object)"2");
        DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidfilter, voucherFilter, paystatusfilter});
        String appid = TemplateTypeEnum.getAppidByTemplate((String)nsrtype);
        OperatorDialogUtils.operateDialogByAppid((String)(appid == null ? "bdtaxr" : appid), (String)entityNumber, (String)ResManager.loadKDString((String)"\u66f4\u6b63\u7533\u62a5", (String)"MultiDeclareBizBusiness_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u66f4\u6b63\u7533\u62a5\u64cd\u4f5c\u6210\u529f\u3002", (String)"MultiDeclareBizBusiness_16", (String)"taxc-bdtaxr", (Object[])new Object[0]), declares.getString("billno")));
    }

    public static String checkBeforeInvalid(Long id) {
        DynamicObject declares = MultiDeclareBizDao.queryMultiDeclareById(id);
        return MultiDeclareBizBusiness.checkBeforeInvalid(declares);
    }

    public static String checkBeforeInvalid(DynamicObject declares) {
        String result;
        String declarestatus = declares.getString("declarestatus");
        String paystatus = declares.getString("paystatus");
        if (!"declared".equals(declarestatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd\u4f5c\u5e9f\u7533\u62a5\u3002", (String)"MultiDeclareBizBusiness_7", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        if (!"unpaid".equals(paystatus) && !"nopay".equals(paystatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u201c\u672a\u7f34\u6b3e\u201d\u6216\u201c\u65e0\u9700\u7f34\u6b3e\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd\u4f5c\u5e9f\u7533\u62a5\u3002", (String)"MultiDeclareBizBusiness_8", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        if (MultiDeclareBizDao.judgeGenerCert(declares.getPkValue().toString())) {
            return ResManager.loadKDString((String)"\u201c\u7a0e\u91d1\u7f34\u7eb3\u5355\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u518d\u64cd\u4f5c\u3002", (String)"MultiDeclareBizBusiness_9", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        if ("gzsb".equals(declares.getString("versiontype"))) {
            return ResManager.loadKDString((String)"\u7248\u672c\u7c7b\u578b\u4e3a\u201c\u66f4\u6b63\u7533\u62a5\u201d\u7684\u6570\u636e\u4e0d\u652f\u6301\u201c\u4f5c\u5e9f\u7533\u62a5\u201d\u3002", (String)"MultiDeclareBizBusiness_17", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        String nsrtype = declares.getString("templatetype.id");
        DeclareReportOpService declareReportOpService = DeclareReportOpFactory.createHandler(nsrtype);
        if (declareReportOpService != null && StringUtil.isNotEmpty((CharSequence)(result = declareReportOpService.checkBefore("invalid", declares)))) {
            return result;
        }
        return null;
    }

    public static DynamicObject queryMultiDeclareById(Long id) {
        return MultiDeclareBizDao.queryMultiDeclareById(id);
    }

    public static DynamicObject queryMultiHisDecalreById(Long id) {
        return MultiDeclareBizDao.queryMultiHisDecalreById(id);
    }

    public static String checkBeforeRectify(Long id) {
        DynamicObject declares = MultiDeclareBizDao.queryMultiDeclareById(id);
        return MultiDeclareBizBusiness.checkBeforeRectify(declares);
    }

    public static String checkBeforeRectify(DynamicObject declares) {
        String result;
        String declarestatus = declares.getString("declarestatus");
        if (!"declared".equals(declarestatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd\u66f4\u6b63\u7533\u62a5\u3002", (String)"MultiDeclareBizBusiness_10", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        String nsrtype = declares.getString("templatetype.id");
        DeclareReportOpService declareReportOpService = DeclareReportOpFactory.createHandler(nsrtype);
        if (declareReportOpService != null && StringUtil.isNotEmpty((CharSequence)(result = declareReportOpService.checkBefore("rectify", declares)))) {
            return result;
        }
        return null;
    }

    private static Long saveHisSbbInfo(DynamicObject declares, String causedesc) {
        Long modelId = MultiDeclareBizBusiness.getModelIdByNumber(MultiTableEnum.TSCOO1.getModel());
        HashMap<String, Object> requestParams = new HashMap<String, Object>(10);
        requestParams.put("causedesc", causedesc);
        requestParams.put("modelId", modelId);
        return (Long)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.SAVE_HISTAXDECLARE_DATA, (Object[])new Object[]{declares.getLong("id"), requestParams});
    }

    public static DynamicObject queryDeclareByIDOrNumber(Long modelId, Long id, String number) {
        DynamicObject declare = null;
        if (ObjectUtils.isNotEmpty((Object)id)) {
            declare = MultiDeclareBizDao.queryDeclareByIdAndModelId(modelId, id);
        } else if (ObjectUtils.isNotEmpty((Object)number)) {
            declare = MultiDeclareBizDao.queryDeclareByNumberAndModelId(modelId, number);
        }
        return declare;
    }

    public static DynamicObject queryHisDeclareByIdAndModelId(Long modelId, Long id) {
        return MultiDeclareBizDao.queryHisDeclareByIdAndModelId(modelId, id);
    }

    public static boolean isModelUpdated(String type) {
        DynamicObject updateConfig;
        boolean isUpdated = false;
        String appid = TemplateTypeEnum.getAppidByTemplate((String)type);
        if (StringUtil.isNotEmpty((CharSequence)appid) && (updateConfig = MultiDeclareBizDao.queryDeclareUpdateConfigByAppId(appid)) != null) {
            isUpdated = updateConfig.getBoolean("isupdated");
        }
        return isUpdated;
    }

    public static List<String> getModelUpdatedTemplateTypes() {
        List<String> appList = MultiDeclareBizBusiness.queryModelUpdatedAppList();
        ArrayList<String> templateTypes = new ArrayList<String>(10);
        if (appList != null && appList.size() > 0) {
            for (String appid : appList) {
                templateTypes.addAll(UpdConstant.getTemplateTypeByApp((String)appid));
            }
        }
        return templateTypes;
    }

    public static List<String> queryModelUpdatedAppList() {
        DynamicObject[] objects = MultiDeclareBizDao.queryModelUpdated();
        return Arrays.stream(objects).map(v -> v.getString("taxappid")).collect(Collectors.toList());
    }

    public static Long getModelIdByNumber(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject d = BusinessDataServiceHelper.loadSingle((String)"tpo_model", (String)"id", (QFilter[])qFilter.toArray());
        if (d == null) {
            return 0L;
        }
        return d.getLong("id");
    }

    public static FormShowParameter getOpenDeclareSsbShowParameter(String type, Long id, String number, Map<String, Object> params) {
        DeclareReportOpenService declareReportOpenService = DeclareReportOpenFactory.createHandler(type);
        if (declareReportOpenService == null) {
            String msg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u7533\u62a5\u8868\uff0c\u6a21\u677f\u7c7b\u578b:%s\u3002", (String)"MultiDeclareBizBusiness_11", (String)"taxc-bdtaxr", (Object[])new Object[]{type});
            throw new KDBizException(msg);
        }
        DynamicObject declare = declareReportOpenService.loadDecalre(type, id, number, params, false);
        if (declare == null) {
            String msg = ResManager.loadKDString((String)"\u7533\u62a5\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"MultiDeclareBizBusiness_12", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String declareFormId = declareReportOpenService.getDeclareFormId(type, declare, false);
        Map<String, Object> customParams = declareReportOpenService.getExtendParams(type, declare, false);
        FormShowParameter showParameter = new FormShowParameter();
        if ("declared".equals(declare.getString("declarestatus")) && TemplateTypeConstant.getNsrtypemap().containsKey(type)) {
            showParameter.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
        }
        showParameter.setFormId(declareFormId);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    public static FormShowParameter getOpenDeclareSsbListParameter(String type, Map<String, Object> params) {
        DeclareReportOpenService declareReportOpenService = DeclareReportOpenFactory.createHandler(type);
        if (declareReportOpenService == null) {
            String msg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u7533\u62a5\u8868\u5217\u8868\uff0c\u6a21\u677f\u7c7b\u578b:%s\u3002", (String)"MultiDeclareBizBusiness_13", (String)"taxc-bdtaxr", (Object[])new Object[]{type});
            throw new KDBizException(msg);
        }
        String declareFormId = declareReportOpenService.getDecalreListFormId(type, params, false);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId(declareFormId);
        showParameter.setCustomParams(params);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    public static FormShowParameter getOpenHistorySsbShowParameter(Long modelId, Long id) {
        DynamicObject hisData = MultiDeclareBizDao.queryHisDeclareByIdAndModelId(modelId, id);
        String type = hisData.getString("templatetype.id");
        DeclareReportOpenService declareReportOpenService = DeclareReportOpenFactory.createHandler(type);
        if (declareReportOpenService == null) {
            String msg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u5386\u53f2\u7533\u62a5\u8868\uff0c\u6a21\u677f\u7c7b\u578b:%s\u3002", (String)"MultiDeclareBizBusiness_14", (String)"taxc-bdtaxr", (Object[])new Object[]{type});
            throw new KDBizException(msg);
        }
        String declareFormId = declareReportOpenService.getDeclareFormId(type, hisData, true);
        Map<String, Object> customParams = declareReportOpenService.getExtendParams(type, hisData, true);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(Long.valueOf(hisData.getLong("id")));
        requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get("orgid"))));
        requestModel.setTemplateType(type);
        requestModel.setSkssqq(DateUtils.format((Date)hisData.getDate("skssqq")));
        requestModel.setSkssqz(DateUtils.format((Date)hisData.getDate("skssqz")));
        requestModel.setModelId(MultiDiConstant.DEFAULT_MODEL);
        requestModel.setOperation("read");
        requestModel.setRefresh(Boolean.FALSE);
        requestModel.addBusinessValue("maindataid", requestModel.getId().toString());
        requestModel.addBusinessValue("declaremonth", (String)customParams.get("skssqq"));
        requestModel.setDataSource("history");
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(declareFormId);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    public static String getModelVersion(String type) {
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        String version = templateEnum.getVersion();
        boolean isUpdated = MultiDeclareBizBusiness.isModelUpdated(type);
        if (isUpdated) {
            version = DeclareConstant.MODEL_VERSION_THREE;
        }
        return version;
    }
}

