/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.multidideclare;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.domain.TemplateCacheParams;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SerializationUtils;

@Deprecated
public class MultiDiTemplateHelper {
    private static final String TEMPLATE_SHEETS = "template_sheets_%s_%s_%s_%s_%s";
    private static final List<String> COLOR_BLACK_LIST = Collections.singletonList("#d4ffaa");
    private static final List<String> TEMPLATE_WHITE_LIST = Arrays.asList("sdsjt_bd", "sdsjt_jt", "jtysbbd_bd", "jtysbbd_jt");

    public static Map<String, DynamicObject> getReportItemsByTemplate(String templateId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(templateId), (String)"tpo_template");
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        Set collect = entryentity.stream().map(a -> a.get("reportitem.id")).collect(Collectors.toSet());
        DynamicObjectCollection cells = QueryServiceHelper.query((String)"tpo_report_item", (String)"number,name,status,creator,modifier,enable,createtime,modifytime,model,row,col,longname,id", (QFilter[])new QFilter("id", "in", collect).toArray());
        Map<String, DynamicObject> result = cells.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b, (m, n) -> m));
        return result;
    }

    public static DynamicObject getTemplateByConfig(Long modelId, String templateType, String orgid, Date startDate, Date endDate) {
        return TemplateUtils.getTemplateObjectByConfig((String)templateType, (String)orgid, (Date)startDate, (Date)endDate, (String)"tpo_template", (QFilter)new QFilter("model", "=", (Object)modelId));
    }

    public static void refreshTemplateCache(TemplateCacheParams params) {
        if (!params.valitParam()) {
            return;
        }
        String templateCacheKey = String.format(TEMPLATE_SHEETS, params.getModelId(), params.getTemplateType(), params.getOrgid(), params.getStartDate(), params.getEndDate());
        List sheets = SpreadUtils.getSheets((String)params.getTemplateContent(), null);
        TemplateVo templateVo = new TemplateVo();
        templateVo.setTemplateId(params.getTemplateId());
        templateVo.setTemplateNumber(params.getTemplateNumber());
        templateVo.setTemplate(sheets);
        CacheUtils.put((String)templateCacheKey, (Object)templateVo);
    }

    public static TemplateVo getBaseTemplate(Long modelId, String templateType, String orgid, Date startDate, Date endDate) {
        String templateCacheKey = String.format(TEMPLATE_SHEETS, modelId, templateType, orgid, startDate, endDate);
        TemplateVo templateVo = null;
        if (templateVo != null) {
            return templateVo;
        }
        DynamicObject templateObj = MultiDiTemplateHelper.getTemplateByConfig(modelId, templateType, orgid, startDate, endDate);
        if (templateObj == null) {
            throw new RuntimeException("No template Data!");
        }
        Long templateId = templateObj.getLong("id");
        ArrayList sheets = new ArrayList();
        String templateNumber = templateObj.getString("number");
        String templateContent = templateObj.getString("content_tag");
        sheets.addAll(SpreadUtils.getSheets((String)templateContent, null));
        templateVo = new TemplateVo();
        templateVo.setTemplateId(templateId);
        templateVo.setTemplateNumber(templateNumber);
        templateVo.setTemplate(sheets);
        CacheUtils.put((String)templateCacheKey, (Object)templateVo);
        return templateVo;
    }

    public static TemplateVo parseTemplate(GetTemplateVo getTemplateVo) {
        List sheets = getTemplateVo.getRequestModel().getBaseTemplate();
        Map cellTypeMap = getTemplateVo.getResponseModel().getAllFormulas().getCelltypeFormulas();
        List dynamicRowList = getTemplateVo.getResponseModel().getDynRowList();
        String templateType = getTemplateVo.getRequestModel().getTemplateType();
        List<String> hideRows = getTemplateVo.getHideRows();
        List<String> hideModificationNotes = getTemplateVo.getHideModificationNotes();
        HashMap dynamicRowMap = new HashMap();
        for (Sheet e : sheets) {
            List rowList = e.getRowList();
            for (int i = 0; i < rowList.size(); ++i) {
                List cellList = (List)rowList.get(i);
                if (!CollectionUtils.isEmpty(hideRows) && !CollectionUtils.isEmpty((Collection)cellList) && cellList.stream().anyMatch(c -> StringUtils.isNotBlank((String)c.getCellKey()) && hideRows.contains(c.getCellKey().split("#")[0]))) {
                    cellList.forEach(c -> c.setHide(true));
                }
                boolean dynamicRow = false;
                boolean dynamicRowSize = false;
                String dynamicRowNo = "";
                for (Cell cell : cellList) {
                    if (cell.getCellKey() != null && cell.getCellKey().contains("#")) {
                        String[] clist = cell.getCellKey().split("#");
                        if (!CollectionUtils.isEmpty(hideModificationNotes) && hideModificationNotes.contains(clist[clist.length - 1])) {
                            cell.setHideModificationNote(true);
                        }
                    }
                    cell.setFormulaVo((FormulaVo)cellTypeMap.get(cell.getCellKey()));
                    if (null == cell.getText() || !cell.getText().contains("#")) {
                        if (cell.getStyle() == null) continue;
                        if (cell.getStyle().gethAlign() == null) {
                            cell.getStyle().sethAlign(Integer.valueOf(0));
                        }
                        cell.getStyle().setLocked(Boolean.TRUE);
                    }
                    if (cell.getStyle() != null && COLOR_BLACK_LIST.contains(cell.getStyle().getBackColor()) && cell.getStyle().getBackColor() != null) {
                        cell.getStyle().setBackColor(null);
                    }
                    if (cell.getStyle() == null || TEMPLATE_WHITE_LIST.contains(templateType)) continue;
                    if (cell.getStyle().getBackColor() != null) {
                        cell.getStyle().setBackColor(null);
                    }
                    if (cell.getStyle().getForeColor() != null) {
                        cell.getStyle().setForeColor(null);
                    }
                    if (cell.getStyle().getFont() == null) continue;
                    cell.getStyle().setFont(null);
                }
                block3: for (Cell cell : cellList) {
                    if (!StringUtils.isNotBlank((String)cell.getText()) || dynamicRowList == null) continue;
                    for (DynamicRowModel rowModel : dynamicRowList) {
                        if (rowModel == null) continue;
                        String dynMatchKey = rowModel.getDynRowNo();
                        dynMatchKey = dynMatchKey.contains("#") ? dynMatchKey.split("#")[0] + "#" : dynMatchKey + "#";
                        String key = cell.getCellKey();
                        if (key == null || !key.startsWith(dynMatchKey)) continue;
                        int startRowNum = rowModel.getStartRow().intValue();
                        dynamicRow = true;
                        dynamicRowNo = rowModel.getDynRowNo();
                        String text = cell.getText();
                        String[] keys = key.split("#");
                        String newKey = String.format("%s#%s#%s", keys[0], startRowNum, keys[keys.length - 1]);
                        FormulaVo f = (FormulaVo)cellTypeMap.get(newKey);
                        if (f != null) {
                            f.setFormulaKey(newKey);
                        }
                        cell.setFormulaVo(f);
                        cell.setText(text.replace(key, newKey));
                        cell.setDynRowCell(dynamicRow);
                        cell.setDynRowNo(dynamicRowNo);
                        cell.setDisablefrontop(rowModel.isDisablefrontop());
                        int rowListSize = 0;
                        if (rowModel.getRowList() != null) {
                            rowListSize = rowModel.getRowList().size();
                        }
                        ArrayList<List> dynamicList = new ArrayList<List>(rowListSize == 0 ? 1 : rowListSize);
                        dynamicList.add(cellList);
                        for (int j = 2; j <= rowListSize; ++j) {
                            ArrayList<Cell> cellListCopy = new ArrayList<Cell>(cellList.size());
                            for (Cell c2 : cellList) {
                                cellListCopy.add((Cell)SerializationUtils.clone((Serializable)c2));
                            }
                            int num = startRowNum + j - 1;
                            for (Cell el : cellListCopy) {
                                el.setText(el.getText().replace("#" + startRowNum + "#", "#" + num + "#"));
                                FormulaVo vo = el.getFormulaVo();
                                if (vo == null) continue;
                                vo.setFormulaKey(el.getCellKey());
                                el.setFormulaVo(vo);
                            }
                            dynamicList.add(cellListCopy);
                        }
                        dynamicRowMap.put(dynamicRowNo, dynamicList);
                        continue block3;
                    }
                }
            }
        }
        TemplateVo templateVo = new TemplateVo();
        templateVo.setTemplate(sheets);
        templateVo.setDynamicRow(dynamicRowMap);
        return templateVo;
    }
}

