/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.multidideclare;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizBusiness;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.helper.tpo.MultiDeclareDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class UnifiedDeclareBizBusiness {
    public static OperationResult executeOperate(String operationKey, List<Long> ids, OperateOption options) {
        OperateOption operateOption = options == null ? OperateOption.create() : options;
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        Long modelId = MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSCOO1.getModel());
        List model3List = (List)DeclareMainServiceHelper.queryDeclareMainByIds((Long)modelId, ids).getData();
        OperationResult model3Result = null;
        if (model3List.size() > 0) {
            model3Result = OperationServiceHelper.executeOperate((String)operationKey, (String)"tpo_declare_tsc_proxy", (Object[])ids.toArray(), (OperateOption)operateOption);
        }
        List model2List = (List)DeclareMainServiceHelper.queryDeclareMainByIds(null, ids).getData();
        OperationResult model2Result = null;
        if (model2List.size() > 0) {
            model2Result = OperationServiceHelper.executeOperate((String)operationKey, (String)"bdtaxr_declare_proxy", (Object[])ids.toArray(), (OperateOption)operateOption);
            if (!"pay".equals(operationKey)) {
                List model2Ids = model2List.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                MultiDeclareDataServiceHelper.syncModel2DataToModel3(model2Ids, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
            }
        }
        if (model3Result != null && model2Result != null) {
            model3Result.mergeOperateResult(model2Result);
        }
        OperationResult result = model3Result != null ? model3Result : model2Result;
        return result;
    }

    public static List<String> checkMutex(List<String> ids) {
        DynamicObjectCollection mutexCollection = QueryServiceHelper.query((String)"bos_datalock", (String)"objectid,objectname,entitykey,user.id,user.name", (QFilter[])new QFilter[]{new QFilter("objectid", "in", ids)});
        if (mutexCollection == null) {
            return Collections.emptyList();
        }
        Map<Long, String> mutexMap = mutexCollection.stream().collect(Collectors.toMap(e -> Long.valueOf(e.getString("objectid")), e -> e.getString("user.name"), (k, v) -> k));
        String model3Table = MultiTableEnum.TSCOO1.getDeclareMainTable();
        DynamicObjectCollection model3Collection = QueryServiceHelper.query((String)model3Table, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", mutexMap.keySet())});
        ArrayList<String> errList = new ArrayList<String>(10);
        model3Collection.stream().forEach(e -> {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91%2$s\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\r\n", (String)"AbstractDeclareReportMultiQueryListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), mutexMap.get(e.getLong("id")), e.getString("billno"));
            errList.add(msg);
        });
        String model2Table = "tcvat_nsrxx";
        DynamicObjectCollection model2Collection = QueryServiceHelper.query((String)model2Table, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", mutexMap.keySet())});
        model2Collection.stream().forEach(e -> {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91%2$s\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\r\n", (String)"AbstractDeclareReportMultiQueryListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), mutexMap.get(e.getLong("id")), e.getString("billno"));
            errList.add(msg);
        });
        return errList;
    }

    public static String checkBeforeInvalid(Long id) {
        List result = (List)MultiDeclareDataServiceHelper.queryDeclareMainByIds((List)Lists.newArrayList((Object[])new Long[]{id})).getData();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            DynamicObject declares = (DynamicObject)result.get(0);
            return MultiDeclareBizBusiness.checkBeforeInvalid(declares);
        }
        return null;
    }

    public static String checkBeforeRectify(Long id) {
        List result = (List)MultiDeclareDataServiceHelper.queryDeclareMainByIds((List)Lists.newArrayList((Object[])new Long[]{id})).getData();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            DynamicObject declares = (DynamicObject)result.get(0);
            return MultiDeclareBizBusiness.checkBeforeRectify(declares);
        }
        return null;
    }

    public static boolean existsHistorySbb(Long sbbid) {
        ModelVersionEnum version;
        String entityName = null;
        Map modelVersionEnumMap = (Map)MultiDeclareDataServiceHelper.queryModelVersionByIds((List)Lists.newArrayList((Object[])new Long[]{sbbid})).getData();
        return !kd.bos.orm.util.CollectionUtils.isEmpty((Map)modelVersionEnumMap) && ((version = (ModelVersionEnum)modelVersionEnumMap.get(sbbid)) != null && ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion()) ? QueryServiceHelper.exists((String)(entityName = "tpo_history_sbb"), (QFilter[])new QFilter[]{new QFilter("declareid", "=", (Object)sbbid)}) : QueryServiceHelper.exists((String)(entityName = "bdtaxr_history_sbb"), (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)}));
    }

    public static String getHistorySbbView(Long sbbid) {
        Map modelVersionEnumMap = (Map)MultiDeclareDataServiceHelper.queryModelVersionByIds((List)Lists.newArrayList((Object[])new Long[]{sbbid})).getData();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Map)modelVersionEnumMap)) {
            ModelVersionEnum version = (ModelVersionEnum)modelVersionEnumMap.get(sbbid);
            if (version != null && ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
                return "tpo_history_sbb_view";
            }
            return "bdtaxr_history_sbb_view";
        }
        return null;
    }

    public static String getDeclareMsgInputView(Long sbbid) {
        Map modelVersionEnumMap = (Map)MultiDeclareDataServiceHelper.queryModelVersionByIds((List)Lists.newArrayList((Object[])new Long[]{sbbid})).getData();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Map)modelVersionEnumMap)) {
            ModelVersionEnum version = (ModelVersionEnum)modelVersionEnumMap.get(sbbid);
            if (version != null && ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
                return "tpo_declare_msg_input";
            }
            return "bdtaxr_declare_msg_input";
        }
        return null;
    }

    public static void pay(List<Long> ids, Date payDate) {
        List model2List;
        Long modelId = MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSCOO1.getModel());
        List model3List = (List)DeclareMainServiceHelper.queryDeclareMainByIds((Long)modelId, ids).getData();
        if (model3List.size() > 0) {
            UnifiedDeclareBizBusiness.payByVersion(model3List, payDate, ModelVersionEnum.MODEL3);
        }
        if ((model2List = (List)DeclareMainServiceHelper.queryDeclareMainByIds(null, ids).getData()).size() > 0) {
            UnifiedDeclareBizBusiness.payByVersion(model2List, payDate, ModelVersionEnum.MODEL2);
        }
    }

    private static void payByVersion(List<DynamicObject> declares, Date payDate, ModelVersionEnum version) {
        if (declares != null && declares.size() > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.size());
            for (DynamicObject declare : declares) {
                declare.set("paystatus", (Object)"paid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"0");
                declare.set("paydate", (Object)payDate);
                declare.set("payer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                DynamicObject[] saveObjects = modifyDynamicObjects.toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])saveObjects);
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                if (version != null && ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                    MultiDeclareMQSender.sendMQ((DynamicObject[])saveObjects, (String)"pay");
                    DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)"pay"));
                } else {
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                    MultiDeclareDataServiceHelper.syncModel2DataToModel3(sbbIds, (DeclareOperationEnum)DeclareOperationEnum.PAY);
                }
            }
        }
    }

    public static DynamicObjectCollection queryTemplateListByType(String type) {
        String entityNumber = null;
        Map modelVersionMap = (Map)MultiDeclareDataServiceHelper.queryModelVersionByTypes((List)Lists.newArrayList((Object[])new String[]{type})).getData();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Map)modelVersionMap)) {
            ModelVersionEnum version = (ModelVersionEnum)modelVersionMap.get(type);
            entityNumber = version != null && ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion()) ? "tpo_template" : "bdtaxr_template_main";
        }
        if (StringUtil.isNotEmpty(entityNumber)) {
            QFilter q = new QFilter("type.number", "=", (Object)type);
            DynamicObjectCollection result = QueryServiceHelper.query((String)entityNumber, (String)"id,name as textfield,type.id as typeid,startdate,enddate,filtercondition,conditionjson", (QFilter[])new QFilter[]{q}, (String)"startdate desc,number");
            return result;
        }
        return new DynamicObjectCollection();
    }

    public static ModelVersionEnum getModelVersionByType(String type) {
        Map modelVersionMap = (Map)MultiDeclareDataServiceHelper.queryModelVersionByTypes((List)Lists.newArrayList((Object[])new String[]{type})).getData();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Map)modelVersionMap)) {
            ModelVersionEnum version = (ModelVersionEnum)modelVersionMap.get(type);
            return version;
        }
        return null;
    }

    public static List<String> getAllReportTemplateTypeList() {
        List excludeTemplateTypes = UpdConstant.model2DraftTemplateTypes;
        QFilter filter = new QFilter("number", "not in", (Object)excludeTemplateTypes);
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"tpo_template_type", (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (colls != null && colls.length > 0) {
            return Arrays.stream(colls).map(v -> v.getString("number")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

