/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.pay;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.pay.IDeclarePayService;
import kd.taxc.bdtaxr.business.pay.MultiDeclarePayServiceFactory;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import org.apache.commons.collections.CollectionUtils;

public class MultiDeclarePayHelper {
    private static final Log logger = LogFactory.getLog(MultiDeclarePayHelper.class);
    public static final String METHOD_MANUALDECLARE = "manualDeclare";
    public static final String METHOD_CANCELDECLARE = "cancelDeclare";
    public static final String METHOD_MANUALPAY = "manualPay";
    public static final String METHOD_CANCELPAY = "cancelPay";

    public static void manualDeclare(List<Long> sbbIds) {
        MultiDeclarePayHelper.invoke(sbbIds, METHOD_MANUALDECLARE);
    }

    public static void cancelDeclare(List<Long> sbbIds) {
        MultiDeclarePayHelper.invoke(sbbIds, METHOD_CANCELDECLARE);
    }

    public static void manualPay(List<Long> sbbIds) {
        MultiDeclarePayHelper.invoke(sbbIds, METHOD_MANUALPAY);
    }

    public static void cancelPay(List<Long> sbbIds) {
        MultiDeclarePayHelper.invoke(sbbIds, METHOD_CANCELPAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invoke(List<Long> sbbIds, String methodName) {
        if (CollectionUtils.isEmpty(sbbIds)) {
            return;
        }
        CopyOnWriteArrayList locks = new CopyOnWriteArrayList();
        try {
            List lockSbbids = sbbIds.stream().filter(id -> MultiDeclarePayHelper.tryLock(methodName, locks, id)).collect(Collectors.toList());
            DynamicObject[] nsrxxList = BusinessDataServiceHelper.load((Object[])lockSbbids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tpo_declare_main_tsc"));
            Map<String, List<DynamicObject>> nsrxxMap = Stream.of(nsrxxList).collect(Collectors.groupingBy(MultiDeclarePayHelper.getDynamicObjectStringFunction()));
            try (TXHandle handle = TX.required();){
                try {
                    for (Map.Entry<String, List<DynamicObject>> entry : nsrxxMap.entrySet()) {
                        IDeclarePayService operation = MultiDeclarePayServiceFactory.getService(entry.getKey());
                        Method method = ReflectionUtils.findMethod(operation.getClass(), (String)methodName, (Class[])new Class[]{List.class});
                        method.invoke((Object)operation, entry.getValue());
                    }
                }
                catch (Exception e) {
                    logger.error("MultiDeclarePayHelper error log ", (Throwable)e);
                    handle.markRollback();
                    throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"MultiDeclarePayHelper_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            }
        }
        finally {
            locks.forEach(lock -> {
                if (lock != null) {
                    lock.unlock();
                }
            });
        }
    }

    private static boolean tryLock(String methodName, List<DLock> locks, Long id) {
        DLock lock = DLock.create((String)methodName.concat(String.valueOf(id)));
        if (lock.tryLock()) {
            locks.add(lock);
            return true;
        }
        return false;
    }

    private static Function<DynamicObject, String> getDynamicObjectStringFunction() {
        return nsrxx -> {
            DynamicObject templatetype = (DynamicObject)nsrxx.get("templatetype");
            String typenumber = templatetype.getString("number");
            String type = TaxTypeUtils.getTaxType((String)typenumber, null);
            if ("totf_cjrjybzj".equals(type)) {
                return "totf_cjrjybzj";
            }
            if ("dkdj".equals(type)) {
                return "dkdj";
            }
            if ("kjqysds".equals(type)) {
                return "kjqysds";
            }
            return "default";
        };
    }
}

