/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.pay.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.pay.DeclarePayHelper;
import kd.taxc.bdtaxr.business.pay.IDeclarePayService;
import kd.taxc.bdtaxr.business.pay.impl.ccxws.CcxwsDimensionPayService;
import kd.taxc.bdtaxr.business.pay.impl.ccxws.CcxwsDimensionPayServiceFactory;
import kd.taxc.bdtaxr.business.subplugin.IPayRecordSaveSubPlugin;
import kd.taxc.bdtaxr.business.subplugin.args.PayRecordSaveAfterArgs;
import kd.taxc.bdtaxr.business.subplugin.args.PayRecordSaveBeforeArgs;
import kd.taxc.bdtaxr.business.subplugin.impl.DefaultPayRecordSaveSubPlugin;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.CalendarTaxType;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.PayDateUtils;
import kd.taxc.bdtaxr.common.util.PayRecordUtils;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public abstract class AbstractDeclarePayService
implements IDeclarePayService {
    private static final Log logger = LogFactory.getLog(AbstractDeclarePayService.class);
    public static final String PAY_RECORD_ENTITY = "bdtaxr_pay_record";
    public static String PAY_RECORD_ENTITY_ALL_FIELDS = "billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,hjsqid,sbbentryid,sbbid,isvoucher,sssq,operatetime,operator,yjje,jkbl,paystatus,deadline,sjje,syqjje,payer,paydate,taxtype,skssqq,skssqz,nsrtype,voucherno,taxauthority,sbbno,yspzno,electrictaxno,accountorg,entrydate,entryentity.taxitem,entryentity.yjjemx,entryentity.sjjemx,entryentity.syqjjemx,entryentity.delaypay,entryentity.accorg,entryentity.bizdimensiontype,entryentity.bizdimensionname,entryentity.bizdimensionid,id,entryentity.id,entryentity.seq,sjznj";
    public static final String DECLARE = "declare";
    public static final String CANCEL_DECLARE = "cancelDeclare";
    public static final String PAY = "pay";
    public static final String CANCEL_PAY = "cancelPay";
    public static final String KEY_SJJE = "sjje";
    public static final String KEY_QJJE = "qjje";
    public static final List<String> TCRET_TAXTYPE = Arrays.asList(CalendarTaxType.YHS.getType(), CalendarTaxType.FCS.getType(), CalendarTaxType.CZTDSYS.getType(), CalendarTaxType.HBS.getType(), CalendarTaxType.ZYS.getType(), CalendarTaxType.CCS.getType(), CalendarTaxType.QS.getType(), CalendarTaxType.CLGZS.getType(), CalendarTaxType.GDZYS.getType(), CalendarTaxType.TDZZS.getType(), CalendarTaxType.YYS.getType());
    private static List<String> singleItem = Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "fjsf", "qysdsjb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_jb", "qysds_hdzs_nb", "yhs", "fcs", "cztdsys", "fcscztdsys", "fcsprice", "fcshire", "tvpt", "tcvvt", "tcept", "yys", "tcrt", "zzsyjskb", "qtsf_tysbb", "qtsf_fsstysbb", "whsyjsf");
    private static final List<String> TCNFEP_ITEM = Arrays.asList("dkdj", "kjqysds");
    private static final List<String> RECTIFY_TAX = Arrays.asList("ccxws", "qtsf_tysbb", "qtsf_fsstysbb", "qtsf_fsstysbb", "zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg");

    public abstract Map<Long, List<DynamicObject>> getSubEntryMap(List<DynamicObject> var1, String var2);

    public abstract boolean needUpdateSubEntry();

    public abstract String getTaxType(DynamicObject var1, DynamicObject var2);

    @Override
    public void manualDeclare(List<DynamicObject> nsrxxList) {
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "sbbid");
        ArrayList<DynamicObject> payRecordList = new ArrayList<DynamicObject>();
        ArrayList prepayList = new ArrayList();
        boolean flag = false;
        for (DynamicObject nsrxx : nsrxxList) {
            String type = nsrxx.getString("type");
            if ("zzsybnsr".equals(type)) {
                Date skssqq = nsrxx.getDate("skssqq");
                Date skssqz = nsrxx.getDate("skssqz");
                Object org = nsrxx.get("org");
                long orgId = org instanceof Long ? ((Long)org).longValue() : ((DynamicObject)org).getLong("id");
                boolean isFzjg = QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{new QFilter("taxtype", "=", (Object)"zzs"), new QFilter("summaryway", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C"), new QFilter("status", "=", (Object)"2"), new QFilter("effectdate", "<=", (Object)skssqq), new QFilter("invaliddate", "is null", null).or("invaliddate", ">=", (Object)skssqz), new QFilter("orgrow.orgid", "=", (Object)orgId)});
                if (isFzjg) continue;
            }
            if (nsrxxList.size() == 1 && "gzsb".equals(nsrxx.get("versiontype")) && PayRecordUtils.havePayRecord((DynamicObject)nsrxxList.get(0))) {
                flag = true;
                if (!RECTIFY_TAX.contains(type)) break;
            }
            List<DynamicObject> subEntryList = subEntryMap.get(nsrxx.getLong("id"));
            BigDecimal totalybtse = BigDecimal.ZERO;
            if (EmptyCheckUtils.isNotEmpty(subEntryList)) {
                HashSet<String> ccxwsLessOneSet = new HashSet<String>();
                if ("ccxws".equals(type)) {
                    Map<String, List<DynamicObject>> taxtypeMap = subEntryList.stream().collect(Collectors.groupingBy(o -> o.getString("taxtype")));
                    for (Map.Entry entry : taxtypeMap.entrySet()) {
                        String taxtype = (String)entry.getKey();
                        List datums = (List)entry.getValue();
                        BigDecimal ybse = datums.stream().map(o -> o.getBigDecimal("bqdybtse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        if (BigDecimal.ONE.compareTo(ybse) < 0) continue;
                        ccxwsLessOneSet.add(taxtype);
                    }
                }
                for (DynamicObject subEntry : subEntryList) {
                    boolean exists;
                    String taxtype = null;
                    if ("ccxws".equals(type)) {
                        taxtype = subEntry.getString("taxtype");
                    }
                    if ("ccxws".equals(type) && ccxwsLessOneSet.contains(taxtype) || (!RECTIFY_TAX.contains(type) || !flag) && (exists = QueryServiceHelper.exists((String)PAY_RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter("sbbentryid", "=", (Object)subEntry.getLong("id"))}))) continue;
                    BigDecimal ybtse = nsrxx.getString("type").startsWith("qtsf_") ? subEntry.getBigDecimal("ybse") : (nsrxx.getString("type").equals("dkdj") ? nsrxx.getBigDecimal("bqybtse") : (nsrxx.getString("type").equals("kjqysds") ? nsrxx.getBigDecimal("bqybtse") : subEntry.getBigDecimal("bqdybtse")));
                    totalybtse = BigDecimalUtil.addObject((Object)totalybtse, (Object)ybtse);
                    if (this.needUpdateSubEntry()) {
                        if (nsrxx.getString("type").equals("dkdj")) {
                            subEntry.set("xsjje", (Object)BigDecimal.ZERO);
                            subEntry.set("sjsezzs", (Object)ybtse);
                        } else if (nsrxx.getString("type").equals("kjqysds")) {
                            subEntry.set("xsjje", (Object)BigDecimal.ZERO);
                            subEntry.set("sjse", (Object)ybtse);
                        } else {
                            subEntry.set(KEY_SJJE, (Object)BigDecimal.ZERO);
                            subEntry.set(KEY_QJJE, (Object)ybtse);
                        }
                    }
                    this.packRecordData(payRecordList, nsrxx, subEntry);
                }
            } else {
                boolean exists = QueryServiceHelper.exists((String)PAY_RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)nsrxx.getString("id"))});
                if (exists) continue;
                totalybtse = nsrxx.getBigDecimal("bqybtse");
                this.packRecordData(payRecordList, nsrxx, null);
            }
            nsrxx.set(KEY_SJJE, (Object)BigDecimal.ZERO);
            nsrxx.set(KEY_QJJE, (Object)totalybtse);
            if (!"zzsybnsr".equals(nsrxx.get("type")) && !"zzsybnsr_ybhz".equals(nsrxx.get("type")) && !"zzsybnsr_hz_zjg".equals(nsrxx.get("type"))) continue;
            String id = nsrxx.getString("id");
            QFilter q1 = new QFilter("sssbbid", "=", (Object)id);
            QFilter q2 = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst((Date)DateUtils.addMonth((Date)nsrxx.getDate("skssqq"), (int)-1)));
            QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)nsrxx.getDate("skssqz")));
            QFilter q4 = new QFilter("deductionperiod", "=", (Object)"0");
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"deductionperiod", (QFilter[])new QFilter[]{q1, q2, q3, q4});
            Arrays.stream(load).forEach(e -> {
                e.set("deductionperiod", (Object)DateUtils.getMonthOfDate((Date)nsrxx.getDate("skssqq")));
                prepayList.add(e);
            });
        }
        if (flag) {
            QFilter[] qFilters;
            Object object;
            String type = nsrxxList.get(0).getString("type");
            List<DynamicObject> subEntryList = subEntryMap.get(nsrxxList.get(0).getLong("id"));
            ArrayList<DynamicObject> saveRecords = new ArrayList<DynamicObject>();
            if (EmptyCheckUtils.isNotEmpty(subEntryList)) {
                if (RECTIFY_TAX.contains(type)) {
                    object = nsrxxList.get(0);
                    qFilters = new QFilter[]{new QFilter("sbbid", "=", (Object)object.getString("id"))};
                    this.buildPayRecord(payRecordList, qFilters, object.getBigDecimal("bqybtse"), subEntryList);
                    saveRecords = payRecordList;
                } else {
                    for (DynamicObject sub : subEntryList) {
                        BigDecimal bqybtse = type.startsWith("qtsf_") ? sub.getBigDecimal("ybse") : sub.getBigDecimal("bqdybtse");
                        QFilter[] qFilters2 = new QFilter[]{new QFilter("sbbentryid", "=", sub.get("id"))};
                        this.buildPayRecord(saveRecords, qFilters2, bqybtse);
                    }
                }
            } else {
                object = nsrxxList.get(0);
                qFilters = new QFilter[]{new QFilter("sbbid", "=", (Object)object.getString("id"))};
                this.buildPayRecord(saveRecords, qFilters, object.getBigDecimal("bqybtse"));
            }
            SaveServiceHelper.save((DynamicObject[])saveRecords.toArray(new DynamicObject[0]));
            try {
                List pkIdList = saveRecords.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                boolean writeBill = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)PAY_RECORD_ENTITY, (String)"audit", pkIdList, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
                logger.info("\u51ed\u8bc1\u767d\u540d\u5355\u5199\u5165\u7ed3\u679c\uff1a" + writeBill);
            }
            catch (Exception e2) {
                throw new KDBizException("generatevoucher error!");
            }
        }
        DefaultPayRecordSaveSubPlugin saveSubPlugin = new DefaultPayRecordSaveSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)saveSubPlugin, IPayRecordSaveSubPlugin.class, (String)"kd.taxc.bdtaxr.mservice.api.applypay.DeclarePayService", null);
        PayRecordSaveBeforeArgs beforeArgs = new PayRecordSaveBeforeArgs();
        beforeArgs.setOperateKey(DECLARE);
        pluginProxy.callReplaceIfPresent(p -> {
            p.beforeSave(beforeArgs);
            return null;
        });
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        nsrxxList.forEach(nxxObj -> DeclareMQSender.sendTaxableListMQ((DynamicObject)nxxObj, (Date)nxxObj.getDate("skssqq"), (Date)nxxObj.getDate("skssqz"), (String)DeclareMQType.DECLARE.name(), (String)DeclareMQEvent.APPLY.name()));
        try {
            Object[] save = SaveServiceHelper.save((DynamicObject[])payRecordList.toArray(new DynamicObject[0]));
            List pkIdList = payRecordList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            boolean writeBill = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)PAY_RECORD_ENTITY, (String)"audit", pkIdList, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
            logger.info("\u51ed\u8bc1\u767d\u540d\u5355\u5199\u5165\u7ed3\u679c\uff1a" + writeBill);
            SaveServiceHelper.save((DynamicObject[])prepayList.toArray(new DynamicObject[0]));
            this.updateSubEntryList(subEntryMap);
            PayRecordSaveAfterArgs afterArgs = new PayRecordSaveAfterArgs();
            List<Long> payRecordIds = Stream.of(save).map(o -> (DynamicObject)o).map(o -> o.getLong("id")).collect(Collectors.toList());
            afterArgs.setOperateKey(DECLARE);
            afterArgs.setPayRecordIds(payRecordIds);
            pluginProxy.callReplaceIfPresent(p -> {
                p.afterSave(afterArgs);
                return null;
            });
        }
        catch (Exception e3) {
            logger.error("\u751f\u6210\u7f34\u7eb3\u5355\u5931\u8d25" + SerializationUtils.toJsonString(payRecordList));
            throw new KDBizException((Throwable)e3, new ErrorCode("AbstractDeclarePayService", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"AbstractDeclarePayService_0", (String)"taxc-bdtaxr", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void buildPayRecord(List<DynamicObject> payRecordList, QFilter[] qFilters, BigDecimal bqybtse, List<DynamicObject> subEntryList) {
        DynamicObject[] records = BusinessDataServiceHelper.load((String)PAY_RECORD_ENTITY, (String)PAY_RECORD_ENTITY_ALL_FIELDS, (QFilter[])qFilters);
        if (records != null && records.length > 0 && !CollectionUtils.isEmpty(payRecordList)) {
            ArrayList<String> removeList = new ArrayList<String>(8);
            for (DynamicObject object : payRecordList) {
                ArrayList<String> removeEntryList = new ArrayList<String>(8);
                String skssqq = DateUtils.format((Date)object.getDate("skssqq"));
                String skssqz = DateUtils.format((Date)object.getDate("skssqz"));
                String taxtype = object.getString("taxtype");
                DynamicObjectCollection entryentitys = object.getDynamicObjectCollection("entryentity");
                for (DynamicObject record : records) {
                    String startdate = DateUtils.format((Date)record.getDate("skssqq"));
                    String enddate = DateUtils.format((Date)record.getDate("skssqz"));
                    String oldtaxtype = record.getString("taxtype");
                    if (!taxtype.equals(oldtaxtype) || !skssqq.equals(startdate) || !skssqz.equals(enddate)) continue;
                    DynamicObjectCollection oldentryentitys = record.getDynamicObjectCollection("entryentity");
                    Map<String, DynamicObject> taxitemMap = oldentryentitys.stream().collect(Collectors.toMap(k -> k.getString("taxitem"), v -> v, (k1, k2) -> k1));
                    for (DynamicObject entry : entryentitys) {
                        String taxitem = entry.getString("taxitem");
                        DynamicObject oldEntry = taxitemMap.get(taxitem);
                        if (oldEntry == null) continue;
                        BigDecimal yjjemx = entry.getBigDecimal("yjjemx");
                        BigDecimal newyjjemx = yjjemx.subtract(oldEntry.getBigDecimal("yjjemx"));
                        if (newyjjemx.doubleValue() <= 0.0) {
                            removeEntryList.add(entry.getString("taxitem"));
                            continue;
                        }
                        entry.set("yjjemx", (Object)newyjjemx);
                        entry.set("syqjjemx", (Object)newyjjemx);
                    }
                }
                entryentitys.removeIf(e -> removeEntryList.contains(e.getString("taxitem")));
                if (CollectionUtils.isEmpty((Collection)entryentitys)) {
                    removeList.add(object.getString("billno"));
                    continue;
                }
                BigDecimal yjje = entryentitys.stream().map(d -> d.getBigDecimal("yjjemx")).reduce(BigDecimal.ZERO, BigDecimal::add);
                object.set("yjje", (Object)yjje);
                object.set("syqjje", (Object)yjje);
            }
            payRecordList.removeIf(e -> removeList.contains(e.getString("billno")));
        }
    }

    private void buildPayRecord(List<DynamicObject> saveRecords, QFilter[] qFilters, BigDecimal bqybtse) {
        BigDecimal yjjeSum;
        DynamicObject[] records = BusinessDataServiceHelper.load((String)PAY_RECORD_ENTITY, (String)PAY_RECORD_ENTITY_ALL_FIELDS, (QFilter[])qFilters);
        if (records != null && records.length > 0 && bqybtse.compareTo(yjjeSum = Arrays.asList(records).stream().map(d -> d.getBigDecimal("yjje")).reduce(BigDecimal.ZERO, BigDecimal::add)) > 0) {
            BigDecimal subtract = bqybtse.subtract(yjjeSum);
            DynamicObject subtractrecord = records[0];
            long[] ids = DBUtils.getLongIds((String)PAY_RECORD_ENTITY, (int)1);
            subtractrecord.set("id", (Object)ids[0]);
            subtractrecord.set("yjje", (Object)subtract);
            subtractrecord.set(KEY_SJJE, (Object)BigDecimal.ZERO);
            subtractrecord.set("syqjje", (Object)subtract);
            subtractrecord.set("paystatus", (Object)"2");
            subtractrecord.set("isvoucher", (Object)"0");
            subtractrecord.set("voucherno", (Object)" ");
            String number = CodeRuleServiceHelper.getNumber((String)PAY_RECORD_ENTITY, (DynamicObject)subtractrecord, (String)subtractrecord.getDynamicObject("org").getString("id"));
            subtractrecord.set("billno", (Object)number);
            subtractrecord.set("paydate", null);
            DynamicObjectCollection entryentitys = subtractrecord.getDynamicObjectCollection("entryentity");
            entryentitys.forEach(one -> {
                long[] ids1 = DBUtils.getLongIds((String)PAY_RECORD_ENTITY, (int)1);
                one.set("id", (Object)ids1[0]);
                one.set("syqjjemx", (Object)subtract);
                one.set("sjjemx", (Object)BigDecimal.ZERO);
                one.set("yjjemx", (Object)subtract);
            });
            DynamicObject subtractrecord2 = BusinessDataServiceHelper.newDynamicObject((String)PAY_RECORD_ENTITY);
            BeanCopyUtils.copyDynamicObject((DynamicObject)subtractrecord, (DynamicObject)subtractrecord2);
            saveRecords.add(subtractrecord2);
        }
    }

    @Override
    public void cancelDeclare(List<DynamicObject> nsrxxList) {
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "sbbid");
        ArrayList prepayList = new ArrayList();
        for (DynamicObject nsrxx : nsrxxList) {
            nsrxx.set(KEY_SJJE, (Object)BigDecimal.ZERO);
            nsrxx.set(KEY_QJJE, (Object)BigDecimal.ZERO);
            List<DynamicObject> subEntryList = subEntryMap.get(nsrxx.getLong("id"));
            if (EmptyCheckUtils.isNotEmpty(subEntryList) && this.needUpdateSubEntry()) {
                subEntryList.forEach(subEntry -> {
                    subEntry.set(KEY_SJJE, (Object)BigDecimal.ZERO);
                    subEntry.set(KEY_QJJE, (Object)BigDecimal.ZERO);
                });
            }
            if (!"zzsybnsr".equals(nsrxx.get("type")) && !"zzsybnsr_ybhz".equals(nsrxx.get("type")) && !"zzsybnsr_hz_zjg".equals(nsrxx.get("type"))) continue;
            String id = nsrxx.getString("id");
            QFilter q1 = new QFilter("sssbbid", "=", (Object)id);
            QFilter q2 = new QFilter("skssqq", ">=", (Object)DateUtils.addMonth((Date)DateUtils.getDayFirst((Date)nsrxx.getDate("skssqq")), (int)-1));
            QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)nsrxx.getDate("skssqz")));
            QFilter q4 = new QFilter("deductionperiod", "=", (Object)String.valueOf(DateUtils.getMonthOfDate((Date)nsrxx.getDate("skssqq"))));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"deductionperiod", (QFilter[])new QFilter[]{q1, q2, q3, q4});
            Arrays.stream(load).forEach(e -> {
                e.set("deductionperiod", (Object)"0");
                prepayList.add(e);
            });
        }
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])prepayList.toArray(new DynamicObject[0]));
        this.updateSubEntryList(subEntryMap);
        nsrxxList.forEach(nxxObj -> DeclareMQSender.sendTaxableListMQ((DynamicObject)nxxObj, (Date)nxxObj.getDate("skssqq"), (Date)nxxObj.getDate("skssqz"), (String)DeclareMQType.DECLARE.name(), (String)DeclareMQEvent.CANCELAPPLY.name()));
        List sbbIds = nsrxxList.stream().map(d -> d.getString("id")).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)PAY_RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbIds)});
    }

    private void updateSubEntryList(Map<Long, List<DynamicObject>> subEntryMap) {
        if (EmptyCheckUtils.isNotEmpty(subEntryMap) && this.needUpdateSubEntry()) {
            ArrayList subEntryList = new ArrayList();
            subEntryMap.forEach((k, v) -> subEntryList.addAll(v));
            SaveServiceHelper.save((DynamicObject[])subEntryList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void manualPay(List<DynamicObject> nsrxxList) {
        List sbbIds = nsrxxList.stream().map(d -> d.getString("id")).collect(Collectors.toList());
        DynamicObject[] payRecords = BusinessDataServiceHelper.load((String)PAY_RECORD_ENTITY, (String)PAY_RECORD_ENTITY_ALL_FIELDS, (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbIds)});
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "id");
        Map<Long, DynamicObject> nsrxxMap = nsrxxList.stream().collect(Collectors.toMap(d -> d.getLong("id"), v -> v));
        for (DynamicObject payRecord : payRecords) {
            boolean gzsbFlag;
            DynamicObject nsrxx = nsrxxMap.get(payRecord.getLong("sbbid"));
            Date paydate = nsrxx.getDate("paydate") != null ? nsrxx.getDate("paydate") : new Date();
            boolean bl = gzsbFlag = !CollectionUtils.isEmpty(nsrxxList) && "gzsb".equals(nsrxxList.get(0).get("versiontype"));
            if (gzsbFlag && "1".equals(payRecord.get("paystatus"))) continue;
            BigDecimal ybtse = nsrxx.getBigDecimal("bqybtse");
            if (EmptyCheckUtils.isNotEmpty(subEntryMap)) {
                List<DynamicObject> subEntryList = nsrxx.getString("type").startsWith("qtsf_") ? subEntryMap.get(payRecord.getLong("sbbid")) : subEntryMap.get(payRecord.getLong("sbbentryid"));
                if (EmptyCheckUtils.isNotEmpty(subEntryList)) {
                    DynamicObject subEntry = subEntryList.get(0);
                    BigDecimal bqdybtse = nsrxx.getString("type").startsWith("qtsf_") ? subEntry.getBigDecimal("ybse") : (nsrxx.getString("type").equals("dkdj") ? ybtse : (nsrxx.getString("type").equals("kjqysds") ? ybtse : subEntry.getBigDecimal("bqdybtse")));
                    this.updatePayRecord(payRecord, "1", payRecord.getBigDecimal("yjje"), BigDecimal.ZERO, nsrxx.get("payer"), paydate);
                    if (this.needUpdateSubEntry()) {
                        if (nsrxx.getString("type").equals("dkdj")) {
                            subEntry.set("xsjje", (Object)bqdybtse);
                            subEntry.set("sjsezzs", (Object)BigDecimal.ZERO);
                        } else if (nsrxx.getString("type").equals("kjqysds")) {
                            subEntry.set("xsjje", (Object)bqdybtse);
                            subEntry.set("sjse", (Object)BigDecimal.ZERO);
                        } else {
                            subEntry.set(KEY_SJJE, (Object)bqdybtse);
                            subEntry.set(KEY_QJJE, (Object)BigDecimal.ZERO);
                        }
                    }
                }
            } else {
                this.updatePayRecord(payRecord, "1", payRecord.getBigDecimal("yjje"), BigDecimal.ZERO, nsrxx.get("payer"), paydate);
            }
            nsrxx.set(KEY_SJJE, (Object)ybtse);
            nsrxx.set(KEY_QJJE, (Object)BigDecimal.ZERO);
        }
        DefaultPayRecordSaveSubPlugin saveSubPlugin = new DefaultPayRecordSaveSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)saveSubPlugin, IPayRecordSaveSubPlugin.class, (String)"kd.taxc.bdtaxr.mservice.api.applypay.DeclarePayService", null);
        PayRecordSaveBeforeArgs beforeArgs = new PayRecordSaveBeforeArgs();
        beforeArgs.setOperateKey(PAY);
        List<Long> payRecordIds = Stream.of(payRecords).map(o -> o.getLong("id")).collect(Collectors.toList());
        beforeArgs.setPayRecordIds(payRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.beforeSave(beforeArgs);
            return null;
        });
        Object[] save = SaveServiceHelper.save((DynamicObject[])payRecords);
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        this.updateSubEntryList(subEntryMap);
        for (DynamicObject nsrxx : nsrxxList) {
            DeclareMQSender.sendMQ((DynamicObject)nsrxx, (Date)AbstractDeclarePayService.getPayDate(nsrxx), (String)DeclareMQType.PAY.name(), (String)PAY);
        }
        PayRecordSaveAfterArgs afterArgs = new PayRecordSaveAfterArgs();
        List<Long> savedPayRecordIds = Stream.of(save).map(o -> (DynamicObject)o).map(o -> o.getLong("id")).collect(Collectors.toList());
        afterArgs.setOperateKey(PAY);
        afterArgs.setPayRecordIds(savedPayRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterSave(afterArgs);
            return null;
        });
    }

    @Override
    public void cancelPay(List<DynamicObject> nsrxxList) {
        List sbbIds = nsrxxList.stream().map(d -> d.getString("id")).collect(Collectors.toList());
        DynamicObject[] payRecords = BusinessDataServiceHelper.load((String)PAY_RECORD_ENTITY, (String)PAY_RECORD_ENTITY_ALL_FIELDS, (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbIds)});
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "id");
        Map<Long, DynamicObject> nsrxxMap = nsrxxList.stream().collect(Collectors.toMap(d -> d.getLong("id"), v -> v));
        for (DynamicObject payRecord : payRecords) {
            List<DynamicObject> subEntryList;
            DynamicObject nsrxx = nsrxxMap.get(payRecord.getLong("sbbid"));
            BigDecimal ybtse = nsrxx.getBigDecimal("bqybtse");
            this.updatePayRecord(payRecord, "2", BigDecimal.ZERO, payRecord.getBigDecimal("yjje"), null, null);
            if (EmptyCheckUtils.isNotEmpty(subEntryMap) && EmptyCheckUtils.isNotEmpty(subEntryList = subEntryMap.get(payRecord.getLong("sbbentryid")))) {
                DynamicObject subEntry = subEntryList.get(0);
                BigDecimal bqdybtse = nsrxx.getString("type").equals("dkdj") ? ybtse : (nsrxx.getString("type").equals("kjqysds") ? ybtse : subEntry.getBigDecimal("bqdybtse"));
                if (this.needUpdateSubEntry()) {
                    if (nsrxx.getString("type").equals("dkdj")) {
                        subEntry.set("xsjje", (Object)BigDecimal.ZERO);
                        subEntry.set("sjsezzs", (Object)bqdybtse);
                    } else if (nsrxx.getString("type").equals("kjqysds")) {
                        subEntry.set("xsjje", (Object)BigDecimal.ZERO);
                        subEntry.set("sjse", (Object)bqdybtse);
                    } else {
                        subEntry.set(KEY_SJJE, (Object)BigDecimal.ZERO);
                        subEntry.set(KEY_QJJE, (Object)bqdybtse);
                    }
                }
            }
            nsrxx.set(KEY_SJJE, (Object)BigDecimal.ZERO);
            nsrxx.set(KEY_QJJE, (Object)ybtse);
        }
        DefaultPayRecordSaveSubPlugin saveSubPlugin = new DefaultPayRecordSaveSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)saveSubPlugin, IPayRecordSaveSubPlugin.class, (String)"kd.taxc.bdtaxr.mservice.api.applypay.DeclarePayService", null);
        PayRecordSaveBeforeArgs beforeArgs = new PayRecordSaveBeforeArgs();
        beforeArgs.setOperateKey(CANCEL_PAY);
        List<Long> payRecordIds = Stream.of(payRecords).map(o -> o.getLong("id")).collect(Collectors.toList());
        beforeArgs.setPayRecordIds(payRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.beforeSave(beforeArgs);
            return null;
        });
        Object[] save = SaveServiceHelper.save((DynamicObject[])payRecords);
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        this.updateSubEntryList(subEntryMap);
        for (DynamicObject nsrxx : nsrxxList) {
            DeclareMQSender.sendMQ((DynamicObject)nsrxx, (Date)AbstractDeclarePayService.getPayDate(nsrxx), (String)DeclareMQType.PAY.name(), (String)"cancelpay");
        }
        PayRecordSaveAfterArgs afterArgs = new PayRecordSaveAfterArgs();
        List<Long> savedPayRecordIds = Stream.of(save).map(o -> (DynamicObject)o).map(o -> o.getLong("id")).collect(Collectors.toList());
        afterArgs.setOperateKey(CANCEL_PAY);
        afterArgs.setPayRecordIds(savedPayRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterSave(afterArgs);
            return null;
        });
    }

    public void packRecordData(List<DynamicObject> payRecordList, DynamicObject nsrxx, DynamicObject subEntry) {
        if (subEntry == null) {
            this.packRecordData(payRecordList, nsrxx, null, this.getTaxType(nsrxx, subEntry), nsrxx.getBigDecimal("bqybtse"), nsrxx.getString("taxlimit"));
        } else {
            BigDecimal bqybtse = nsrxx.getString("type").startsWith("qtsf_") ? subEntry.getBigDecimal("ybse") : (nsrxx.getString("type").equals("dkdj") ? nsrxx.getBigDecimal("bqybtse") : (nsrxx.getString("type").equals("kjqysds") ? nsrxx.getBigDecimal("bqybtse") : subEntry.getBigDecimal("bqdybtse")));
            String taxlimit = nsrxx.getString("taxlimit");
            Date skssqq = nsrxx.getDate("skssqq");
            Date skssqz = nsrxx.getDate("skssqz");
            String taxType = this.getTaxType(nsrxx, subEntry);
            if (CalendarTaxType.FJSF.getType().equals(taxType)) {
                for (String taxtype : TaxTypeUtils.FJSF_SPLIT) {
                    long entryid = subEntry.getLong("id");
                    boolean exists = QueryServiceHelper.exists((String)PAY_RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter("sbbentryid", "=", (Object)entryid), new QFilter("taxtype", "=", (Object)taxtype)});
                    if (exists) continue;
                    this.packRecordData(payRecordList, nsrxx, subEntry, taxtype, DeclarePayHelper.queryFjsfSubAmt(nsrxx.getString("id"), taxtype, nsrxx.getString("type")), taxlimit);
                }
            } else if ("zzsybnsr_ybhz".equals(nsrxx.getString("type")) && CalendarTaxType.ZZS.getType().equals(taxType)) {
                String sbbid = nsrxx.getString("id");
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvat_ybqyhzsb_fpb", (String)"lwfpse,jzjtfpse,ysfwfpse,ysfwjzjtfpse", (QFilter[])new QFilter[]{new QFilter("ewblxh", "=", (Object)"1"), new QFilter("sbbid", "=", (Object)sbbid)});
                if (dynamicObject != null) {
                    bqybtse = dynamicObject.getBigDecimal("lwfpse").add(dynamicObject.getBigDecimal("jzjtfpse")).add(dynamicObject.getBigDecimal("ysfwfpse")).add(dynamicObject.getBigDecimal("ysfwjzjtfpse"));
                }
                this.packRecordData(payRecordList, nsrxx, subEntry, taxType, bqybtse, taxlimit);
                DynamicObjectCollection fzjgCollections = QueryServiceHelper.query((String)"tcvat_ybqyhzsb_fzjg", (String)"nsrsbh,fpse,jzjtfpse,ysfwfpse,ysfwjzjtfpse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
                if (!fzjgCollections.isEmpty()) {
                    for (DynamicObject fzjgCollection : fzjgCollections) {
                        String nsrsbh = fzjgCollection.getString("nsrsbh");
                        if (StringUtils.isBlank((CharSequence)nsrsbh)) continue;
                        BigDecimal zzs = fzjgCollection.getBigDecimal("fpse").add(fzjgCollection.getBigDecimal("jzjtfpse")).add(fzjgCollection.getBigDecimal("ysfwfpse")).add(fzjgCollection.getBigDecimal("ysfwjzjtfpse"));
                        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)nsrsbh).getData();
                        if (taxMain == null) continue;
                        DynamicObject fzjg = new DynamicObject(nsrxx.getDynamicObjectType());
                        fzjg.set("nsrsbh", (Object)nsrsbh);
                        fzjg.set("id", nsrxx.get("id"));
                        fzjg.set("billno", nsrxx.get("billno"));
                        fzjg.set("skssqq", nsrxx.get("skssqq"));
                        fzjg.set("skssqz", nsrxx.get("skssqz"));
                        fzjg.set("type", nsrxx.get("type"));
                        fzjg.set("declaredate", nsrxx.get("declaredate"));
                        fzjg.set("org", taxMain.get("taxorg.id"));
                        fzjg.set("taxauthority", taxMain.get("taxoffice.id"));
                        this.packRecordData(payRecordList, fzjg, subEntry, "zzs", zzs, taxlimit);
                        for (String taxtype : TaxTypeUtils.FJSF_SPLIT) {
                            String param = this.getPolicyParams(taxtype.toUpperCase(), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz), taxMain.getString("taxorg.id"));
                            BigDecimal ybtse = zzs.multiply(new BigDecimal(param)).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
                            this.packRecordData(payRecordList, fzjg, subEntry, taxtype, ybtse, taxlimit);
                        }
                    }
                }
            } else {
                this.packRecordData(payRecordList, nsrxx, subEntry, taxType, bqybtse, taxlimit);
            }
        }
    }

    protected void packRecordData(List<DynamicObject> payRecordList, DynamicObject sbb, DynamicObject subEntry, String taxtype, BigDecimal ybtse, String taxlimit) {
        DynamicObject dyo;
        Date skssqq = null;
        Date skssqz = null;
        String zszm = " ";
        if (ybtse.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Object org = sbb.get("org");
        long orgId = org instanceof Long ? ((Long)org).longValue() : ((DynamicObject)org).getLong("id");
        Object sbbid = sbb.get("id");
        Long sbbEntryId = subEntry == null ? 0L : subEntry.getLong("id");
        DynamicObject payRecord = BusinessDataServiceHelper.newDynamicObject((String)PAY_RECORD_ENTITY);
        DynamicObjectCollection entryentity = payRecord.getDynamicObjectCollection("entryentity");
        String number = CodeRuleServiceHelper.getNumber((String)PAY_RECORD_ENTITY, (DynamicObject)payRecord, (String)String.valueOf(orgId));
        String nsrtype = sbb.getString("type");
        payRecord.set("billno", (Object)number);
        payRecord.set("yjje", (Object)ybtse);
        payRecord.set("jkbl", (Object)BigDecimal.ONE);
        payRecord.set("paystatus", (Object)"2");
        if ("zzsyjskb".equals(nsrtype)) {
            payRecord.set("sbbno", (Object)sbb.getString("serialno"));
        } else {
            payRecord.set("sbbno", (Object)sbb.getString("billno"));
        }
        payRecord.set("taxtype", (Object)taxtype);
        payRecord.set(KEY_SJJE, (Object)BigDecimal.ZERO);
        payRecord.set("syqjje", (Object)ybtse);
        payRecord.set("sbbid", sbbid);
        payRecord.set("sbbentryid", (Object)sbbEntryId);
        Long accountOrg = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)orgId).getData();
        payRecord.set("accountorg", (Object)accountOrg);
        payRecord.set("org", (Object)orgId);
        if (TCRET_TAXTYPE.contains(taxtype) && sbbEntryId != 0L) {
            skssqq = subEntry.getDate("skssqq");
            skssqz = subEntry.getDate("skssqz");
            payRecord.set("skssqq", (Object)skssqq);
            payRecord.set("skssqz", (Object)skssqz);
        } else if (TemplateTypeConstant.TOTF_TAXTYPE.contains(taxtype) && sbbEntryId != 0L) {
            skssqq = subEntry.getDate("startdate");
            skssqz = subEntry.getDate("enddate");
            payRecord.set("skssqq", (Object)skssqq);
            payRecord.set("skssqz", (Object)skssqz);
        } else if (TemplateTypeConstant.TOTF_TAXTYPE_STBCBCF.contains(taxtype) && sbbEntryId != 0L) {
            skssqq = subEntry.getDate("startdate");
            skssqz = subEntry.getDate("enddate");
            payRecord.set("skssqq", (Object)skssqq);
            payRecord.set("skssqz", (Object)skssqz);
            zszm = subEntry.getString("zszm");
        } else {
            skssqq = sbb.getDate("skssqq");
            skssqz = sbb.getDate("skssqz");
            payRecord.set("skssqq", (Object)skssqq);
            payRecord.set("skssqz", (Object)skssqz);
        }
        String skssqqStr = DateUtils.format((Date)payRecord.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
        String skssqzStr = DateUtils.format((Date)payRecord.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
        payRecord.set("sssq", (Object)skssqqStr.concat("-").concat(skssqzStr));
        payRecord.set("nsrtype", (Object)nsrtype);
        payRecord.set("billstatus", (Object)"C");
        if (null != sbb && TCNFEP_ITEM.contains(taxtype)) {
            payRecord.set("deadline", (Object)DateUtils.addDay((Date)skssqz, (int)7));
        } else if (null != sbb) {
            Date declaredate = sbb.getDate("declaredate");
            Long taxauthorityId = sbb.get("taxauthority") instanceof DynamicObject ? sbb.getDynamicObject("taxauthority").getLong("id") : sbb.getLong("taxauthority");
            Date deadline = PayDateUtils.getPayDate((Date)declaredate, (Long)taxauthorityId, (String)nsrtype, (Date)skssqz);
            payRecord.set("deadline", (Object)deadline);
        }
        Object taxauthority = sbb.get("taxauthority");
        if ("zzsyjskb".equals(sbb.getString("type")) && (dyo = QueryServiceHelper.queryOne((String)"tcvat_prepay_declare_bill", (String)"prepayproject.taxoffice as taxoffice", (QFilter[])new QFilter[]{new QFilter("id", "=", sbbid)})) != null) {
            taxauthority = dyo.get("taxoffice");
        }
        payRecord.set("taxauthority", taxauthority);
        this.updateFormEntity(payRecord, entryentity, taxtype, ybtse, BigDecimal.ZERO, ybtse, sbb, skssqq, skssqz, orgId, zszm);
        payRecordList.add(payRecord);
    }

    private void updatePayRecord(DynamicObject payRecord, String payStatus, BigDecimal sjje, BigDecimal syqjje, Object payer, Date payDate) {
        payRecord.set("paystatus", (Object)payStatus);
        payRecord.set(KEY_SJJE, (Object)sjje);
        payRecord.set("syqjje", (Object)syqjje);
        payRecord.set("payer", payer);
        payRecord.set("paydate", (Object)payDate);
        payRecord.set("entrydate", (Object)payDate);
        DynamicObjectCollection entryentity = payRecord.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            for (DynamicObject dynamicObject : entryentity) {
                BigDecimal yjjemx;
                if ("1".equals(payStatus)) {
                    yjjemx = dynamicObject.getBigDecimal("yjjemx");
                    dynamicObject.set("sjjemx", (Object)yjjemx);
                    dynamicObject.set("syqjjemx", (Object)BigDecimal.ZERO);
                    continue;
                }
                yjjemx = dynamicObject.getBigDecimal("yjjemx");
                dynamicObject.set("syqjjemx", (Object)yjjemx);
                dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
            }
            PayRecordUtils.setZnj((DynamicObject)payRecord);
        }
    }

    private void updateFormEntity(DynamicObject payRecord, DynamicObjectCollection entryentity, String taxtype, Object yjje, Object sjje, Object syqjje, DynamicObject nsrxx, Date skssqq, Date skssqz, long orgId, String zszm) {
        long sbbid = nsrxx.getLong("id");
        String nsrtype = nsrxx.getString("type");
        if (singleItem.contains(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)taxtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
            if (TemplateTypeConstant.TOTF_TAXTYPE_STBCBCF.contains(taxtype)) {
                dynamicObject.set("zszm", (Object)zszm);
            }
        } else if ("szys_a".equals(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)nsrtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
        } else if ("ccxws".equals(nsrtype)) {
            MultiLangEnumBridge multiLangEnumBridge;
            String taxname = null;
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbid));
            QFilter skssqqFilter = new QFilter("startdate", "=", (Object)skssqq);
            QFilter skssqzFilter = new QFilter("enddate", "=", (Object)skssqz);
            if ("zys".equals(taxtype)) {
                taxtype = "tcrt";
            }
            if ("ccs".equals(taxtype)) {
                taxtype = "tcvvt";
            }
            if ("hbs".equals(taxtype)) {
                taxtype = "tcept";
            }
            if ("szys".equals(taxtype)) {
                taxtype = "tcwat";
            }
            if (null != (multiLangEnumBridge = DeclareTaxType.nssbMatchBaseName((String)taxtype))) {
                taxname = multiLangEnumBridge.loadKDString();
            }
            String datatype = nsrxx.getString("datatype");
            Long baseTaxtype = DeclareTaxType.nssbMatchBaseId((String)taxtype);
            if ("1".equals(datatype) && baseTaxtype != null && this.checkDimension(orgId, baseTaxtype, skssqq, skssqz)) {
                CcxwsDimensionPayService dimensionPayService = CcxwsDimensionPayServiceFactory.createService(baseTaxtype);
                if (dimensionPayService != null) {
                    dimensionPayService.generateEntryEntity(payRecord, entryentity, sbbid);
                }
            } else {
                QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)taxname);
                DynamicObject[] sbb = BusinessDataServiceHelper.load((String)"tcret_ccxws_zb_hb", (String)"taxtype,startdate,enddate,ybse,sm", (QFilter[])new QFilter[]{sbbidFilter, taxtypeFilter, skssqqFilter, skssqzFilter});
                HashMap<String, DynamicObject> sbbMap = new HashMap<String, DynamicObject>(8);
                for (DynamicObject object : sbb) {
                    String type = object.getString("taxtype");
                    String startdate = DateUtils.format((Date)object.getDate("startdate"));
                    String enddate = DateUtils.format((Date)object.getDate("enddate"));
                    String sm = object.getString("sm");
                    String key = type + startdate + enddate + sm;
                    DynamicObject object1 = (DynamicObject)sbbMap.get(key);
                    if (object1 == null) {
                        sbbMap.put(key, object);
                        continue;
                    }
                    object1.set("ybse", (Object)object1.getBigDecimal("ybse").add(object.getBigDecimal("ybse")));
                }
                for (Map.Entry entry : sbbMap.entrySet()) {
                    DynamicObject object = (DynamicObject)entry.getValue();
                    DynamicObject dynamicObject = entryentity.addNew();
                    dynamicObject.set("taxitem", (Object)object.getString("sm"));
                    BigDecimal yjjemx = object.getBigDecimal("ybse");
                    dynamicObject.set("yjjemx", (Object)yjjemx);
                    dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
                    dynamicObject.set("syqjjemx", (Object)yjjemx);
                    dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
                    dynamicObject.set("accorg", payRecord.get("accountorg"));
                }
            }
        } else if (TCNFEP_ITEM.contains(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)taxtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
        }
    }

    private boolean checkDimension(long orgId, long taxtype, Date skssqq, Date skssqz) {
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)taxtype, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz);
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
            return entry.getBoolean("ruleentity.rule.isdimprovision");
        }
        return false;
    }

    private String getPolicyParams(String param, String startdate, String enddate, String orgId) {
        List paramList = AssistService.queryAssistParams((String)param, (String)orgId, (String)startdate, (String)enddate);
        if (paramList.size() > 0) {
            return (String)paramList.get(0);
        }
        return "0";
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)PAY_RECORD_ENTITY, (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }
}

