/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.pay.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.pay.IDeclarePayService;
import kd.taxc.bdtaxr.business.pay.impl.AbstractDeclarePayService;
import kd.taxc.bdtaxr.business.subplugin.IPayRecordSaveSubPlugin;
import kd.taxc.bdtaxr.business.subplugin.args.PayRecordSaveAfterArgs;
import kd.taxc.bdtaxr.business.subplugin.args.PayRecordSaveBeforeArgs;
import kd.taxc.bdtaxr.business.subplugin.impl.DefaultPayRecordSaveSubPlugin;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.enums.CalendarTaxType;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.PayRecordUtils;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public abstract class AbstractMultiDeclarePayService
implements IDeclarePayService {
    private static final Log logger = LogFactory.getLog(AbstractDeclarePayService.class);
    public static final String PAY_RECORD_ENTITY = "bdtaxr_pay_record";
    public static String PAY_RECORD_ENTITY_ALL_FIELDS = "billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,hjsqid,sbbentryid,sbbid,isvoucher,sssq,operatetime,operator,yjje,jkbl,paystatus,deadline,sjje,syqjje,payer,paydate,taxtype,skssqq,skssqz,nsrtype,voucherno,taxauthority,sbbno,yspzno,electrictaxno,accountorg,entrydate,entryentity.taxitem,entryentity.yjjemx,entryentity.sjjemx,entryentity.syqjjemx,entryentity.delaypay,entryentity.accorg,entryentity.bizdimensiontype,entryentity.bizdimensionname,entryentity.bizdimensionid,id,entryentity.id,entryentity.seq";
    public static final String DECLARE = "declare";
    public static final String CANCEL_DECLARE = "cancelDeclare";
    public static final String PAY = "pay";
    public static final String CANCEL_PAY = "cancelPay";
    public static final String KEY_SJJE = "sjje";
    public static final String KEY_QJJE = "qjje";
    public static final List<String> TCRET_TAXTYPE = Arrays.asList(CalendarTaxType.YHS.getType(), CalendarTaxType.FCS.getType(), CalendarTaxType.CZTDSYS.getType(), CalendarTaxType.HBS.getType(), CalendarTaxType.ZYS.getType(), CalendarTaxType.CCS.getType(), CalendarTaxType.QS.getType(), CalendarTaxType.CLGZS.getType(), CalendarTaxType.GDZYS.getType(), CalendarTaxType.TDZZS.getType(), CalendarTaxType.YYS.getType());
    private static List<String> singleItem = Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "fjsf", "qysdsjb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_jb", "qysds_hdzs_nb", "yhs", "fcs", "cztdsys", "fcscztdsys", "fcsprice", "fcshire", "tvpt", "tcvvt", "tcept", "yys", "tcrt", "zzsyjskb", "qtsf_tysbb", "qtsf_fsstysbb", "whsyjsf", "totf_cjrjybzj");
    private static final List<String> TCNFEP_ITEM = Arrays.asList("dkdj", "kjqysds");

    public abstract Map<Long, List<DynamicObject>> getSubEntryMap(List<DynamicObject> var1, String var2);

    public abstract boolean needUpdateSubEntry();

    public abstract String getTaxType(DynamicObject var1, DynamicObject var2);

    @Override
    public void manualDeclare(List<DynamicObject> nsrxxList) {
        List pkIdList;
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "sbbid");
        ArrayList<DynamicObject> payRecordList = new ArrayList<DynamicObject>();
        boolean flag = false;
        for (DynamicObject nsrxx : nsrxxList) {
            DynamicObject templatetype = (DynamicObject)nsrxx.get("templatetype");
            String type = templatetype.getString("number");
            if (nsrxxList.size() == 1 && "gzsb".equals(nsrxx.get("versiontype")) && PayRecordUtils.havePayRecord((DynamicObject)nsrxxList.get(0))) {
                flag = true;
                if (!"ccxws".equals(type)) break;
            }
            List<DynamicObject> subEntryList = subEntryMap.get(nsrxx.getLong("id"));
            BigDecimal totalybtse = BigDecimal.ZERO;
            if (EmptyCheckUtils.isNotEmpty(subEntryList)) {
                Iterator<DynamicObject> iterator = subEntryList.iterator();
                while (iterator.hasNext()) {
                    boolean exists;
                    DynamicObject subEntry = iterator.next();
                    if (!flag && (exists = QueryServiceHelper.exists((String)PAY_RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter("sbbentryid", "=", (Object)subEntry.getLong("id"))}))) continue;
                    BigDecimal ybtse = type.startsWith("qtsf_") ? subEntry.getBigDecimal("ybse") : (type.equals("dkdj") ? nsrxx.getBigDecimal("bqybtse") : (type.equals("kjqysds") ? nsrxx.getBigDecimal("bqybtse") : subEntry.getBigDecimal("bqdybtse")));
                    totalybtse = BigDecimalUtil.addObject((Object)totalybtse, (Object)ybtse);
                    if (this.needUpdateSubEntry()) {
                        subEntry.set(KEY_SJJE, (Object)BigDecimal.ZERO);
                        subEntry.set(KEY_QJJE, (Object)ybtse);
                    }
                    this.packRecordData(payRecordList, nsrxx, subEntry);
                }
                continue;
            }
            boolean exists = QueryServiceHelper.exists((String)PAY_RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)nsrxx.getString("id"))});
            if (exists) continue;
            totalybtse = nsrxx.getBigDecimal("bqybtse");
            this.packRecordData(payRecordList, nsrxx, null);
        }
        if (flag) {
            DynamicObject templatetype = (DynamicObject)nsrxxList.get(0).get("templatetype");
            String type = templatetype.getString("number");
            List<DynamicObject> subEntryList = subEntryMap.get(nsrxxList.get(0).getLong("id"));
            ArrayList<DynamicObject> saveRecords = new ArrayList<DynamicObject>();
            if (EmptyCheckUtils.isNotEmpty(subEntryList)) {
                for (DynamicObject sub : subEntryList) {
                    BigDecimal bqybtse = type.startsWith("qtsf_") ? sub.getBigDecimal("ybse") : sub.getBigDecimal("bqdybtse");
                    QFilter[] qFilters = new QFilter[]{new QFilter("sbbentryid", "=", sub.get("id"))};
                    this.buildPayRecord(saveRecords, qFilters, bqybtse);
                }
            } else {
                DynamicObject object = nsrxxList.get(0);
                QFilter[] qFilters = new QFilter[]{new QFilter("sbbid", "=", (Object)object.getString("id"))};
                this.buildPayRecord(saveRecords, qFilters, object.getBigDecimal("bqybtse"));
            }
            SaveServiceHelper.save((DynamicObject[])saveRecords.toArray(new DynamicObject[0]));
            try {
                pkIdList = saveRecords.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                boolean writeBill = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)PAY_RECORD_ENTITY, (String)"audit", pkIdList, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
                logger.info("\u51ed\u8bc1\u767d\u540d\u5355\u5199\u5165\u7ed3\u679c\uff1a" + writeBill);
            }
            catch (Exception e2) {
                throw new KDBizException("generatevoucher error!");
            }
        }
        DefaultPayRecordSaveSubPlugin saveSubPlugin = new DefaultPayRecordSaveSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)saveSubPlugin, IPayRecordSaveSubPlugin.class, (String)"kd.taxc.bdtaxr.mservice.api.applypay.DeclarePayService", null);
        PayRecordSaveBeforeArgs beforeArgs = new PayRecordSaveBeforeArgs();
        beforeArgs.setOperateKey(DECLARE);
        pluginProxy.callReplaceIfPresent(p -> {
            p.beforeSave(beforeArgs);
            return null;
        });
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        Object[] save = SaveServiceHelper.save((DynamicObject[])payRecordList.toArray(new DynamicObject[0]));
        try {
            pkIdList = payRecordList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            boolean writeBill = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)PAY_RECORD_ENTITY, (String)"audit", pkIdList, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
            logger.info("\u51ed\u8bc1\u767d\u540d\u5355\u5199\u5165\u7ed3\u679c\uff1a" + writeBill);
        }
        catch (Exception e3) {
            throw new KDBizException("generatevoucher error!");
        }
        this.updateSubEntryList(subEntryMap);
        PayRecordSaveAfterArgs afterArgs = new PayRecordSaveAfterArgs();
        List<Long> payRecordIds = Stream.of(save).map(o -> (DynamicObject)o).map(o -> o.getLong("id")).collect(Collectors.toList());
        afterArgs.setOperateKey(DECLARE);
        afterArgs.setPayRecordIds(payRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterSave(afterArgs);
            return null;
        });
    }

    private void buildPayRecord(List<DynamicObject> saveRecords, QFilter[] qFilters, BigDecimal bqybtse) {
        BigDecimal yjjeSum;
        DynamicObject[] records = BusinessDataServiceHelper.load((String)PAY_RECORD_ENTITY, (String)PAY_RECORD_ENTITY_ALL_FIELDS, (QFilter[])qFilters);
        if (records != null && records.length > 0 && bqybtse.compareTo(yjjeSum = Arrays.asList(records).stream().map(d -> d.getBigDecimal("yjje")).reduce(BigDecimal.ZERO, BigDecimal::add)) > 0) {
            BigDecimal subtract = bqybtse.subtract(yjjeSum);
            DynamicObject subtractrecord = records[0];
            long[] ids = DBUtils.getLongIds((String)PAY_RECORD_ENTITY, (int)1);
            subtractrecord.set("id", (Object)ids[0]);
            subtractrecord.set("yjje", (Object)subtract);
            subtractrecord.set(KEY_SJJE, (Object)BigDecimal.ZERO);
            subtractrecord.set("syqjje", (Object)subtract);
            subtractrecord.set("paystatus", (Object)"2");
            subtractrecord.set("isvoucher", (Object)"0");
            subtractrecord.set("voucherno", (Object)" ");
            String number = CodeRuleServiceHelper.getNumber((String)PAY_RECORD_ENTITY, (DynamicObject)subtractrecord, (String)subtractrecord.getDynamicObject("org").getString("id"));
            subtractrecord.set("billno", (Object)number);
            subtractrecord.set("paydate", null);
            DynamicObjectCollection entryentitys = subtractrecord.getDynamicObjectCollection("entryentity");
            entryentitys.forEach(one -> {
                long[] ids1 = DBUtils.getLongIds((String)PAY_RECORD_ENTITY, (int)1);
                one.set("id", (Object)ids1[0]);
                one.set("syqjjemx", (Object)subtract);
                one.set("sjjemx", (Object)BigDecimal.ZERO);
                one.set("yjjemx", (Object)subtract);
            });
            DynamicObject subtractrecord2 = BusinessDataServiceHelper.newDynamicObject((String)PAY_RECORD_ENTITY);
            BeanCopyUtils.copyDynamicObject((DynamicObject)subtractrecord, (DynamicObject)subtractrecord2);
            saveRecords.add(subtractrecord2);
        }
    }

    @Override
    public void cancelDeclare(List<DynamicObject> nsrxxList) {
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "sbbid");
        for (DynamicObject nsrxx : nsrxxList) {
            List<DynamicObject> subEntryList = subEntryMap.get(nsrxx.getLong("id"));
            if (!EmptyCheckUtils.isNotEmpty(subEntryList) || !this.needUpdateSubEntry()) continue;
            subEntryList.forEach(subEntry -> {
                subEntry.set(KEY_SJJE, (Object)BigDecimal.ZERO);
                subEntry.set(KEY_QJJE, (Object)BigDecimal.ZERO);
            });
        }
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        this.updateSubEntryList(subEntryMap);
        List sbbIds = nsrxxList.stream().map(d -> d.getString("id")).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)PAY_RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbIds)});
    }

    private void updateSubEntryList(Map<Long, List<DynamicObject>> subEntryMap) {
        if (EmptyCheckUtils.isNotEmpty(subEntryMap) && this.needUpdateSubEntry()) {
            ArrayList subEntryList = new ArrayList();
            subEntryMap.forEach((k, v) -> subEntryList.addAll(v));
            SaveServiceHelper.save((DynamicObject[])subEntryList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void manualPay(List<DynamicObject> nsrxxList) {
        List sbbIds = nsrxxList.stream().map(d -> d.getString("id")).collect(Collectors.toList());
        DynamicObject[] payRecords = BusinessDataServiceHelper.load((String)PAY_RECORD_ENTITY, (String)PAY_RECORD_ENTITY_ALL_FIELDS, (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbIds)});
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "id");
        Map<Long, DynamicObject> nsrxxMap = nsrxxList.stream().collect(Collectors.toMap(d -> d.getLong("id"), v -> v));
        for (DynamicObject payRecord : payRecords) {
            boolean gzsbFlag;
            DynamicObject nsrxx = nsrxxMap.get(payRecord.getLong("sbbid"));
            Date paydate = nsrxx.getDate("paydate") != null ? nsrxx.getDate("paydate") : new Date();
            boolean bl = gzsbFlag = !CollectionUtils.isEmpty(nsrxxList) && "gzsb".equals(nsrxxList.get(0).get("versiontype"));
            if (gzsbFlag && "1".equals(payRecord.get("paystatus"))) continue;
            BigDecimal ybtse = nsrxx.getBigDecimal("bqybtse");
            if (EmptyCheckUtils.isNotEmpty(subEntryMap)) {
                DynamicObject templatetype = (DynamicObject)nsrxx.get("templatetype");
                String type = templatetype.getString("number");
                List<DynamicObject> subEntryList = type.startsWith("qtsf_") ? subEntryMap.get(payRecord.getLong("sbbid")) : subEntryMap.get(payRecord.getLong("sbbentryid"));
                if (!EmptyCheckUtils.isNotEmpty(subEntryList)) continue;
                DynamicObject subEntry = subEntryList.get(0);
                BigDecimal bqdybtse = type.startsWith("qtsf_") ? subEntry.getBigDecimal("ybse") : (type.equals("dkdj") ? ybtse : (type.equals("kjqysds") ? ybtse : subEntry.getBigDecimal("bqdybtse")));
                this.updatePayRecord(payRecord, "1", payRecord.getBigDecimal("yjje"), BigDecimal.ZERO, nsrxx.get("payer"), paydate);
                if (!this.needUpdateSubEntry()) continue;
                if (type.equals("dkdj")) {
                    subEntry.set("xsjje", (Object)bqdybtse);
                    subEntry.set("sjsezzs", (Object)BigDecimal.ZERO);
                    continue;
                }
                if (type.equals("kjqysds")) {
                    subEntry.set("xsjje", (Object)bqdybtse);
                    subEntry.set("sjse", (Object)BigDecimal.ZERO);
                    continue;
                }
                subEntry.set(KEY_SJJE, (Object)bqdybtse);
                subEntry.set(KEY_QJJE, (Object)BigDecimal.ZERO);
                continue;
            }
            this.updatePayRecord(payRecord, "1", payRecord.getBigDecimal("yjje"), BigDecimal.ZERO, nsrxx.get("payer"), paydate);
        }
        DefaultPayRecordSaveSubPlugin saveSubPlugin = new DefaultPayRecordSaveSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)saveSubPlugin, IPayRecordSaveSubPlugin.class, (String)"kd.taxc.bdtaxr.mservice.api.applypay.DeclarePayService", null);
        PayRecordSaveBeforeArgs beforeArgs = new PayRecordSaveBeforeArgs();
        beforeArgs.setOperateKey(PAY);
        List<Long> payRecordIds = Stream.of(payRecords).map(o -> o.getLong("id")).collect(Collectors.toList());
        beforeArgs.setPayRecordIds(payRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.beforeSave(beforeArgs);
            return null;
        });
        Object[] save = SaveServiceHelper.save((DynamicObject[])payRecords);
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        this.updateSubEntryList(subEntryMap);
        PayRecordSaveAfterArgs afterArgs = new PayRecordSaveAfterArgs();
        List<Long> savedPayRecordIds = Stream.of(save).map(o -> (DynamicObject)o).map(o -> o.getLong("id")).collect(Collectors.toList());
        afterArgs.setOperateKey(PAY);
        afterArgs.setPayRecordIds(savedPayRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterSave(afterArgs);
            return null;
        });
    }

    @Override
    public void cancelPay(List<DynamicObject> nsrxxList) {
        List sbbIds = nsrxxList.stream().map(d -> d.getString("id")).collect(Collectors.toList());
        DynamicObject[] payRecords = BusinessDataServiceHelper.load((String)PAY_RECORD_ENTITY, (String)PAY_RECORD_ENTITY_ALL_FIELDS, (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbIds)});
        Map<Long, List<DynamicObject>> subEntryMap = this.getSubEntryMap(nsrxxList, "id");
        Map<Long, DynamicObject> nsrxxMap = nsrxxList.stream().collect(Collectors.toMap(d -> d.getLong("id"), v -> v));
        for (DynamicObject payRecord : payRecords) {
            List<DynamicObject> subEntryList;
            DynamicObject nsrxx = nsrxxMap.get(payRecord.getLong("sbbid"));
            DynamicObject templatetype = (DynamicObject)nsrxx.get("templatetype");
            String type = templatetype.getString("number");
            BigDecimal ybtse = nsrxx.getBigDecimal("bqybtse");
            this.updatePayRecord(payRecord, "2", BigDecimal.ZERO, payRecord.getBigDecimal("yjje"), null, null);
            if (!EmptyCheckUtils.isNotEmpty(subEntryMap) || !EmptyCheckUtils.isNotEmpty(subEntryList = subEntryMap.get(payRecord.getLong("sbbentryid")))) continue;
            DynamicObject subEntry = subEntryList.get(0);
            BigDecimal bqdybtse = type.equals("dkdj") ? ybtse : (type.equals("kjqysds") ? ybtse : subEntry.getBigDecimal("bqdybtse"));
            if (!this.needUpdateSubEntry()) continue;
            if (type.equals("dkdj")) {
                subEntry.set("xsjje", (Object)BigDecimal.ZERO);
                subEntry.set("sjsezzs", (Object)bqdybtse);
                continue;
            }
            if (type.equals("kjqysds")) {
                subEntry.set("xsjje", (Object)BigDecimal.ZERO);
                subEntry.set("sjse", (Object)bqdybtse);
                continue;
            }
            subEntry.set(KEY_SJJE, (Object)BigDecimal.ZERO);
            subEntry.set(KEY_QJJE, (Object)bqdybtse);
        }
        DefaultPayRecordSaveSubPlugin saveSubPlugin = new DefaultPayRecordSaveSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)saveSubPlugin, IPayRecordSaveSubPlugin.class, (String)"kd.taxc.bdtaxr.mservice.api.applypay.DeclarePayService", null);
        PayRecordSaveBeforeArgs beforeArgs = new PayRecordSaveBeforeArgs();
        beforeArgs.setOperateKey(CANCEL_PAY);
        List<Long> payRecordIds = Stream.of(payRecords).map(o -> o.getLong("id")).collect(Collectors.toList());
        beforeArgs.setPayRecordIds(payRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.beforeSave(beforeArgs);
            return null;
        });
        Object[] save = SaveServiceHelper.save((DynamicObject[])payRecords);
        SaveServiceHelper.save((DynamicObject[])nsrxxList.toArray(new DynamicObject[0]));
        this.updateSubEntryList(subEntryMap);
        PayRecordSaveAfterArgs afterArgs = new PayRecordSaveAfterArgs();
        List<Long> savedPayRecordIds = Stream.of(save).map(o -> (DynamicObject)o).map(o -> o.getLong("id")).collect(Collectors.toList());
        afterArgs.setOperateKey(CANCEL_PAY);
        afterArgs.setPayRecordIds(savedPayRecordIds);
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterSave(afterArgs);
            return null;
        });
    }

    public void packRecordData(List<DynamicObject> payRecordList, DynamicObject nsrxx, DynamicObject subEntry) {
        if (subEntry == null) {
            this.packRecordData(payRecordList, nsrxx, null, this.getTaxType(nsrxx, subEntry), nsrxx.getBigDecimal("bqybtse"), nsrxx.getString("taxlimit"));
        } else {
            DynamicObject templatetype = (DynamicObject)nsrxx.get("templatetype");
            String type = templatetype.getString("number");
            BigDecimal bqybtse = type.startsWith("qtsf_") ? subEntry.getBigDecimal("ybse") : (type.equals("dkdj") ? nsrxx.getBigDecimal("bqybtse") : (type.equals("kjqysds") ? nsrxx.getBigDecimal("bqybtse") : subEntry.getBigDecimal("bqdybtse")));
            String taxlimit = nsrxx.getString("taxlimit");
            Date skssqq = nsrxx.getDate("skssqq");
            Date skssqz = nsrxx.getDate("skssqz");
            String taxType = this.getTaxType(nsrxx, subEntry);
            this.packRecordData(payRecordList, nsrxx, subEntry, taxType, bqybtse, taxlimit);
        }
    }

    protected void packRecordData(List<DynamicObject> payRecordList, DynamicObject sbb, DynamicObject subEntry, String taxtype, BigDecimal ybtse, String taxlimit) {
        Date skssqq = null;
        Date skssqz = null;
        if (ybtse.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Object org = sbb.get("org");
        long orgId = org instanceof Long ? ((Long)org).longValue() : ((DynamicObject)org).getLong("id");
        Object sbbid = sbb.get("id");
        Long sbbEntryId = subEntry == null ? 0L : subEntry.getLong("id");
        DynamicObject payRecord = BusinessDataServiceHelper.newDynamicObject((String)PAY_RECORD_ENTITY);
        DynamicObjectCollection entryentity = payRecord.getDynamicObjectCollection("entryentity");
        String number = CodeRuleServiceHelper.getNumber((String)PAY_RECORD_ENTITY, (DynamicObject)payRecord, (String)String.valueOf(orgId));
        DynamicObject templatetype = (DynamicObject)sbb.get("templatetype");
        String typenumber = templatetype.getString("number");
        String nsrtype = TaxTypeUtils.getTaxType((String)typenumber, null);
        payRecord.set("billno", (Object)number);
        payRecord.set("yjje", (Object)ybtse);
        payRecord.set("jkbl", (Object)BigDecimal.ONE);
        payRecord.set("paystatus", (Object)"2");
        if ("zzsyjskb".equals(nsrtype)) {
            payRecord.set("sbbno", (Object)sbb.getString("serialno"));
        } else {
            payRecord.set("sbbno", (Object)sbb.getString("billno"));
        }
        payRecord.set("taxtype", (Object)taxtype);
        payRecord.set(KEY_SJJE, (Object)BigDecimal.ZERO);
        payRecord.set("syqjje", (Object)ybtse);
        payRecord.set("sbbid", sbbid);
        payRecord.set("sbbentryid", (Object)sbbEntryId);
        payRecord.set("accountorg", (Object)this.doSetAccountOrg(orgId, skssqq, skssqz));
        payRecord.set("org", sbb.get("org"));
        if (TCRET_TAXTYPE.contains(taxtype) && sbbEntryId != 0L) {
            skssqq = subEntry.getDate("skssqq");
            skssqz = subEntry.getDate("skssqz");
            payRecord.set("skssqq", (Object)skssqq);
            payRecord.set("skssqz", (Object)skssqz);
        } else {
            skssqq = sbb.getDate("skssqq");
            skssqz = sbb.getDate("skssqz");
            payRecord.set("skssqq", (Object)skssqq);
            payRecord.set("skssqz", (Object)skssqz);
        }
        String skssqqStr = DateUtils.format((Date)payRecord.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
        String skssqzStr = DateUtils.format((Date)payRecord.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
        payRecord.set("sssq", (Object)skssqqStr.concat("-").concat(skssqzStr));
        payRecord.set("nsrtype", (Object)nsrtype);
        payRecord.set("billstatus", (Object)"C");
        if (TCNFEP_ITEM.contains(taxtype)) {
            payRecord.set("deadline", (Object)DateUtils.addDay((Date)skssqz, (int)7));
        }
        this.updateFormEntity(entryentity, nsrtype, taxtype, ybtse, BigDecimal.ZERO, ybtse, String.valueOf(sbbid), skssqq, skssqz);
        Object taxauthority = sbb.get("taxauthority");
        payRecord.set("taxauthority", taxauthority);
        payRecordList.add(payRecord);
    }

    private void updatePayRecord(DynamicObject payRecord, String payStatus, BigDecimal sjje, BigDecimal syqjje, Object payer, Date payDate) {
        payRecord.set("paystatus", (Object)payStatus);
        payRecord.set(KEY_SJJE, (Object)sjje);
        payRecord.set("syqjje", (Object)syqjje);
        payRecord.set("payer", payer);
        payRecord.set("paydate", (Object)payDate);
        payRecord.set("entrydate", (Object)payDate);
        DynamicObjectCollection entryentity = payRecord.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            for (DynamicObject dynamicObject : entryentity) {
                BigDecimal yjjemx;
                if ("1".equals(payStatus)) {
                    yjjemx = dynamicObject.getBigDecimal("yjjemx");
                    dynamicObject.set("sjjemx", (Object)yjjemx);
                    dynamicObject.set("syqjjemx", (Object)BigDecimal.ZERO);
                    continue;
                }
                yjjemx = dynamicObject.getBigDecimal("yjjemx");
                dynamicObject.set("syqjjemx", (Object)yjjemx);
                dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
            }
        }
    }

    private Long doSetAccountOrg(Long taxOrg, Date startDate, Date endDate) {
        Long defaultAccountOrg = this.setDefaultAccountOrg(taxOrg, startDate, endDate).get(0);
        return defaultAccountOrg;
    }

    private List<Long> setDefaultAccountOrg(Long taxOrg, Date startDate, Date endDate) {
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
        return !CollectionUtils.isEmpty((Collection)orgRelations) ? orgRelations.stream().distinct().collect(Collectors.toList()) : Lists.newArrayList((Object[])new Long[]{0L});
    }

    private void updateFormEntity(DynamicObjectCollection entryentity, String nsrtype, String taxtype, Object yjje, Object sjje, Object syqjje, String sbbid, Date startDate, Date endDate) {
        if (singleItem.contains(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)taxtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
        } else if ("szys_a".equals(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)nsrtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
        } else if ("ccxws".equals(nsrtype)) {
            MultiLangEnumBridge multiLangEnumBridge;
            String taxname = null;
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
            QFilter skssqqFilter = new QFilter("startdate", "=", (Object)startDate);
            QFilter skssqzFilter = new QFilter("enddate", "=", (Object)endDate);
            if ("zys".equals(taxtype)) {
                taxtype = "tcrt";
            }
            if ("ccs".equals(taxtype)) {
                taxtype = "tcvvt";
            }
            if ("hbs".equals(taxtype)) {
                taxtype = "tcept";
            }
            if ("szys".equals(taxtype)) {
                taxtype = "tcwat";
            }
            if (null != (multiLangEnumBridge = DeclareTaxType.nssbMatchBaseName((String)taxtype))) {
                taxname = multiLangEnumBridge.loadKDString();
            }
            QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)taxname);
            DynamicObject[] sbb = BusinessDataServiceHelper.load((String)"tcret_ccxws_zb_hb", (String)"sm,ybse", (QFilter[])new QFilter[]{sbbidFilter, taxtypeFilter, skssqqFilter, skssqzFilter});
            for (int i = 0; i < sbb.length; ++i) {
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("taxitem", (Object)sbb[i].getString("sm"));
                BigDecimal yjjemx = sbb[i].getBigDecimal("ybse");
                dynamicObject.set("yjjemx", (Object)yjjemx);
                dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
                dynamicObject.set("syqjjemx", (Object)yjjemx);
                dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
            }
        } else if (TCNFEP_ITEM.contains(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)taxtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
        } else {
            return;
        }
    }

    private String getPolicyParams(String param, String startdate, String enddate, String orgId) {
        List paramList = AssistService.queryAssistParams((String)param, (String)orgId, (String)startdate, (String)enddate);
        if (paramList.size() > 0) {
            return (String)paramList.get(0);
        }
        return "0";
    }
}

