/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.provision.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.provision.impl.GeneralCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class CitrtaCreateProvisionServiceImpl
extends GeneralCreateProvisionServiceImpl {
    private static final Long ROWMEMBER = 1929212778455774208L;
    private static final Long FZJGMC_COLMEMBER = 1929214111548192768L;
    private static final Long CYSE_COLMEMBER = 1929214111590134784L;

    @Override
    public void createProvision(AccrualListEnum accrualListEnum, List<DynamicObject> dataEntities) {
        super.createProvision(accrualListEnum, dataEntities);
        this.createBranchProvision(accrualListEnum, dataEntities);
    }

    @Override
    protected void setExtraParams(DynamicObject dynamicObject, Map<String, Object> map) {
        Object btse = BigDecimal.ZERO;
        if (dynamicObject == null) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicObject.getDynamicObjectCollection("entryentity"))) {
            btse = ((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).get("btse");
        }
        map.put("total", btse);
        map.put("sourcedrafttype", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u6bd4\u5bf9\u5e95\u7a3f", (String)"CitrtaCreateProvisionServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        if (!dynamicObject.containsProperty("accountorg") || dynamicObject.get("accountorg") == null) {
            DynamicObject org = (DynamicObject)dynamicObject.get("org");
            Long orgId = org.getLong("id");
            Long orgRelation = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)orgId).getData();
            map.put("accountorg", null != orgRelation ? orgRelation : 0L);
        }
    }

    public void createBranchProvision(AccrualListEnum accrualListEnum, List<DynamicObject> dataEntities) {
        TaxResult taxpayerResult;
        List draftIds = dataEntities.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter draftFilter = new QFilter("entryid", "in", draftIds);
        QFilter rowFilter = new QFilter("row", "=", (Object)ROWMEMBER);
        QFilter colFilter = new QFilter("column", "in", Arrays.asList(FZJGMC_COLMEMBER, CYSE_COLMEMBER));
        DynamicObjectCollection branchOrgList = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"value,entryid,index,row,column", (QFilter[])new QFilter[]{draftFilter, rowFilter, colFilter});
        ArrayList<HashMap<String, Long>> branchList = new ArrayList<HashMap<String, Long>>(16);
        ArrayList<Long> branchOrgIdList = new ArrayList<Long>(16);
        if (!CollectionUtils.isEmpty((Collection)branchOrgList)) {
            for (DynamicObject obj : branchOrgList) {
                if (obj.getLong("column") == FZJGMC_COLMEMBER.longValue()) {
                    branchOrgIdList.add(obj.getLong("value"));
                }
                Long rowId = obj.getLong("row");
                String index = obj.getString("index");
                Long colId = obj.getLong("column");
                String string = obj.getString("value");
                HashMap<String, Long> map = branchList.stream().filter(e -> e.get("rowId").equals(rowId) && index.equals(e.get("index"))).findFirst().orElse(null);
                if (map == null) {
                    map = new HashMap<String, Long>(16);
                    map.put("rowId", rowId);
                    map.put("index", (Long)((Object)index));
                    branchList.add(map);
                }
                map.put("draftId", obj.getLong("entryid"));
                if (FZJGMC_COLMEMBER.equals(colId)) {
                    map.put("org", (Long)((Object)string));
                }
                if (!CYSE_COLMEMBER.equals(colId)) continue;
                map.put("cyse", (Long)((Object)string));
            }
        }
        if ((taxpayerResult = TaxcOrgDataServiceHelper.queryTaxcOrgIdsByOrgIdsAndIsTaxpayer(branchOrgIdList, (Long)1L)) == null) {
            return;
        }
        List taxpayerList = (List)taxpayerResult.getData();
        ArrayList arrayList = new ArrayList();
        Optional<DynamicObject> optional = this.getItem(accrualListEnum);
        for (Map map : branchList) {
            if (map.get("org") == null || !taxpayerList.contains(Long.parseLong(String.valueOf(map.get("org"))))) continue;
            Long orgId = Long.parseLong(String.valueOf(map.get("org")));
            HashMap<String, Object> map2 = new HashMap<String, Object>(16);
            map2.put("total", map.get("cyse"));
            String userId = RequestContext.get().getUserId();
            map2.put("taxtype", 3L);
            map2.put("taxsystem", 1);
            map2.put("coins", 1);
            map2.put("provistonitem", optional.isPresent() ? optional.get().get("id") : Long.valueOf(0L));
            if (map.get("draftId") == null) continue;
            Long draftId = Long.valueOf(String.valueOf(map.get("draftId")));
            DynamicObject draftObj = dataEntities.stream().filter(e -> e.getLong("id") == draftId.longValue()).findFirst().orElse(null);
            if (draftObj == null) continue;
            map2.put("taxorg", orgId);
            Long orgRelation = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)orgId).getData();
            map2.put("accountorg", null != orgRelation ? orgRelation : 0L);
            map2.put("startdate", draftObj.getDate("skssqq"));
            map2.put("enddate", draftObj.getDate("skssqz"));
            map2.put("entitytype", accrualListEnum.getEntryentity());
            map2.put("sourcedrafttype", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u6bd4\u5bf9\u5e95\u7a3f", (String)"CitrtaCreateProvisionServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String draftNumber = draftObj.getString("billno");
            map2.put("entitynumber", draftNumber);
            map2.put("creator", userId);
            map2.put("modifier", userId);
            Date entrydate = draftObj.getDate("skssqz");
            if ("CITRTA".equals(accrualListEnum.getCategory())) {
                entrydate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)entrydate, (int)1));
            }
            map2.put("entrydate", entrydate);
            arrayList.add(map2);
        }
        if (CollectionUtils.isEmpty(arrayList)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(arrayList)});
    }
}

