/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.provision.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.provision.ICreateProvisionService;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class GeneralCreateProvisionServiceImpl
implements ICreateProvisionService {
    private static final String ITP_PROVISTON_ITEM = "itp_proviston_item";

    @Override
    public void createProvision(AccrualListEnum accrualListEnum, List<DynamicObject> dataEntities) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (DynamicObject dataEntity : dataEntities) {
            arrayList.add(this.createParams(accrualListEnum, dataEntity, this.getItem(accrualListEnum)));
            dataEntity.set("generatebusinessdoc", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities.toArray(new DynamicObject[0]));
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(arrayList)});
    }

    public Optional<DynamicObject> getItem(AccrualListEnum accrualListEnum) {
        QFilter q1 = new QFilter("taxtype", "=", (Object)accrualListEnum.getBaseTaxId());
        String provistonItemNumber = accrualListEnum.getProvistonItemNumber();
        QFilter q2 = null;
        if (EmptyCheckUtils.isNotEmpty((Object)provistonItemNumber)) {
            q2 = new QFilter("number", "=", (Object)provistonItemNumber);
        }
        QFilter q3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ITP_PROVISTON_ITEM, (String)"id,systemset", (QFilter[])new QFilter[]{q1, q2, q3});
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return Optional.ofNullable(dynamicObjects.stream().filter(s -> s.getBoolean("systemset")).findFirst().orElseGet(() -> (DynamicObject)dynamicObjects.get(0)));
        }
        return Optional.empty();
    }

    private Map<String, Object> createParams(AccrualListEnum accrualListEnum, DynamicObject dynamicObject, Optional<DynamicObject> optional) {
        boolean isDimension;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject org = (DynamicObject)dynamicObject.get("org");
        DynamicObject accountorg = dynamicObject.containsProperty("accountorg") ? (DynamicObject)dynamicObject.get("accountorg") : null;
        String billno = (String)dynamicObject.get("billno");
        String userId = RequestContext.get().getUserId();
        map.put("taxtype", dynamicObject.getLong("taxtype.id"));
        map.put("taxsystem", AccrualConstant.TAXSYSTEM_CHINA);
        map.put("coins", 1);
        map.put("provistonitem", optional.isPresent() ? optional.get().get("id") : Long.valueOf(0L));
        map.put("taxorg", org.getLong("id"));
        map.put("accountorg", accountorg != null ? accountorg.getLong("id") : 0L);
        map.put("startdate", dynamicObject.get("skssqq"));
        map.put("enddate", dynamicObject.get("skssqz"));
        map.put("entitytype", accrualListEnum.getEntryentity());
        map.put("entitynumber", billno);
        map.put("creator", userId);
        map.put("modifier", userId);
        Date entrydate = dynamicObject.getDate("skssqz");
        if ("CITRTA".equals(accrualListEnum.getCategory())) {
            entrydate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)entrydate, (int)1));
        }
        map.put("entrydate", entrydate);
        this.setExtraParams(dynamicObject, map);
        DynamicObject dimensionResult = this.getDimensionData(org.getLong("id"), dynamicObject.getLong("taxtype.id"), dynamicObject.getDate("skssqq"), dynamicObject.getDate("skssqz"));
        boolean bl = isDimension = dimensionResult != null && dimensionResult.getBoolean("ruleentity.rule.isdimprovision");
        if (accrualListEnum.isDimprovision() && isDimension) {
            try {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)accrualListEnum.getEntryentity());
                DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
                ArrayList<HashMap<String, Object>> details = new ArrayList<HashMap<String, Object>>();
                for (DynamicObject entry : entryentity) {
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("taxitem", entry.get("taxitem"));
                    this.addDimensionData(detail, dimensionResult, entry);
                    detail.put("sjjt", entry.getBigDecimal("jtynse"));
                    details.add(detail);
                }
                map.put("details", details);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    protected void setExtraParams(DynamicObject dynamicObject, Map<String, Object> map) {
        map.put("total", dynamicObject.get("jtynsesum"));
        map.put("taxarea", AccrualConstant.TAXAREAGROUP_CHINA);
    }

    private DynamicObject getDimensionData(Long orgid, Long taxtypeId, Date skssqq, Date skssqz) {
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgid), (Long)taxtypeId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz);
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            return (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
        }
        return null;
    }

    private void addDimensionData(Map<String, Object> detail, DynamicObject dimensionResult, DynamicObject entry) {
        boolean isdimprovision = dimensionResult.getBoolean("ruleentity.rule.isdimprovision");
        String provisiondimension = dimensionResult.getString("ruleentity.rule.provisiondimension");
        if (isdimprovision && provisiondimension.contains("accountorg")) {
            detail.put("accountorg", entry.getLong("accorg.id"));
        }
        if (isdimprovision && provisiondimension.contains("businessdimension")) {
            detail.put("bizdimensiontype", entry.getString("bizdimensiontype.id"));
            detail.put("bizdimensionname", entry.getString("bizdimensionname"));
            detail.put("bizdimensionid", entry.get("bizdimensionid"));
        }
    }
}

