/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.provision.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.provision.impl.GeneralCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class QysdsjbCreateProvisionServiceImpl
extends GeneralCreateProvisionServiceImpl {
    @Override
    public void createProvision(AccrualListEnum accrualListEnum, List<DynamicObject> dataEntities) {
        super.createProvision(accrualListEnum, dataEntities);
        this.createBranchProvision(accrualListEnum, dataEntities);
    }

    public void createBranchProvision(AccrualListEnum accrualListEnum, List<DynamicObject> dataEntities) {
        List draftnumberList = dataEntities.stream().map(d -> d.getString("billno")).collect(Collectors.toList());
        DynamicObjectCollection branchOrgList = QueryServiceHelper.query((String)"tccit_seasonal_split_sjjt", (String)"sjybtsdse,branchorgid,draftnumber,skssqq,skssqz,type", (QFilter[])new QFilter[]{new QFilter("draftnumber", "in", draftnumberList)});
        List branchOrgIdList = branchOrgList.stream().map(b -> b.getLong("branchorgid")).collect(Collectors.toList());
        TaxResult taxpayerResult = TaxcOrgDataServiceHelper.queryTaxcOrgIdsByOrgIdsAndIsTaxpayer(branchOrgIdList, (Long)1L);
        if (taxpayerResult == null) {
            return;
        }
        List taxpayerList = (List)taxpayerResult.getData();
        ArrayList arrayList = new ArrayList();
        Optional<DynamicObject> optional = this.getItem(accrualListEnum);
        for (DynamicObject branchObj : branchOrgList) {
            if (!taxpayerList.contains(branchObj.getLong("branchorgid"))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("total", branchObj.getBigDecimal("sjybtsdse"));
            String userId = RequestContext.get().getUserId();
            map.put("taxtype", 3L);
            map.put("taxsystem", 1);
            map.put("coins", 1);
            map.put("provistonitem", optional.isPresent() ? optional.get().get("id") : Long.valueOf(0L));
            map.put("taxorg", branchObj.getLong("branchorgid"));
            Long orgRelation = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)branchObj.getLong("branchorgid")).getData();
            map.put("accountorg", null != orgRelation ? orgRelation : 0L);
            map.put("startdate", branchObj.getDate("skssqq"));
            map.put("enddate", branchObj.getDate("skssqz"));
            map.put("entitytype", accrualListEnum.getEntryentity());
            map.put("entitynumber", branchObj.getString("draftnumber"));
            map.put("creator", userId);
            map.put("modifier", userId);
            Date entrydate = branchObj.getDate("skssqz");
            if ("CITRTA".equals(accrualListEnum.getCategory())) {
                entrydate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)entrydate, (int)1));
            }
            map.put("entrydate", entrydate);
            arrayList.add(map);
        }
        if (CollectionUtils.isEmpty(arrayList)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(arrayList)});
    }
}

