/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.rule.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.business.rule.impl.AbstractAccessConfigIdentify;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractRuleAccessConfigService
extends AbstractAccessConfigIdentify
implements RuleAccessConfigService {
    private static Log logger = LogFactory.getLog(AbstractRuleAccessConfigService.class);

    @Override
    public List<DynamicObject> queryMatchAccessConfig(Long orgId, QFilter accessWhereFilter, QFilter sharingPlanWhereFilter) {
        long startTime = System.currentTimeMillis();
        List<DynamicObject> privateAccessConfigList = this.queryPrivateAccessConfig(orgId, accessWhereFilter);
        List noRepeatPrivateAccessConfigList = privateAccessConfigList.stream().filter(this.distinctByKey(row -> row.getLong(this.accessConfig_ProjectId))).collect(Collectors.toList());
        List privateAccessProjectIds = noRepeatPrivateAccessConfigList.stream().map(row -> row.getLong(this.accessConfig_ProjectId)).collect(Collectors.toList());
        List<DynamicObject> sharingPlanList = this.querySharingPlanAccessConfig(orgId, sharingPlanWhereFilter);
        List publicAccessProjectIds = sharingPlanList.stream().filter(row -> !privateAccessProjectIds.contains(row.getLong(this.sharingPlan_Rule_AccessProject))).filter(this.distinctByKey(row -> row.getLong(this.sharingPlan_Rule_AccessProject))).map(o -> o.getLong(this.sharingPlan_Rule)).collect(Collectors.toList());
        ArrayList publicAccessConfigList = new ArrayList();
        if (ObjectUtils.isNotEmpty(publicAccessProjectIds)) {
            QFilter accessIdQ = new QFilter("id", "in", publicAccessProjectIds);
            QFilter publicFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"public");
            List<QFilter> list = this.buildEnableQfilter(this.accessConfigEntityName);
            list.stream().forEach(o -> accessIdQ.and(o));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{accessIdQ, publicFilter});
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                Collections.addAll(publicAccessConfigList, collection);
            }
        }
        ArrayList<DynamicObject> allAccessConfigList = new ArrayList<DynamicObject>();
        allAccessConfigList.addAll(noRepeatPrivateAccessConfigList);
        allAccessConfigList.addAll(publicAccessConfigList);
        List id = allAccessConfigList.stream().map(row -> row.getString("id")).collect(Collectors.toList());
        logger.info("queryMatchAccessConfig[time = {}ms,org = {},pkId = {}]", new Object[]{System.currentTimeMillis() - startTime, orgId, StringUtil.join(id, (String)",")});
        return allAccessConfigList;
    }

    protected List<DynamicObject> queryPrivateAccessConfig(Long orgId, QFilter accessWhereFilter) {
        long startTime = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        QFilter orgQ = new QFilter(this.accessConfig_Org, "=", (Object)orgId);
        if (ObjectUtils.isNotEmpty((Object)accessWhereFilter)) {
            orgQ.and(accessWhereFilter);
        }
        QFilter privateFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"private");
        List<QFilter> enableQList = this.buildEnableQfilter(this.accessConfigEntityName);
        enableQList.stream().forEach(o -> orgQ.and(o));
        DynamicObject[] privateAccessConfigList = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{orgQ, privateFilter});
        if (ObjectUtils.isNotEmpty((Object)privateAccessConfigList)) {
            Collections.addAll(list, privateAccessConfigList);
        }
        List id = list.stream().map(row -> row.getString("id")).collect(Collectors.toList());
        logger.info("queryPrivateAccessConfig[time = {}ms,org = {},pkId = {}]", new Object[]{System.currentTimeMillis() - startTime, orgId, StringUtil.join(id, (String)",")});
        return list;
    }

    protected List<DynamicObject> querySharingPlanAccessConfig(Long orgId, QFilter sharingPlanWhereFilter) {
        long startTime = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        QFilter orgQ = new QFilter(this.sharingPlan_Org, "=", (Object)orgId);
        if (ObjectUtils.isNotEmpty((Object)sharingPlanWhereFilter)) {
            orgQ.and(sharingPlanWhereFilter);
        }
        List<QFilter> enableQList = this.buildEnableQfilter(this.sharingplanEntityName);
        enableQList.stream().forEach(o -> orgQ.and(o));
        DynamicObjectCollection sharingPlanList = QueryServiceHelper.query((String)this.sharingplanEntityName, (String)this.sharingplanSelectFields, (QFilter[])new QFilter[]{orgQ});
        if (ObjectUtils.isEmpty((Object)sharingPlanList)) {
            return list;
        }
        sharingPlanList.stream().forEach(o -> list.add((DynamicObject)o));
        List id = list.stream().map(row -> row.getString("id")).collect(Collectors.toList());
        logger.info("querySharingPlanAccessConfig[time = {}ms,org = {},pkId = {}]", new Object[]{System.currentTimeMillis() - startTime, orgId, StringUtil.join(id, (String)",")});
        return list;
    }

    protected List<QFilter> buildEnableQfilter(String entityNumber) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        IDataEntityProperty enableProperty = mainEntityType.findProperty("enable");
        IDataEntityProperty statusProperty = mainEntityType.findProperty("status");
        IDataEntityProperty billstatusProperty = mainEntityType.findProperty("billstatus");
        if (ObjectUtils.isNotEmpty((Object)enableProperty) && StringUtil.isNotBlank((CharSequence)enableProperty.getAlias())) {
            list.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (ObjectUtils.isNotEmpty((Object)statusProperty) && StringUtil.isNotBlank((CharSequence)statusProperty.getAlias())) {
            list.add(new QFilter("status", "=", (Object)"C"));
        }
        if (ObjectUtils.isNotEmpty((Object)billstatusProperty) && StringUtil.isNotBlank((CharSequence)billstatusProperty.getAlias())) {
            list.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        return list;
    }

    protected <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

