/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.rulefetch;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.dto.rulefetch.QueryRuleFetchParam;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class RuleFetchServiceHandler
implements RuleFetchConstant {
    private static final Log logger = LogFactory.getLog(RuleFetchServiceHandler.class);

    public static Long getRuleFetchMainId(RuleFetchMainDto ruleFetchMainDto) {
        QFilter templateIdFilter = new QFilter("templateid", "=", (Object)ruleFetchMainDto.getTemplateId());
        QFilter orgFilter = new QFilter("org", "=", (Object)ruleFetchMainDto.getOrgId());
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)ruleFetchMainDto.getSkssqq());
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)ruleFetchMainDto.getSkssqz());
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)ruleFetchMainDto.getDatastatus());
        QFilter purposeFilter = new QFilter("purpose", "=", (Object)ruleFetchMainDto.getPurpose());
        QFilter taxsystemFilter = new QFilter("taxsystem", "=", (Object)ruleFetchMainDto.getTaxsystem());
        QFilter taxareagroupFilter = new QFilter("taxareagroup", "=", (Object)ruleFetchMainDto.getTaxareagroup());
        logger.info("getRuleFetchMainId: table - bdtaxr_rule_fetch_main - params: {}", (Object)JSONObject.toJSONString((Object)ruleFetchMainDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreErrorGetter}));
        DynamicObject[] mainIds = BusinessDataServiceHelper.load((String)"bdtaxr_rule_fetch_main", (String)"id", (QFilter[])new QFilter[]{templateIdFilter, orgFilter, skssqqFilter, skssqzFilter, purposeFilter, datastatusFilter, taxsystemFilter, taxareagroupFilter});
        return mainIds.length == 0 ? 0L : mainIds[0].getLong("id");
    }

    public static List<Long> getRuleFetchMainIds(RuleFetchMainDto ruleFetchMainDto) {
        QFilter templateIdFilter = new QFilter("templateid", "=", (Object)ruleFetchMainDto.getTemplateId());
        QFilter orgFilter = new QFilter("org", "=", (Object)ruleFetchMainDto.getOrgId());
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)ruleFetchMainDto.getSkssqq());
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)ruleFetchMainDto.getSkssqz());
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)ruleFetchMainDto.getDatastatus());
        QFilter purposeFilter = new QFilter("purpose", "=", (Object)ruleFetchMainDto.getPurpose());
        QFilter taxsystemFilter = new QFilter("taxsystem", "=", (Object)ruleFetchMainDto.getTaxsystem());
        QFilter taxareagroupFilter = new QFilter("taxareagroup", "=", (Object)ruleFetchMainDto.getTaxareagroup());
        logger.info("getRuleFetchMainId: table - bdtaxr_rule_fetch_main - params: {}", (Object)JSONObject.toJSONString((Object)ruleFetchMainDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreErrorGetter}));
        DynamicObject[] mainIds = BusinessDataServiceHelper.load((String)"bdtaxr_rule_fetch_main", (String)"id", (QFilter[])new QFilter[]{templateIdFilter, orgFilter, skssqqFilter, skssqzFilter, purposeFilter, datastatusFilter, taxsystemFilter, taxareagroupFilter});
        return mainIds.length == 0 ? new ArrayList<Long>() : Arrays.stream(mainIds).map(a -> a.getLong("id")).collect(Collectors.toList());
    }

    public static void setInfo(RuleFetchMainDto ruleFetchMainDto, String taxsystem, String taxareagroup) {
        if (taxsystem != null && !"null".equals(taxsystem)) {
            ruleFetchMainDto.setTaxsystem(Long.valueOf(Long.parseLong(taxsystem)));
        }
        if (taxareagroup != null && !"null".equals(taxareagroup)) {
            ruleFetchMainDto.setTaxareagroup(Long.valueOf(Long.parseLong(taxareagroup)));
        }
    }

    public static QFilter[] getQueryFilters(QueryRuleFetchParam param) {
        QFilter mainIdFilter = new QFilter("rulefetchmainid", "=", (Object)param.getRuleFetchMainId());
        if (StringUtil.isNotEmpty((CharSequence)param.getReportItem())) {
            QFilter reportItemFilter = new QFilter("reportitem", "=", (Object)param.getReportItem());
            return new QFilter[]{mainIdFilter, reportItemFilter};
        }
        if (StringUtil.isNotEmpty((CharSequence)param.getRuleTable()) && StringUtil.isNotEmpty((CharSequence)param.getRuleId()) && StringUtil.isNotEmpty((CharSequence)param.getRuleItem())) {
            QFilter ruleTableFilter = new QFilter("ruletable", "=", (Object)param.getRuleTable());
            QFilter ruleIdFilter = new QFilter("ruleid", "=", (Object)param.getRuleId());
            QFilter ruleItemFilter = new QFilter("ruleitem", "=", (Object)param.getRuleItem());
            return new QFilter[]{mainIdFilter, ruleTableFilter, ruleIdFilter, ruleItemFilter};
        }
        return new QFilter[0];
    }

    public static QFilter[] getQueryFilters(Long ruleFetchMainId, List<String> reportitemList, List<String> ruleIds, List<String> ruleItems, String ruleTable) {
        QFilter mainIdFilter = new QFilter("rulefetchmainid", "=", (Object)ruleFetchMainId);
        if (EmptyCheckUtils.isNotEmpty(reportitemList)) {
            QFilter reportItemFilter = new QFilter("reportitem", "in", reportitemList);
            return new QFilter[]{mainIdFilter, reportItemFilter};
        }
        if (StringUtil.isNotEmpty((CharSequence)ruleTable) && EmptyCheckUtils.isNotEmpty(ruleIds) && EmptyCheckUtils.isNotEmpty(ruleItems)) {
            QFilter ruleTableFilter = new QFilter("ruletable", "=", (Object)ruleTable);
            QFilter ruleIdFilter = new QFilter("ruleid", "in", ruleIds);
            QFilter ruleItemFilter = new QFilter("ruleitem", "in", ruleItems);
            return new QFilter[]{mainIdFilter, ruleTableFilter, ruleIdFilter, ruleItemFilter};
        }
        return new QFilter[0];
    }
}

