/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxablelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.taxablelist.TaxableListDeclareConsumerService;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TcretTaxableListDeclareConsumerService
implements TaxableListDeclareConsumerService {
    private static final Log LOGGER = LogFactory.getLog(TcretTaxableListDeclareConsumerService.class);

    @Override
    public List<QFilter> getUpdateFilters(DeclareMQMessage declareMQMessage, DeclareCateGory declareCateGory) {
        List<QFilter> lists = DeclareMQEvent.DELETE.name().equals(declareMQMessage.getEvent()) ? this.doTcretEntryDataUpdate(declareMQMessage, declareCateGory) : this.doTcretUpdate(declareMQMessage, declareCateGory);
        return lists;
    }

    private List<QFilter> doTcretEntryDataUpdate(DeclareMQMessage declareMQMessage, DeclareCateGory declareCateGory) {
        Long taxcatetory;
        ArrayList<QFilter> lists = new ArrayList<QFilter>();
        List datas = declareMQMessage.getData();
        Long org = declareMQMessage.getOrg();
        Long taxauthority = declareMQMessage.getTaxauthority();
        String category = declareCateGory.getCategory();
        DeclareMQMessageData anyOne = null;
        for (DeclareMQMessageData data : datas) {
            Date skssqz;
            Date skssqq = DateUtils.stringToDate((String)data.getSkssqq());
            if (skssqq.equals(skssqz = DateUtils.stringToDate((String)data.getSkssqz()))) {
                anyOne = data;
                continue;
            }
            Long taxcatetory2 = this.getTaxcatetory(data);
            QFilter filter = new QFilter("org", "=", (Object)org).and("skssqq", "=", (Object)DateUtils.trunc((Date)skssqq)).and("skssqz", "<=", (Object)DateUtils.trunc((Date)skssqz)).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)taxcatetory2).and("taxauthority", "=", (Object)taxauthority);
            lists.add(filter);
        }
        if (anyOne != null && !((Object)(taxcatetory = this.getTaxcatetory(anyOne))).equals(0L)) {
            String sbbno = anyOne.getBillNo();
            QFilter filter = new QFilter("org", "=", (Object)org).and("sbbno", "=", (Object)sbbno).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)taxcatetory).and("taxauthority", "=", (Object)taxauthority);
            lists.add(filter);
        }
        return lists;
    }

    private Long getTaxcatetory(DeclareMQMessageData data) {
        try {
            return Long.parseLong(data.getTaxType());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return 0L;
        }
    }

    private List<QFilter> doTcretUpdate(DeclareMQMessage declareMQMessage, DeclareCateGory declareCateGory) {
        ArrayList<QFilter> lists = new ArrayList<QFilter>();
        if (DeclareMQEvent.SAVE.name().equals(declareMQMessage.getEvent())) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage());
            }
        }
        String sbbid = declareMQMessage.getSbbid();
        Long org = declareMQMessage.getOrg();
        Long taxauthority = declareMQMessage.getTaxauthority();
        String category = declareCateGory.getCategory();
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
        DynamicObjectCollection tcretCcxwsZbTds = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid,taxtype,startdate as skssqq,enddate as skssqz", (QFilter[])new QFilter[]{sbbidFilter});
        QFilter sbbidFilter1 = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
        DynamicObject tcretZb = QueryServiceHelper.queryOne((String)"tcret_declare_main", (String)"declaredate,org,taxauthority,sbbid", (QFilter[])new QFilter[]{sbbidFilter1});
        Map<String, Long> taxtypeMap = Arrays.stream(DeclareTaxType.values()).filter(a -> a.getLocalTaxName() != null && a.getBaseTaxId() != null).collect(Collectors.toMap(k -> k.getLocalTaxName(), v -> v.getBaseTaxId(), (m, n) -> m));
        boolean hasAcsbYhs = false;
        Date declaredate = null;
        DynamicObject anyOne = null;
        for (DynamicObject tcvatNsrxx : tcretCcxwsZbTds) {
            if (tcvatNsrxx.getString("taxtype") == null) continue;
            Date skssqq = DateUtils.trunc((Date)tcvatNsrxx.getDate("skssqq"));
            Date skssqz = DateUtils.trunc((Date)tcvatNsrxx.getDate("skssqz"));
            QFilter dataFilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
            if (skssqq.compareTo(skssqz) == 0) {
                hasAcsbYhs = true;
                anyOne = tcvatNsrxx;
                if (declaredate != null || tcretZb == null) continue;
                declaredate = tcretZb.getDate("declaredate");
                continue;
            }
            Long taxcatetory = taxtypeMap.get(tcvatNsrxx.getString("taxtype"));
            if (taxcatetory == null) continue;
            QFilter filter = new QFilter("org", "=", (Object)org).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)taxcatetory).and("taxauthority", "=", (Object)taxauthority);
            filter.and(dataFilter);
            lists.add(filter);
        }
        if (hasAcsbYhs && anyOne != null && declaredate != null && tcretZb != null) {
            QFilter dataFilter = new QFilter("skssqq", "=", declaredate).and("skssqz", "=", declaredate);
            QFilter filter = new QFilter("org", "=", (Object)org).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)DeclareTaxType.YHS.getBaseTaxId()).and("taxauthority", "=", (Object)taxauthority);
            filter.and(dataFilter);
            lists.add(filter);
        }
        return lists;
    }
}

