/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareTemplateService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import org.apache.commons.lang3.SerializationUtils;

public class DeclareTemplateServiceImpl
implements DeclareTemplateService {
    private static Log logger = LogFactory.getLog(DeclareTemplateServiceImpl.class);

    @Override
    public TemplateVo getTemplate(GetTemplateVo getTemplateVo) {
        long l = System.currentTimeMillis();
        Long templateId = getTemplateVo.getResponseModel().getTemplateId();
        String sheetName = "";
        List<String> hideRows = getTemplateVo.getHideRows();
        List<String> hideCols = getTemplateVo.getHideCols();
        List<String> hideModificationNotes = getTemplateVo.getHideModificationNotes();
        List<String> hideSheets = getTemplateVo.getHideSheets();
        Map<String, EntityField> typeMap = getTemplateVo.getTypeMap();
        if (StringUtils.isBlank((Object)templateId)) {
            throw new IllegalArgumentException("templateId Illegal!");
        }
        Map cellTypeMap = CacheFormulaService.getCellFormulas((Long)templateId);
        ArrayList<String> sheetNames = null;
        if (StringUtils.isNotBlank((CharSequence)sheetName)) {
            String[] sheetAry;
            sheetNames = new ArrayList<String>(256);
            for (String name : sheetAry = sheetName.split(",")) {
                sheetNames.add(name);
            }
        }
        DynamicObject templateContentObj = TemplateUtils.getTemplateDynamicObjectById((Long)templateId);
        String templateContent = templateContentObj.getString("content_tag");
        String templateNumber = templateContentObj.getString("number");
        String templateName = templateContentObj.getString("name");
        ArrayList sheets = new ArrayList();
        if (null != sheetNames && EmptyCheckUtils.isNotEmpty(sheetNames)) {
            sheetNames.stream().forEach(v -> sheets.addAll(SpreadUtils.getSheets((String)templateContent, (String)v)));
        } else {
            sheets.addAll(SpreadUtils.getSheets((String)templateContent, null));
        }
        List dynamicRowList = getTemplateVo.getResponseModel().getDynRowList();
        HashMap dynamicRowMap = new HashMap();
        if (null != hideSheets) {
            Iterator iterator = sheets.iterator();
            while (iterator.hasNext()) {
                Sheet sheet = (Sheet)iterator.next();
                if (!hideSheets.contains(sheet.getName())) continue;
                iterator.remove();
            }
        }
        HashMap sheetCellMap = new HashMap(sheets.size());
        HashMap<String, String> sheetIdNames = new HashMap<String, String>(sheets.size());
        ArrayList<Integer> hideColIndex = new ArrayList<Integer>();
        for (Sheet e : sheets) {
            sheetIdNames.put(e.getId(), e.getName());
            HashMap<String, String> cellsMap = new HashMap<String, String>();
            List rowList = e.getRowList();
            block3: for (int i = 0; i < rowList.size(); ++i) {
                List cellList = (List)rowList.get(i);
                if (!CollectionUtils.isEmpty(hideRows) && cellList.stream().anyMatch(c -> c.getCellKey() != null && c.getCellKey().contains("#") && hideRows.contains(c.getCellKey().split("#")[0]))) {
                    cellList.forEach(c -> c.setHide(true));
                }
                boolean dynamicRow = false;
                String dynamicRowNo = "";
                for (Cell cell : cellList) {
                    String cellKey = cell.getCellKey();
                    if (cellKey != null && cellKey.contains("#")) {
                        int hideCol;
                        EntityField field;
                        String newCellKey = cellKey;
                        if (newCellKey.endsWith("%")) {
                            newCellKey = newCellKey.substring(0, newCellKey.length() - 1);
                        }
                        if (typeMap != null && (field = typeMap.get(newCellKey)) != null && "decimal".equalsIgnoreCase(field.getFieldType())) {
                            Style style = cell.getStyle() == null ? new Style() : cell.getStyle();
                            style.sethAlign(Integer.valueOf(2));
                            cell.setStyle(style);
                        }
                        cellsMap.put(newCellKey, newCellKey);
                        String[] clist = cellKey.split("#");
                        if (!CollectionUtils.isEmpty(hideModificationNotes) && hideModificationNotes.contains(clist[clist.length - 1])) {
                            cell.setHideModificationNote(true);
                        }
                        if (!CollectionUtils.isEmpty(hideCols) && hideCols.contains(clist[clist.length - 1]) && !hideColIndex.contains(hideCol = cell.getCol())) {
                            hideColIndex.add(hideCol);
                        }
                    }
                    cell.setText(StringUtil.escapeText((String)cell.getText()));
                    cell.setFormulaVo((FormulaVo)cellTypeMap.get(cell.getCellKey()));
                    if (null == cell.getText() || !cell.getText().contains("#")) {
                        if (cell.getStyle() == null) {
                            cell.setStyle(new Style());
                        }
                        if (cell.getStyle().gethAlign() == null) {
                            cell.getStyle().sethAlign(Integer.valueOf(0));
                        }
                        cell.getStyle().setLocked(Boolean.TRUE);
                    }
                    if (cell.getStyle() != null && cell.getStyle().getBackColor() != null) {
                        cell.getStyle().setBackColor(null);
                    }
                    if (cell.getStyle() != null && cell.getStyle().getForeColor() != null) {
                        cell.getStyle().setForeColor(null);
                    }
                    if (cell.getStyle() != null && cell.getStyle().getFont() != null) {
                        cell.getStyle().setFont(null);
                    }
                    if (cell.getStyle() == null) continue;
                    if (cell.getStyle().getBorderBottom() != null) {
                        cell.getStyle().setBorderBottom(null);
                    }
                    if (cell.getStyle().getBorderLeft() != null) {
                        cell.getStyle().setBorderLeft(null);
                    }
                    if (cell.getStyle().getBorderRight() != null) {
                        cell.getStyle().setBorderRight(null);
                    }
                    if (cell.getStyle().getBorderTop() == null) continue;
                    cell.getStyle().setBorderTop(null);
                }
                Cell cell = (Cell)cellList.get(0);
                if (cell == null || !StringUtils.isNotBlank((CharSequence)cell.getText()) || dynamicRowList == null) continue;
                for (DynamicRowModel rowModel : dynamicRowList) {
                    if (null == rowModel || !cell.getText().contains(rowModel.getDynRowNo())) continue;
                    int startRowNum = rowModel.getStartRow().intValue();
                    dynamicRow = true;
                    dynamicRowNo = rowModel.getDynRowNo();
                    cell.setDynRowCell(dynamicRow);
                    cell.setDynRowNo(dynamicRowNo);
                    cell.setDisablefrontop(rowModel.isDisablefrontop());
                    int rowListSize = 0;
                    if (rowModel.getRowList() != null) {
                        rowListSize = rowModel.getRowList().size();
                    }
                    ArrayList<List> dynamicList = new ArrayList<List>(rowListSize == 0 ? 1 : rowListSize);
                    dynamicList.add(cellList);
                    for (int j = 2; j <= rowListSize; ++j) {
                        ArrayList<Cell> cellListCopy = new ArrayList<Cell>(cellList.size());
                        for (Cell c2 : cellList) {
                            cellListCopy.add((Cell)SerializationUtils.clone((Serializable)c2));
                        }
                        int num = startRowNum + j - 1;
                        for (Cell el : cellListCopy) {
                            if (el == null || el.getText() == null) continue;
                            el.setText(el.getText().replace("#" + startRowNum + "#", "#" + num + "#"));
                            String newCellKey = el.getCellKey();
                            if (newCellKey.endsWith("%")) {
                                newCellKey = newCellKey.substring(0, newCellKey.length() - 1);
                            }
                            cellsMap.put(newCellKey, newCellKey);
                            FormulaVo vo = el.getFormulaVo();
                            if (vo == null) continue;
                            vo.setFormulaKey(el.getCellKey());
                            el.setFormulaVo(vo);
                        }
                        dynamicList.add(cellListCopy);
                    }
                    dynamicList.forEach(a -> {
                        if (a != null) {
                            a.forEach(b -> {
                                if (b != null) {
                                    b.setDynRowCell(true);
                                }
                            });
                        }
                    });
                    dynamicRowMap.put(dynamicRowNo, dynamicList);
                    continue block3;
                }
            }
            sheetCellMap.put(e.getId(), cellsMap);
            if (CollectionUtils.isEmpty(hideColIndex)) continue;
            for (List list : rowList) {
                for (Cell cell : list) {
                    if (!hideColIndex.contains(cell.getCol())) continue;
                    cell.setHide(true);
                }
            }
        }
        TemplateVo templateVo = new TemplateVo();
        templateVo.setTemplateNumber(templateNumber);
        templateVo.setTemplateName(templateName);
        templateVo.setTemplate(sheets);
        templateVo.setDynamicRow(dynamicRowMap);
        templateVo.setSheetCellMap(sheetCellMap);
        templateVo.setSheetIdNames(sheetIdNames);
        long l1 = System.currentTimeMillis();
        logger.info("getTemplate cost:{}ms", (Object)(l1 - l));
        return templateVo;
    }

    @Override
    public Long getTemplateId(String templateType, String orgId, Date startDate, Date endDate) {
        Long templateId = null;
        try {
            DynamicObject template = TemplateUtils.getTemplateObjectByConfig((String)templateType, (String)orgId, (Date)startDate, (Date)endDate);
            if (template != null) {
                templateId = template.getLong("id");
            }
        }
        catch (Throwable e) {
            logger.error("TemplateServiceImpl-getTemplateId-error", e);
            return templateId;
        }
        return templateId;
    }
}

