/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.service.taxdeclare.RiskDataService;
import kd.taxc.bdtaxr.common.constant.BooleanEnum;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class RiskDataServiceImpl
implements RiskDataService {
    private static Log logger = LogFactory.getLog(RiskDataServiceImpl.class);

    private static Map<String, String> createTctrcMap(DynamicObject dynamicObject) {
        HashMap<String, String> tctrcMap = new HashMap<String, String>(16);
        tctrcMap.put("id", dynamicObject.getString("id"));
        tctrcMap.put("tctrcriskname", String.format(ResManager.loadKDString((String)"%s\u5f02\u5e38", (String)"RiskDataServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), dynamicObject.getString("risk.name")));
        tctrcMap.put("tctrcriskdesc", dynamicObject.getString("riskdesc"));
        return tctrcMap;
    }

    @Override
    public List<Map<String, String>> queryTctrcResultMapList(Long org, String templateType, String skssqq, String skssqz) {
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(org);
        requestModel.setTemplateType(templateType);
        requestModel.setSkssqq(skssqq);
        requestModel.setSkssqz(skssqz);
        return this.queryTctrcResult(requestModel);
    }

    @Override
    public List<Map<String, String>> queryTctrcResult(DeclareRequestModel requestModel) {
        DynamicObject[] dynamicObjects;
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(10);
        String templateTypeId = this.queryTemplateTypeIdByNumber(requestModel.getTemplateType());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter templateTypeFilter = new QFilter("risk.sbbtype.fbasedataid", "=", (Object)templateTypeId);
        QFilter issbShowFilter = new QFilter("risk.issbshow", "=", (Object)BooleanEnum.YES.getCode());
        QFilter startdateFilter = new QFilter("startdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)requestModel.getSkssqq())));
        QFilter enddateFilter = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)requestModel.getSkssqz())));
        QFilter riskLevelFilter = new QFilter("rlevel.id", "in", Arrays.asList(1, 2, 3));
        QFilter statusFilter = new QFilter("status", "in", Arrays.asList("0", "2"));
        statusFilter.or(new QFilter("status", "=", (Object)"1").and(new QFilter("dealresult", "=", (Object)"3")));
        QFilter runorgFilter = new QFilter("runorg.id", "=", (Object)requestModel.getOrgId());
        qFilterList.add(templateTypeFilter);
        qFilterList.add(issbShowFilter);
        qFilterList.add(startdateFilter);
        qFilterList.add(enddateFilter);
        qFilterList.add(riskLevelFilter);
        qFilterList.add(statusFilter);
        qFilterList.add(runorgFilter);
        if (EmptyCheckUtils.isNotEmpty((Object)requestModel.getExtendParams()) && EmptyCheckUtils.isNotEmpty(requestModel.getExtendParams().get("draftpurpose"))) {
            QFilter purposeFilter = new QFilter("risk.draftpurpose", "=", (Object)requestModel.getExtendParams().get("draftpurpose").toString());
            qFilterList.add(purposeFilter);
        }
        if (EmptyCheckUtils.isEmpty((Object)(dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_handle_list", (String)"id,risk.name,risk.number,riskdesc", (QFilter[])qFilterList.toArray(new QFilter[0]))))) {
            return resultList;
        }
        return Arrays.stream(dynamicObjects).map(RiskDataServiceImpl::createTctrcMap).collect(Collectors.toList());
    }

    private String queryTemplateTypeIdByNumber(String templateType) {
        QFilter qFilter = new QFilter("number", "=", (Object)templateType);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tpo_template_type", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801%s\u67e5\u8be2tctb_template_type\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (String)"RiskDataServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), templateType));
        }
        if (dynamicObjects.length != 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801%s\u67e5\u8be2tctb_template_type\u67e5\u8be2\u5230\u591a\u6761\u8bb0\u5f55", (String)"RiskDataServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), templateType));
        }
        return dynamicObjects[0].getString("id");
    }

    @Override
    public List<Map<String, String>> queryTctrcResultByTax(String taxtype, Date skssqq, Date skssqz) {
        logger.info("queryTctrcResultByTax invoke,params:taxtype={},skssqq={},skssqz={}", new Object[]{taxtype, skssqq, skssqz});
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(10);
        QFilter qFilter = new QFilter("risk.sbbtype.fbasedataid", "like", (Object)taxtype);
        QFilter qFilter6 = new QFilter("risk.issbshow", "=", (Object)BooleanEnum.YES.getCode());
        QFilter qFilter1 = new QFilter("startdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)skssqq));
        QFilter qFilter2 = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)skssqz));
        QFilter qFilter3 = new QFilter("rlevel.id", "in", Arrays.asList(1, 2, 3));
        QFilter qFilter4 = new QFilter("status", "in", Arrays.asList("0", "2"));
        qFilter4.or(new QFilter("status", "=", (Object)"1").and(new QFilter("dealresult", "=", (Object)"3")));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_handle_list", (String)"id,risk.name,risk.number,riskdesc", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4, qFilter6});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return resultList;
        }
        List<Map<String, String>> result = Arrays.stream(dynamicObjects).map(RiskDataServiceImpl::createTctrcMap).collect(Collectors.toList());
        logger.info("queryTctrcResultByTax invoke,result size:{}", (Object)result.size());
        return result;
    }
}

