/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.task.helper.TaxMainValidateHelper;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class SingleDeclareTask
extends AbstractTask {
    public static final String SERVICE_NAME = "DeclareService";
    public static final String METHOD_NAME = "generate";
    private static final Log logger = LogFactory.getLog(SingleDeclareTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            String category = (String)map.get("category");
            DeclareCateGory cateGory = DeclareCateGory.valueOfCode((String)category);
            if (StringUtils.isNotEmpty((CharSequence)category)) {
                DeclareRequest declareRequest = new DeclareRequest();
                declareRequest.setCategory(category);
                declareRequest.setDataType("schedule");
                declareRequest.setOrgId((String)map.get("orgid"));
                declareRequest.setExecuteTime(DateUtils.stringToDate((String)((String)map.get("executetime"))));
                declareRequest.setStartDate(map.get("startdate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("startdate"))) : null);
                declareRequest.setEndDate(map.get("enddate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("enddate"))) : null);
                declareRequest.setCombineDeclare(Boolean.valueOf(Boolean.parseBoolean((String)map.get("combinedeclare"))));
                long taxauthority = map.get("taxauthority") != null ? Long.parseLong((String)map.get("taxauthority")) : 0L;
                declareRequest.setTaxauthority(Long.valueOf(taxauthority));
                Long orgId = Long.parseLong(String.valueOf(map.get("orgid")));
                EngineResponse response = TaxMainValidateHelper.buildResponseIfRegisterTimeAfterExecuteTime(orgId, declareRequest.getExecuteTime());
                if (response == null) {
                    String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)cateGory.getAppId(), (String)SERVICE_NAME, (String)METHOD_NAME, (Object[])new Object[]{SerializationUtils.toJsonString((Object)declareRequest)});
                    response = (EngineResponse)SerializationUtils.fromJsonString((String)result, EngineResponse.class);
                }
                Boolean success = response.getSuccess();
                Map responseData = (Map)response.getData();
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (Objects.nonNull(responseData)) {
                    if (Objects.nonNull(responseData.get("skssqq"))) {
                        params.put("skssqq", DateUtils.stringToDate((String)((String)responseData.get("skssqq"))));
                    }
                    if (Objects.nonNull(responseData.get("skssqz"))) {
                        params.put("skssqz", DateUtils.stringToDate((String)((String)responseData.get("skssqz"))));
                    }
                }
                params.put("success", success.toString());
                params.put("taskId", this.taskId);
                params.put("taskSerialNumber", map.get("taskSerialNumber"));
                params.put("executeDetail", response.getMessage());
                logger.info("\u7a0e\u52a1\u5de5\u4f5c\u53f0\u751f\u6210\u7533\u62a5\u8868\u66f4\u65b0\u65e5\u5fd7\u53c2\u6570taskId\uff1a{}\uff1b\u7ed3\u679c\uff1a{}\uff1b\u6267\u884c\u8be6\u60c5\uff1a{}", new Object[]{this.taskId, success.toString(), response.getMessage()});
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"updateTaskInfo", (Object[])new Object[]{params});
            }
        }
        catch (Throwable e) {
            logger.error("SingleDeclareTask error", e);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("success", Boolean.FALSE.toString());
            params.put("taskId", this.taskId);
            params.put("taskSerialNumber", map.get("taskSerialNumber"));
            params.put("executeDetail", e.getMessage());
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"updateTaskInfo", (Object[])new Object[]{params});
            throw e;
        }
    }
}

