/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxcode.callservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxcode.calculatetypestrategy.AbstractCalculateRowTypeStrategy;
import kd.taxc.bdtaxr.business.taxcode.calculatetypestrategy.CalculateTypeStrategyFactory;
import kd.taxc.bdtaxr.business.tctb.TaxPeriodBusiness;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeResultDto;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeSubDetailDto;
import kd.taxc.bdtaxr.common.helper.ttc.TtcCalculateServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractCallService {
    private static final Log logger = LogFactory.getLog(AbstractCallService.class);
    protected static final String PARAMKEY = "codePluginParam";
    private static final String param_TaxRax_sumAmount = "_sumAmount";
    protected static final String DEFAULT_RESULTVALUE = "0.00";

    public TaxcodeResultDto callService(Context context, Map<String, Object> param, FormulaVo formulaVo) {
        TaxcodeResultDto taxcodeResultDto = this.callTaxCodeAndBackResult(param, formulaVo);
        this.deleteOldResult(taxcodeResultDto);
        if (ObjectUtils.isEmpty((Object)taxcodeResultDto.getTaxcodeDetailDtoList())) {
            return taxcodeResultDto;
        }
        List<TaxcodeDetailDto> lastDetailDtoList = this.calculateAmount(context, param, formulaVo, taxcodeResultDto.getSplitstartdate(), taxcodeResultDto.getTaxcodeDetailDtoList());
        taxcodeResultDto.setTaxcodeDetailDtoList(lastDetailDtoList);
        this.saveResult(taxcodeResultDto);
        return taxcodeResultDto;
    }

    public String getResultValue(TaxcodeResultDto taxcodeResultDto) {
        if (ObjectUtils.isNotEmpty((Object)taxcodeResultDto) && StringUtil.isNotEmpty((CharSequence)taxcodeResultDto.getTaxcodeName()) && StringUtil.isNotEmpty((CharSequence)taxcodeResultDto.getTaxcodeNumber())) {
            return taxcodeResultDto.getTaxcodeName() + "|" + taxcodeResultDto.getTaxcodeNumber();
        }
        return DEFAULT_RESULTVALUE;
    }

    protected List<TaxcodeDetailDto> calculateAmount(Context context, Map<String, Object> param, FormulaVo formulaVo, Date splitStartDate, List<TaxcodeDetailDto> taxcodeDetailDtoList) {
        String reportkey = formulaVo.getFormulaKey();
        ArrayList<TaxcodeDetailDto> list = new ArrayList<TaxcodeDetailDto>(8);
        BigDecimal originalAmount = new BigDecimal(ObjectUtils.isNotEmpty((Object)param.get("codePluginParam_" + formulaVo.getFormulaKey() + "_0")) ? (String)param.get("codePluginParam_" + formulaVo.getFormulaKey() + "_0") : DEFAULT_RESULTVALUE);
        Date skssqq = ObjectUtils.isNotEmpty((Object)param.get("skssqq")) ? DateUtils.stringToDate2((String)((String)param.get("skssqq"))) : null;
        Date skssqz = ObjectUtils.isNotEmpty((Object)param.get("skssqq")) ? DateUtils.stringToDate2((String)((String)param.get("skssqz"))) : null;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (TaxcodeDetailDto detailDto : taxcodeDetailDtoList) {
            AbstractCalculateRowTypeStrategy calculateRowTypeStrategy = CalculateTypeStrategyFactory.getTaxCodeRowTypeStrategyByType(detailDto.getResultSource());
            TaxcodeDetailDto lastCalculateDto = calculateRowTypeStrategy.calculateService(detailDto, originalAmount, splitStartDate, skssqq, skssqz);
            if (!ObjectUtils.isNotEmpty((Object)lastCalculateDto)) continue;
            totalAmount = totalAmount.add(lastCalculateDto.getSumIntervalAmount());
            list.add(lastCalculateDto);
        }
        context.getParam().put(reportkey + param_TaxRax_sumAmount, totalAmount);
        return list;
    }

    protected void deleteOldResult(TaxcodeResultDto resultDto) {
        QFilter qfilter = new QFilter("orgid", "=", (Object)resultDto.getOrgId());
        qfilter.and(new QFilter("taxationsys", "=", (Object)resultDto.getTaxationsys()));
        qfilter.and(new QFilter("taxtype", "=", (Object)resultDto.getTaxtype()));
        qfilter.and(new QFilter("reportkey", "=", (Object)resultDto.getReportkey()));
        qfilter.and(new QFilter("taxareagroup", "=", (Object)resultDto.getTaxareagroup()));
        qfilter.and(new QFilter("templateid", "=", (Object)resultDto.getTemplateId()));
        qfilter.and(new QFilter("draftpurpose", "=", (Object)resultDto.getDraftpurpose()));
        qfilter.and(new QFilter("skssqq", "=", (Object)resultDto.getSkssqq()));
        qfilter.and(new QFilter("skssqz", "=", (Object)resultDto.getSkssqz()));
        qfilter.and(new QFilter("datastatus", "=", (Object)"0"));
        DeleteServiceHelper.delete((String)"bdtaxr_taxcode_result", (QFilter[])new QFilter[]{qfilter});
        logger.info("\u5220\u9664\u5386\u53f2\u7a0e\u7801\u670d\u52a1\u4e34\u65f6\u7ed3\u679c\u6570\u636e\u7684\u6761\u4ef6" + qfilter.toString());
    }

    protected void saveResult(TaxcodeResultDto resultDto) {
        if (ObjectUtils.isEmpty((Object)resultDto.getTaxcodeDetailDtoList())) {
            return;
        }
        BigDecimal taxAmount = BigDecimal.ZERO;
        Long taxcodeId = 0L;
        for (TaxcodeDetailDto taxcodeDetailDto : resultDto.getTaxcodeDetailDtoList()) {
            taxAmount = taxAmount.add(taxcodeDetailDto.getSumIntervalAmount());
            taxcodeId = taxcodeDetailDto.getTaxCodeId();
        }
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_taxcode_result");
        result.set("draftid", (Object)resultDto.getDraftId());
        result.set("orgid", (Object)resultDto.getOrgId());
        result.set("templateid", (Object)resultDto.getTemplateId());
        result.set("taxationsys", (Object)resultDto.getTaxationsys());
        result.set("taxtype", (Object)resultDto.getTaxtype());
        result.set("skssqq", (Object)resultDto.getSkssqq());
        result.set("skssqz", (Object)resultDto.getSkssqz());
        result.set("taxareagroup", (Object)resultDto.getTaxareagroup());
        result.set("reportkey", (Object)resultDto.getReportkey());
        result.set("draftpurpose", (Object)resultDto.getDraftpurpose());
        result.set("splitstartdate", (Object)resultDto.getSplitstartdate());
        result.set("taxamount", (Object)taxAmount);
        result.set("taxcode", (Object)taxcodeId);
        result.set("createdate", (Object)new Date());
        result.set("creater", (Object)RequestContext.get().getCurrUserId());
        result.set("datastatus", (Object)"0");
        int detailSeq = 1;
        for (TaxcodeDetailDto taxcodeDetailDto : resultDto.getTaxcodeDetailDtoList()) {
            DynamicObject detail = result.getDynamicObjectCollection("entryentity").addNew();
            detail.set("totaldays", (Object)taxcodeDetailDto.getTotalDays());
            detail.set("days", (Object)taxcodeDetailDto.getDays());
            detail.set("proportion", (Object)taxcodeDetailDto.getProportion());
            detail.set("taxbaseamount", (Object)taxcodeDetailDto.getTaxbaseAmount());
            detail.set("sumintervalamount", (Object)taxcodeDetailDto.getSumIntervalAmount());
            detail.set("intervalstartdate", (Object)taxcodeDetailDto.getIntervalStartdate());
            detail.set("intervalenddate", (Object)taxcodeDetailDto.getIntervalEnddate());
            detail.set("resultnumber", (Object)taxcodeDetailDto.getResultNumber());
            detail.set("resultname", (Object)taxcodeDetailDto.getResultName());
            detail.set("resultsource", (Object)taxcodeDetailDto.getResultSource());
            detail.set("resultid", (Object)taxcodeDetailDto.getResultId());
            detail.set("startdate", (Object)taxcodeDetailDto.getStartDate());
            detail.set("enddate", (Object)taxcodeDetailDto.getEndDate());
            detail.set("taxcodetype", (Object)taxcodeDetailDto.getTaxcodeType());
            detail.set("taxratetype", (Object)taxcodeDetailDto.getTaxrateType());
            detail.set("seq", (Object)detailSeq++);
            int subDetailSeq = 1;
            for (TaxcodeSubDetailDto subDetailDto : taxcodeDetailDto.getTaxcodeSubDetailDtoList()) {
                DynamicObject subDetail = detail.getDynamicObjectCollection("subentryentity").addNew();
                subDetail.set("seq", (Object)subDetailSeq++);
                subDetail.set("interval", (Object)subDetailDto.getInterval());
                subDetail.set("intervaljson_tag", (Object)subDetailDto.getIntervaljson());
                subDetail.set("intervaltaxrate", (Object)subDetailDto.getIntervalTaxRate());
                subDetail.set("intervalamount", (Object)subDetailDto.getIntervalAmount());
                subDetail.set("intervaltaxamount", (Object)subDetailDto.getIntervalTaxAmount());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
    }

    protected TaxcodeResultDto callTaxCodeAndBackResult(Map<String, Object> param, FormulaVo formulaVo) {
        String ttctag;
        String reportKey = formulaVo.getFormulaKey();
        TaxcodeResultDto taxcodeResultDto = this.initTaxCodeResultDto(param, formulaVo);
        ArrayList<Long> taxTypeList = new ArrayList<Long>(16);
        taxTypeList.add(taxcodeResultDto.getTaxtype());
        ArrayList taxProductList = new ArrayList(8);
        ArrayList taxAptitudeList = new ArrayList(8);
        ArrayList processList = new ArrayList(8);
        ArrayList addressTypeList = new ArrayList(8);
        HashMap<Long, Long> addressType = ObjectUtils.isNotEmpty(param) ? (HashMap<Long, Long>)param.get("addressType") : null;
        String string = ttctag = ObjectUtils.isNotEmpty(param) ? (String)param.get("ttctag") : "";
        if (addressType != null) {
            addressTypeList.add(addressType);
        } else {
            addressType = new HashMap<Long, Long>(16);
            addressType.put(taxcodeResultDto.getTaxareagroup(), 1036241275604686848L);
            addressTypeList.add(addressType);
        }
        logger.info("\u8c03\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u6761\u4ef6\uff1areportKey" + reportKey + ",orgid = " + taxcodeResultDto.getOrgId() + ",country = " + 0L + ",taxationsys = " + taxcodeResultDto.getTaxationsys() + ",taxTypeList = " + taxTypeList + ",validDate = " + new Date() + ",taxProductList = " + ((Object)taxProductList).toString() + ",addressTypeList = " + ((Object)addressTypeList).toString() + ",taxAptitudeList = " + ((Object)taxAptitudeList).toString() + ",processList = " + ((Object)processList).toString());
        TaxResult taxResult = TtcCalculateServiceHelper.callTaxCodeServiceByCondition((long)taxcodeResultDto.getOrgId(), (long)0L, (long)taxcodeResultDto.getTaxationsys(), (String)ttctag, (Date)new Date(), taxTypeList, taxProductList, addressTypeList, taxAptitudeList, processList);
        if (ObjectUtils.isEmpty((Object)taxResult) || ObjectUtils.isNotEmpty((Object)taxResult) && ObjectUtils.isEmpty((Object)taxResult.getData())) {
            logger.info("AbstractCallService:\u8c03\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7ed3\u679c\u4e3a\u7a7a");
            return taxcodeResultDto;
        }
        logger.info("AbstractCallService:\u8c03\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7ed3\u679c:" + (ObjectUtils.isNotEmpty(((List)taxResult.getData()).get(0)) ? ((TaxcodeDetailDto)((List)taxResult.getData()).get(0)).getTaxCodeNumber() : ""));
        this.buildTaxcodeResultDto(param, taxcodeResultDto, (List)taxResult.getData());
        return taxcodeResultDto;
    }

    protected TaxcodeResultDto buildTaxcodeResultDto(Map<String, Object> param, TaxcodeResultDto taxcodeResultDto, List<TaxcodeDetailDto> taxcodeDetailDtoList) {
        List<TaxcodeDetailDto> list = this.filterTaxCodeDetailRow(param, taxcodeDetailDtoList);
        if (ObjectUtils.isNotEmpty(list)) {
            taxcodeResultDto.setTaxcodeNumber(list.stream().map(o -> o.getTaxCodeNumber()).findFirst().orElse(""));
            taxcodeResultDto.setTaxcodeName(list.stream().map(o -> o.getTaxCodeName()).findFirst().orElse(""));
            taxcodeResultDto.setTaxcodeId(list.stream().map(o -> o.getTaxCodeId()).findFirst().get());
        }
        taxcodeResultDto.getTaxcodeDetailDtoList().addAll(list);
        return taxcodeResultDto;
    }

    protected List<TaxcodeDetailDto> filterTaxCodeDetailRow(Map<String, Object> param, List<TaxcodeDetailDto> taxcodeDetailDtoList) {
        return taxcodeDetailDtoList;
    }

    public TaxcodeResultDto initTaxCodeResultDtoNoCalculateSplitStartDate(Map<String, Object> param, FormulaVo formulaVo) {
        return this.initTaxCodeResultDto(param, formulaVo, false);
    }

    public TaxcodeResultDto initTaxCodeResultDto(Map<String, Object> param, FormulaVo formulaVo) {
        return this.initTaxCodeResultDto(param, formulaVo, true);
    }

    public TaxcodeResultDto initTaxCodeResultDto(Map<String, Object> param, FormulaVo formulaVo, boolean isCalculateSplitStartDate) {
        String reportkey = formulaVo.getFormulaKey();
        long orgid = 0L;
        long country = 0L;
        long taxationsys = 0L;
        long taxtype = 0L;
        long taxareagroup = 0L;
        long draftid = 0L;
        long templateid = 0L;
        String draftpurpose = "";
        Date skssqq = new Date();
        Date skssqz = new Date();
        Date splitStartDate = skssqq;
        if (param != null && param.size() > 0) {
            orgid = Long.parseLong((String)param.get("orgid"));
            taxationsys = Long.parseLong((String)param.get("taxationsys"));
            taxtype = Long.parseLong((String)param.get("taxtype"));
            templateid = (Long)param.get("templateId");
            draftid = (Long)param.get("reportId");
            taxareagroup = Long.parseLong((String)param.get("taxareagroup"));
            skssqq = DateUtils.stringToDate2((String)((String)param.get("skssqq")));
            skssqz = DateUtils.stringToDate2((String)((String)param.get("skssqz")));
            draftpurpose = (String)param.get("draftpurpose");
            if (isCalculateSplitStartDate) {
                splitStartDate = this.getFirstDayOfYearByDraftPurpose(param);
            }
        }
        TaxcodeResultDto taxcodeResultDto = new TaxcodeResultDto(Long.valueOf(draftid), Long.valueOf(orgid), Long.valueOf(templateid), Long.valueOf(taxationsys), Long.valueOf(taxtype), skssqq, skssqz, reportkey, Long.valueOf(taxareagroup), draftpurpose, splitStartDate);
        return taxcodeResultDto;
    }

    public Date getFirstDayOfYearByDraftPurpose(Map<String, Object> param) {
        Date skssqq;
        Long orgId = ObjectUtils.isNotEmpty((Object)param.get("orgid")) ? Long.parseLong((String)param.get("orgid")) : 0L;
        Long taxationsys = ObjectUtils.isNotEmpty((Object)param.get("taxationsys")) ? Long.parseLong((String)param.get("taxationsys")) : 0L;
        Long taxcategoryId = ObjectUtils.isNotEmpty((Object)param.get("taxtype")) ? Long.parseLong((String)param.get("taxtype")) : 0L;
        String draftpurpose = ObjectUtils.isNotEmpty((Object)param.get("draftpurpose")) ? (String)param.get("draftpurpose") : "";
        Date date = skssqq = ObjectUtils.isNotEmpty((Object)param.get("skssqq")) ? DateUtils.stringToDate2((String)((String)param.get("skssqq"))) : null;
        if (ObjectUtils.isEmpty(skssqq)) {
            return null;
        }
        return TaxPeriodBusiness.getFirstDayOfYearByDraftPurpose(orgId, taxationsys, taxcategoryId, draftpurpose, skssqq);
    }
}

