/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxcode.callservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taxcode.callservice.AbstractCallService;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeResultDto;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class CacheCallService
extends AbstractCallService {
    private static final Log logger = LogFactory.getLog(CacheCallService.class);

    @Override
    protected TaxcodeResultDto callTaxCodeAndBackResult(Map<String, Object> param, FormulaVo formulaVo) {
        List taxcodeResult;
        long tabtaxareagroup;
        String reportkey = formulaVo.getFormulaKey();
        TaxcodeResultDto taxcodeResultDto = this.initTaxCodeResultDto(param, formulaVo);
        ArrayList<Long> taxTypeList = new ArrayList<Long>(16);
        taxTypeList.add(taxcodeResultDto.getTaxtype());
        ArrayList taxProductList = new ArrayList(8);
        ArrayList taxAptitudeList = new ArrayList(8);
        ArrayList processList = new ArrayList(8);
        ArrayList addressTypeList = new ArrayList(8);
        HashMap<Long, Long> addressType = ObjectUtils.isNotEmpty(param) ? (HashMap<Long, Long>)param.get("addressType") : null;
        String ttctag = ObjectUtils.isNotEmpty(param) ? (String)param.get("ttctag") : "";
        long l = tabtaxareagroup = ObjectUtils.isEmpty((Object)param.get("codePluginParam_" + reportkey + "_1")) ? 0L : Long.parseLong((String)param.get("codePluginParam_" + reportkey + "_1"));
        if (addressType != null) {
            addressTypeList.add(addressType);
        } else {
            addressType = new HashMap<Long, Long>(16);
            addressType.put(0L == tabtaxareagroup ? taxcodeResultDto.getTaxareagroup() : tabtaxareagroup, 1036241275604686848L);
            addressTypeList.add(addressType);
        }
        String taxcodekeyprefix = taxcodeResultDto.getTaxationsys() + "_" + taxcodeResultDto.getTaxtype() + "_" + (0L == tabtaxareagroup ? taxcodeResultDto.getTaxareagroup() : tabtaxareagroup);
        logger.info("CacheCallService \u8c03\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u6761\u4ef6\uff1areportkey " + reportkey + "orgid = " + taxcodeResultDto.getOrgId() + ",country = " + 0L + ",taxationsys = " + taxcodeResultDto.getTaxationsys() + ",taxTypeList = " + ((Object)taxTypeList).toString() + ",validDate = " + new Date() + ",taxProductList = " + ((Object)taxProductList).toString() + ",addressTypeList = " + ((Object)addressTypeList).toString() + ",taxAptitudeList = " + ((Object)taxAptitudeList).toString() + ",processList = " + ((Object)processList).toString());
        List list = taxcodeResult = ObjectUtils.isNotEmpty(param) && param.containsKey(taxcodekeyprefix + "_taxcodedetail") ? (List)param.get(taxcodekeyprefix + "_taxcodedetail") : null;
        if (ObjectUtils.isEmpty(taxcodeResult)) {
            logger.info("DefaultCallService:\u8c03\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7ed3\u679c\u4e3a\u7a7a");
            return taxcodeResultDto;
        }
        String codenumber = ObjectUtils.isNotEmpty(taxcodeResult.get(0)) ? ((TaxcodeDetailDto)taxcodeResult.get(0)).getTaxCodeNumber() : "";
        String taxcodeName = ObjectUtils.isNotEmpty(taxcodeResult.get(0)) ? ((TaxcodeDetailDto)taxcodeResult.get(0)).getTaxCodeName() : "";
        logger.info("DefaultCallService:\u8c03\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7ed3\u679c" + (ObjectUtils.isNotEmpty((Object)codenumber) ? codenumber : ""));
        taxcodeResultDto.setTaxcodeNumber(codenumber);
        taxcodeResultDto.setTaxcodeName(taxcodeName);
        this.buildTaxcodeResultDto(param, taxcodeResultDto, taxcodeResult);
        return taxcodeResultDto;
    }

    @Override
    public TaxcodeResultDto callService(Context context, Map<String, Object> param, FormulaVo formulaVo) {
        TaxcodeResultDto taxcodeResultDto = this.callTaxCodeAndBackResult(param, formulaVo);
        List<TaxcodeResultDto> saveTaxcodeDetailDtoList = new ArrayList(16);
        List<String> deleteCellkeyList = new ArrayList<String>(12);
        if (ObjectUtils.isNotEmpty((Object)context.getBusinessParam())) {
            if (!context.getBusinessParam().containsKey("saveTaxcodeDetailDtoList")) {
                context.getBusinessParam().put("saveTaxcodeDetailDtoList", saveTaxcodeDetailDtoList);
            } else {
                saveTaxcodeDetailDtoList = (List)context.getBusinessParam().get("saveTaxcodeDetailDtoList");
            }
            if (!context.getBusinessParam().containsKey("deleteCellkeyList")) {
                context.getBusinessParam().put("deleteCellkeyList", deleteCellkeyList);
            } else {
                deleteCellkeyList = (List)context.getBusinessParam().get("deleteCellkeyList");
            }
        }
        if (ObjectUtils.isEmpty((Object)taxcodeResultDto.getTaxcodeDetailDtoList())) {
            deleteCellkeyList.add(taxcodeResultDto.getReportkey());
            return taxcodeResultDto;
        }
        List<TaxcodeDetailDto> lastDetailDtoList = this.calculateAmount(context, param, formulaVo, taxcodeResultDto.getSplitstartdate(), taxcodeResultDto.getTaxcodeDetailDtoList());
        taxcodeResultDto.setTaxcodeDetailDtoList(lastDetailDtoList);
        saveTaxcodeDetailDtoList.add(taxcodeResultDto);
        deleteCellkeyList.add(taxcodeResultDto.getReportkey());
        return taxcodeResultDto;
    }

    @Override
    protected List<TaxcodeDetailDto> filterTaxCodeDetailRow(Map<String, Object> param, List<TaxcodeDetailDto> taxcodeDetailDtoList) {
        taxcodeDetailDtoList.removeIf(row -> !StringUtil.equalsIgnoreCase((CharSequence)row.getResultSource(), (CharSequence)"bd_taxrate"));
        return taxcodeDetailDtoList;
    }

    @Override
    public Date getFirstDayOfYearByDraftPurpose(Map<String, Object> param) {
        Date skssqq;
        Date date = skssqq = ObjectUtils.isNotEmpty((Object)param.get("skssqq")) ? DateUtils.stringToDate2((String)((String)param.get("skssqq"))) : null;
        if (ObjectUtils.isEmpty(skssqq)) {
            return null;
        }
        return ObjectUtils.isNotEmpty((Object)param.get("taxPeriodyear")) ? DateUtils.stringToDate2((String)param.get("taxPeriodyear").toString()) : null;
    }
}

