/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.Date;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class GXQYDiscountsInfoDeclareReportServiceImpl
implements DeclareReportService {
    public Long getSbbId(Map<String, String> params) {
        DynamicObject dynamicObject;
        Long orgId = Long.valueOf(params.get("orgid"));
        Date skssq = DateUtils.stringToDate((String)params.get("skssqq"));
        Date skssz = DateUtils.stringToDate((String)params.get("skssqz"));
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)params.get("templatetype")).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz);
        MultiTableEnum modelNumber = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber());
        if (modelNumber != null && (dynamicObject = QueryServiceHelper.queryOne((String)modelNumber.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter})) != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!this.getModelNumber().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rdesd_gxqyyhmxb_list");
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)startDate);
        dynamicObject.set("skssqz", (Object)endDate);
        String number = codeRuleService.readNumber("rdesd_gxqyyhmxb_list", dynamicObject, null);
        boolean exists = QueryServiceHelper.exists((String)"rdesd_gxqyyhmxb_list", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (exists) {
            codeRuleService.getNumber("rdesd_gxqyyhmxb_list", dynamicObject, null);
            number = codeRuleService.readNumber("rdesd_gxqyyhmxb_list", dynamicObject, null);
        }
        return number;
    }

    private String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        return null;
    }

    public String getUniKey(Map<String, String> mainTableMap) {
        String orgId = mainTableMap.get("org");
        String skssq = mainTableMap.get("skssqq");
        String skssz = mainTableMap.get("skssqz");
        return String.format("%s_%s_%s_%s", orgId, skssq, skssz, mainTableMap.get("templatetype"));
    }
}

