/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.Date;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class GljysbDeclareReportServiceImpl
implements DeclareReportService {
    private static final String ICTM_DECLARE_QUERY_LIST = "ictm_declare_query_list";
    private static final Long GYXJZ_ID = 1544973716101142528L;
    private static final Long ZGYJJF_ID = 1544973716981946369L;

    public Long getSbbId(Map<String, String> params) {
        DynamicObject dynamicObject;
        Long orgId = Long.valueOf(params.get("orgid"));
        Date skssq = DateUtils.stringToDate((String)params.get("skssqq"));
        Date skssz = DateUtils.stringToDate((String)params.get("skssqz"));
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)params.get("templatetype")).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz);
        MultiTableEnum modelNumber = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber());
        if (modelNumber != null && (dynamicObject = QueryServiceHelper.queryOne((String)modelNumber.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter})) != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!this.getModelNumber().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    private String getModelNumber() {
        return "TSC001";
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ICTM_DECLARE_QUERY_LIST);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)startDate);
        dynamicObject.set("skssqz", (Object)endDate);
        String number = codeRuleService.readNumber(ICTM_DECLARE_QUERY_LIST, dynamicObject, null);
        boolean exists = QueryServiceHelper.exists((String)ICTM_DECLARE_QUERY_LIST, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (exists) {
            codeRuleService.getNumber(ICTM_DECLARE_QUERY_LIST, dynamicObject, null);
            number = codeRuleService.readNumber(ICTM_DECLARE_QUERY_LIST, dynamicObject, null);
        }
        return number;
    }

    public Map<String, String> getFormmulaParams() {
        Map formmulaParams = super.getFormmulaParams();
        return formmulaParams;
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        return null;
    }

    public String getUniKey(Map<String, String> mainTableMap) {
        String orgId = mainTableMap.get("org");
        String taxsystem = mainTableMap.get("taxsystem");
        String skssq = mainTableMap.get("skssqq");
        String skssz = mainTableMap.get("skssqz");
        String zt = mainTableMap.get("accountsettype");
        return String.format("%s_%s_%s_%s_%s_%s", orgId, taxsystem, skssq, skssz, zt, mainTableMap.get("templatetype"));
    }
}

