/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.Date;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class JtysbbdDeclareReportServiceImpl
implements DeclareReportService {
    private static final String ITP_ACCRUALDEC_THAN_LIST = "itp_accrualdec_than_list";
    private static final Long GYXJZ_ID = 1544973716101142528L;
    private static final Long ZGYJJF_ID = 1544973716981946369L;

    public Long getSbbId(Map<String, String> params) {
        DynamicObject dynamicObject;
        Long orgId = Long.valueOf(params.get("orgid"));
        Long taxsystemId = Long.valueOf(params.get("taxsystem"));
        Date skssq = DateUtils.stringToDate((String)params.get("skssqq"));
        Date skssz = DateUtils.stringToDate((String)params.get("skssqz"));
        String accountsettype = params.get("accountsettype");
        String comparisonType = params.get("comparisontype");
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)params.get("templatetype")).and("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)accountsettype).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz).and("comparisontype", "=", (Object)comparisonType);
        MultiTableEnum modelNumber = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber());
        if (modelNumber != null && (dynamicObject = QueryServiceHelper.queryOne((String)modelNumber.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter})) != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!this.getModelNumber().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    private String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ITP_ACCRUALDEC_THAN_LIST);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)startDate);
        dynamicObject.set("skssqz", (Object)endDate);
        String number = codeRuleService.readNumber(ITP_ACCRUALDEC_THAN_LIST, dynamicObject, null);
        boolean exists = QueryServiceHelper.exists((String)ITP_ACCRUALDEC_THAN_LIST, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (exists) {
            codeRuleService.getNumber(ITP_ACCRUALDEC_THAN_LIST, dynamicObject, null);
            number = codeRuleService.readNumber(ITP_ACCRUALDEC_THAN_LIST, dynamicObject, null);
        }
        return number;
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        if (extendParams == null) {
            return null;
        }
        Long taxsystemId = extendParams.get("taxsystem") == null ? 0L : Long.parseLong(extendParams.get("taxsystem").toString());
        String accountsettype = extendParams.get("accountsettype") == null ? "" : (String)extendParams.get("accountsettype");
        String comparisonType = extendParams.get("comparisontype") == null ? "" : (String)extendParams.get("comparisontype");
        return new QFilter("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)accountsettype).and("comparisontype", "=", (Object)comparisonType);
    }

    public String getUniKey(Map<String, String> mainTableMap) {
        String orgId = mainTableMap.get("org");
        String taxsystem = mainTableMap.get("taxsystem");
        String skssq = mainTableMap.get("skssqq");
        String skssz = mainTableMap.get("skssqz");
        String zt = mainTableMap.get("accountsettype");
        String templateType = mainTableMap.get("templatetype");
        return String.format("%s_%s_%s_%s_%s_%s", orgId, taxsystem, skssq, skssz, zt, templateType);
    }
}

