/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class SdsjtDeclareReportServiceImpl
implements DeclareReportService {
    private static final Long GYXJZ_ID = 1544973716101142528L;
    private static final Long ZGYJJF_ID = 1544973716981946369L;

    public Long getSbbId(Map<String, String> params) {
        DynamicObject dynamicObject;
        MultiTableEnum modelNumber;
        Long orgId = Long.valueOf(params.get("orgid"));
        Long taxsystemId = Long.valueOf(params.get("taxsystem"));
        Date skssq = DateUtils.stringToDate((String)params.get("skssqq"));
        Date skssz = DateUtils.stringToDate((String)params.get("skssqz"));
        String accountsettype = params.get("accountsettype");
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)params.get("templatetype")).and("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)accountsettype).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz).and("isadjustperiod", "=", (Object)params.get("isadjustperiod"));
        if ("1".equals(params.get("isadjustperiod"))) {
            defaultQfilter.and("adjustperiod", "=", (Object)params.get("adjustperiod"));
        }
        if ((modelNumber = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber())) != null && (dynamicObject = QueryServiceHelper.queryOne((String)modelNumber.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter})) != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!this.getModelNumber().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    private String getModelNumber() {
        return "TSD001";
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"itp_draft_query_list");
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)startDate);
        dynamicObject.set("skssqz", (Object)endDate);
        return codeRuleService.getNumber("itp_draft_query_list", dynamicObject, null);
    }

    public Map<String, String> getFormmulaParams() {
        Map formmulaParams = super.getFormmulaParams();
        formmulaParams.put("1544973714876405763", "{Q[ywzdfjs_nstz#ywzdfjs_je]}");
        formmulaParams.put("1544973716989985792", "{Q[ggxcfjs_nstz#je]}");
        formmulaParams.put("1544973714876405761", "{Q[ghjf_sstz#ghje_je]}");
        formmulaParams.put("1544973714876056577", "{Q[zgflf_sstz#zgflf_je]}");
        formmulaParams.put("1544973714876405762", "{Q[bcylbx_sstz#bcylbx_je]}");
        formmulaParams.put("1544973714876056578", "{Q[bcylbxx_sstz#bcylbxx_je]}");
        formmulaParams.put("1544973718390883330", "{Q[dzzgzjf_sstz#dzzgzjf_je]}");
        QFilter fetchItemsFilter = new QFilter("id", "in", Arrays.asList(GYXJZ_ID, ZGYJJF_ID));
        DynamicObjectCollection fetchItems = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,name,taxationsys,biztype.number as biztype", (QFilter[])new QFilter[]{fetchItemsFilter});
        for (DynamicObject fetchItem : fetchItems) {
            if (GYXJZ_ID.longValue() == fetchItem.getLong("id")) {
                if ("YWLB0002".equalsIgnoreCase(fetchItem.getString("biztype"))) {
                    formmulaParams.put("1544973716101142528", "{Q[gyxjzzcxekcjs_bnnstzje#gyxjzzcxekcjs_je]}");
                    continue;
                }
                if (!"YWLB0001".equalsIgnoreCase(fetchItem.getString("biztype"))) continue;
                formmulaParams.put("1544973716101142528", "{Q[gyxjzzcxekcjs_jzyhndkcehj#gyxjzzcxekcjs_je]}-{Q[gyxjzzcxekcjs_yqndjzkkcdjze#gyxjzzcxekcjs_je]}");
                continue;
            }
            if ("YWLB0002".equalsIgnoreCase(fetchItem.getString("biztype"))) {
                formmulaParams.put("1544973716981946369", "{Q[zgjyjfjs_nstz#zgjyjfjs_je]}");
                continue;
            }
            if (!"YWLB0001".equalsIgnoreCase(fetchItem.getString("biztype"))) continue;
            formmulaParams.put("1544973716981946369", "{Q[zgjyjfjs_ljjzyhndkce#zgjyjfjs_je]}-{Q[zgjyjfjs_yqndjzkce#zgjyjfjs_je]}");
        }
        return formmulaParams;
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        if (extendParams == null) {
            return null;
        }
        Long taxsystemId = extendParams.get("taxsystem") == null ? 0L : Long.parseLong(extendParams.get("taxsystem").toString());
        String accountsettype = extendParams.get("accountsettype") == null ? "" : (String)extendParams.get("accountsettype");
        QFilter filter = new QFilter("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)accountsettype).and("isadjustperiod", "=", extendParams.get("isadjustperiod"));
        if ("1".equals(extendParams.get("isadjustperiod"))) {
            filter.and("adjustperiod", "=", extendParams.get("adjustperiod"));
        }
        return filter;
    }

    public String getUniKey(Map<String, String> mainTableMap) {
        String orgId = mainTableMap.get("org");
        String taxsystem = mainTableMap.get("taxsystem");
        String skssq = mainTableMap.get("skssqq");
        String skssz = mainTableMap.get("skssqz");
        String zt = mainTableMap.get("accountsettype");
        return String.format("%s_%s_%s_%s_%s_%s", orgId, taxsystem, skssq, skssz, zt, mainTableMap.get("templatetype"));
    }
}

