/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxcode.TaxCodeResultBussiness;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeResultDto;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.FormulaCalVo;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtcpDeclareReportCalculateServiceImpl
implements DeclareReportCalculateService {
    private static final Logger log = LoggerFactory.getLogger(GtcpDeclareReportCalculateServiceImpl.class);

    @Override
    public DeclareResponseModel afterCalculate(DeclareRequestModel declareModel, DeclareResponseModel data, List<DynamicRowModel> dynRowList, Map<String, EntityField> typeMap) {
        return data;
    }

    @Override
    public Map<String, String> afterCalculate(Map<String, String> showData) {
        return DeclareReportCalculateService.super.afterCalculate(showData);
    }

    @Override
    public void beforeCalFormula(DeclareRequestModel requestModel, CalFormulaContext context, Map<String, String> data, FormulaCalVo formulaCalVo, FormulaCollectionVo formulas, Map<String, String> variableKeys) {
        log.info("GtcpDeclareReportCalculateServiceImpl beforeCalFormula");
        ArrayList<String> allTaxCodeNumberList = requestModel.getBusinessMap().containsKey("allTaxCodeNumberList") ? JsonUtil.fromJsonList((String)((String)requestModel.getBusinessMap().get("allTaxCodeNumberList")), String.class) : new ArrayList<String>();
        this.getAllTaxcodeDetails(requestModel, allTaxCodeNumberList, formulaCalVo);
    }

    @Override
    public void afterCalFormula(DeclareRequestModel requestModel, CalFormulaContext context, Map<String, String> data, FormulaCalVo formulaCalVo, FormulaCollectionVo formulas, Map<String, String> variableKeys) {
        if (ObjectUtils.isNotEmpty((Object)context) && ObjectUtils.isNotEmpty((Object)context.getBusinessParam())) {
            String taxtype = requestModel.getBusinessMap().containsKey("taxtype") ? (String)requestModel.getBusinessMap().get("taxtype") : "0";
            String taxareagroup = requestModel.getBusinessMap().containsKey("taxareagroup") ? (String)requestModel.getBusinessMap().get("taxareagroup") : "0";
            String draftpurpose = requestModel.getBusinessMap().containsKey("draftpurpose") ? (String)requestModel.getBusinessMap().get("draftpurpose") : "nssb";
            List saveTaxcodeDetailDtoList = null;
            List deleteCellkeyList = null;
            if (context.getBusinessParam().containsKey("saveTaxcodeDetailDtoList")) {
                saveTaxcodeDetailDtoList = (List)context.getBusinessParam().get("saveTaxcodeDetailDtoList");
            }
            if (context.getBusinessParam().containsKey("deleteCellkeyList")) {
                deleteCellkeyList = (List)context.getBusinessParam().get("deleteCellkeyList");
            }
            if (ObjectUtils.isNotEmpty(deleteCellkeyList)) {
                TaxcodeResultDto taxcodeResultDto = new TaxcodeResultDto(requestModel.getOrgId(), requestModel.getTemplateId(), requestModel.getTaxationsys(), Long.valueOf(Long.parseLong(taxtype)), DateUtils.stringToDate2((String)requestModel.getSkssqq()), DateUtils.stringToDate2((String)requestModel.getSkssqz()), Long.valueOf(Long.parseLong(taxareagroup)), draftpurpose);
                TaxCodeResultBussiness.deleteOldResult(taxcodeResultDto, deleteCellkeyList);
            }
            if (ObjectUtils.isNotEmpty((Object)saveTaxcodeDetailDtoList)) {
                TaxCodeResultBussiness.saveResult(saveTaxcodeDetailDtoList);
            }
            if (context.getBusinessParam().containsKey("saveTaxcodeTempList")) {
                List saveTaxcodeTempList = (List)context.getBusinessParam().get("saveTaxcodeTempList");
                SaveServiceHelper.save((DynamicObject[])saveTaxcodeTempList.toArray(new DynamicObject[saveTaxcodeTempList.size()]));
            }
        }
    }

    private void getAllTaxcodeDetails(DeclareRequestModel requestModel, List<String> allTaxCodeNumberList, FormulaCalVo formulaCalVo) {
        TaxResult dynamicResult;
        Map businessMap = requestModel.getBusinessMap();
        HashMap detailMap = new HashMap(12);
        HashMap minimumtaxDetailMap = new HashMap(12);
        if (ObjectUtils.isNotEmpty(allTaxCodeNumberList) && ObjectUtils.isNotEmpty((Object)(dynamicResult = TaxcCombineBusinessDataServiceHelper.loadExtentByTaxcCodeNumbersGroupByTaxCode(allTaxCodeNumberList))) && dynamicResult.isSuccess() && ObjectUtils.isNotEmpty((Object)dynamicResult.getData())) {
            for (Map.Entry entry : ((Map)dynamicResult.getData()).entrySet()) {
                String entrykey = (String)entry.getKey() + "_taxcode";
                String mapkey = (String)businessMap.get(entrykey) + "_taxcodedetail";
                if (!detailMap.containsKey(mapkey)) {
                    detailMap.put(mapkey, new ArrayList());
                }
                if (!ObjectUtils.isNotEmpty(entry.getValue())) continue;
                ((List)detailMap.get(mapkey)).addAll((Collection)entry.getValue());
                for (TaxcodeDetailDto taxcodeDetailDto : (List)entry.getValue()) {
                    if (!"bd_minimumtax".equals(taxcodeDetailDto.getResultSource())) continue;
                    if (!minimumtaxDetailMap.containsKey((String)businessMap.get(entrykey) + "_minimumtaxdetail")) {
                        minimumtaxDetailMap.put((String)businessMap.get(entrykey) + "_minimumtaxdetail", new ArrayList());
                    }
                    ((List)minimumtaxDetailMap.get((String)businessMap.get(entrykey) + "_minimumtaxdetail")).add(taxcodeDetailDto);
                }
            }
        }
        if (ObjectUtils.isNotEmpty((Object)formulaCalVo) && ObjectUtils.isNotEmpty((Object)formulaCalVo.getBusinessParam())) {
            formulaCalVo.getBusinessParam().putAll(detailMap);
            formulaCalVo.getBusinessParam().putAll(minimumtaxDetailMap);
        }
    }
}

