/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.vo.DynRowVo;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public interface DeclareReportImportService {
    public static final String TEMPLATE_ID_KEY = "TEMPLATE_ID#0#0";

    default public Map<String, String> getDynMapper(String sheetName, List<Map.Entry<String, EntityField>> datas, List<String> dynRowNoList) {
        return new HashMap<String, String>(16);
    }

    default public List<String> getDynRows(Map<String, String> mapper) {
        return new ArrayList<String>();
    }

    default public List<Map.Entry<String, String>> getDynStartRows(String sheetName, Map<String, String> excelDataMap, List<String> dynRows) {
        return new ArrayList<Map.Entry<String, String>>();
    }

    default public ValidDataResultVo checkDynData(Map<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>> dynRowDatas, String sheetName) {
        return ValidDataResultVo.success();
    }

    default public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        return ValidDataResultVo.success();
    }

    default public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        return ValidDataResultVo.success();
    }

    default public Map<String, Integer> getOffsetsWithTemplate(Long templateId, Map<String, List<Map.Entry<String, EntityField>>> sheetsMaps, Map<String, String> excelDataMap, DynamicObject templateContent) {
        HashMap<String, Integer> offsets = new HashMap<String, Integer>(32);
        sheetsMaps.entrySet().stream().forEach(s -> ((List)s.getValue()).forEach(ss -> offsets.put((String)ss.getKey(), 0)));
        return offsets;
    }

    default public ValidDataResultVo validExcelType(Map<String, String> excelDataMap, DynamicObject templateContent) {
        if (templateContent.getString("id").equals(excelDataMap.get(TEMPLATE_ID_KEY))) {
            return ValidDataResultVo.success();
        }
        return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u5f15\u5165\u7684\u7533\u62a5\u8868\u548c\u9009\u62e9\u7684\u6a21\u7248\u7c7b\u578b\u4e00\u81f4\u3002", (String)"DeclareReportImportService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }

    default public String getBillNo(String id, String skssqz) {
        return id;
    }

    default public DynamicObject queryReportExistsId(ImportDataVo vo) {
        return TemplateUtils.queryReportExistsId((String)vo.getOrgId(), (String)vo.getTemplateTypeId(), (Date)vo.getStartDate(), (Date)vo.getEndDate(), (String)vo.getTaxLimit());
    }

    default public Supplier<Function<Map.Entry<String, String>, String>> getSupplier(String sheetName) {
        return () -> s -> (String)s.getValue();
    }

    default public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
    }

    default public boolean isHandleGetDynData() {
        return false;
    }

    default public Map<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>> getDynDatas(Map<String, String> excelDataMap, String sheetName) {
        return new HashMap<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>>(4);
    }

    default public List<DynRowVo> getDynRowList(String sheetName, Map<String, String> excelDataMap) {
        return new ArrayList<DynRowVo>(0);
    }

    default public void sendImportSheets(DeclareRequestModel requestModel, List<String> sheetNames) {
    }

    default public boolean checkSksqq(Date skssqq) {
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)skssqq);
        return skssqq.compareTo(firstDateOfMonth) == 0;
    }

    default public TaxResult<DynamicObject> queryOrgInfo(ImportDataVo importDataVo) {
        TaxResult result = null;
        result = StringUtil.isNotBlank((CharSequence)importDataVo.getNsrsbh()) ? TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)importDataVo.getNsrsbh()) : TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)importDataVo.getOrgNumber());
        return result;
    }

    default public boolean queryImportBasedata(Map<String, String> itemMap, Map<String, String> resultMap, String inputValue, String rKey) {
        return false;
    }

    default public boolean validateDates(String orgid, String typeId, long templateId, Date skssqq, Date skssqz, Date fregistertime, Map<String, String> resultMap) {
        return false;
    }

    default public String getLanguage() {
        return null;
    }

    default public boolean isSupportRefreshData() {
        return false;
    }

    default public void setRequestModelParams(String templatetype, DeclareRequestModel requestModel, Map<String, String> resultMap, List<DynamicRowModel> dynamicRows) {
        DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)requestModel.getModelId());
        String mainTable = declareTable.getMainTable();
        String billNo = resultMap.get(mainTable + "#taxtype");
        requestModel.setBillNo(billNo);
        if ("Overseas_VAT".equals(templatetype) || "Overseas_CIT".equals(templatetype) || "USA_CIT".equals(templatetype)) {
            String taxsystem = resultMap.get(mainTable + "#taxsystem");
            String taxtype = resultMap.get(mainTable + "#taxtype");
            String draftpurpose = resultMap.get(mainTable + "#draftpurpose");
            requestModel.setTaxationsys(ObjectUtils.toLong((Object)taxsystem));
            if (requestModel.getExtendParams() == null) {
                requestModel.setExtendParams(new HashMap(10));
            }
            requestModel.getExtendParams().put("taxtype", taxtype);
            requestModel.getExtendParams().put("draftpurpose", draftpurpose);
        }
    }
}

