/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractJtysbbdDeclareReportImportServiceImpl
implements DeclareReportImportService {
    private static Log logger = LogFactory.getLog(AbstractJtysbbdDeclareReportImportServiceImpl.class);
    private static final String MAINTABLE = "tpo_declare_main_tsd";
    private static final Map<String, String> ztType = new HashMap<String, String>(2);

    @Override
    public Map<String, String> getDynMapper(String sheetName, List<Map.Entry<String, EntityField>> datas, List<String> dynRowNoList) {
        HashMap<String, String> dynMapper = new HashMap<String, String>(dynRowNoList.size());
        for (Map.Entry<String, EntityField> entry : datas) {
            if (!dynRowNoList.contains(entry.getValue().getEntityId() + "#1")) continue;
            dynMapper.put(entry.getKey(), entry.getValue().getFieldId());
        }
        return dynMapper;
    }

    @Override
    public List<String> getDynRows(Map<String, String> mapper) {
        return mapper.entrySet().stream().map(s -> (String)s.getValue()).collect(Collectors.toList());
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        QFilter defaultQfilter;
        DynamicObject dyn;
        String OrgNumKey = "tpo_declare_main_tsd#orgnumber";
        String taxSystemKey = "tpo_declare_main_tsd#taxsystem";
        String accountSetTypeKey = "tpo_declare_main_tsd#accountsettype";
        String skssqqKey = "tpo_declare_main_tsd#skssqq";
        String skssqzKey = "tpo_declare_main_tsd#skssqz";
        String templatetypeKey = "tpo_declare_main_tsd#templatetype";
        String orgNum = excelDataMap.get(OrgNumKey);
        String taxsystem = excelDataMap.get(taxSystemKey);
        String accountsettype = excelDataMap.get(accountSetTypeKey);
        String skssqq = excelDataMap.get(skssqqKey);
        String skssqz = excelDataMap.get(skssqzKey);
        String templatetype = excelDataMap.get(templatetypeKey);
        boolean isvalidTaxationsys = true;
        try {
            if (StringUtil.isNotEmpty((CharSequence)taxsystem)) {
                List<Long> validTaxationsys = this.getValidTaxationsys();
                isvalidTaxationsys = validTaxationsys.contains(Long.valueOf(taxsystem));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        StringBuilder buffer = new StringBuilder();
        if (StringUtil.isEmpty((CharSequence)orgNum)) {
            buffer.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (!isvalidTaxationsys) {
            buffer.append(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u8f93\u5165\u6709\u8bef\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((CharSequence)accountsettype) || !this.getAccountSetType().contains(accountsettype)) {
            if (StringUtil.isNotBlank((CharSequence)buffer)) {
                buffer.append("\r\n");
            }
            buffer.append(ResManager.loadKDString((String)"\u8d26\u5957\u7c7b\u578b\u8f93\u5165\u6709\u8bef\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.addComparisonTypeValidate(buffer, excelDataMap, orgNum, skssqq, skssqz, accountsettype, taxsystem);
        if (StringUtils.isNotBlank((CharSequence)buffer)) {
            return ValidDataResultVo.fail((String)buffer.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)buffer)) {
            return ValidDataResultVo.fail((String)buffer.toString());
        }
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgNum(Collections.singletonList(orgNum));
        String comparisonType = excelDataMap.get("tpo_declare_main_tsd#comparisontype");
        if (ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)taxResult.getData()) && (dyn = BusinessDataServiceHelper.loadSingle((String)MAINTABLE, (String)"id,org,billno", (QFilter[])new QFilter[]{defaultQfilter = new QFilter("org", "=", (Object)((DynamicObject)((List)taxResult.getData()).get(0)).getLong("org.id")).and("templatetype", "=", (Object)templatetype).and("taxsystem", "=", (Object)Long.valueOf(taxsystem)).and("accountsettype", "=", (Object)accountsettype).and("comparisontype", "=", (Object)comparisonType), new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq)).and("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz))})) != null) {
            return ValidDataResultVo.fail((String)String.format(ResManager.loadKDString((String)"%1$s %2$s - %3$s %4$s \u5df2\u5b58\u5728\u5e95\u7a3f\uff1a%5$s\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), ((DynamicObject)((List)taxResult.getData()).get(0)).getString("org.name"), skssqq, skssqz, ztType.get(accountsettype), dyn.getString("billno")));
        }
        return ValidDataResultVo.success();
    }

    private void addComparisonTypeValidate(StringBuilder builder, Map<String, String> excelDataMap, String orgNum, String skssqq, String skssqz, String accountsettype, String taxsystem) {
        TaxResult orgIdResult = TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgNum((String)orgNum);
        if (orgIdResult == null || !orgIdResult.isSuccess()) {
            return;
        }
        String paramValue = (String)SystemParamUtil.getAppParameter((String)"itp", (String)"jtsdshjsbd", (long)((Long)orgIdResult.getData()));
        String comparisonTypeDimension = "tpo_declare_main_tsd#comparisontype";
        String comparisonTypeValue = excelDataMap.get(comparisonTypeDimension);
        List comparisonTypes = Stream.of("sdbd", "hjbd").collect(Collectors.toList());
        if ("tsbd".equalsIgnoreCase(paramValue)) {
            if (StringUtil.isEmpty((CharSequence)comparisonTypeValue)) {
                excelDataMap.put(comparisonTypeDimension, "sdhjbd");
                comparisonTypeValue = "sdhjbd";
            } else if (comparisonTypes.contains(comparisonTypeValue)) {
                builder.append(ResManager.loadKDString((String)"\u6bd4\u5bf9\u7c7b\u578b\u8f93\u5165\u6709\u8bef\uff0c\u8ba1\u63d0\u4e0e\u5ba1\u5b9a\u6570\u3001\u6c47\u7f34\u6570\u6bd4\u5bf9\u53c2\u6570\u8bbe\u7f6e\u540c\u65f6\u6bd4\u5bf9\u65f6\uff0c\u6bd4\u5bf9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u5ba1\u5b9a\u6bd4\u5bf9\u6216\u6c47\u7f34\u6bd4\u5bf9\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
        }
        if ("fkbd".equalsIgnoreCase(paramValue)) {
            if (StringUtil.isEmpty((CharSequence)comparisonTypeValue)) {
                builder.append(ResManager.loadKDString((String)"\u6bd4\u5bf9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if ("sdhjbd".equalsIgnoreCase(comparisonTypeValue)) {
                builder.append(ResManager.loadKDString((String)"\u6bd4\u5bf9\u7c7b\u578b\u8f93\u5165\u6709\u8bef\uff0c\u8ba1\u63d0\u4e0e\u5ba1\u5b9a\u6570\u3001\u6c47\u7f34\u6570\u6bd4\u5bf9\u53c2\u6570\u8bbe\u7f6e\u5206\u5f00\u6bd4\u5bf9\u65f6\uff0c\u6bd4\u5bf9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u5ba1\u5b9a\u6c47\u7f34\u6bd4\u5bf9\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
        }
        String templateType = "jtzt".equalsIgnoreCase(accountsettype) ? "jtysbbd_jt" : "jtysbbd_bd";
        QFilter commonFilter = new QFilter("org", "=", orgIdResult.getData()).and("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq)).and("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz)).and("accountsettype", "=", (Object)accountsettype).and("templatetype", "=", (Object)templateType).and("taxsystem", "=", (Object)Long.valueOf(taxsystem));
        QFilter filter = null;
        filter = comparisonTypes.contains(comparisonTypeValue) ? new QFilter("comparisonType", "=", (Object)"sdhjbd") : new QFilter("comparisonType", "in", comparisonTypes);
        if (QueryServiceHelper.exists((String)MAINTABLE, (QFilter[])new QFilter[]{commonFilter, filter})) {
            builder.append(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u5b58\u5728\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u8868\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        if ("hjbd".equalsIgnoreCase(comparisonTypeValue) && !QueryServiceHelper.exists((String)MAINTABLE, (QFilter[])new QFilter[]{commonFilter, filter = new QFilter("comparisonType", "=", (Object)"sdbd")})) {
            builder.append(ResManager.loadKDString((String)"\u8ba1\u63d0\u4e0e\u5ba1\u5b9a\u6570\u3001\u6c47\u7f34\u6570\u6bd4\u5bf9\u53c2\u6570\u8bbe\u7f6e\u5206\u5f00\u6bd4\u5bf9\u65f6\uff0c\u8bf7\u5148\u751f\u6210\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5ba1\u5b9a\u6bd4\u5bf9\u7c7b\u578b\u6bd4\u5bf9\u8868\u3002", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
    }

    private boolean isAnIntersection(Long orgId, Long taxsystemId, Date sksqq, Date sksqz, String zt, String templateType) {
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)templateType).and("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)zt);
        QFilter dateQfilter = new QFilter("skssqq", ">=", (Object)sksqq).and("skssqq", "<=", (Object)sksqz);
        QFilter q1 = new QFilter("skssqq", "<=", (Object)sksqq).and("skssqz", ">=", (Object)sksqz);
        QFilter q2 = new QFilter("skssqz", ">=", (Object)sksqq).and("skssqz", "<=", (Object)sksqz);
        dateQfilter.or(q1);
        dateQfilter.or(q2);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)MAINTABLE, (String)"id", (QFilter[])new QFilter[]{defaultQfilter, new QFilter("skssqq", "=", (Object)sksqq).and("skssqz", "=", (Object)sksqz)});
        if (dynamicObject != null) {
            return false;
        }
        return QueryServiceHelper.exists((String)MAINTABLE, (QFilter[])new QFilter[]{defaultQfilter, dateQfilter});
    }

    private List<Long> getValidTaxationsys() {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>();
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("activedate", "<=", (Object)new Date());
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)"id,number,expdate", (QFilter[])new QFilter[]{filter})) {
            if (bd.getDate("expdate") != null && bd.getDate("expdate").getTime() < System.currentTimeMillis()) continue;
            bids.add(bd.getLong("id"));
        }
        return bids;
    }

    public abstract String getAccountSetType();

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        String paramValue = (String)SystemParamUtil.getAppParameter((String)"itp", (String)"jtsdshjsbd", (long)Long.parseLong(importDataVo.getOrgId()));
        String comparisonTypeDimension = "tpo_declare_main_tsd#comparisontype";
        String comparisonTypeValue = resultMap.get(comparisonTypeDimension);
        if ("tsbd".equalsIgnoreCase(paramValue) && StringUtil.isEmpty((CharSequence)comparisonTypeValue)) {
            resultMap.put(comparisonTypeDimension, "sdhjbd");
        }
    }

    static {
        ztType.put("bdzt", ResManager.loadKDString((String)"\u672c\u5730\u8d26\u7c3f", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        ztType.put("jtzt", ResManager.loadKDString((String)"\u96c6\u56e2\u8d26\u7c3f", (String)"AbstractJtysbbdDeclareReportImportServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }
}

